/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.metareader;

import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.converter.ColorType;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metareader.FSISubImageMetaData;
import com.neptunelabs.imagereader.metareader.MetaReaderAbstract;
import com.neptunelabs.imagereader.reader.fpx.FPXImage;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;

public final class MetaReaderFPX
extends MetaReaderAbstract {
    public static final int VERSION = 256;

    public MetaReaderFPX(FSILogger logger, ImageFormat format) {
        super(logger, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanImage(PathCached inputFile, boolean deep) throws IOException {
        this.metaData = new FSIMetaData(inputFile);
        FPXImage fpximage = null;
        try {
            fpximage = new FPXImage(this.logger, inputFile.getPath(), false);
            int image_count = fpximage.getImageCount();
            this.metaData.byteOrder = ByteOrder.BIG_ENDIAN;
            this.metaData.colorType = ColorType.RGB24;
            for (int i = 0; i < image_count; ++i) {
                FSISubImageMetaData metaDataImage = this.metaData.createImage(i);
                metaDataImage.width = fpximage.getWidth(i);
                metaDataImage.height = fpximage.getHeight(i);
                metaDataImage.tileWidth = fpximage.getTileWidth();
                metaDataImage.tileHeight = fpximage.getTileHeight();
                metaDataImage.bitspersample = fpximage.getColorModel().getComponentSize()[0];
                this.errorCode |= this.validateMetaData(metaDataImage);
                if (this.errorCode == 0) {
                    this.metaData.addImage(metaDataImage);
                    continue;
                }
                break;
            }
        }
        catch (Error e) {
            this.logger.logError(e, 3850, this.metaData.source);
            this.errorCode |= 4;
        }
        catch (NoSuchFileException e) {
            this.logger.logException(e, 3801, this.metaData.source);
            this.errorCode |= 1;
        }
        catch (IOException e) {
            this.logger.logException(e, 3850, this.metaData.source);
            this.errorCode |= 2;
        }
        catch (Exception e) {
            this.logger.logException(e, 3850, this.metaData.source);
            this.errorCode |= 4;
        }
        finally {
            if (this.errorCode == 0 && fpximage != null) {
                try {
                    fpximage.close();
                }
                catch (IOException e) {
                    this.errorCode |= 2;
                }
            }
        }
    }
}

