/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.metareader;

import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.io.ReaderAbstract;
import com.neptunelabs.fsiframework.io.ReaderChannel;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.converter.ColorType;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metareader.FSISubImageMetaData;
import com.neptunelabs.imagereader.metareader.MetaReaderAbstract;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;

public final class MetaReaderGIF
extends MetaReaderAbstract {
    public static final int VERSION = 256;
    private ReaderAbstract draf = null;

    public MetaReaderGIF(FSILogger logger, ImageFormat format) {
        super(logger, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanImage(PathCached inputFile, boolean deep) throws IOException {
        block15: {
            this.metaData = new FSIMetaData(inputFile);
            try {
                this.draf = new ReaderChannel(inputFile.getPath(), StandardOpenOption.READ);
                this.draf.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                byte[] header = new byte[6];
                this.draf.read(header);
                if (header[0] != 71 || header[1] != 73 || header[2] != 70) {
                    this.errorCode |= 4;
                }
                if (this.errorCode != 0) break block15;
                this.metaData.colorType = ColorType.INDEXED;
                this.metaData.hasAlpha = true;
                FSISubImageMetaData metaDataImage = this.metaData.createImage(0);
                try {
                    metaDataImage.width = this.draf.readShort();
                    metaDataImage.height = this.draf.readShort();
                }
                catch (IOException e) {
                    this.errorCode |= 4;
                }
                this.errorCode |= this.validateMetaData(metaDataImage);
                if (this.errorCode == 0) {
                    this.metaData.addImage(metaDataImage);
                }
            }
            catch (Error e) {
                this.logger.logError(e, 3850, this.metaData.source);
                this.errorCode |= 4;
            }
            catch (NoSuchFileException e) {
                this.logger.logException(e, 3801, this.metaData.source);
                this.errorCode |= 1;
            }
            catch (IOException e) {
                this.logger.logException(e, 3850, this.metaData.source);
                this.errorCode |= 2;
            }
            catch (Exception e) {
                this.logger.logException(e, 3850, this.metaData.source);
                this.errorCode |= 4;
            }
            finally {
                this.close();
            }
        }
    }

    private void close() {
        if (this.draf != null) {
            try {
                this.draf.close();
            }
            catch (IOException e) {
                if (this.logger != null) {
                    this.logger.logException(e, 3811, this.metaData.source, e.getLocalizedMessage());
                }
                this.errorCode |= 2;
            }
        }
    }
}

