/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.metareader;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.io.ReaderAbstract;
import com.neptunelabs.fsiframework.io.ReaderChannel;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.converter.ColorType;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.helper.Decode8BIM;
import com.neptunelabs.imagereader.helper.Rational;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metareader.FSISubImageMetaData;
import com.neptunelabs.imagereader.metareader.MetaReaderAbstract;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class MetaReaderJPEG
extends MetaReaderAbstract {
    public static final int VERSION = 256;
    private ReaderAbstract draf = null;
    private static final int JPG_MARKER = 255;
    private static final int JPG_SOI = 216;
    private static final int JPG_EOI = 217;
    private static final int JPG_SOS = 218;
    private static final int JPG_SOF0 = 192;
    private static final int JPG_SOF2 = 194;
    private static final int JPG_SOF3 = 195;
    private static final int JPG_SOF7 = 199;
    private static final int JPG_APP0 = 224;
    private static final int JPG_APP1 = 225;
    private static final int JPG_APP2 = 226;
    private static final int JPG_APP8 = 232;
    private static final int JPG_APPC = 236;
    private static final int JPG_APPD = 237;
    private static final int JPG_APPE = 238;
    private static final int JPG_FF = 255;

    public MetaReaderJPEG(FSILogger logger, ImageFormat format) {
        super(logger, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanImage(PathCached inputFile, boolean deep) {
        block56: {
            this.metaData = new FSIMetaData(inputFile);
            try {
                this.draf = new ReaderChannel(inputFile.getPath(), StandardOpenOption.READ);
                this.draf.setByteOrder(ByteOrder.BIG_ENDIAN);
            }
            catch (NoSuchFileException e) {
                this.errorCode |= 1;
            }
            catch (IOException e) {
                this.errorCode |= 2;
            }
            finally {
                if (this.errorCode != 0) {
                    this.close();
                }
            }
            if (this.errorCode == 0 && this.draf != null) {
                try {
                    if (this.draf.read() == 255 && this.draf.read() == 216) {
                        FSISubImageMetaData metaDataImage = this.metaData.createImage(0);
                        this.metaData.byteOrder = ByteOrder.BIG_ENDIAN;
                        boolean stop = false;
                        byte[] xmpbase = null;
                        byte[] xmpextended = null;
                        byte[] bim8raw = null;
                        byte[] ownICC = null;
                        block30: while ((this.draf.read() & 0xFF) == 255 && !stop) {
                            int codec = this.draf.read();
                            if (codec == 255) {
                                codec = this.draf.read();
                            } else if (codec == 0) continue;
                            if (codec == 255) continue;
                            int length = this.draf.readUShort() - 2;
                            switch (codec) {
                                case 224: {
                                    int app0Marker = this.draf.readInt();
                                    this.draf.readByte();
                                    if (app0Marker == 1246120262) {
                                        this.draf.readUShort();
                                        metaDataImage.unitResolution = this.draf.readByte();
                                        metaDataImage.xResolution = new Rational(this.draf.readUShort(), 1L);
                                        metaDataImage.yResolution = new Rational(this.draf.readUShort(), 1L);
                                        byte xThumbnail = this.draf.readByte();
                                        byte yThumbnail = this.draf.readByte();
                                        this.draf.skip(xThumbnail * yThumbnail * 3);
                                        continue block30;
                                    }
                                    this.draf.skip(length - 5);
                                    continue block30;
                                }
                                case 225: {
                                    int oldlen;
                                    int interpos;
                                    byte[] data;
                                    if (deep) {
                                        data = new byte[length];
                                        this.draf.read(data);
                                        interpos = this.isEXIF(data);
                                        if (interpos != -1) {
                                            if (metaDataImage.exif == null) {
                                                metaDataImage.exif = new byte[0];
                                            }
                                            oldlen = metaDataImage.exif.length;
                                            int cutlen = data.length - interpos;
                                            metaDataImage.exif = Arrays.copyOf(metaDataImage.exif, metaDataImage.exif.length + cutlen);
                                            System.arraycopy(data, interpos, metaDataImage.exif, oldlen, cutlen);
                                            continue block30;
                                        }
                                        interpos = this.isXMPBase(data);
                                        if (interpos != -1) {
                                            if (xmpbase == null) {
                                                xmpbase = new byte[]{};
                                            }
                                            oldlen = xmpbase.length;
                                            xmpbase = Arrays.copyOf(xmpbase, xmpbase.length + data.length - interpos);
                                            System.arraycopy(data, interpos, xmpbase, oldlen, data.length - interpos);
                                            continue block30;
                                        }
                                        interpos = this.isXMPExtension(data);
                                        if (interpos == -1) continue block30;
                                        if (xmpextended == null) {
                                            xmpextended = new byte[]{};
                                        }
                                        oldlen = xmpextended.length;
                                        xmpextended = Arrays.copyOf(xmpextended, xmpextended.length + data.length - interpos);
                                        System.arraycopy(data, interpos, xmpextended, oldlen, data.length - interpos);
                                        continue block30;
                                    }
                                    this.draf.skip(length);
                                    continue block30;
                                }
                                case 226: {
                                    int oldlen;
                                    byte[] data;
                                    if (deep) {
                                        data = new byte[length];
                                        this.draf.read(data);
                                        if (!this.isJPEGICC(data)) continue block30;
                                        if (ownICC == null) {
                                            ownICC = new byte[]{};
                                        }
                                        oldlen = ownICC.length;
                                        ownICC = Arrays.copyOf(ownICC, ownICC.length + data.length - 14);
                                        System.arraycopy(data, 14, ownICC, oldlen, data.length - 14);
                                        continue block30;
                                    }
                                    this.draf.skip(length);
                                    continue block30;
                                }
                                case 237: {
                                    int oldlen;
                                    int interpos;
                                    byte[] data;
                                    if (deep) {
                                        data = new byte[length];
                                        this.draf.read(data);
                                        interpos = this.is8BIM(data);
                                        if (interpos == -1) continue block30;
                                        if (bim8raw == null) {
                                            bim8raw = new byte[]{};
                                        }
                                        oldlen = bim8raw.length;
                                        bim8raw = Arrays.copyOf(bim8raw, bim8raw.length + data.length - interpos);
                                        System.arraycopy(data, interpos, bim8raw, oldlen, data.length - interpos);
                                        continue block30;
                                    }
                                    this.draf.skip(length);
                                    continue block30;
                                }
                                case 238: {
                                    this.metaData.sawAdobeMarker = true;
                                    this.draf.skip(length);
                                    continue block30;
                                }
                                case 195: 
                                case 199: {
                                    metaDataImage.compression = 0;
                                    this.draf.skip(length);
                                    continue block30;
                                }
                                case 192: 
                                case 194: {
                                    metaDataImage.bitspersample = this.draf.read();
                                    metaDataImage.height = this.draf.readShort();
                                    metaDataImage.width = this.draf.readShort();
                                    metaDataImage.samplesperpixel = this.draf.read();
                                    this.metaData.colorType = this.getColorType(metaDataImage.samplesperpixel);
                                    this.draf.skip(length - 6);
                                    continue block30;
                                }
                                case 217: {
                                    stop = true;
                                    continue block30;
                                }
                            }
                            if (length <= 0) continue;
                            this.draf.skip(length);
                        }
                        if (this.errorCode != 0) break block56;
                        if (ownICC != null) {
                            metaDataImage.icc = new ICCProfileWrap(ownICC);
                        }
                        if (bim8raw != null) {
                            try {
                                Decode8BIM psResource = new Decode8BIM(bim8raw);
                                metaDataImage.iptc = psResource.getResource("IPTC");
                                if (psResource.getPathCount() > 0) {
                                    metaDataImage.selections = psResource.getPaths();
                                }
                                metaDataImage.alphaNames = psResource.getAlphaNames();
                            }
                            catch (Exception e) {
                                this.logger.logException(e, 3861, this.metaData.source);
                            }
                        }
                        if (xmpbase != null) {
                            metaDataImage.xmp = xmpbase;
                            if (xmpextended != null) {
                                metaDataImage.xmp = this.mergeXMP(xmpbase, xmpextended);
                            }
                        }
                        this.errorCode |= this.validateMetaData(metaDataImage);
                        if (this.errorCode == 0) {
                            this.metaData.addImage(metaDataImage);
                        }
                        break block56;
                    }
                    this.logger.log(3850, this.metaData.source);
                    this.errorCode |= 4;
                }
                catch (Error e) {
                    this.logger.logError(e, 3850, this.metaData.source);
                    this.errorCode |= 4;
                }
                catch (NoSuchFileException e) {
                    this.logger.logException(e, 3801, this.metaData.source);
                    this.errorCode |= 1;
                }
                catch (IOException e) {
                    this.logger.logException(e, 3850, this.metaData.source);
                    this.errorCode |= 2;
                }
                catch (Exception e) {
                    this.logger.logException(e, 3850, this.metaData.source);
                    this.errorCode |= 4;
                }
                finally {
                    this.close();
                }
            }
        }
        FSISubImageMetaData metaDataImage = this.metaData.getImage();
        if (this.errorCode == 0 && metaDataImage != null && (metaDataImage.width <= 0 || metaDataImage.height <= 0 || metaDataImage.bitspersample <= 0 || metaDataImage.samplesperpixel <= 0)) {
            if (this.logger != null) {
                this.logger.log(3850, this.metaData.source);
            }
            this.errorCode |= 4;
        }
    }

    private ColorType getColorType(int image_samplesperpixel) {
        ColorType str = ColorType.UNKNOWN;
        if (image_samplesperpixel == 1) {
            str = ColorType.GRAY;
        } else if (image_samplesperpixel == 3) {
            str = ColorType.RGB24;
        } else if (image_samplesperpixel == 4) {
            str = ColorType.CMYK;
        }
        return str;
    }

    private void close() {
        try {
            if (this.draf != null) {
                this.draf.close();
            }
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.logException(e, 3811, this.metaData.source, e.getLocalizedMessage());
            }
            this.errorCode |= 2;
        }
    }

    private byte[] mergeXMP(byte[] xmpbase, byte[] xmpextended) {
        byte[] xmp = null;
        Node xmpbaseHook = null;
        ByteArrayInputStream sbis = new ByteArrayInputStream(xmpbase);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document xmpbaseDoc = null;
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            xmpbaseDoc = builder.parse(sbis);
            NodeList nlist = xmpbaseDoc.getElementsByTagName("x:xmpmeta");
            for (int n = 0; n < nlist.getLength(); ++n) {
                Node node = nlist.item(n);
                if (node.getNodeName() != "x:xmpmeta") continue;
                NodeList rootList = node.getChildNodes();
                for (int rl = 0; rl < rootList.getLength(); ++rl) {
                    Node rlNode = rootList.item(rl);
                    if (rlNode.getNodeType() != 1 || rlNode.getNodeName() != "rdf:RDF") continue;
                    xmpbaseHook = rlNode;
                }
                break;
            }
            sbis.close();
        }
        catch (ParserConfigurationException e) {
            this.logger.logException(e, 3860, e.getLocalizedMessage());
        }
        catch (IOException e) {
            this.logger.logException(e, 3860, e.getLocalizedMessage());
        }
        catch (SAXException e) {
            this.logger.logException(e, 3860, e.getLocalizedMessage());
        }
        if (xmpbaseHook != null && xmpbaseDoc != null) {
            sbis = new ByteArrayInputStream(xmpextended);
            DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
            factory2.setValidating(false);
            factory2.setIgnoringComments(true);
            factory2.setIgnoringElementContentWhitespace(true);
            try {
                DocumentBuilder builder = factory2.newDocumentBuilder();
                Document xmpextDoc = builder.parse(sbis);
                NodeList nlist = xmpextDoc.getElementsByTagName("x:xmpmeta");
                for (int n = 0; n < nlist.getLength(); ++n) {
                    Node node = nlist.item(n);
                    if (node.getNodeName() != "x:xmpmeta") continue;
                    NodeList rootList = node.getChildNodes();
                    for (int rl = 0; rl < rootList.getLength(); ++rl) {
                        Node rlNode = rootList.item(rl);
                        if (rlNode.getNodeType() != 1 || rlNode.getNodeName() != "rdf:RDF") continue;
                        NodeList rrList = rlNode.getChildNodes();
                        for (int rr = 0; rr < rrList.getLength(); ++rr) {
                            Node rrNode = rrList.item(rr);
                            if (rrNode.getNodeType() != 1) continue;
                            Node rrimNode = xmpbaseDoc.importNode(rrNode, true);
                            xmpbaseHook.appendChild(rrimNode);
                        }
                    }
                    break;
                }
            }
            catch (ParserConfigurationException e) {
                this.logger.logException(e, 3860, e.getLocalizedMessage());
            }
            catch (IOException e) {
                this.logger.logException(e, 3860, e.getLocalizedMessage());
            }
            catch (SAXException e) {
                this.logger.logException(e, 3860, e.getLocalizedMessage());
            }
            Transformer transformer = null;
            try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast();){
                transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(xmpbaseDoc), new StreamResult(baos));
                xmp = baos.toByteArray();
            }
            catch (TransformerConfigurationException e) {
                this.logger.logException(e, 3860, e.getLocalizedMessage());
            }
            catch (IllegalArgumentException e) {
                this.logger.logException(e, 3860, e.getLocalizedMessage());
            }
            catch (TransformerException e) {
                this.logger.logException(e, 3860, e.getLocalizedMessage());
            }
        }
        return xmp;
    }
}

