/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.metareader;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.io.ReaderAbstract;
import com.neptunelabs.fsiframework.io.ReaderChannel;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.converter.ColorType;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metareader.FSISubImageMetaData;
import com.neptunelabs.imagereader.metareader.MetaReaderAbstract;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.zip.InflaterOutputStream;

public final class MetaReaderPNG
extends MetaReaderAbstract {
    public static final int VERSION = 256;
    private ReaderAbstract draf = null;
    private static final byte[] magic = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] chunk_IHDR = new byte[]{73, 72, 68, 82};
    private static final byte[] chunk_iCCP = new byte[]{105, 67, 67, 80};
    private static final byte[] chunk_IEND = new byte[]{73, 69, 78, 68};

    public MetaReaderPNG(FSILogger fsilogger, ImageFormat format) {
        super(fsilogger, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanImage(PathCached inputFile, boolean deep) throws IOException {
        block63: {
            this.metaData = new FSIMetaData(inputFile);
            try {
                this.draf = new ReaderChannel(inputFile.getPath(), StandardOpenOption.READ);
                this.draf.setByteOrder(ByteOrder.BIG_ENDIAN);
            }
            catch (NoSuchFileException e) {
                this.logger.logException(e, 3801, inputFile);
                this.errorCode |= 1;
            }
            catch (IOException e) {
                this.logger.logException(e, 3802, inputFile);
                this.errorCode |= 2;
            }
            finally {
                if (this.errorCode != 0) {
                    this.close();
                }
            }
            if (this.errorCode == 0 && this.draf != null) {
                try {
                    byte[] m = new byte[8];
                    this.draf.read(m);
                    if (Arrays.equals(m, magic)) {
                        boolean endIsNear = false;
                        byte[] type = new byte[4];
                        int maxChunks = 20;
                        FSISubImageMetaData metaDataImage = this.metaData.createImage(0);
                        this.metaData.byteOrder = ByteOrder.BIG_ENDIAN;
                        boolean metaHasBasic = false;
                        boolean metaHasDeep = false;
                        while (!endIsNear && maxChunks-- > 0) {
                            int len = this.draf.readInt();
                            this.draf.read(type);
                            if (Arrays.equals(type, chunk_IHDR)) {
                                metaDataImage.width = this.draf.readInt();
                                metaDataImage.height = this.draf.readInt();
                                metaDataImage.bitspersample = this.draf.read();
                                int image_colortype = this.draf.read();
                                this.metaData.colorType = this.getColorType(image_colortype);
                                this.metaData.hasAlpha = this.hasAlpha(image_colortype);
                                if (this.metaData.hasAlpha && this.metaData.colorType != ColorType.INDEXED) {
                                    if (this.metaData.colorType == ColorType.RGB24) {
                                        this.metaData.alphaBand = 3;
                                    } else if (this.metaData.colorType == ColorType.GRAY) {
                                        this.metaData.alphaBand = 1;
                                    }
                                    this.metaData.alphaBandPremultiplied = false;
                                }
                                metaDataImage.samplesperpixel = this.getSamplesPerPixel(metaDataImage.bitspersample);
                                this.draf.skip(3L);
                                metaHasBasic = true;
                            } else if (deep && Arrays.equals(type, chunk_iCCP)) {
                                block62: {
                                    int sp = 0;
                                    while (this.draf.read() != 0) {
                                        ++sp;
                                    }
                                    int compression = this.draf.read();
                                    int n = len - sp - 2;
                                    if (compression == 0) {
                                        byte[] iccRaw = new byte[n];
                                        this.draf.read(iccRaw);
                                        try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(iccRaw.length);
                                             InflaterOutputStream ios = new InflaterOutputStream(baos);){
                                            ios.write(iccRaw);
                                            ios.close();
                                            byte[] data = baos.toByteArray();
                                            metaDataImage.icc = new ICCProfileWrap(data);
                                            break block62;
                                        }
                                    }
                                    this.draf.skip(n);
                                }
                                metaHasDeep = true;
                            } else if (Arrays.equals(type, chunk_IEND)) {
                                endIsNear = true;
                            } else if (len > 0) {
                                this.draf.skip(len);
                            }
                            if (deep && metaHasDeep && metaHasBasic || !deep && metaHasBasic) break;
                            this.draf.skip(4L);
                        }
                        this.errorCode |= this.validateMetaData(metaDataImage);
                        if (this.errorCode == 0) {
                            this.metaData.addImage(metaDataImage);
                        }
                        break block63;
                    }
                    if (this.logger != null) {
                        this.logger.log(3850, this.metaData.source);
                    }
                    this.errorCode |= 4;
                }
                catch (Error e) {
                    this.logger.logError(e, 3850, this.metaData.source);
                    this.errorCode |= 4;
                }
                catch (NoSuchFileException e) {
                    this.logger.logException(e, 3801, this.metaData.source);
                    this.errorCode |= 1;
                }
                catch (IOException e) {
                    this.logger.logException(e, 3850, this.metaData.source);
                    this.errorCode |= 2;
                }
                catch (Exception e) {
                    this.logger.logException(e, 3850, this.metaData.source);
                    this.errorCode |= 4;
                }
                finally {
                    this.close();
                }
            }
        }
    }

    private boolean hasAlpha(int image_colortype) {
        boolean ret = false;
        if (image_colortype == 3 || image_colortype == 4 || image_colortype == 6) {
            ret = true;
        }
        return ret;
    }

    private ColorType getColorType(int image_colortype) {
        ColorType ret = ColorType.UNKNOWN;
        if (image_colortype == 0 || image_colortype == 4) {
            ret = ColorType.GRAY;
        } else if (image_colortype == 2 || image_colortype == 6) {
            ret = ColorType.RGB24;
        } else if (image_colortype == 3) {
            ret = ColorType.INDEXED;
        }
        return ret;
    }

    @Override
    public int getErrorCode() {
        return 0;
    }

    private int getSamplesPerPixel(int image_bitspersample) {
        int ret = 1;
        switch (image_bitspersample) {
            case 1: 
            case 4: 
            case 8: 
            case 16: {
                ret = -1;
                break;
            }
            case 24: 
            case 32: {
                ret = 3;
            }
        }
        return ret;
    }

    private void close() {
        try {
            if (this.draf != null) {
                this.draf.close();
            }
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.logException(e, 3811, this.metaData.source, e.getLocalizedMessage());
            }
            this.errorCode |= 2;
        }
    }
}

