/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.metareader;

import com.neptunelabs.fsiframework.helpers.Bits;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.io.ReaderAbstract;
import com.neptunelabs.fsiframework.io.ReaderChannel;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.converter.ColorType;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.exif.ExifBuilder;
import com.neptunelabs.imagereader.exif.ExifIDFRawTag;
import com.neptunelabs.imagereader.helper.Decode8BIM;
import com.neptunelabs.imagereader.helper.Rational;
import com.neptunelabs.imagereader.helper.TIFFRawTag;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metareader.FSISubImageMetaData;
import com.neptunelabs.imagereader.metareader.MetaReaderAbstract;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;

public final class MetaReaderTIFF
extends MetaReaderAbstract {
    public static final int VERSION = 256;
    private static final int COMPRESSION_NONE = 1;
    private static final int COMPRESSION_LZW = 5;
    private static final int COMPRESSION_JPEG = 7;
    private static final int COMPRESSION_ADOBE_DEFLATE = 8;
    private static final int COMPRESSION_DEFLATE = 32946;
    private boolean scanDeep = false;
    private ReaderAbstract reader;
    private long idfOffset = -1L;
    private boolean littleendian = false;

    public MetaReaderTIFF(FSILogger logger, ImageFormat format) {
        super(logger, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanImage(PathCached inputFile, boolean deep) throws IOException {
        this.metaData = new FSIMetaData(inputFile);
        this.scanDeep = deep;
        try {
            this.reader = new ReaderChannel(inputFile.getPath(), StandardOpenOption.READ);
        }
        catch (NoSuchFileException e) {
            this.logger.logException(e, 3801, inputFile);
            this.errorCode |= 1;
        }
        catch (IOException e) {
            this.logger.logException(e, 3802, inputFile);
            this.errorCode |= 2;
        }
        finally {
            if (this.errorCode != 0) {
                this.close();
            }
        }
        if (this.errorCode == 0 && this.reader != null) {
            try {
                byte[] imagefileheader = new byte[4];
                this.reader.read(imagefileheader);
                this.parseHeader(imagefileheader);
                this.idfOffset = this.reader.readUInt();
                this.metaData.byteOrder = ByteOrder.BIG_ENDIAN;
                int imagecount = 0;
                while (this.errorCode == 0 && this.idfOffset >= 8L) {
                    FSISubImageMetaData metaDataImage = this.metaData.createImage(imagecount++);
                    long nextIDF = this.scanIDF(metaDataImage);
                    if (metaDataImage.exif == null) {
                        ExifBuilder builder = new ExifBuilder();
                        if (metaDataImage.software != null) {
                            byte[] s = metaDataImage.software.getBytes(FileOperations.charsetASCII);
                            ExifIDFRawTag tag = new ExifIDFRawTag();
                            tag.tagname = 305;
                            tag.tagtype = 2;
                            tag.tagvaluecount = metaDataImage.software.length();
                            builder.addTag(tag, s);
                        }
                        if (metaDataImage.orientation != -1) {
                            ExifIDFRawTag tag = new ExifIDFRawTag();
                            tag.tagname = 274;
                            tag.tagtype = 3;
                            tag.tagvaluecount = 1;
                            tag.tagvalueoffset = metaDataImage.orientation;
                            builder.addTag(tag, null);
                        }
                        try {
                            metaDataImage.exif = builder.evaluate();
                        }
                        catch (IOException e) {
                            this.errorCode |= 2;
                        }
                    }
                    if (metaDataImage.software != null && metaDataImage.software.equals("MRT Converter")) {
                        metaDataImage.icc = null;
                    }
                    if (metaDataImage.xResolution != null && metaDataImage.yResolution != null) {
                        metaDataImage.pixelAspectRatio = this.getPixelAspectRatio(metaDataImage.xResolution, metaDataImage.yResolution);
                    }
                    metaDataImage.isTiled = this.isTiled(metaDataImage.tileWidth, metaDataImage.tileHeight);
                    if (metaDataImage.extrasamples != null) {
                        int state;
                        int n;
                        int offSamples = metaDataImage.extrasamples.length;
                        if (offSamples > 0) {
                            this.metaData.extraSamples = offSamples;
                        }
                        if (this.metaData.extraSamples < 0 || this.metaData.extraSamples > 64) {
                            this.metaData.extraSamples = 0;
                        }
                        if (metaDataImage.extrasamples != null) {
                            for (int i = 0; i < metaDataImage.extrasamples.length; ++i) {
                                if (metaDataImage.extrasamples[i] == 1) {
                                    this.metaData.alphaBand = metaDataImage.samplesperpixel - metaDataImage.extrasamples.length + i;
                                    this.metaData.alphaBandPremultiplied = true;
                                    this.metaData.hasAlpha = true;
                                    break;
                                }
                                if (metaDataImage.extrasamples[i] != 0 && metaDataImage.extrasamples[i] != 2) continue;
                                this.metaData.alphaBand = metaDataImage.samplesperpixel - metaDataImage.extrasamples.length + i;
                                this.metaData.alphaBandPremultiplied = false;
                                this.metaData.hasAlpha = true;
                                break;
                            }
                        }
                        if (this.metaData.colorType == ColorType.GRAY || this.metaData.colorType == ColorType.GRAYINVERTED) {
                            if (metaDataImage.samplesperpixel - this.metaData.extraSamples > 1) {
                                int[] nArray = metaDataImage.extrasamples;
                                int n2 = nArray.length;
                                for (n = 0; n < n2; ++n) {
                                    state = nArray[n];
                                    if (state != 1) continue;
                                    this.metaData.hasAlpha = true;
                                    break;
                                }
                            }
                        } else if (this.metaData.colorType == ColorType.RGB15 || this.metaData.colorType == ColorType.RGB16 || this.metaData.colorType == ColorType.RGB24) {
                            if (metaDataImage.samplesperpixel - this.metaData.extraSamples > 3) {
                                int[] nArray = metaDataImage.extrasamples;
                                int n3 = nArray.length;
                                for (n = 0; n < n3; ++n) {
                                    state = nArray[n];
                                    if (state != 1) continue;
                                    this.metaData.hasAlpha = true;
                                    break;
                                }
                            }
                        } else if (this.metaData.colorType == ColorType.CMYK) {
                            if (metaDataImage.samplesperpixel - this.metaData.extraSamples > 4) {
                                int[] nArray = metaDataImage.extrasamples;
                                int n4 = nArray.length;
                                for (n = 0; n < n4; ++n) {
                                    state = nArray[n];
                                    if (state != 1) continue;
                                    this.metaData.hasAlpha = true;
                                    break;
                                }
                            }
                        } else {
                            this.metaData.hasAlpha = false;
                        }
                    } else {
                        if (this.metaData.colorType == ColorType.GRAY || this.metaData.colorType == ColorType.GRAYINVERTED) {
                            if (metaDataImage.samplesperpixel > 1) {
                                this.metaData.extraSamples = metaDataImage.samplesperpixel - 1;
                            }
                        } else if (this.metaData.colorType == ColorType.RGB15 || this.metaData.colorType == ColorType.RGB16 || this.metaData.colorType == ColorType.RGB24) {
                            if (metaDataImage.samplesperpixel > 3) {
                                this.metaData.extraSamples = metaDataImage.samplesperpixel - 3;
                            }
                        } else if (this.metaData.colorType == ColorType.CMYK && metaDataImage.samplesperpixel > 4) {
                            this.metaData.extraSamples = metaDataImage.samplesperpixel - 4;
                        }
                        if (this.metaData.extraSamples < 0 || this.metaData.extraSamples > 64) {
                            this.metaData.extraSamples = 0;
                        }
                    }
                    this.errorCode |= this.validateMetaData(metaDataImage);
                    if (this.errorCode == 0) {
                        this.metaData.addImage(metaDataImage);
                    }
                    if (nextIDF != 0L && this.errorCode == 0 && this.idfOffset != nextIDF) {
                        this.idfOffset = nextIDF;
                        continue;
                    }
                    break;
                }
            }
            catch (Error e) {
                this.logger.logError(e, 3850, this.metaData.source);
                this.errorCode |= 4;
            }
            catch (NoSuchFileException e) {
                this.logger.logException(e, 3801, this.metaData.source);
                this.errorCode |= 1;
            }
            catch (IOException e) {
                this.logger.logException(e, 3850, this.metaData.source);
                this.errorCode |= 2;
            }
            catch (Exception e) {
                this.logger.logException(e, 3850, this.metaData.source);
                this.errorCode |= 4;
            }
            finally {
                this.close();
            }
        }
    }

    private ColorType getColorType(int photometric) {
        ColorType str = ColorType.UNKNOWN;
        switch (photometric) {
            case 0: {
                str = ColorType.GRAYINVERTED;
                break;
            }
            case 1: {
                str = ColorType.GRAY;
                break;
            }
            case 2: {
                str = ColorType.RGB24;
                break;
            }
            case 3: {
                str = ColorType.INDEXED;
                break;
            }
            case 5: {
                str = ColorType.CMYK;
                break;
            }
            case 6: {
                str = ColorType.RGB24;
                break;
            }
            case 8: {
                str = ColorType.LAB;
                break;
            }
            case 9: {
                str = ColorType.LAB;
                break;
            }
            case 10: {
                str = ColorType.LAB;
            }
        }
        return str;
    }

    private float getPixelAspectRatio(Rational xResolution, Rational yResolution) {
        if (xResolution != null && yResolution != null) {
            return (float)((double)xResolution.denominator * (double)yResolution.numerator) / (float)(xResolution.numerator * yResolution.denominator);
        }
        return -1.0f;
    }

    private boolean isStriped(int tileWidth, int tileHeight) {
        boolean returnvalue = false;
        if (tileWidth == -1 && tileHeight != -1) {
            returnvalue = true;
        }
        return returnvalue;
    }

    private boolean isTiled(int tileWidth, int tileHeight) {
        return !this.isStriped(tileWidth, tileHeight);
    }

    private void close() {
        block3: {
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (IOException e) {
                if (this.logger == null) break block3;
                this.logger.logException(e, 3899, e.getLocalizedMessage());
            }
        }
    }

    private long evaluateTag(FSISubImageMetaData metaDataImage, int tagname, int tagtype, long tagvaluecount, long tagvalueoffset) throws IOException {
        long nextIDF = 0L;
        boolean readTag = false;
        switch (tagname) {
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 262: 
            case 274: 
            case 277: 
            case 278: 
            case 282: 
            case 283: 
            case 284: 
            case 296: 
            case 305: 
            case 322: 
            case 323: 
            case 330: 
            case 338: {
                readTag = true;
                break;
            }
            case 700: 
            case 33723: 
            case 34377: 
            case 34665: 
            case 34675: {
                if (!this.scanDeep) break;
                readTag = true;
            }
        }
        if (readTag) {
            long tagvalue = -1L;
            float valueFloat = -1.0f;
            double valueDouble = -1.0;
            Rational rational = null;
            byte[] bytes = null;
            long[] longs = null;
            String ascii = null;
            if (tagtype == 3 || tagtype == 8) {
                tagvalue = tagvaluecount == 1L ? (this.littleendian ? tagvalueoffset & 0xFFFFL : (long)(((int)(tagvalueoffset >> 24) & 0xFF) * 256 + ((int)(tagvalueoffset >> 16) & 0xFF))) : (long)this.getTagValueShort(tagvalueoffset, tagvaluecount);
            } else if (tagtype == 4 || tagtype == 9 || tagtype == 13) {
                if (tagvaluecount == 1L) {
                    tagvalue = tagvalueoffset;
                } else {
                    longs = this.getTagValueLong(tagvalueoffset, tagvaluecount);
                }
            } else if (tagtype == 11) {
                valueFloat = this.getTagValueFloat((int)tagvalueoffset, tagvaluecount);
            } else if (tagtype == 12) {
                valueDouble = this.getTagValueDouble(tagvalueoffset, tagvaluecount);
            } else if (tagtype == 5 || tagtype == 10) {
                rational = this.getTagValueRational(tagvalueoffset, tagvaluecount);
            } else if (tagtype == 1 || tagtype == 7) {
                bytes = this.getTagValueBytes(tagvalueoffset, tagvaluecount);
            } else if (tagtype == 2) {
                byte[] strRaw = this.getTagValueBytes(tagvalueoffset, tagvaluecount);
                ascii = new String(strRaw, FileOperations.charsetASCII);
                if ((ascii = ascii.trim()).length() == 0) {
                    ascii = null;
                }
            }
            switch (tagname) {
                case 256: {
                    metaDataImage.width = (int)tagvalue;
                    break;
                }
                case 257: {
                    metaDataImage.height = (int)tagvalue;
                    break;
                }
                case 258: {
                    metaDataImage.bitspersample = (int)tagvalue;
                    break;
                }
                case 259: {
                    metaDataImage.compression = (int)tagvalue;
                    break;
                }
                case 274: {
                    metaDataImage.orientation = (int)tagvalue;
                    break;
                }
                case 262: {
                    metaDataImage.photometric = (int)tagvalue;
                    this.metaData.colorType = this.getColorType(metaDataImage.photometric);
                    break;
                }
                case 277: {
                    metaDataImage.samplesperpixel = (int)tagvalue;
                    break;
                }
                case 338: {
                    metaDataImage.extrasamples = this.getTagValueShortArray(tagvalueoffset, tagvaluecount);
                    break;
                }
                case 284: {
                    metaDataImage.planarconfiguration = (int)tagvalue;
                    break;
                }
                case 278: {
                    metaDataImage.tileHeight = (int)tagvalue;
                    break;
                }
                case 322: {
                    metaDataImage.tileWidth = (int)tagvalue;
                    break;
                }
                case 323: {
                    metaDataImage.tileHeight = (int)tagvalue;
                    break;
                }
                case 296: {
                    metaDataImage.unitResolution = (int)tagvalue;
                    break;
                }
                case 282: {
                    metaDataImage.xResolution = rational;
                    break;
                }
                case 283: {
                    metaDataImage.yResolution = rational;
                    break;
                }
                case 700: {
                    metaDataImage.xmp = bytes;
                    break;
                }
                case 305: {
                    if (ascii == null) break;
                    metaDataImage.software = ascii;
                    break;
                }
                case 33723: {
                    if (longs != null) {
                        metaDataImage.iptc = this.longsToBytes(longs, this.reader.getByteOrder());
                        break;
                    }
                    if (bytes != null) {
                        metaDataImage.iptc = bytes;
                        break;
                    }
                    if (tagvalue == -1L) break;
                    this.reader.seek(tagvalue);
                    metaDataImage.iptc = this.intToBytes((int)this.reader.readUInt(), this.reader.getByteOrder());
                    break;
                }
                case 34377: {
                    byte[] data = null;
                    if (bytes != null) {
                        data = bytes;
                    } else if (longs != null) {
                        data = this.longsToBytes(longs, this.reader.getByteOrder());
                    } else if (tagvalue != -1L) {
                        this.reader.seek(tagvalue);
                        data = this.intToBytes((int)this.reader.readUInt(), this.reader.getByteOrder());
                    }
                    if (data == null) break;
                    int interpos = this.is8BIM(data);
                    if (interpos != -1) {
                        byte[] rawxmp;
                        Decode8BIM dec8BIM = new Decode8BIM(data);
                        byte[] rawexif = dec8BIM.getResource("EXIF");
                        if (rawexif != null) {
                            metaDataImage.exif = rawexif;
                        }
                        if ((rawxmp = dec8BIM.getResource("XMP")) != null) {
                            metaDataImage.xmp = rawxmp;
                        }
                        if (dec8BIM.getPathCount() > 0) {
                            metaDataImage.selections = dec8BIM.getPaths();
                        }
                        metaDataImage.alphaNames = dec8BIM.getAlphaNames();
                        break;
                    }
                    interpos = this.isEXIF(data);
                    if (interpos == 0) {
                        int cutlen = data.length - interpos;
                        metaDataImage.exif = new byte[cutlen];
                        System.arraycopy(data, interpos, metaDataImage.exif, 0, cutlen);
                        break;
                    }
                    interpos = this.isIPTC(data);
                    if (interpos != 0) break;
                    int cutlen = data.length - interpos;
                    metaDataImage.iptc = new byte[cutlen];
                    System.arraycopy(data, interpos, metaDataImage.iptc, 0, cutlen);
                    break;
                }
                case 34665: {
                    metaDataImage.exif = this.scanExifIDF(tagvalue);
                    break;
                }
                case 34675: {
                    metaDataImage.icc = new ICCProfileWrap(bytes);
                    break;
                }
                case 330: {
                    nextIDF = tagvalue;
                }
            }
        }
        return nextIDF;
    }

    private long[] getTagValueLong(long tagvalueoffset, long tagvaluecount) throws IOException {
        if (tagvaluecount > Integer.MAX_VALUE) {
            throw new IOException("tagvaluecount > 2147483647");
        }
        long[] result = new long[(int)tagvaluecount];
        if (tagvaluecount == 1L) {
            result[0] = (int)tagvalueoffset;
        } else {
            this.reader.seek(tagvalueoffset);
            int l = 0;
            while ((long)l < tagvaluecount) {
                result[l] = this.reader.readUInt();
                ++l;
            }
        }
        return result;
    }

    private float getTagValueFloat(long tagvalueoffset, long tagvaluecount) throws IOException {
        float returnvalue = -1.0f;
        if (tagvaluecount <= 2L) {
            return Float.intBitsToFloat(this.littleendian ? (int)tagvalueoffset : Bits.swap((int)tagvalueoffset));
        }
        this.reader.seek(tagvalueoffset);
        returnvalue = this.reader.readFloat();
        return returnvalue;
    }

    private double getTagValueDouble(long tagvalueoffset, long tagvaluecount) throws IOException {
        double returnvalue = -1.0;
        if (tagvaluecount == 1L) {
            return Double.longBitsToDouble(this.littleendian ? tagvalueoffset : Bits.swap(tagvalueoffset));
        }
        this.reader.seek(tagvalueoffset);
        returnvalue = this.reader.readDouble();
        return returnvalue;
    }

    private Rational getTagValueRational(long tagvalueoffset, long tagvaluecount) throws IOException {
        this.reader.seek(tagvalueoffset);
        long num = this.reader.readUInt();
        long dom = this.reader.readUInt();
        Rational returnvalue = new Rational(num, dom);
        return returnvalue;
    }

    private int getTagValueShort(long tagvalueoffset, long tagvaluecount) throws IOException {
        int returnvalue = -1;
        if (tagvaluecount <= 2L) {
            returnvalue = this.littleendian ? (int)tagvalueoffset : ((int)(tagvalueoffset >> 24) & 0xFF) * 256 + ((int)(tagvalueoffset >> 16) & 0xFF);
        } else {
            try {
                this.reader.seek(tagvalueoffset);
                returnvalue = this.reader.readUShort();
            }
            catch (IllegalArgumentException e) {
                if (this.logger != null) {
                    this.logger.logException(e, 3811, this.metaData.source, e.getLocalizedMessage());
                }
                this.errorCode |= 4;
            }
        }
        return returnvalue;
    }

    private int[] getTagValueShortArray(long tagvalueoffset, long tagvaluecount) throws IOException {
        if (tagvaluecount > Integer.MAX_VALUE) {
            throw new IOException("tagvaluecount > 2147483647");
        }
        int[] returnvalue = new int[(int)tagvaluecount];
        if (tagvaluecount > 2L) {
            this.reader.seek(tagvalueoffset);
            int c = 0;
            while ((long)c < tagvaluecount) {
                returnvalue[c] = this.reader.readUShort();
                ++c;
            }
        } else if (this.littleendian) {
            int c = 0;
            int s = 0;
            while ((long)c < tagvaluecount) {
                returnvalue[c] = (int)(tagvalueoffset >> s & 0xFFFFL);
                ++c;
                s += 16;
            }
        } else {
            int c = 0;
            int s = 0;
            while ((long)c < tagvaluecount) {
                returnvalue[(int)tagvaluecount - c - 1] = (int)(tagvalueoffset >> s & 0xFFFFL);
                ++c;
                s += 16;
            }
        }
        return returnvalue;
    }

    private byte[] getTagValueBytes(long tagvalueoffset, long tagvaluecount) throws IOException {
        if (tagvaluecount > Integer.MAX_VALUE) {
            throw new IOException("tagvaluecount > 2147483647");
        }
        byte[] bytes = new byte[(int)tagvaluecount];
        if (tagvaluecount <= 4L) {
            int i = 0;
            while ((long)i < tagvaluecount) {
                bytes[i] = (byte)(tagvalueoffset >> 8 * i & 0xFFL);
                ++i;
            }
        } else {
            this.reader.seek(tagvalueoffset);
            this.reader.read(bytes);
        }
        return bytes;
    }

    private byte[] longsToBytes(long[] longs, ByteOrder bo) {
        byte[] result = new byte[longs.length * 4];
        int p = 0;
        if (bo == ByteOrder.BIG_ENDIAN) {
            for (long l : longs) {
                result[p++] = (byte)(l >> 24);
                result[p++] = (byte)(l >> 16 & 0xFFL);
                result[p++] = (byte)(l >> 8 & 0xFFL);
                result[p++] = (byte)(l & 0xFFL);
            }
        } else {
            for (long l : longs) {
                result[p++] = (byte)(l & 0xFFL);
                result[p++] = (byte)(l >> 8 & 0xFFL);
                result[p++] = (byte)(l >> 16 & 0xFFL);
                result[p++] = (byte)(l >> 24);
            }
        }
        return result;
    }

    private byte[] intToBytes(int i, ByteOrder bo) {
        byte[] result = new byte[4];
        if (bo == ByteOrder.BIG_ENDIAN) {
            result[0] = (byte)(i >> 24);
            result[1] = (byte)(i >> 16 & 0xFF);
            result[2] = (byte)(i >> 8 & 0xFF);
            result[3] = (byte)(i & 0xFF);
        } else {
            result[0] = (byte)(i & 0xFF);
            result[1] = (byte)(i >> 8 & 0xFF);
            result[2] = (byte)(i >> 16 & 0xFF);
            result[3] = (byte)(i >> 24);
        }
        return result;
    }

    private void parseHeader(byte[] ifh) {
        boolean error = false;
        if (ifh[0] == 73 && ifh[1] == 73) {
            this.littleendian = true;
            this.reader.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else if (ifh[0] == 77 && ifh[1] == 77) {
            this.littleendian = false;
            this.reader.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else {
            error = true;
        }
        if (this.littleendian && ifh[2] != 42 && ifh[3] != 0) {
            error = true;
        } else if (!this.littleendian && ifh[2] != 0 && ifh[3] != 42) {
            error = true;
        }
        if (error) {
            this.errorCode |= 4;
            if (this.logger != null) {
                this.logger.log(3804, "TIFF", this.metaData.source);
            }
        }
    }

    private long scanIDF(FSISubImageMetaData metaDataImage) {
        long nextIDF = 0L;
        try {
            this.reader.seek(this.idfOffset);
            int idf_entry_count = this.reader.readUShort();
            if (idf_entry_count > 0) {
                int i;
                TIFFRawTag[] idf = new TIFFRawTag[idf_entry_count];
                for (i = 0; i < idf_entry_count; ++i) {
                    idf[i] = new TIFFRawTag();
                    idf[i].tagname = this.reader.readUShort();
                    idf[i].tagtype = this.reader.readUShort();
                    idf[i].tagvaluecount = this.reader.readUInt();
                    idf[i].tagvalueoffset = this.reader.readUInt();
                }
                nextIDF = this.reader.readUInt();
                for (i = 0; i < idf_entry_count; ++i) {
                    long nextIDFTag = this.evaluateTag(metaDataImage, idf[i].tagname, idf[i].tagtype, idf[i].tagvaluecount, idf[i].tagvalueoffset);
                    if (nextIDFTag == 0L) continue;
                    nextIDF = nextIDFTag;
                }
            } else {
                if (this.logger != null) {
                    this.logger.log(3850, this.metaData.source);
                }
                this.errorCode |= 4;
            }
        }
        catch (Error e) {
            this.logger.logError(e, 3834, this.metaData.source);
            this.errorCode |= 4;
        }
        catch (Exception e) {
            this.logger.logException(e, 3850, this.metaData.source);
            this.errorCode |= 4;
        }
        return nextIDF;
    }

    private byte[] scanExifIDF(long exifIDFPos) {
        byte[] nExif = null;
        try {
            this.reader.seek(exifIDFPos);
            int exifEntryCount = this.reader.readUShort();
            long nextExifIdf = -1L;
            int n = 0;
            if (exifEntryCount > 0 && exifEntryCount < 2000) {
                ExifBuilder builder = new ExifBuilder();
                ExifIDFRawTag[] idf = new ExifIDFRawTag[exifEntryCount];
                while (nextExifIdf != 0L) {
                    int i;
                    for (i = n; i < exifEntryCount; ++i) {
                        idf[i] = new ExifIDFRawTag();
                        idf[i].tagname = this.reader.readUShort();
                        idf[i].tagtype = this.reader.readUShort();
                        idf[i].tagvaluecount = this.reader.readInt();
                        idf[i].tagvalueoffset = this.reader.readInt();
                    }
                    nextExifIdf = 0L;
                    for (i = n; i < exifEntryCount; ++i) {
                        this.evaluateExifTag(builder, idf[i]);
                    }
                }
                nExif = builder.evaluate();
            } else if (exifEntryCount != 0 && this.logger != null) {
                this.logger.log(3862, this.metaData.source);
            }
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.logException(e, 3850, this.metaData.source);
            }
            this.errorCode |= 4;
        }
        return nExif;
    }

    private void evaluateExifTag(ExifBuilder builder, ExifIDFRawTag entry) throws IOException {
        if (entry.tagtype == 3 || entry.tagtype == 8) {
            int tagvalue = this.getTagValueShort(entry.tagvalueoffset, entry.tagvaluecount);
            entry.tagvaluecount = 1;
            entry.tagvalueoffset = tagvalue;
            builder.addTag(entry, null);
        } else if (entry.tagtype == 4 || entry.tagtype == 9 || entry.tagtype == 13) {
            long[] longs = null;
            if (entry.tagvaluecount != 1) {
                longs = this.getTagValueLong(entry.tagvalueoffset, entry.tagvaluecount);
            }
            builder.addTag(entry, longs);
        } else if (entry.tagtype == 11) {
            float valueFloat = this.getTagValueFloat(entry.tagvalueoffset, entry.tagvaluecount);
            entry.tagvaluecount = 0;
            entry.tagvalueoffset = Float.floatToIntBits(valueFloat);
            builder.addTag(entry, null);
        } else if (entry.tagtype == 12) {
            double valueDouble = this.getTagValueDouble(entry.tagvalueoffset, entry.tagvaluecount);
            entry.tagvaluecount = 1;
            entry.tagvalueoffset = 0L;
            Long raw = Double.doubleToLongBits(valueDouble);
            builder.addTag(entry, raw);
        } else if (entry.tagtype == 5 || entry.tagtype == 10) {
            Rational rational = this.getTagValueRational(entry.tagvalueoffset, entry.tagvaluecount);
            builder.addTag(entry, rational);
        } else if (entry.tagtype == 1 || entry.tagtype == 2) {
            byte[] bytes = null;
            if (entry.tagvaluecount > 4) {
                bytes = this.getTagValueBytes(entry.tagvalueoffset, entry.tagvaluecount);
            }
            builder.addTag(entry, bytes);
        }
    }

    private float resolution(Rational r, int unit) {
        float resx = -1.0f;
        if (r != null && unit != 1) {
            long numerator = r.numerator;
            long dominator = r.denominator;
            if (unit == 2) {
                numerator *= 100L;
                dominator *= 254L;
            }
            resx = (float)(10.0 * (double)dominator / (double)numerator);
            if (unit == 2) {
                resx = (float)Math.floor(25.4f / resx);
            }
        }
        return resx;
    }
}

