/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.metrics;

import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;

public final class Histogram {
    public float[] statisticRed = new float[256];
    public float[] statisticGreen = new float[256];
    public float[] statisticBlue = new float[256];
    public float[] statisticHue = new float[360];
    public float[] statisticSaturation = new float[256];
    public float[] statisticBrightness = new float[256];
    public volatile long pixel = 0L;
    public float redFraction = 0.0f;
    public float greenFraction = 0.0f;
    public float blueFraction = 0.0f;
    public byte redMin;
    public byte redMax;
    public byte greenMin;
    public byte greenMax;
    public byte blueMin;
    public byte blueMax;
    public byte saturationMin;
    public byte saturationMax;
    public byte brightnessMin;
    public byte brightnessMax;
    public long redSum;
    public long greenSum;
    public long blueSum;
    public long saturationSum;
    public long brightnessSum;
    private int[] channelR = new int[256];
    private int[] channelG = new int[256];
    private int[] channelB = new int[256];
    private final int[] channelHue = new int[360];
    private int[] channelSat = new int[256];
    private int[] channelBri = new int[256];

    public void pushRGB(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        this.pushRGB(r, g, b);
    }

    public void pushARGB(int argb) {
        int a = argb >> 24 & 0xFF;
        if (a > 0) {
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            this.pushRGB(r, g, b);
        }
    }

    public void pushARGB(int a, int r, int g, int b) {
        if (a > 0) {
            this.pushRGB(r, g, b);
        }
    }

    public void pushRGB(int r, int g, int b) {
        int brightness = Math.max(Math.max(r, g), b);
        int minrgbi = Math.min(Math.min(r, g), b);
        int deltai = brightness - minrgbi;
        int saturation = brightness == 0 ? 0 : (int)((float)deltai / (float)brightness * 255.0f + 0.5f);
        int hue = Histogram.getHue(r, g, b, brightness, deltai);
        int n = r;
        this.channelR[n] = this.channelR[n] + 1;
        int n2 = g;
        this.channelG[n2] = this.channelG[n2] + 1;
        int n3 = b;
        this.channelB[n3] = this.channelB[n3] + 1;
        int n4 = saturation;
        this.channelSat[n4] = this.channelSat[n4] + 1;
        int n5 = brightness;
        this.channelBri[n5] = this.channelBri[n5] + 1;
        if (saturation > 0) {
            int n6 = hue;
            this.channelHue[n6] = this.channelHue[n6] + 1;
        }
        ++this.pixel;
    }

    public boolean hasData() {
        return this.pixel > 0L;
    }

    public void digest() {
        this.redMin = (byte)Histogram.getMin(this.channelR);
        this.greenMin = (byte)Histogram.getMin(this.channelR);
        this.blueMin = (byte)Histogram.getMin(this.channelB);
        this.saturationMin = (byte)Histogram.getMin(this.channelSat);
        this.brightnessMin = (byte)Histogram.getMin(this.channelBri);
        this.redMax = (byte)Histogram.getMax(this.channelR);
        this.greenMax = (byte)Histogram.getMax(this.channelG);
        this.blueMax = (byte)Histogram.getMax(this.channelB);
        this.saturationMax = (byte)Histogram.getMax(this.channelSat);
        this.brightnessMax = (byte)Histogram.getMax(this.channelBri);
        float[] normalR = new float[this.channelR.length];
        int sumR = Histogram.getSum(this.channelR);
        float vsumR = (float)sumR / 100.0f;
        int n = this.channelR.length;
        for (int p = 0; p < n; ++p) {
            if (!(vsumR > 0.0f)) continue;
            normalR[p] = (float)this.channelR[p] / vsumR;
        }
        this.statisticRed = normalR;
        float[] normalG = new float[this.channelG.length];
        int sumG = Histogram.getSum(this.channelG);
        float vsumG = (float)sumG / 100.0f;
        int n2 = this.channelG.length;
        for (int p = 0; p < n2; ++p) {
            if (!(vsumG > 0.0f)) continue;
            normalG[p] = (float)this.channelG[p] / vsumG;
        }
        this.statisticGreen = normalG;
        float[] normalB = new float[this.channelB.length];
        int sumB = Histogram.getSum(this.channelB);
        float vsumB = (float)sumB / 100.0f;
        int n3 = this.channelB.length;
        for (int p = 0; p < n3; ++p) {
            if (!(vsumB > 0.0f)) continue;
            normalB[p] = (float)this.channelB[p] / vsumB;
        }
        this.statisticBlue = normalB;
        float[] normalHue = new float[this.channelHue.length];
        int sumHue = Histogram.getSum(this.channelHue);
        float vsumHue = (float)sumHue / 100.0f;
        int n4 = this.channelHue.length;
        for (int p = 0; p < n4; ++p) {
            if (!(vsumHue > 0.0f)) continue;
            normalHue[p] = (float)this.channelHue[p] / vsumHue;
        }
        this.statisticHue = normalHue;
        float[] normalSat = new float[this.channelSat.length];
        int sumSat = Histogram.getSum(this.channelSat);
        float vsumSat = (float)sumSat / 100.0f;
        int n5 = this.channelSat.length;
        for (int p = 0; p < n5; ++p) {
            if (!(vsumSat > 0.0f)) continue;
            normalSat[p] = (float)this.channelSat[p] / vsumSat;
        }
        this.statisticSaturation = normalSat;
        float[] normalBri = new float[this.channelBri.length];
        int sumBri = Histogram.getSum(this.channelBri);
        float vsumBri = (float)sumBri / 100.0f;
        int n6 = this.channelBri.length;
        for (int p = 0; p < n6; ++p) {
            if (!(vsumBri > 0.0f)) continue;
            normalBri[p] = (float)this.channelBri[p] / vsumBri;
        }
        this.statisticBrightness = normalBri;
        long sumTotalRGB = sumR + sumG + sumB;
        if (sumTotalRGB > 0L) {
            this.redFraction = (float)sumR / (float)sumTotalRGB;
            this.greenFraction = (float)sumG / (float)sumTotalRGB;
            this.blueFraction = (float)sumB / (float)sumTotalRGB;
        }
    }

    private static int getMin(int[] channel) {
        int result = 255;
        int n = channel.length;
        for (int i = 0; i < n && (result <= channel[i] || (result = channel[i]) != 0); ++i) {
        }
        return result;
    }

    private static int getMax(int[] channel) {
        int result = 0;
        int n = channel.length;
        for (int i = 0; i < n && (result >= channel[i] || (result = channel[i]) != 255); ++i) {
        }
        return result;
    }

    private static int getSum(int[] channel) {
        int result = 0;
        int n = channel.length;
        for (int i = 0; i < n; ++i) {
            result += channel[i];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Histogram) {
            Histogram other = (Histogram)obj;
            if (this.hashCode() == other.hashCode()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode ^= Float.floatToIntBits(this.redFraction);
        hashCode ^= Float.floatToIntBits(this.greenFraction);
        hashCode ^= Float.floatToIntBits(this.blueFraction);
        hashCode ^= this.redMin;
        hashCode ^= this.redMax;
        hashCode ^= this.greenMin << 8;
        hashCode ^= this.redMax << 8;
        hashCode ^= this.blueMin << 16;
        hashCode ^= this.blueMax << 16;
        hashCode ^= this.saturationMin << 24;
        hashCode ^= this.saturationMax << 24;
        hashCode ^= this.brightnessMin;
        hashCode ^= this.brightnessMin;
        hashCode ^= Arrays.hashCode(this.statisticRed);
        hashCode ^= Arrays.hashCode(this.statisticGreen);
        hashCode ^= Arrays.hashCode(this.statisticBlue);
        hashCode ^= Arrays.hashCode(this.statisticHue);
        hashCode ^= Arrays.hashCode(this.statisticSaturation);
        return hashCode ^= Arrays.hashCode(this.statisticBrightness);
    }

    public static Histogram unserialize(byte[] data) {
        int l;
        int i;
        Histogram hist = new Histogram();
        ByteArrayWalker bb = ByteArrayWalker.wrap(data, ByteOrder.nativeOrder());
        hist.pixel = bb.getLong();
        int len = bb.getInt();
        for (i = 0; i < len; ++i) {
            hist.statisticRed[i] = bb.getFloat();
        }
        len = bb.getInt();
        for (i = 0; i < len; ++i) {
            hist.statisticGreen[i] = bb.getFloat();
        }
        len = bb.getInt();
        for (i = 0; i < len; ++i) {
            hist.statisticBlue[i] = bb.getFloat();
        }
        len = bb.getInt();
        for (i = 0; i < len; ++i) {
            hist.statisticHue[i] = bb.getFloat();
        }
        len = bb.getInt();
        for (i = 0; i < len; ++i) {
            hist.statisticSaturation[i] = bb.getFloat();
        }
        len = bb.getInt();
        for (i = 0; i < len; ++i) {
            hist.statisticBrightness[i] = bb.getFloat();
        }
        hist.redFraction = bb.getFloat();
        hist.greenFraction = bb.getFloat();
        hist.blueFraction = bb.getFloat();
        hist.redMin = bb.get();
        hist.redMax = bb.get();
        hist.greenMin = bb.get();
        hist.greenMax = bb.get();
        hist.blueMin = bb.get();
        hist.blueMax = bb.get();
        hist.saturationMin = bb.get();
        hist.saturationMax = bb.get();
        hist.brightnessMin = bb.get();
        hist.brightnessMax = bb.get();
        byte channels = bb.get();
        len = bb.getInt();
        hist.channelR = new int[len];
        for (l = 0; l < len; ++l) {
            hist.channelR[l] = bb.getInt();
        }
        len = bb.getInt();
        hist.channelG = new int[len];
        for (l = 0; l < len; ++l) {
            hist.channelG[l] = bb.getInt();
        }
        len = bb.getInt();
        hist.channelB = new int[len];
        for (l = 0; l < len; ++l) {
            hist.channelB[l] = bb.getInt();
        }
        len = bb.getInt();
        hist.channelSat = new int[len];
        for (l = 0; l < len; ++l) {
            hist.channelSat[l] = bb.getInt();
        }
        len = bb.getInt();
        hist.channelBri = new int[len];
        for (l = 0; l < len; ++l) {
            hist.channelBri[l] = bb.getInt();
        }
        len = bb.getInt();
        for (l = 0; l < len; ++l) {
            hist.channelHue[l] = bb.getInt();
        }
        len = bb.getInt();
        hist.redMin = (byte)bb.getInt();
        hist.greenMin = (byte)bb.getInt();
        hist.blueMin = (byte)bb.getInt();
        hist.saturationMin = (byte)bb.getInt();
        hist.brightnessMin = (byte)bb.getInt();
        len = bb.getInt();
        hist.redMax = (byte)bb.getInt();
        hist.greenMax = (byte)bb.getInt();
        hist.blueMax = (byte)bb.getInt();
        hist.saturationMax = (byte)bb.getInt();
        hist.brightnessMax = (byte)bb.getInt();
        len = bb.getInt();
        hist.redSum = (byte)bb.getLong();
        hist.greenSum = (byte)bb.getLong();
        hist.blueSum = (byte)bb.getLong();
        hist.saturationSum = (byte)bb.getLong();
        hist.brightnessSum = (byte)bb.getLong();
        return hist;
    }

    /*
     * Exception decompiling
     */
    public byte[] serialize() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int getHue(int red, int green, int blue, int maxrgbi, int deltai) {
        int h;
        if (deltai != 0) {
            float hue = red == maxrgbi ? 60.0f * ((float)(green - blue) / (float)deltai) : (green == maxrgbi ? 60.0f * (2.0f + (float)(blue - red) / (float)deltai) : 60.0f * (4.0f + (float)(red - green) / (float)deltai));
            if (hue < 0.0f) {
                hue += 360.0f;
            } else if (hue == 360.0f) {
                hue = 0.0f;
            }
            h = (int)hue;
        } else {
            h = 0;
        }
        return h;
    }

    private static int[] getHSBOrg(int red, int green, int blue) {
        int maxrgbi = Math.max(Math.max(red, green), blue);
        int minrgbi = Math.min(Math.min(red, green), blue);
        int deltai = maxrgbi - minrgbi;
        int[] result = new int[3];
        result[2] = maxrgbi;
        int n = result[1] = maxrgbi == 0 ? 0 : (int)((float)deltai / (float)maxrgbi * 255.0f + 0.5f);
        if (deltai != 0) {
            float hue = red == maxrgbi ? 60.0f * ((float)(green - blue) / (float)deltai) : (green == maxrgbi ? 60.0f * (2.0f + (float)(blue - red) / (float)deltai) : 60.0f * (4.0f + (float)(red - green) / (float)deltai));
            if (hue < 0.0f) {
                hue += 360.0f;
            } else if (hue == 360.0f) {
                hue = 0.0f;
            }
            result[0] = (int)hue;
        } else {
            result[0] = 0;
        }
        return result;
    }
}

