/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.pyramidreader;

import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.converter.BufferedImageConverterThreaded;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.helper.RangeRelative;
import com.neptunelabs.imagereader.helper.ReaderHelperAbstact;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import java.io.IOException;
import java.nio.ByteOrder;

public abstract class PyramidImageReaderAbstract
extends ReaderHelperAbstact {
    final long maxRawMem;
    final int flatImageLimit;
    final boolean forceSwap;
    final ByteOrder byteOrder;
    final BufferedImageConverterThreaded converter;
    final CacheManager cacheManager;
    String assetURLPath = null;
    FSIMetaData metaData = null;
    ICCProfileWrap defaultCMYKICC = null;
    ICCProfileWrap defaultRGBICC = null;
    ICCProfileWrap defaultGrayICC = null;
    boolean fallbackICCConversion = true;
    IOController ioController = null;
    FSIImage image = null;
    boolean error = false;
    boolean shutdown = false;
    boolean finished = false;

    public PyramidImageReaderAbstract(FSILogger fsilogger, ExecutorPool executorPool, SwapPool swapPool, BufferedImageConverterThreaded converter, PluginLoader pluginLoader, CacheManager cacheManager, ByteOrder byteOrder, boolean forceSwap, long maxRawMem, int flatImageLimit) {
        super(fsilogger, swapPool, executorPool, pluginLoader);
        this.forceSwap = forceSwap;
        this.maxRawMem = maxRawMem;
        this.flatImageLimit = flatImageLimit;
        this.byteOrder = byteOrder;
        this.converter = converter;
        this.cacheManager = cacheManager;
        if (cacheManager == null) {
            throw new NullPointerException("CacheManager cannot be null");
        }
    }

    public abstract boolean readImage(FSIMetaData var1, String var2, int var3, int var4, RangeRelative var5, int var6, int var7) throws IOException;

    public void setDefaultICCProfiles(ICCProfileWrap cmyk, ICCProfileWrap rgb, ICCProfileWrap gray) {
        this.defaultCMYKICC = cmyk;
        this.defaultRGBICC = rgb;
        this.defaultGrayICC = gray;
    }

    public void setUseFallbackICCConversion(boolean state) {
        this.fallbackICCConversion = state;
    }

    public void setIOController(IOController ioController) {
        this.ioController = ioController;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public boolean isDown() {
        return this.finished;
    }

    public void destroy() {
        this.shutdown();
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
    }

    public FSIImage getImage() {
        return this.image;
    }

    public void setImage(FSIImage image) {
        this.image = image;
    }

    public boolean hasError() {
        return this.error;
    }

    public boolean isDisposed() {
        boolean result = false;
        if (this.image != null && this.image.isDisposed()) {
            result = true;
        }
        return result;
    }

    public boolean isPluginLoaded(String name) {
        return this.pluginLoader.isPluginLoaded(name);
    }
}

