/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.pyramidreader;

import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.converter.BufferedImageConverterThreaded;
import com.neptunelabs.imagereader.helper.RangeRelative;
import com.neptunelabs.imagereader.helper.ReaderHelperAbstact;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.pyramidreader.PyramidImageReaderAbstract;
import com.neptunelabs.imagereader.reader.fpx.FPXImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class PyramidImageReaderFPX
extends PyramidImageReaderAbstract {
    private FPXImage fpximage = null;

    public PyramidImageReaderFPX(FSILogger fsilogger, ExecutorPool executorPool, SwapPool swapPool, BufferedImageConverterThreaded converter, PluginLoader pluginLoader, CacheManager cacheManager, ByteOrder byteOrder, boolean swap, long maxRawMem, int flatImageLimit) {
        super(fsilogger, executorPool, swapPool, converter, pluginLoader, cacheManager, byteOrder, swap, maxRawMem, flatImageLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readImage(FSIMetaData metaData, String assetURLPath, int priority, int level, RangeRelative range, int totalWidthInLevel, int totalHeightInLevel) throws IOException {
        boolean returnvalue = false;
        try {
            this.metaData = metaData;
            this.assetURLPath = assetURLPath;
            try {
                this.fpximage = new FPXImage(this.logger, metaData.sourceFile.getPath(), false);
            }
            catch (IOException e) {
                this.error = true;
            }
            int tileSizeX = this.fpximage.getTileWidth();
            int tileSizeY = this.fpximage.getTileHeight();
            double rangeWidth = this.autoCorrectRangeParam(range.left, range.width);
            double rangeHeight = this.autoCorrectRangeParam(range.top, range.height);
            boolean hasAlpha = false;
            this.image = this.createResultImage((double)totalWidthInLevel * rangeWidth, (double)totalHeightInLevel * rangeHeight, false);
            int xOffsetInLevel = (int)Math.floor((double)totalWidthInLevel * range.left);
            int yOffsetInLevel = (int)Math.floor((double)totalHeightInLevel * range.top);
            int firstTileX = xOffsetInLevel / tileSizeX;
            int firstTileY = yOffsetInLevel / tileSizeY;
            int currentResultOffsetX = 0;
            int currentResultOffsetY = 0;
            if (!this.error) {
                boolean result = this.fpximage.changeResolution(level);
                int tilesX = (int)Math.ceil((float)(this.image.getWidth() + xOffsetInLevel) / (float)tileSizeX) + firstTileX;
                int tilesY = (int)Math.ceil((float)(this.image.getHeight() + yOffsetInLevel) / (float)tileSizeY) + firstTileY;
                int tilesTotal = tilesX * tilesY;
                PriorityExecutorCompletionService<Boolean> completionService = new PriorityExecutorCompletionService<Boolean>(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_IO), tilesTotal);
                ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(tilesTotal);
                int jobs = 0;
                int ty = firstTileY;
                while (currentResultOffsetY < this.image.getHeight()) {
                    currentResultOffsetX = 0;
                    int n = 0;
                    if (ty == firstTileY) {
                        n = yOffsetInLevel % tileSizeY;
                    }
                    int tx = firstTileX;
                    while (currentResultOffsetX < this.image.getWidth()) {
                        Raster raster;
                        int tileOffsetX = 0;
                        if (tx == firstTileX) {
                            tileOffsetX = xOffsetInLevel % tileSizeX;
                        }
                        if ((raster = this.fpximage.getTile(tx, ty)) != null) {
                            ReaderHelperAbstact.TileCopierRaster tileCopier = new ReaderHelperAbstact.TileCopierRaster(priority, this.image.createSlice(), raster, tileOffsetX, n, currentResultOffsetX, currentResultOffsetY);
                            futures.add(completionService.submit(tileCopier));
                            ++jobs;
                        }
                        currentResultOffsetX += tileSizeX - tileOffsetX;
                        ++tx;
                    }
                    currentResultOffsetY += tileSizeY - n;
                    ++ty;
                }
                returnvalue = true;
                try {
                    for (int c = 0; c < jobs; ++c) {
                        returnvalue &= ((Boolean)completionService.take().get()).booleanValue();
                    }
                }
                catch (InterruptedException e) {
                    returnvalue = false;
                    return returnvalue;
                }
                catch (ExecutionException e) {
                    returnvalue = false;
                    this.logger.logException(e, 3800, e.getLocalizedMessage());
                }
                finally {
                    for (Future future : futures) {
                        future.cancel(true);
                    }
                }
            }
            this.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnvalue;
    }

    @Override
    public void destroy() {
        this.shutdown();
        while (!this.finished && !this.error) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        super.destroy();
    }

    private void close() {
        try {
            if (this.fpximage != null) {
                this.fpximage.close();
            }
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.logException(e, 3811, this.metaData.source, e.getLocalizedMessage());
            }
            this.error = true;
        }
        this.finished = true;
    }

    private FSIImage createResultImage(double width, double height, boolean hasAlpha) {
        FSIImageMode mode = hasAlpha ? FSIImageMode.ARGB : FSIImageMode.RGB;
        return new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, (int)Math.ceil(width), (int)Math.ceil(height), this.metaData.source, mode);
    }

    private double autoCorrectRangeParam(double start, double range) {
        if (start + range > 1.0) {
            range = 1.0 - start;
        }
        return range;
    }
}

