/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.pyramidreader;

import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheLoad;
import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imageioimpl.SeekableByteChannelImageInputStreamSpi;
import com.neptunelabs.imagereader.converter.BufferedImageConverterThreaded;
import com.neptunelabs.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.imagereader.helper.RangeRelative;
import com.neptunelabs.imagereader.helper.ReaderHelperAbstact;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.pyramidreader.FlatImageException;
import com.neptunelabs.imagereader.pyramidreader.PyramidImageReaderAbstract;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public final class PyramidImageReaderTIFF
extends PyramidImageReaderAbstract {
    private TIFFImageReader imgReader = null;
    private InputStream fis = null;
    private ImageInputStream iis = null;

    public PyramidImageReaderTIFF(FSILogger logger, ExecutorPool executorPool, SwapPool swapPool, BufferedImageConverterThreaded converter, PluginLoader pluginLoader, CacheManager cacheManager, ByteOrder byteOrder, boolean swap, long maxRawMem, int flatImageLimit) {
        super(logger, executorPool, swapPool, converter, pluginLoader, cacheManager, byteOrder, swap, maxRawMem, flatImageLimit);
    }

    private boolean hasValidPyramid() {
        boolean result = false;
        if (this.metaData != null) {
            int depth = this.metaData.imageCount;
            int width = this.metaData.getWidth(0);
            int height = this.metaData.getHeight(0);
            result = depth != 1 || width <= this.flatImageLimit && height <= this.flatImageLimit;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readImage(FSIMetaData metaDataValue, String assetURLPath, int priority, int level, RangeRelative range, int totalWidthInLevel, int totalHeightInLevel) throws IOException {
        boolean returnvalue = false;
        this.metaData = metaDataValue;
        this.assetURLPath = assetURLPath;
        int tileSizeX = this.metaData.getTileWidth(level);
        int tileSizeY = this.metaData.getTileHeight(level);
        double rangeWidth = this.autoCorrectRangeParam(range.left, range.width);
        double rangeHeight = this.autoCorrectRangeParam(range.top, range.height);
        boolean hasAlpha = false;
        int xOffsetInLevel = (int)Math.floor((double)totalWidthInLevel * range.left);
        int yOffsetInLevel = (int)Math.floor((double)totalHeightInLevel * range.top);
        int firstTileX = xOffsetInLevel / tileSizeX;
        int firstTileY = yOffsetInLevel / tileSizeY;
        int currentResultOffsetX = 0;
        int currentResultOffsetY = 0;
        if (!this.error) {
            int targetWidth = (int)Math.ceil((double)totalWidthInLevel * rangeWidth);
            int targetHeight = (int)Math.ceil((double)totalHeightInLevel * rangeHeight);
            int tileOffsetXOff = xOffsetInLevel % tileSizeX;
            int tilesX = targetWidth == tileSizeX ? 1 : (int)Math.ceil((float)(targetWidth + tileOffsetXOff) / (float)tileSizeX);
            int tileOffsetYOff = yOffsetInLevel % tileSizeY;
            int tilesY = targetHeight == tileSizeY ? 1 : (int)Math.ceil((float)(targetHeight + tileOffsetYOff) / (float)tileSizeY);
            CacheKey cacheKey = CacheKey.getInstance(assetURLPath, 'A', "irrb_" + level + "_" + firstTileX + "_" + tilesX + "_" + firstTileY + "_" + tilesY + "_" + xOffsetInLevel + "_" + yOffsetInLevel + "_" + rangeWidth + "_" + rangeHeight);
            CacheLoad fsiRawBaseImage = this.cacheManager.get(cacheKey, CacheType.IMAGE);
            if (fsiRawBaseImage != null) {
                this.image = FSIImage.unpack(this.logger, this.swapPool, fsiRawBaseImage.data);
            } else {
                try {
                    this.imgReader = new TIFFImageReader(new TIFFImageReaderSpi());
                    try {
                        SeekableByteChannelImageInputStreamSpi sbciis = new SeekableByteChannelImageInputStreamSpi();
                        this.iis = sbciis.createInputStreamInstance(this.metaData.sourceFile.getPath(), false, null);
                    }
                    catch (NoSuchFileException e) {
                        this.logger.logException(e, 3801, this.metaData.source);
                        this.error = true;
                    }
                    catch (IOException e) {
                        this.logger.logException(e, 3802, this.metaData.source);
                        this.error = true;
                    }
                    if (this.imgReader != null && this.iis != null) {
                        this.imgReader.setInput(this.iis, false, false);
                        boolean pyramid = this.hasValidPyramid();
                        if (!pyramid) {
                            throw new FlatImageException();
                        }
                    } else {
                        this.error = true;
                    }
                    this.image = this.createResultImage((double)totalWidthInLevel * rangeWidth, (double)totalHeightInLevel * rangeHeight, false);
                    PriorityExecutor es = this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_IO);
                    PriorityExecutorCompletionService<Boolean> completionService = new PriorityExecutorCompletionService<Boolean>(es);
                    ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
                    int jobs = 0;
                    int ty = firstTileY;
                    while (currentResultOffsetY < this.image.getHeight()) {
                        currentResultOffsetX = 0;
                        int n = 0;
                        if (ty == firstTileY) {
                            n = yOffsetInLevel % tileSizeY;
                        }
                        int tx = firstTileX;
                        while (currentResultOffsetX < this.image.getWidth()) {
                            CacheKey cacheKeyLocal;
                            CacheLoad fsiRawImage;
                            FSIImage cacheImage;
                            int tileOffsetX = 0;
                            if (tx == firstTileX) {
                                tileOffsetX = xOffsetInLevel % tileSizeX;
                            }
                            if ((cacheImage = (fsiRawImage = this.cacheManager.get(cacheKeyLocal = CacheKey.getInstance(assetURLPath, 'A', "irr_" + level + "_" + tx + "_" + ty), CacheType.IMAGE)) != null ? FSIImage.unpack(this.logger, this.swapPool, fsiRawImage.data) : null) == null) {
                                BufferedImage bit = null;
                                this.ioController.waitForRead();
                                try {
                                    bit = this.imgReader.readTile(level, tx, ty);
                                }
                                catch (IOException e) {
                                    this.error = true;
                                }
                                catch (IndexOutOfBoundsException e) {
                                    this.error = true;
                                }
                                finally {
                                    this.ioController.unlockRead();
                                }
                                if (bit != null) {
                                    BufferedImageWrap biw = new BufferedImageWrap(bit, this.converter.getClutCache());
                                    biw.setDefaultICCProfiles(this.defaultCMYKICC, this.defaultRGBICC, this.defaultGrayICC);
                                    biw.setICCProfile(this.metaData.getICC());
                                    biw.initColorConverter(this.metaData.colorType);
                                    biw.sourceImage = this.metaData.source;
                                    ReaderHelperAbstact.TileCopierBI tileCopier = new ReaderHelperAbstact.TileCopierBI(priority, biw, this.converter, this.image, tileOffsetX, n, currentResultOffsetX, currentResultOffsetY);
                                    futures.add(completionService.submit(tileCopier));
                                    ++jobs;
                                }
                            } else {
                                ReaderHelperAbstact.TileCopierFSIImage tileCopier = new ReaderHelperAbstact.TileCopierFSIImage(priority, this.image, cacheImage, tileOffsetX, n, currentResultOffsetX, currentResultOffsetY);
                                completionService.submit(tileCopier);
                                ++jobs;
                            }
                            currentResultOffsetX += tileSizeX - tileOffsetX;
                            ++tx;
                        }
                        currentResultOffsetY += tileSizeY - n;
                        ++ty;
                    }
                    returnvalue = true;
                    try {
                        for (int c = 0; c < jobs; ++c) {
                            Future future = completionService.take();
                            returnvalue &= ((Boolean)future.get()).booleanValue();
                        }
                    }
                    catch (InterruptedException e) {
                        returnvalue = false;
                        return returnvalue;
                    }
                    catch (ExecutionException e) {
                        returnvalue = false;
                        this.logger.logException(e, 3800, e.getLocalizedMessage());
                    }
                    finally {
                        for (Future future : futures) {
                            future.cancel(true);
                        }
                    }
                }
                finally {
                    this.close();
                }
            }
        }
        this.finished = true;
        return returnvalue;
    }

    @Override
    public void destroy() {
        this.shutdown();
        while (!this.finished && !this.error) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        super.destroy();
    }

    private void close() {
        try {
            if (this.iis != null) {
                this.iis.close();
            }
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.logException(e, 3811, this.metaData.source, e.getLocalizedMessage());
            }
            this.error = true;
        }
        try {
            if (this.fis != null) {
                this.fis.close();
            }
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.logException(e, 3811, this.metaData.source, e.getLocalizedMessage());
            }
            this.error = true;
        }
        if (this.imgReader != null) {
            this.imgReader.reset();
            this.imgReader.dispose();
            this.closeReaderInput(this.imgReader);
            this.imgReader = null;
        }
    }

    private void closeReaderInput(ImageReader reader) {
        if (reader == null) {
            return;
        }
        Object input = reader.getInput();
        if (input != null && input instanceof ImageInputStream) {
            try {
                ((ImageInputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private FSIImage createResultImage(double width, double height, boolean hasAlpha) {
        FSIImageMode mode = hasAlpha ? FSIImageMode.ARGB : FSIImageMode.RGB;
        return new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, (int)Math.ceil(width), (int)Math.ceil(height), this.metaData.source, mode);
    }

    private double autoCorrectRangeParam(double start, double range) {
        if (start + range > 1.0) {
            range = 1.0 - start;
        }
        return range;
    }
}

