/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.reader;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.imagereader.converter.ColorLookUpTableCache;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.helper.ReaderHelperAbstact;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageUnlimited;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;

public abstract class ConverterImageReaderAbstract
extends ReaderHelperAbstact {
    final int version;
    final boolean forceSwap;
    final ByteOrder byteOrder;
    final BufferedImageConverter converter;
    FSIMetaData metaData;
    ICCProfileWrap defaultCMYKICC = null;
    ICCProfileWrap defaultRGBICC = null;
    ICCProfileWrap defaultGrayICC = null;
    boolean fallbackICCConversion = true;
    IOController ioController = null;
    FSIImage image = null;
    FSIImage[] extraAlpha = null;
    volatile boolean error = false;
    String errorMessage = null;
    boolean oversized = false;
    volatile boolean shutdown = false;
    boolean finished = false;
    boolean started = false;
    boolean prefetch = false;
    long maxPrefetchSize = 0x2000000L;
    int rangeImage = -1;
    int rangeLeft = -1;
    int rangeTop = -1;
    int rangeWidth = -1;
    int rangeHeight = -1;
    boolean makeHistogram = true;
    final int maxBIMem = 0x7800000;

    public ConverterImageReaderAbstract(FSILogger logger, ExecutorPool executorPool, SwapPool swapPool, BufferedImageConverter converter, PluginLoader pluginLoader, ByteOrder byteOrder, boolean forceSwap, int version) {
        super(logger, swapPool, executorPool, pluginLoader);
        this.forceSwap = forceSwap;
        this.byteOrder = byteOrder;
        this.converter = converter;
        this.version = version;
    }

    public abstract void setFile(FSIMetaData var1);

    public abstract boolean readImage(int var1) throws IOException;

    public void setDefaultICCProfiles(ICCProfileWrap cmyk, ICCProfileWrap rgb, ICCProfileWrap gray) {
        this.defaultCMYKICC = cmyk;
        this.defaultRGBICC = rgb;
        this.defaultGrayICC = gray;
    }

    public void setIOController(IOController ioController) {
        this.ioController = ioController;
    }

    public void setMakeHistogram(boolean state) {
        this.makeHistogram = state;
    }

    public void setUseFallbackICCConversion(boolean state) {
        this.fallbackICCConversion = state;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public boolean isDown() {
        return this.finished;
    }

    public int getVersion() {
        return this.version;
    }

    public void destroy() {
        this.shutdown();
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
    }

    public FSIImage getImage() {
        return this.image;
    }

    public FSIImage[] getExtraAlpha() {
        return this.extraAlpha;
    }

    public void setImage(FSIImage image) {
        this.image = image;
    }

    public void setPrefetch(boolean state, long maxSize) {
        this.prefetch = state;
        this.maxPrefetchSize = maxSize;
    }

    public boolean isOversized() {
        return this.oversized;
    }

    public boolean isMapped() {
        return this.image.isMapped();
    }

    public boolean hasError() {
        return this.error;
    }

    public void setError(boolean state) {
        this.error = state;
    }

    public boolean isDisposed() {
        boolean result = false;
        if (this.image != null && this.image.isDisposed()) {
            result = true;
        }
        return result;
    }

    public boolean isPluginLoaded(String name) {
        return this.pluginLoader.isPluginLoaded(name);
    }

    void lock() {
        if (this.ioController != null) {
            this.ioController.waitForRead();
        }
    }

    void unlock() {
        if (this.ioController != null) {
            this.ioController.unlockRead();
        }
    }

    class TileCopierRaster
    implements Callable<Boolean>,
    PriorityExecutor.Important {
        private final int priority;
        private final Raster raster;
        private final int tx;
        private final int ty;
        private final int tileWidth;
        private final int tileHeight;
        private final FSIImage fimage;
        private final Histogram histogram;

        protected TileCopierRaster(int priority, FSIImage image, Raster raster, int tx, int ty, int tileWidth, int tileHeight) {
            this.priority = priority;
            this.fimage = image;
            this.histogram = ConverterImageReaderAbstract.this.metaData.histogram;
            this.raster = raster;
            this.tx = tx;
            this.ty = ty;
            this.tileWidth = tileWidth;
            this.tileHeight = tileHeight;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public Boolean call() {
            boolean result = false;
            try {
                DataBuffer db;
                int dbtype;
                int width = this.fimage.getWidth();
                int height = this.fimage.getHeight();
                if (!ConverterImageReaderAbstract.this.shutdown && (dbtype = (db = this.raster.getDataBuffer()).getDataType()) == 0) {
                    int bands = this.raster.getNumBands();
                    int sxs = this.tx * this.tileWidth;
                    int sxe = (this.tx + 1) * this.tileWidth;
                    int sys = this.ty * this.tileHeight;
                    int sye = (this.ty + 1) * this.tileHeight;
                    if (bands == 3) {
                        int i = 0;
                        for (int py = sys; py < sye; ++py) {
                            int px = sxs;
                            while (px < sxe) {
                                if (px < width && py < height) {
                                    int rgb = db.getElem(0, i) << 16 | db.getElem(0, i + 1) << 8 | db.getElem(0, i + 2);
                                    if (this.histogram != null) {
                                        this.histogram.pushRGB(rgb);
                                    }
                                    this.fimage.setSample(px, py, rgb);
                                }
                                ++px;
                                i += 3;
                            }
                        }
                        result = true;
                    } else if (bands == 4) {
                        int i = 0;
                        for (int py = sys; py < sye; ++py) {
                            int px = sxs;
                            while (px < sxe) {
                                if (px < width && py < height) {
                                    int rgb = db.getElem(0, i) << 16 | db.getElem(0, i + 1) << 8 | db.getElem(0, i + 2);
                                    if (this.histogram != null) {
                                        this.histogram.pushRGB(rgb);
                                    }
                                    this.fimage.setSample(px, py, rgb);
                                }
                                ++px;
                                i += 4;
                            }
                        }
                        result = true;
                    } else if (bands == 1) {
                        int i = 0;
                        for (int py = sys; py < sye; ++py) {
                            int px = sxs;
                            while (px < sxe) {
                                if (px < width && py < height) {
                                    int rgb = db.getElem(0, i);
                                    rgb = rgb << 16 | rgb << 8 | rgb;
                                    if (this.histogram != null) {
                                        this.histogram.pushRGB(rgb);
                                    }
                                    this.fimage.setSample(px, py, rgb);
                                }
                                ++px;
                                ++i;
                            }
                        }
                        result = true;
                    }
                }
            }
            catch (FSIImageException e) {
                ConverterImageReaderAbstract.this.error = true;
                ConverterImageReaderAbstract.this.errorMessage = e.getLocalizedMessage();
            }
            return result;
        }
    }

    class TileCopierBufferedImage
    implements Callable<Boolean>,
    PriorityExecutor.Important {
        private final int priority;
        private BufferedImageWrap biw;
        private final boolean useSwap;
        private final int tx;
        private final int ty;
        private final int tileWidth;
        private final int tileHeight;
        private final FSIImage fimage;

        protected TileCopierBufferedImage(int priority, FSIImage image, BufferedImage bi, ColorLookUpTableCache clutCache, ByteOrder byteOrder, boolean useSwap, int tx, int ty, int tileWidth, int tileHeight) {
            this.priority = priority;
            this.fimage = image;
            this.useSwap = useSwap;
            this.tx = tx;
            this.ty = ty;
            this.tileWidth = tileWidth;
            this.tileHeight = tileHeight;
            this.biw = new BufferedImageWrap(bi, clutCache);
            this.biw.setDefaultICCProfiles(ConverterImageReaderAbstract.this.defaultCMYKICC, ConverterImageReaderAbstract.this.defaultRGBICC, ConverterImageReaderAbstract.this.defaultGrayICC);
            this.biw.setICCProfile(ConverterImageReaderAbstract.this.metaData.getICC());
            this.biw.setSawAdobeMarker(ConverterImageReaderAbstract.this.metaData.sawAdobeMarker);
            this.biw.setUseFallbackConverter(ConverterImageReaderAbstract.this.fallbackICCConversion);
            this.biw.initColorConverter(ConverterImageReaderAbstract.this.metaData.colorType);
            this.biw.histogram = ConverterImageReaderAbstract.this.metaData.histogram;
            this.biw.sourceImage = ConverterImageReaderAbstract.this.metaData.source;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            boolean result = false;
            try {
                FSIImage smallImage = !this.useSwap ? new FSIImageLimited(ConverterImageReaderAbstract.this.logger, ConverterImageReaderAbstract.this.swapPool, ConverterImageReaderAbstract.this.byteOrder, this.biw.width, this.biw.height, ConverterImageReaderAbstract.this.metaData.source, this.fimage.getMode()) : new FSIImageUnlimited(ConverterImageReaderAbstract.this.logger, ConverterImageReaderAbstract.this.swapPool, ConverterImageReaderAbstract.this.byteOrder, this.biw.width, this.biw.height, ConverterImageReaderAbstract.this.metaData.source, this.fimage.getMode(), null, false);
                try {
                    int sxs = this.tx * this.tileWidth;
                    int sys = this.ty * this.tileHeight;
                    result = ConverterImageReaderAbstract.this.converter.convert(this.priority, 0, ExecutorPool.Type.CONVERTER_CPU, this.biw, this.fimage, sxs, sys);
                }
                catch (Exception e) {
                    ConverterImageReaderAbstract.this.logger.logException(e, 3804, ConverterImageReaderAbstract.this.metaData.source, e.getLocalizedMessage());
                    result = false;
                }
                finally {
                    smallImage.dispose();
                    this.biw.dispose();
                    this.biw = null;
                }
            }
            catch (FSIImageException e) {
                ConverterImageReaderAbstract.this.error = true;
                ConverterImageReaderAbstract.this.errorMessage = e.getLocalizedMessage();
            }
            return result;
        }
    }
}

