/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.reader;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import com.neptunelabs.imagereader.image.FSIImageUnlimited;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metrics.Histogram;
import com.neptunelabs.imagereader.reader.ConverterImageReaderAbstract;
import com.neptunelabs.imagereader.reader.fpx.FPXImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.concurrent.Future;

public final class ConverterImageReaderFPX
extends ConverterImageReaderAbstract {
    public static final int VERSION = 259;

    public ConverterImageReaderFPX(FSILogger logger, ExecutorPool executorPool, SwapPool swapPool, BufferedImageConverter converter, PluginLoader pluginLoader, ByteOrder byteOrder, boolean swap) {
        super(logger, executorPool, swapPool, converter, pluginLoader, byteOrder, swap, 259);
    }

    @Override
    public void setFile(FSIMetaData metaData) {
        this.metaData = metaData;
        long rawbytes = (long)metaData.getWidth() * (long)metaData.getHeight() * 4L;
        if (rawbytes > MemoryManager.getFreeHeapSpace() || rawbytes > Integer.MAX_VALUE) {
            this.oversized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readImage(int priority) throws IOException {
        boolean returnvalue = false;
        this.started = true;
        boolean lockObtained = false;
        try {
            this.image = this.oversized || this.forceSwap ? new FSIImageUnlimited(this.logger, this.swapPool, this.byteOrder, this.metaData.getWidth(), this.metaData.getHeight(), this.metaData.source, FSIImageMode.RGB, null, false) : new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, this.metaData.getWidth(), this.metaData.getHeight(), this.metaData.source, FSIImageMode.RGB, this.oversized);
            if (this.makeHistogram) {
                this.metaData.histogram = new Histogram();
            }
            boolean doPrefetch = this.prefetch && this.metaData.filesize < this.maxPrefetchSize;
            ExecutorPool.Type tileCopierType = ExecutorPool.Type.CONVERTER_IO;
            if (doPrefetch) {
                this.lock();
                lockObtained = true;
            }
            FPXImage fpximage = new FPXImage(this.logger, this.metaData.sourceFile.getPath(), doPrefetch);
            if (doPrefetch) {
                this.unlock();
                lockObtained = false;
            }
            int tileWidth = fpximage.getTileWidth();
            int tileHeight = fpximage.getTileHeight();
            int tilesX = (int)Math.ceil((float)fpximage.getWidth() / (float)tileWidth);
            int tilesY = (int)Math.ceil((float)fpximage.getHeight() / (float)tileHeight);
            int tilesTotal = tilesX * tilesY;
            int tiles = 0;
            int tx = 0;
            int ty = 0;
            int ctx = 0;
            int cty = 0;
            PriorityExecutor es = this.executorPool.getExecutorService(tileCopierType);
            while (!(tiles >= tilesTotal || this.shutdown || this.error || this.shutdown || this.error)) {
                int c;
                ctx = tx;
                cty = ty;
                int tileMem = tileWidth * tileHeight * 4;
                int biThreads = this.executorPool.getAvailableThreads(tileCopierType);
                int biMem = tileMem * biThreads;
                if (biMem > 0x7800000 && (biThreads = (int)Math.floor(0x7800000 / tileMem)) < 1) {
                    biThreads = 1;
                }
                int thisRoundTiles = Math.min(biThreads, tilesTotal - tiles);
                Raster[] ris = new Raster[thisRoundTiles];
                if (!doPrefetch) {
                    this.lock();
                }
                try {
                    for (int c2 = 0; c2 < thisRoundTiles; ++c2) {
                        ris[c2] = fpximage.getTile(tx, ty);
                        if (++tx == tilesX) {
                            tx = 0;
                            ++ty;
                        }
                        ++tiles;
                    }
                }
                finally {
                    if (!doPrefetch) {
                        this.unlock();
                    }
                }
                PriorityExecutorCompletionService<Boolean> completionService = new PriorityExecutorCompletionService<Boolean>(es, thisRoundTiles);
                ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(thisRoundTiles);
                boolean result = true;
                for (c = 0; c < thisRoundTiles; ++c) {
                    ConverterImageReaderAbstract.TileCopierRaster tileCopierRaster = new ConverterImageReaderAbstract.TileCopierRaster(priority, this.image.createSlice(), ris[c], ctx, cty, tileWidth, tileHeight);
                    futures.add(completionService.submit(tileCopierRaster));
                    if (++ctx != tilesX) continue;
                    ctx = 0;
                    ++cty;
                }
                try {
                    for (c = 0; c < thisRoundTiles; ++c) {
                        result &= ((Boolean)completionService.take().get()).booleanValue();
                    }
                }
                finally {
                    for (Future future : futures) {
                        future.cancel(true);
                    }
                }
                if (result) continue;
                this.error = true;
            }
            fpximage.close();
        }
        catch (NoSuchFileException e) {
            this.logger.logException(e, 3801, this.metaData.source);
            this.error = true;
        }
        catch (IOException e) {
            this.logger.logException(e, 3899, e.getLocalizedMessage());
            this.error = true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logger.logException(e, 3899, e.getLocalizedMessage());
            this.error = true;
        }
        catch (Exception e) {
            this.logger.logException(e, 3804, this.metaData.source, e.getLocalizedMessage());
            this.error = true;
        }
        catch (Error e) {
            this.logger.logError(e, 3804, this.metaData.source, e.getLocalizedMessage());
            this.error = true;
        }
        finally {
            this.close();
            if (lockObtained) {
                this.unlock();
            }
        }
        if (this.image != null) {
            returnvalue = true;
        }
        if (this.metaData.histogram != null) {
            this.metaData.histogram.digest();
        }
        return returnvalue;
    }

    private void close() {
        this.finished = true;
    }
}

