/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.reader;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imageio.SeekableByteChannelImageInputStream;
import com.neptunelabs.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import com.neptunelabs.imagereader.image.FSIImageUnlimited;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metrics.Histogram;
import com.neptunelabs.imagereader.reader.ConverterImageReaderAbstract;
import com.neptunelabs.imagereader.reader.ImageIOHelper;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public final class ConverterImageReaderGIF
extends ConverterImageReaderAbstract {
    public static final int VERSION = 258;
    private ImageReader imgReader;
    private ImageInputStream iis = null;
    private boolean isPrefetched = false;

    public ConverterImageReaderGIF(FSILogger logger, ExecutorPool executorPool, SwapPool swapPool, BufferedImageConverter converter, PluginLoader pluginLoader, ByteOrder byteOrder, boolean swap) {
        super(logger, executorPool, swapPool, converter, pluginLoader, byteOrder, swap, 258);
    }

    @Override
    public void setFile(FSIMetaData metaData) {
        this.metaData = metaData;
        long rawbytes = (long)metaData.getWidth() * (long)metaData.getHeight() * 4L;
        if (rawbytes > MemoryManager.getFreeHeapSpace() || rawbytes > Integer.MAX_VALUE) {
            this.oversized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readImage(int priority) throws IOException {
        boolean returnvalue;
        block28: {
            returnvalue = false;
            this.started = true;
            try {
                this.imgReader = ImageIOHelper.getReader("com.sun", "gif");
                if (this.imgReader == null) break block28;
                ByteArrayInputStream bais = null;
                this.isPrefetched = false;
                if (this.prefetch && this.metaData.filesize < this.maxPrefetchSize) {
                    this.isPrefetched = true;
                    this.lock();
                    try {
                        bais = new ByteArrayInputStream(FileOperations.readFile(this.logger, this.metaData.sourceFile.getPath()));
                    }
                    finally {
                        this.unlock();
                    }
                }
                this.iis = bais == null ? new SeekableByteChannelImageInputStream(this.metaData.sourceFile.getPath()) : new MemoryCacheImageInputStream(bais);
                this.image = this.oversized || this.forceSwap ? new FSIImageUnlimited(this.logger, this.swapPool, this.byteOrder, this.metaData.getWidth(), this.metaData.getHeight(), this.metaData.source, FSIImageMode.ARGB, null, false) : new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, this.metaData.getWidth(), this.metaData.getHeight(), this.metaData.source, FSIImageMode.ARGB, this.oversized);
                if (this.makeHistogram) {
                    this.metaData.histogram = new Histogram();
                }
                BufferedImage bi = null;
                this.imgReader.setInput(this.iis);
                if (!this.isPrefetched) {
                    this.lock();
                }
                try {
                    bi = this.imgReader.read(0);
                }
                finally {
                    if (!this.isPrefetched) {
                        this.unlock();
                    }
                }
                this.imgReader.dispose();
                this.closeReaderInput(this.imgReader);
                this.imgReader = null;
                if (bi == null) break block28;
                BufferedImageWrap biw = new BufferedImageWrap(bi, this.converter.getClutCache());
                biw.initColorConverter(this.metaData.colorType);
                biw.setHasAlpha(bi.getColorModel().getTransparency() != 1);
                if (biw.hasAlpha()) {
                    biw.setIsAlphaPremultiplied(false);
                    this.image.createExtraAlpha(1);
                }
                biw.histogram = this.metaData.histogram;
                try {
                    returnvalue = this.converter.convert(priority, 0, ExecutorPool.Type.CONVERTER_CPU, biw, this.image, 0, 0);
                }
                finally {
                    biw.dispose();
                }
                if (!biw.hasAlpha()) {
                    this.image.removeAlpha();
                }
                if (this.image == null) {
                    returnvalue = false;
                }
            }
            catch (NoSuchFileException e) {
                this.logger.logException(e, 3801, this.metaData.source);
                this.error = true;
            }
            catch (IOException e) {
                this.logger.logException(e, 3899, e.getLocalizedMessage());
                this.error = true;
            }
            catch (Exception e) {
                this.logger.logException(e, 3804, this.metaData.source, e.getLocalizedMessage());
                this.error = true;
            }
            catch (Error e) {
                this.logger.logError(e, 3804, this.metaData.source, e.getLocalizedMessage());
                this.error = true;
            }
            finally {
                this.close();
            }
        }
        if (this.metaData.histogram != null) {
            this.metaData.histogram.digest();
        }
        return returnvalue;
    }

    private void close() {
        if (this.iis != null) {
            try {
                this.iis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.finished = true;
    }

    private void closeReaderInput(ImageReader reader) {
        if (reader == null) {
            return;
        }
        Object input = reader.getInput();
        if (input != null && input instanceof ImageInputStream) {
            try {
                ((ImageInputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

