/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.reader;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imageioimpl.common.Register;
import com.neptunelabs.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import com.neptunelabs.imagereader.image.FSIImageUnlimited;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metrics.Histogram;
import com.neptunelabs.imagereader.reader.ConverterImageReaderAbstract;
import com.neptunelabs.imagereader.reader.ConverterImageReaderJPEGCMYK;
import com.neptunelabs.imagereader.reader.ConverterImageReaderJPEGImageIO;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;

public final class ConverterImageReaderJPEG
extends ConverterImageReaderAbstract {
    public static final int VERSION = 258;
    private boolean isCMYK = false;

    public ConverterImageReaderJPEG(FSILogger logger, ExecutorPool executorPool, SwapPool swapPool, BufferedImageConverter converter, PluginLoader pluginLoader, ByteOrder byteOrder, boolean swap) {
        super(logger, executorPool, swapPool, converter, pluginLoader, byteOrder, swap, 258);
    }

    @Override
    public void setFile(FSIMetaData metaData) {
        long rawbytes;
        this.metaData = metaData;
        if (metaData.getSamplesPerPixel() == 4) {
            this.isCMYK = true;
        }
        if ((rawbytes = (long)metaData.getWidth() * (long)metaData.getHeight() * 4L) > MemoryManager.getFreeHeapSpace() || rawbytes > Integer.MAX_VALUE) {
            this.oversized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readImage(int priority) throws IOException {
        boolean returnvalue = false;
        this.started = true;
        try {
            if (this.makeHistogram) {
                this.metaData.histogram = new Histogram();
            }
            boolean doPrefetch = this.prefetch && this.metaData.filesize < this.maxPrefetchSize;
            BufferedImage bi = null;
            Path metaFile = this.metaData.sourceFile.getPath();
            if (metaFile != null) {
                block45: {
                    try {
                        this.lock();
                        if (this.isCMYK && Register.hasSunLoader()) {
                            if (this.isPluginLoaded("JAI")) {
                                bi = ConverterImageReaderJPEGCMYK.getPlanarImage(this.logger, metaFile, doPrefetch);
                            }
                            break block45;
                        }
                        if (Register.hasSunLoader()) {
                            bi = ConverterImageReaderJPEGImageIO.getBufferedImageImage(this.logger, metaFile, this.ioController, doPrefetch);
                            break block45;
                        }
                        ImageReader imageReader = ImageIO.getImageReadersBySuffix("jpeg").next();
                        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(metaFile, StandardOpenOption.READ));){
                            imageReader.setInput(ImageIO.createImageInputStream(is));
                            ImageReadParam readParam = imageReader.getDefaultReadParam();
                            bi = (BufferedImage)imageReader.readAsRenderedImage(0, readParam);
                        }
                        finally {
                            imageReader.dispose();
                        }
                    }
                    finally {
                        this.unlock();
                    }
                }
                if (bi != null) {
                    BufferedImageWrap biw = new BufferedImageWrap(bi, this.converter.getClutCache());
                    biw.setDefaultICCProfiles(this.defaultCMYKICC, this.defaultRGBICC, this.defaultGrayICC);
                    biw.setICCProfile(this.metaData.getICC());
                    biw.setSawAdobeMarker(this.metaData.sawAdobeMarker);
                    biw.setUseFallbackConverter(this.fallbackICCConversion);
                    biw.initColorConverter(this.metaData.colorType);
                    biw.histogram = this.metaData.histogram;
                    try {
                        this.image = this.oversized || this.forceSwap ? new FSIImageUnlimited(this.logger, this.swapPool, this.byteOrder, this.metaData.getWidth(), this.metaData.getHeight(), this.metaData.source, FSIImageMode.RGB, null, false) : new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, this.metaData.getWidth(), this.metaData.getHeight(), this.metaData.source, FSIImageMode.RGB, this.oversized);
                        returnvalue = this.converter.convert(priority, 0, ExecutorPool.Type.CONVERTER_CPU, biw, this.image, 0, 0);
                    }
                    finally {
                        biw.dispose();
                    }
                    if (this.image == null) {
                        this.error = true;
                    }
                } else {
                    this.error = true;
                }
            }
            if (this.image == null) {
                returnvalue = false;
            }
        }
        catch (NoSuchFileException e) {
            this.error = true;
            this.logger.logException(e, 3801, this.metaData.source);
        }
        catch (IOException e) {
            this.error = true;
            this.logger.logException(e, 3899, e.getLocalizedMessage());
        }
        catch (FSIImageException e) {
            this.logger.logException(e, 3804, this.metaData.source, e.getLocalizedMessage());
            this.error = true;
        }
        catch (Exception e) {
            this.logger.logException(e, 3804, this.metaData.source, e.getLocalizedMessage());
            this.error = true;
        }
        catch (Error e) {
            this.logger.logError(e, 3804, this.metaData.source, e.getLocalizedMessage());
            this.error = true;
        }
        finally {
            this.close();
        }
        if (this.metaData.histogram != null) {
            this.metaData.histogram.digest();
        }
        if (this.error) {
            returnvalue = false;
        }
        return returnvalue;
    }

    private void close() {
        this.finished = true;
    }
}

