/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.reader;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

class ConverterImageReaderJPEGCMYK {
    ConverterImageReaderJPEGCMYK() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BufferedImage getPlanarImage(FSILogger logger, Path inputFile, boolean doPrefetch) {
        BufferedImage bi = null;
        byte[] data2 = null;
        try {
            InputStream imageInputStream;
            if (doPrefetch) {
                data2 = FileOperations.readFile(inputFile);
                imageInputStream = new ByteArrayInputStream(data2);
            } else {
                imageInputStream = new BufferedInputStream(Files.newInputStream(inputFile, new OpenOption[0]));
            }
            try {
                JPEGImageDecoder dec = JPEGCodec.createJPEGDecoder((InputStream)imageInputStream);
                bi = dec.decodeAsBufferedImage();
            }
            catch (ImageFormatException e) {
                imageInputStream.close();
                imageInputStream = data2 != null ? new ByteArrayInputStream(data2) : Files.newInputStream(inputFile, new OpenOption[0]);
                JPEGImageDecoder dec = JPEGCodec.createJPEGDecoder((InputStream)imageInputStream);
                Raster r = dec.decodeAsRaster();
                int[] iArray = new int[4];
                r.getPixel(0, 0, iArray);
                JPEGDecodeParam dp = dec.getJPEGDecodeParam();
                DataBuffer db = r.getDataBuffer();
                ColorSpace cs = ColorSpace.getInstance(1004);
                ComponentColorModel cm = new ComponentColorModel(cs, true, true, 1, 0);
                if (dp.getEncodedColorID() == 4 || dp.getEncodedColorID() == 9) {
                    int dblen = db.getSize();
                    for (int p = 0; p < dblen; p += 4) {
                        db.setElem(0, p, 255 - db.getElem(0, p));
                        db.setElem(0, p + 1, 255 - db.getElem(0, p + 1));
                        db.setElem(0, p + 2, 255 - db.getElem(0, p + 2));
                    }
                }
                bi = new BufferedImage(cm, (WritableRaster)r, true, null);
                imageInputStream.close();
            }
            finally {
                imageInputStream.close();
            }
        }
        catch (Exception e) {
            logger.logException(e, 3804, inputFile, e.getLocalizedMessage());
        }
        catch (Error e) {
            logger.logError(e, 3804, inputFile, e.getLocalizedMessage());
        }
        return bi;
    }
}

