/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.reader;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imageio.SeekableByteChannelImageInputStream;
import com.neptunelabs.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import com.neptunelabs.imagereader.image.FSIImageUnlimited;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.reader.ConverterImageReaderAbstract;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;

public final class ConverterImageReaderJPEG_TM
extends ConverterImageReaderAbstract {
    public static final int VERSION = 258;
    private boolean isCMYK = false;

    public ConverterImageReaderJPEG_TM(FSILogger logger, ExecutorPool executorPool, SwapPool swapPool, BufferedImageConverter converter, PluginLoader pluginLoader, ByteOrder byteOrder, boolean swap) {
        super(logger, executorPool, swapPool, converter, pluginLoader, byteOrder, swap, 258);
    }

    @Override
    public void setFile(FSIMetaData metaData) {
        long rawbytes;
        this.metaData = metaData;
        if (metaData.getSamplesPerPixel() == 4) {
            this.isCMYK = true;
        }
        if ((rawbytes = (long)metaData.getWidth() * (long)metaData.getHeight() * 4L) > MemoryManager.getFreeHeapSpace() || rawbytes > Integer.MAX_VALUE) {
            this.oversized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readImage(int priority) throws IOException {
        boolean returnvalue = false;
        try {
            if (this.pluginLoader.isPluginLoaded("TwelveMonkeys")) {
                this.started = true;
                ByteArrayInputStream bais = null;
                boolean isPrefetch = false;
                if (this.prefetch && this.metaData.filesize < this.maxPrefetchSize) {
                    isPrefetch = true;
                    this.lock();
                    try {
                        bais = new ByteArrayInputStream(FileOperations.readFile(this.logger, this.metaData.sourceFile.getPath()));
                    }
                    finally {
                        this.unlock();
                    }
                }
                ImageInputStream iis = null;
                try {
                    iis = bais == null ? new SeekableByteChannelImageInputStream(this.metaData.sourceFile.getPath()) : ImageIO.createImageInputStream(bais);
                }
                catch (NoSuchFileException e) {
                    this.logger.logException(e, 3801, this.metaData.source);
                    this.error = true;
                }
                catch (IOException e) {
                    this.logger.logException(e, 3802, this.metaData.source);
                    this.error = true;
                }
                if (!this.error && iis != null) {
                    Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName("jpeg");
                    ImageReader imgReader = null;
                    imgReader = it.next();
                    try {
                        imgReader.setInput(iis);
                        ImageTypeSpecifier type = imgReader.getImageTypes(0).next();
                        BufferedImage dest = type.createBufferedImage(this.metaData.getWidth(), this.metaData.getHeight());
                        ImageReadParam param = imgReader.getDefaultReadParam();
                        param.setDestination(dest);
                        imgReader.read(0, param);
                        BufferedImageWrap biw = new BufferedImageWrap(dest, this.converter.getClutCache());
                        biw.setDefaultICCProfiles(this.defaultCMYKICC, this.defaultRGBICC, this.defaultGrayICC);
                        biw.setICCProfile(this.metaData.getICC());
                        biw.setSawAdobeMarker(this.metaData.sawAdobeMarker);
                        biw.setUseFallbackConverter(this.fallbackICCConversion);
                        biw.initColorConverter(this.metaData.colorType);
                        biw.histogram = this.metaData.histogram;
                        try {
                            this.image = this.oversized || this.forceSwap ? new FSIImageUnlimited(this.logger, this.swapPool, this.byteOrder, this.metaData.getWidth(), this.metaData.getHeight(), this.metaData.source, FSIImageMode.RGB, null, false) : new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, this.metaData.getWidth(), this.metaData.getHeight(), this.metaData.source, FSIImageMode.RGB, this.oversized);
                            returnvalue = this.converter.convert(priority, 0, ExecutorPool.Type.CONVERTER_CPU, biw, this.image, 0, 0);
                        }
                        finally {
                            biw.dispose();
                        }
                        if (this.image == null) {
                            this.error = true;
                        }
                    }
                    finally {
                        imgReader.dispose();
                        iis.close();
                    }
                }
            }
            if (this.image == null) {
                returnvalue = false;
            }
        }
        catch (NoSuchFileException e) {
            this.error = true;
            this.logger.logException(e, 3801, this.metaData.source);
        }
        catch (IOException e) {
            this.error = true;
            this.logger.logException(e, 3899, e.getLocalizedMessage());
        }
        catch (FSIImageException e) {
            this.logger.logException(e, 3804, this.metaData.source, e.getLocalizedMessage());
            this.error = true;
        }
        catch (Exception e) {
            this.logger.logException(e, 3804, this.metaData.source, e.getLocalizedMessage());
            this.error = true;
        }
        catch (Error e) {
            this.logger.logError(e, 3804, this.metaData.source, e.getLocalizedMessage());
            this.error = true;
        }
        finally {
            this.close();
        }
        if (this.metaData.histogram != null) {
            this.metaData.histogram.digest();
        }
        if (this.error) {
            returnvalue = false;
        }
        return returnvalue;
    }

    private void close() {
        this.finished = true;
    }
}

