/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.reader;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imageio.SeekableByteChannelImageInputStream;
import com.neptunelabs.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.imagereader.converter.ColorLookUpTableCache;
import com.neptunelabs.imagereader.helper.ReaderHelperAbstact;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import com.neptunelabs.imagereader.image.FSIImageUnlimited;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metrics.Histogram;
import com.neptunelabs.imagereader.reader.ConverterImageReaderAbstract;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public final class ConverterImageReaderTIFF
extends ConverterImageReaderAbstract {
    public static final int VERSION = 259;
    private static final long LINECACHE_MAX = 0x1000000L;

    public ConverterImageReaderTIFF(FSILogger fsilogger, ExecutorPool executorPool, SwapPool swapPool, BufferedImageConverter converter, PluginLoader pluginLoader, ByteOrder byteOrder, boolean swap) {
        super(fsilogger, executorPool, swapPool, converter, pluginLoader, byteOrder, swap, 259);
    }

    @Override
    public void setFile(FSIMetaData metaData) {
        long rawbytes;
        this.metaData = metaData;
        if (metaData.filesize > 0xFFFFFFFEL) {
            if (this.logger != null) {
                this.logger.log(3806, metaData.source);
            }
            this.error = true;
        }
        if (!(this.error || (rawbytes = 4L * (long)metaData.getWidth() * (long)metaData.getHeight()) <= MemoryManager.getFreeHeapSpace() && rawbytes <= Integer.MAX_VALUE)) {
            this.oversized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readImage(int priority) throws IOException {
        this.started = true;
        TIFFImageReader imgReader = new TIFFImageReader(new TIFFImageReaderSpi());
        ByteArrayInputStream bais = null;
        boolean isPrefetch = false;
        if (this.prefetch && this.metaData.filesize < this.maxPrefetchSize) {
            isPrefetch = true;
            this.lock();
            try {
                bais = new ByteArrayInputStream(FileOperations.readFile(this.logger, this.metaData.sourceFile.getPath()));
            }
            finally {
                this.unlock();
            }
        }
        ImageInputStream iis = null;
        try {
            iis = bais == null ? new SeekableByteChannelImageInputStream(this.metaData.sourceFile.getPath()) : ImageIO.createImageInputStream(bais);
        }
        catch (NoSuchFileException e) {
            this.logger.logException(e, 3801, this.metaData.source);
            this.error = true;
        }
        catch (IOException e) {
            this.logger.logException(e, 3802, this.metaData.source);
            this.error = true;
        }
        if (!this.error && iis != null) {
            imgReader.setInput(iis);
            try {
                int biThreads;
                int tileMem;
                int biMem;
                int alphaChannels;
                FSIImageMode mode = this.metaData.hasAlpha ? FSIImageMode.ARGB : FSIImageMode.RGB;
                this.image = this.oversized || this.forceSwap ? new FSIImageUnlimited(this.logger, this.swapPool, this.byteOrder, this.metaData.getWidth(), this.metaData.getHeight(), this.metaData.source, mode, null, false) : new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, this.metaData.getWidth(), this.metaData.getHeight(), this.metaData.source, mode, this.oversized | this.forceSwap);
                if (this.metaData.extraSamples > 0 && (alphaChannels = this.metaData.extraSamples) > 0) {
                    this.image.createExtraAlpha(alphaChannels);
                }
                this.metaData.getSamplesPerPixel();
                if (this.makeHistogram) {
                    this.metaData.histogram = new Histogram();
                }
                int width = this.metaData.getWidth();
                int height = this.metaData.getHeight();
                int tileWidth = this.metaData.getTileWidth();
                int tileHeight = this.metaData.getTileHeight();
                if (tileWidth == -1) {
                    tileWidth = width;
                }
                if (tileHeight == -1) {
                    tileHeight = height;
                }
                int tilesX = (int)Math.ceil((float)width / (float)tileWidth);
                int tilesY = (int)Math.ceil((float)height / (float)tileHeight);
                int tilesTotal = tilesX * tilesY;
                int tiles = 0;
                int tx = 0;
                int ty = 0;
                int ctx = 0;
                int cty = 0;
                boolean tileOversized = false;
                long rawTileSize = 4L * (long)tileWidth * (long)tileHeight;
                if (rawTileSize > MemoryManager.getFreeHeapSpace() || rawTileSize > 0x1000000L) {
                    tileOversized = true;
                }
                if ((biMem = (tileMem = tileWidth * tileHeight * 4) * (biThreads = 1000)) > 0x7800000 && (biThreads = (int)Math.floor(0x7800000 / tileMem)) < 1) {
                    biThreads = 1;
                }
                PriorityExecutor es = this.executorPool.getExecutorService(ExecutorPool.Type.CONVERTER_IO);
                boolean returnvalue = true;
                while (tiles < tilesTotal && !this.shutdown) {
                    int c;
                    if (this.error) {
                        break;
                    }
                    ctx = tx;
                    cty = ty;
                    int thisRoundTiles = Math.min(biThreads, tilesTotal - tiles);
                    BufferedImage[] bis = new BufferedImage[thisRoundTiles];
                    if (!isPrefetch) {
                        this.lock();
                    }
                    try {
                        for (int c2 = 0; c2 < thisRoundTiles; ++c2) {
                            bis[c2] = imgReader.readTile(0, tx, ty);
                            if (++tx == tilesX) {
                                tx = 0;
                                ++ty;
                            }
                            ++tiles;
                        }
                    }
                    finally {
                        if (!isPrefetch) {
                            this.unlock();
                        }
                    }
                    PriorityExecutorCompletionService<Boolean> completionService = new PriorityExecutorCompletionService<Boolean>(es, thisRoundTiles);
                    ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(thisRoundTiles);
                    for (c = 0; c < thisRoundTiles; ++c) {
                        BufferedImageWrap bufferedImageWrap = new BufferedImageWrap(bis[c], this.converter.getClutCache());
                        bufferedImageWrap.setDefaultICCProfiles(this.defaultCMYKICC, this.defaultRGBICC, this.defaultGrayICC);
                        bufferedImageWrap.setICCProfile(this.metaData.getICC());
                        bufferedImageWrap.setSawAdobeMarker(this.metaData.sawAdobeMarker);
                        bufferedImageWrap.setUseFallbackConverter(this.fallbackICCConversion);
                        bufferedImageWrap.initColorConverter(this.metaData.colorType);
                        bufferedImageWrap.histogram = this.metaData.histogram;
                        bufferedImageWrap.sourceImage = this.metaData.source;
                        if (this.metaData.alphaBand != -1) {
                            bufferedImageWrap.setAlphaBand(this.metaData.alphaBand);
                            bufferedImageWrap.setHasAlpha(true);
                            bufferedImageWrap.setIsAlphaPremultiplied(this.metaData.alphaBandPremultiplied);
                            bufferedImageWrap.setAlphaStart(this.metaData.alphaBand);
                        }
                        int sxs = ctx * tileWidth;
                        int sys = cty * tileHeight;
                        ReaderHelperAbstact.DirectCopierBI tileCopier = new ReaderHelperAbstact.DirectCopierBI(priority, bufferedImageWrap, this.converter, this.image, sxs, sys);
                        futures.add(completionService.submit(tileCopier));
                        if (++ctx != tilesX) continue;
                        ctx = 0;
                        ++cty;
                    }
                    try {
                        for (c = 0; c < thisRoundTiles; ++c) {
                            returnvalue &= ((Boolean)completionService.take().get()).booleanValue();
                        }
                    }
                    finally {
                        for (Future future : futures) {
                            future.cancel(true);
                        }
                    }
                    if (returnvalue) continue;
                    this.error = true;
                }
            }
            catch (NullPointerException e) {
                this.logger.logException(e, 3804, this.metaData.source, "1 " + e.getLocalizedMessage());
                this.error = true;
            }
            catch (FSIImageException e) {
                this.logger.logException(e, 3804, this.metaData.source, "2 " + e.getLocalizedMessage());
                this.error = true;
            }
            catch (ExecutionException e) {
                if (!this.shutdown) {
                    this.logger.logException(e, 3804, this.metaData.source, "3 " + e.getLocalizedMessage());
                }
                this.error = true;
            }
            catch (Exception e) {
                this.logger.logException(e, 3804, this.metaData.source, "4 " + e.getLocalizedMessage());
                this.error = true;
            }
            catch (OutOfMemoryError e) {
                this.logger.logError(e, 3804, this.metaData.source, "5 " + e.getLocalizedMessage());
                this.error = true;
            }
            catch (Error e) {
                this.logger.logError(e, 3804, this.metaData.source, "6 " + e.getLocalizedMessage());
                this.error = true;
            }
            finally {
                imgReader.reset();
                imgReader.dispose();
                this.closeReaderInput(imgReader);
                imgReader = null;
                this.finished = true;
            }
        }
        if (iis != null) {
            try {
                iis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.metaData.histogram != null) {
            this.metaData.histogram.digest();
        }
        return !this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tileConvert(int priority, FSIImage targetImage, BufferedImage sourceImage, ColorLookUpTableCache clutCache, boolean useSwap, int tx, int ty, int tileWidth, int tileHeight) {
        boolean result = false;
        BufferedImageWrap biw = new BufferedImageWrap(sourceImage, clutCache);
        biw.setDefaultICCProfiles(this.defaultCMYKICC, this.defaultRGBICC, this.defaultGrayICC);
        biw.setICCProfile(this.metaData.getICC());
        biw.setSawAdobeMarker(this.metaData.sawAdobeMarker);
        biw.setUseFallbackConverter(this.fallbackICCConversion);
        biw.initColorConverter(this.metaData.colorType);
        biw.histogram = this.metaData.histogram;
        biw.sourceImage = this.metaData.source;
        if (this.metaData.alphaBand != -1) {
            biw.setAlphaBand(this.metaData.alphaBand);
            biw.setHasAlpha(true);
            biw.setIsAlphaPremultiplied(this.metaData.alphaBandPremultiplied);
        }
        try {
            int sxs = tx * tileWidth;
            int sys = ty * tileHeight;
            result = this.converter.convert(priority, 0, ExecutorPool.Type.CONVERTER_CPU, biw, targetImage, sxs, sys);
        }
        catch (FSIImageException e) {
            this.error = true;
            this.errorMessage = e.getLocalizedMessage();
        }
        catch (Exception e) {
            this.logger.logException(e, 3804, this.metaData.source, e.getLocalizedMessage());
            result = false;
        }
        finally {
            biw.dispose();
            biw = null;
        }
        return result;
    }

    @Override
    public void destroy() {
        this.shutdown();
        if (this.started) {
            while (!this.finished && !this.error) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        super.destroy();
    }

    private void closeReaderInput(ImageReader reader) {
        if (reader == null) {
            return;
        }
        Object input = reader.getInput();
        if (input != null && input instanceof ImageInputStream) {
            try {
                ((ImageInputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

