/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.reader.fpx;

public class FPXUtils {
    public static final short getShortLE(byte[] data, int offset) {
        int b0 = data[offset] & 0xFF;
        int b1 = data[offset + 1] & 0xFF;
        return (short)(b1 << 8 | b0);
    }

    public static final int getUnsignedShortLE(byte[] data, int offset) {
        int b0 = data[offset] & 0xFF;
        int b1 = data[offset + 1] & 0xFF;
        return b1 << 8 | b0;
    }

    public static final int getIntLE(byte[] data, int offset) {
        int b0 = data[offset] & 0xFF;
        int b1 = data[offset + 1] & 0xFF;
        int b2 = data[offset + 2] & 0xFF;
        int b3 = data[offset + 3] & 0xFF;
        return b3 << 24 | b2 << 16 | b1 << 8 | b0;
    }

    public static final long getUnsignedIntLE(byte[] data, int offset) {
        long b0 = data[offset] & 0xFF;
        long b1 = data[offset + 1] & 0xFF;
        long b2 = data[offset + 2] & 0xFF;
        long b3 = data[offset + 3] & 0xFF;
        return b3 << 24 | b2 << 16 | b1 << 8 | b0;
    }

    public static final String getString(byte[] data, int offset, int length) {
        if (length == 0) {
            return "<none>";
        }
        length = length / 2 - 1;
        StringBuffer b = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            int c = FPXUtils.getUnsignedShortLE(data, offset);
            b.append((char)c);
            offset += 2;
        }
        return b.toString();
    }
}

