/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.reader.fpx;

import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.reader.fpx.Property;
import com.sun.media.jai.codec.SeekableStream;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;

class PropertySet {
    private static final int TYPE_VT_EMPTY = -1;
    private static final int TYPE_VT_NULL = -1;
    private static final int TYPE_VT_I2 = 2;
    private static final int TYPE_VT_I4 = 3;
    private static final int TYPE_VT_R4 = -1;
    private static final int TYPE_VT_R8 = -1;
    private static final int TYPE_VT_CY = -1;
    private static final int TYPE_VT_DATE = -1;
    private static final int TYPE_VT_BSTR = -1;
    private static final int TYPE_VT_ERROR = -1;
    private static final int TYPE_VT_BOOL = -1;
    private static final int TYPE_VT_VARIANT = -1;
    private static final int TYPE_VT_UI1 = -1;
    private static final int TYPE_VT_UI2 = -1;
    private static final int TYPE_VT_UI4 = 19;
    private static final int TYPE_VT_I8 = -1;
    private static final int TYPE_VT_UI8 = -1;
    private static final int TYPE_VT_LPSTR = 30;
    private static final int TYPE_VT_LPWSTR = 31;
    private static final int TYPE_VT_FILETIME = 64;
    private static final int TYPE_VT_BLOB = 65;
    private static final int TYPE_VT_STREAM = -1;
    private static final int TYPE_VT_STORAGE = -1;
    private static final int TYPE_VT_STREAMED_OBJECT = -1;
    private static final int TYPE_VT_STORED_OBJECT = -1;
    private static final int TYPE_VT_BLOB_OBJECT = -1;
    private static final int TYPE_VT_CF = 71;
    private static final int TYPE_VT_CLSID = 72;
    private static final int TYPE_VT_VECTOR = 4096;
    private final FSILogger logger;
    private final File file;
    private final SeekableStream stream;
    private final Hashtable<Integer, Property> properties = new Hashtable();

    public PropertySet(FSILogger logger, File file, SeekableStream stream) throws IOException {
        this.logger = logger;
        this.file = file;
        this.stream = stream;
        stream.seek(44L);
        int sectionOffset = stream.readIntLE();
        stream.seek((long)sectionOffset);
        int sectionSize = stream.readIntLE();
        int sectionCount = stream.readIntLE();
        for (int i = 0; i < sectionCount; ++i) {
            stream.seek((long)(sectionOffset + 8 * i + 8));
            int pid = stream.readIntLE();
            int offset = stream.readIntLE();
            stream.seek((long)(sectionOffset + offset));
            int type = stream.readIntLE();
            Property p = new Property(type, sectionOffset + offset + 4);
            this.properties.put(new Integer(pid), p);
        }
    }

    public boolean hasProperty(int id) {
        Property p = this.properties.get(new Integer(id));
        return p != null;
    }

    public int getI4(int id) {
        Property p = this.properties.get(new Integer(id));
        try {
            int offset = p.getOffset();
            this.stream.seek((long)offset);
            return this.stream.readIntLE();
        }
        catch (IOException e) {
            this.logger.log(3819, "IOException occurs when get I4", this.file);
            return -1;
        }
    }

    public int getUI1(int id) {
        Property p = this.properties.get(new Integer(id));
        try {
            int offset = p.getOffset();
            this.stream.seek((long)offset);
            return this.stream.readUnsignedByte();
        }
        catch (IOException e) {
            this.logger.log(3819, "IOException occurs when get I4", this.file);
            return -1;
        }
    }

    public int getUI2(int id) {
        Property p = this.properties.get(new Integer(id));
        try {
            int offset = p.getOffset();
            this.stream.seek((long)offset);
            return this.stream.readUnsignedShortLE();
        }
        catch (IOException e) {
            this.logger.log(3819, "IOException occurs when get UI1", this.file);
            return -1;
        }
    }

    public long getUI4(int id) {
        Property p = this.properties.get(new Integer(id));
        try {
            int offset = p.getOffset();
            this.stream.seek((long)offset);
            return this.stream.readUnsignedIntLE();
        }
        catch (IOException e) {
            this.logger.log(3819, "IOException occurs when get UI4", this.file);
            return -1L;
        }
    }

    public long getUI4(int id, long defaultValue) {
        Property p = this.properties.get(new Integer(id));
        if (p == null) {
            return defaultValue;
        }
        try {
            int offset = p.getOffset();
            this.stream.seek((long)offset);
            return this.stream.readUnsignedIntLE();
        }
        catch (IOException e) {
            this.logger.log(3819, "IOException occurs when get UI4", this.file);
            return -1L;
        }
    }

    public String getLPSTR(int id) {
        Property p = this.properties.get(new Integer(id));
        if (p == null) {
            return null;
        }
        try {
            int offset = p.getOffset();
            this.stream.seek((long)offset);
            int length = this.stream.readIntLE();
            StringBuffer sb = new StringBuffer(length);
            for (int i = 0; i < length; ++i) {
                sb.append((char)this.stream.read());
            }
            return sb.toString();
        }
        catch (IOException e) {
            this.logger.log(3819, "IOException occurs when get LPSTR/LPWSTR", this.file);
            return null;
        }
    }

    public String getLPWSTR(int id) {
        Property p = this.properties.get(new Integer(id));
        try {
            int offset = p.getOffset();
            this.stream.seek((long)offset);
            int length = this.stream.readIntLE();
            StringBuffer sb = new StringBuffer(length);
            for (int i = 0; i < length; ++i) {
                sb.append(this.stream.readCharLE());
            }
            return sb.toString();
        }
        catch (IOException e) {
            this.logger.log(3819, "IOException occurs when get LPSTR/LPWSTR", this.file);
            return null;
        }
    }

    public float getR4(int id) {
        Property p = this.properties.get(new Integer(id));
        try {
            int offset = p.getOffset();
            this.stream.seek((long)offset);
            return this.stream.readFloatLE();
        }
        catch (IOException e) {
            this.logger.log(3819, "IOException occurs when get R4", this.file);
            return -1.0f;
        }
    }

    public Date getDate(int id) {
        throw new RuntimeException("Not implemented:" + this.file);
    }

    public Date getFiletime(int id) {
        throw new RuntimeException("Not implemented:" + this.file);
    }

    public byte[] getBlob(int id) {
        Property p = this.properties.get(new Integer(id));
        try {
            int offset = p.getOffset();
            this.stream.seek((long)offset);
            int length = this.stream.readIntLE();
            byte[] buf = new byte[length];
            this.stream.seek((long)(offset + 4));
            this.stream.readFully(buf);
            return buf;
        }
        catch (IOException e) {
            this.logger.log(3819, "IOException occurs when get blob", this.file);
            return null;
        }
    }

    public int[] getUI1Vector(int id) {
        throw new RuntimeException("Not implemented:" + this.file);
    }

    public int[] getUI2Vector(int id) {
        throw new RuntimeException("Not implemented:" + this.file);
    }

    public long[] getUI4Vector(int id) {
        throw new RuntimeException("Not implemented:" + this.file);
    }

    public float[] getR4Vector(int id) {
        throw new RuntimeException("Not implemented:" + this.file);
    }

    public String[] getLPWSTRVector(int id) {
        throw new RuntimeException("Not implemented:" + this.file);
    }
}

