/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.neptunelabs.fsiframework.helpers.FloatAdvancer;
import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;
import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.SimpleCMYKColorSpace;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public abstract class TIFFDecompressor {
    private static final boolean DEBUG = false;
    protected ImageReader reader;
    protected IIOMetadata metadata;
    protected int photometricInterpretation;
    protected int compression;
    protected boolean planar;
    protected int samplesPerPixel;
    protected int[] bitsPerSample;
    protected int[] sampleFormat = new int[]{1};
    protected int[] extraSamples;
    protected char[] colorMap;
    protected ImageInputStream stream;
    protected long offset;
    protected int byteCount;
    protected int srcMinX;
    protected int srcMinY;
    protected int srcWidth;
    protected int srcHeight;
    protected int sourceXOffset;
    protected int dstXOffset;
    protected int sourceYOffset;
    protected int dstYOffset;
    protected int subsampleX;
    protected int subsampleY;
    protected int[] sourceBands;
    protected int[] destinationBands;
    protected BufferedImage rawImage;
    protected BufferedImage image;
    protected int dstMinX;
    protected int dstMinY;
    protected int dstWidth;
    protected int dstHeight;
    protected int activeSrcMinX;
    protected int activeSrcMinY;
    protected int activeSrcWidth;
    protected int activeSrcHeight;
    protected TIFFColorConverter colorConverter;
    boolean isBilevel;
    boolean isContiguous;
    boolean isImageSimple;
    protected boolean adjustBitDepths;
    int[][] bitDepthScale;
    private boolean isFirstBitDepthTable = true;
    private boolean planarCache = false;
    private int[] destBitsPerSampleCache = null;
    private int[] sourceBandsCache = null;
    private int[] bitsPerSampleCache = null;
    private int[] destinationBandsCache = null;

    static SampleModel createInterleavedSM(int dataType, int numBands) {
        int[] bandOffsets = new int[numBands];
        for (int i = 0; i < numBands; ++i) {
            bandOffsets[i] = i;
        }
        return new PixelInterleavedSampleModel(dataType, 1, 1, numBands, numBands, bandOffsets);
    }

    static ColorModel createComponentCM(ColorSpace colorSpace, int numBands, int dataType, boolean hasAlpha, boolean isAlphaPremultiplied) {
        ComponentColorModel colorModel;
        int transparency;
        int n = transparency = hasAlpha ? 3 : 1;
        if (dataType == 4 || dataType == 5) {
            colorModel = new ComponentColorModel(colorSpace, hasAlpha, isAlphaPremultiplied, transparency, dataType);
        } else {
            int bits;
            int[] numBits = new int[numBands];
            if (dataType == 0) {
                bits = 8;
            } else if (dataType == 2 || dataType == 1) {
                bits = 16;
            } else if (dataType == 3) {
                bits = 32;
            } else {
                throw new IllegalArgumentException("dataType = " + dataType);
            }
            for (int i = 0; i < numBands; ++i) {
                numBits[i] = bits;
            }
            colorModel = new ComponentColorModel(colorSpace, numBits, hasAlpha, isAlphaPremultiplied, transparency, dataType);
        }
        return colorModel;
    }

    private static int createMask(int[] bitsPerSample, int band) {
        int mask = (1 << bitsPerSample[band]) - 1;
        for (int i = band + 1; i < bitsPerSample.length; ++i) {
            mask <<= bitsPerSample[i];
        }
        return mask;
    }

    private static int getDataTypeFromNumBits(int numBits, boolean isSigned) {
        int dataType = numBits <= 8 ? 0 : (numBits <= 16 ? (isSigned ? 2 : 1) : 3);
        return dataType;
    }

    private static boolean areIntArraysEqual(int[] a, int[] b) {
        if (a == null || b == null) {
            return a == null && b == null;
        }
        if (a.length != b.length) {
            return false;
        }
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static int getDataTypeSize(int dataType) throws IIOException {
        int dataTypeSize = 0;
        switch (dataType) {
            case 0: {
                dataTypeSize = 8;
                break;
            }
            case 1: 
            case 2: {
                dataTypeSize = 16;
                break;
            }
            case 3: 
            case 4: {
                dataTypeSize = 32;
                break;
            }
            case 5: {
                dataTypeSize = 64;
                break;
            }
            default: {
                throw new IIOException("Unknown data type " + dataType);
            }
        }
        return dataTypeSize;
    }

    private static int getBitsPerPixel(SampleModel sm) {
        int bitsPerPixel = 0;
        int[] sampleSize = sm.getSampleSize();
        int numBands = sampleSize.length;
        for (int i = 0; i < numBands; ++i) {
            bitsPerPixel += sampleSize[i];
        }
        return bitsPerPixel;
    }

    private static boolean areSampleSizesEqual(SampleModel sm) {
        boolean allSameSize = true;
        int[] sampleSize = sm.getSampleSize();
        int sampleSize0 = sampleSize[0];
        int numBands = sampleSize.length;
        for (int i = 1; i < numBands; ++i) {
            if (sampleSize[i] == sampleSize0) continue;
            allSameSize = false;
            break;
        }
        return allSameSize;
    }

    private static boolean isDataBufferBitContiguous(SampleModel sm) throws IIOException {
        int dataTypeSize = TIFFDecompressor.getDataTypeSize(sm.getDataType());
        if (sm instanceof ComponentSampleModel) {
            int numBands = sm.getNumBands();
            for (int i = 0; i < numBands; ++i) {
                if (sm.getSampleSize(i) == dataTypeSize) continue;
                return false;
            }
        } else if (sm instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sm;
            if (dataTypeSize % mppsm.getPixelBitStride() != 0) {
                return false;
            }
        } else if (sm instanceof SinglePixelPackedSampleModel) {
            int numBands = sm.getNumBands();
            int numBits = 0;
            for (int i = 0; i < numBands; ++i) {
                numBits += sm.getSampleSize(i);
            }
            if (numBits != dataTypeSize) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static void reformatData(byte[] buf, int bytesPerRow, int numRows, short[] shortData, int[] intData, int outOffset, int outStride) throws IIOException {
        if (shortData != null) {
            int inOffset = 0;
            int shortsPerRow = bytesPerRow / 2;
            int numExtraBytes = bytesPerRow % 2;
            for (int j = 0; j < numRows; ++j) {
                int k = outOffset;
                for (int i = 0; i < shortsPerRow; ++i) {
                    shortData[k++] = (short)((buf[inOffset++] & 0xFF) << 8 | buf[inOffset++] & 0xFF);
                }
                if (numExtraBytes != 0) {
                    shortData[k++] = (short)((buf[inOffset++] & 0xFF) << 8);
                }
                outOffset += outStride;
            }
        } else if (intData != null) {
            int inOffset = 0;
            int intsPerRow = bytesPerRow / 4;
            int numExtraBytes = bytesPerRow % 4;
            for (int j = 0; j < numRows; ++j) {
                int k = outOffset;
                for (int i = 0; i < intsPerRow; ++i) {
                    intData[k++] = (buf[inOffset++] & 0xFF) << 24 | (buf[inOffset++] & 0xFF) << 16 | (buf[inOffset++] & 0xFF) << 8 | buf[inOffset++] & 0xFF;
                }
                if (numExtraBytes != 0) {
                    int shift = 24;
                    int ival = 0;
                    for (int b = 0; b < numExtraBytes; ++b) {
                        ival |= (buf[inOffset++] & 0xFF) << shift;
                        shift -= 8;
                    }
                    intData[k++] = ival;
                }
                outOffset += outStride;
            }
        } else {
            throw new IIOException("shortData == null && intData == null!");
        }
    }

    private static void reformatDiscontiguousData(byte[] buf, int stride, int w, int h, WritableRaster raster) throws IOException {
        SampleModel sm = raster.getSampleModel();
        int numBands = sm.getNumBands();
        int[] sampleSize = sm.getSampleSize();
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(is);
        long iisPosition = 0L;
        int y = raster.getMinY();
        int j = 0;
        while (j < h) {
            iis.seek(iisPosition);
            int x = raster.getMinX();
            int i = 0;
            while (i < w) {
                for (int b = 0; b < numBands; ++b) {
                    long bits = iis.readBits(sampleSize[b]);
                    raster.setSample(x, y, b, (int)bits);
                }
                ++i;
                ++x;
            }
            iisPosition += (long)stride;
            ++j;
            ++y;
        }
    }

    public static ImageTypeSpecifier getRawImageTypeSpecifier(int photometricInterpretation, int compression, int samplesPerPixel, int[] bitsPerSample, int[] sampleFormat, int[] extraSamples, char[] colorMap) {
        if (!(samplesPerPixel != 1 || sampleFormat[0] != 2 && sampleFormat[0] != 1 && sampleFormat[0] != 4 || bitsPerSample[0] != 1 && bitsPerSample[0] != 2 && bitsPerSample[0] != 4 && bitsPerSample[0] != 8 && bitsPerSample[0] != 16)) {
            if (colorMap == null) {
                boolean isSigned;
                boolean bl = isSigned = sampleFormat[0] == 2;
                int dataType = bitsPerSample[0] <= 8 ? 0 : (sampleFormat[0] == 2 ? 2 : 1);
                return ImageTypeSpecifier.createGrayscale(bitsPerSample[0], dataType, isSigned);
            }
            int mapSize = 1 << bitsPerSample[0];
            byte[] redLut = new byte[mapSize];
            byte[] greenLut = new byte[mapSize];
            byte[] blueLut = new byte[mapSize];
            byte[] alphaLut = null;
            for (int i = 0; i < mapSize; ++i) {
                redLut[i] = (byte)(colorMap[i] * 255 / 65535);
                greenLut[i] = (byte)(colorMap[mapSize + i] * 255 / 65535);
                blueLut[i] = (byte)(colorMap[2 * mapSize + i] * 255 / 65535);
            }
            int dataType = bitsPerSample[0] == 8 ? 0 : 1;
            return ImageTypeSpecifier.createIndexed(redLut, greenLut, blueLut, alphaLut, bitsPerSample[0], dataType);
        }
        if (samplesPerPixel == 2 && bitsPerSample[0] == 8 && bitsPerSample[1] == 8) {
            boolean dataType = false;
            boolean alphaPremultiplied = false;
            if (extraSamples != null && extraSamples[0] == 1) {
                alphaPremultiplied = true;
            }
            return ImageTypeSpecifier.createGrayscale(8, 0, false, alphaPremultiplied);
        }
        if (!(samplesPerPixel != 2 || bitsPerSample[0] != 16 || bitsPerSample[1] != 16 || sampleFormat[0] != 2 && sampleFormat[0] != 1 || sampleFormat[1] != 2 && sampleFormat[1] != 1)) {
            int dataType = sampleFormat[0] == 2 ? 2 : 1;
            boolean alphaPremultiplied = false;
            if (extraSamples != null && extraSamples[0] == 1) {
                alphaPremultiplied = true;
            }
            boolean isSigned = dataType == 2;
            return ImageTypeSpecifier.createGrayscale(16, dataType, isSigned, alphaPremultiplied);
        }
        ColorSpace rgb = ColorSpace.getInstance(1000);
        if (samplesPerPixel == 3 && bitsPerSample[0] == 8 && bitsPerSample[1] == 8 && bitsPerSample[2] == 8) {
            int[] bandOffsets = new int[]{0, 1, 2};
            boolean dataType = false;
            ColorSpace theColorSpace = photometricInterpretation == 6 && compression != 7 && compression != 6 || photometricInterpretation == 8 ? ColorSpace.getInstance(1004) : rgb;
            return ImageTypeSpecifier.createInterleaved(theColorSpace, bandOffsets, 0, false, false);
        }
        if (samplesPerPixel == 4 && bitsPerSample[0] == 8 && bitsPerSample[1] == 8 && bitsPerSample[2] == 8 && bitsPerSample[3] == 8) {
            boolean hasAlpha;
            ColorSpace theColorSpace;
            int[] bandOffsets = new int[]{0, 1, 2, 3};
            boolean dataType = false;
            boolean alphaPremultiplied = false;
            if (photometricInterpretation == 5) {
                theColorSpace = SimpleCMYKColorSpace.getInstance();
                hasAlpha = false;
            } else {
                theColorSpace = rgb;
                hasAlpha = true;
                if (extraSamples != null && extraSamples[0] == 1) {
                    alphaPremultiplied = true;
                }
            }
            return ImageTypeSpecifier.createInterleaved(theColorSpace, bandOffsets, 0, hasAlpha, alphaPremultiplied);
        }
        if (samplesPerPixel == 3 && bitsPerSample[0] == 16 && bitsPerSample[1] == 16 && bitsPerSample[2] == 16 && (sampleFormat[0] == 2 || sampleFormat[0] == 1 || sampleFormat[0] == 4)) {
            int[] bandOffsets = new int[]{0, 1, 2};
            int dataType = sampleFormat[0] == 2 ? 2 : 1;
            ColorSpace theColorSpace = photometricInterpretation == 6 && compression != 7 && compression != 6 || photometricInterpretation == 8 ? ColorSpace.getInstance(1004) : rgb;
            return ImageTypeSpecifier.createInterleaved(theColorSpace, bandOffsets, dataType, false, false);
        }
        if (samplesPerPixel == 4 && bitsPerSample[0] == 16 && bitsPerSample[1] == 16 && bitsPerSample[2] == 16 && bitsPerSample[3] == 16 && (sampleFormat[0] == 2 || sampleFormat[0] == 1 || sampleFormat[0] == 4)) {
            int[] bandOffsets = new int[]{0, 1, 2, 3};
            int dataType = sampleFormat[0] == 2 ? 2 : 1;
            boolean alphaPremultiplied = false;
            if (extraSamples != null && extraSamples[0] == 1) {
                alphaPremultiplied = true;
            }
            return ImageTypeSpecifier.createInterleaved(rgb, bandOffsets, dataType, true, alphaPremultiplied);
        }
        if (photometricInterpretation == 5 && (bitsPerSample[0] == 1 || bitsPerSample[0] == 2 || bitsPerSample[0] == 4)) {
            ColorSpace cs = null;
            cs = samplesPerPixel == 4 ? SimpleCMYKColorSpace.getInstance() : new BogusColorSpace(samplesPerPixel);
            ComponentColorModel cm = new ComponentColorModel(cs, bitsPerSample, false, false, 1, 0);
            return new ImageTypeSpecifier(cm, ((ColorModel)cm).createCompatibleSampleModel(1, 1));
        }
        int totalBits = 0;
        for (int element : bitsPerSample) {
            totalBits += element;
        }
        if (!(samplesPerPixel != 3 && samplesPerPixel != 4 || totalBits != 8 && totalBits != 16)) {
            int redMask = TIFFDecompressor.createMask(bitsPerSample, 0);
            int greenMask = TIFFDecompressor.createMask(bitsPerSample, 1);
            int blueMask = TIFFDecompressor.createMask(bitsPerSample, 2);
            int alphaMask = samplesPerPixel == 4 ? TIFFDecompressor.createMask(bitsPerSample, 3) : 0;
            int transferType = totalBits == 8 ? 0 : 1;
            boolean alphaPremultiplied = false;
            if (extraSamples != null && extraSamples[0] == 1) {
                alphaPremultiplied = true;
            }
            return ImageTypeSpecifier.createPacked(rgb, redMask, greenMask, blueMask, alphaMask, transferType, alphaPremultiplied);
        }
        if (bitsPerSample[0] % 8 == 0) {
            boolean allSameBitDepth = true;
            for (int i = 1; i < bitsPerSample.length; ++i) {
                if (bitsPerSample[i] == bitsPerSample[i - 1]) continue;
                allSameBitDepth = false;
                break;
            }
            if (allSameBitDepth) {
                int dataType = -1;
                int isDataTypeSet = 0;
                switch (bitsPerSample[0]) {
                    case 8: {
                        if (sampleFormat[0] == 3) break;
                        dataType = 0;
                        isDataTypeSet = 1;
                        break;
                    }
                    case 16: {
                        if (sampleFormat[0] == 2) {
                            dataType = 2;
                            isDataTypeSet = 1;
                            break;
                        }
                        if (sampleFormat[0] == 1) {
                            dataType = 1;
                            isDataTypeSet = 1;
                            break;
                        }
                        if (sampleFormat[0] != 3) break;
                        dataType = 4;
                        isDataTypeSet = 1;
                        break;
                    }
                    case 24: 
                    case 32: {
                        dataType = sampleFormat[0] == 3 ? 4 : 3;
                        isDataTypeSet = 1;
                    }
                }
                if (isDataTypeSet != 0) {
                    ColorModel cm;
                    SampleModel sm = TIFFDecompressor.createInterleavedSM(dataType, samplesPerPixel);
                    if (samplesPerPixel >= 1 && samplesPerPixel <= 4 && (dataType == 3 || dataType == 4)) {
                        ColorSpace cs = samplesPerPixel <= 2 ? ColorSpace.getInstance(1003) : rgb;
                        boolean hasAlpha = samplesPerPixel % 2 == 0;
                        boolean alphaPremultiplied = false;
                        if (hasAlpha && extraSamples != null && extraSamples[0] == 1) {
                            alphaPremultiplied = true;
                        }
                        cm = TIFFDecompressor.createComponentCM(cs, samplesPerPixel, dataType, hasAlpha, alphaPremultiplied);
                    } else {
                        BogusColorSpace cs = new BogusColorSpace(samplesPerPixel);
                        cm = TIFFDecompressor.createComponentCM(cs, samplesPerPixel, dataType, false, false);
                    }
                    return new ImageTypeSpecifier(cm, sm);
                }
            }
        }
        if (colorMap == null && sampleFormat[0] != 3) {
            int dataType;
            int dataType2;
            boolean isSigned;
            int maxBitsPerSample = 0;
            for (int element : bitsPerSample) {
                if (element <= maxBitsPerSample) continue;
                maxBitsPerSample = element;
            }
            boolean bl = isSigned = sampleFormat[0] == 2;
            if (samplesPerPixel == 1) {
                dataType2 = TIFFDecompressor.getDataTypeFromNumBits(maxBitsPerSample, isSigned);
                return ImageTypeSpecifier.createGrayscale(maxBitsPerSample, dataType2, isSigned);
            }
            if (samplesPerPixel == 2) {
                boolean alphaPremultiplied = false;
                if (extraSamples != null && extraSamples[0] == 1) {
                    alphaPremultiplied = true;
                }
                dataType = TIFFDecompressor.getDataTypeFromNumBits(maxBitsPerSample, isSigned);
                return ImageTypeSpecifier.createGrayscale(maxBitsPerSample, dataType, false, alphaPremultiplied);
            }
            if (samplesPerPixel == 3 || samplesPerPixel == 4) {
                if (totalBits <= 32 && !isSigned) {
                    int redMask = TIFFDecompressor.createMask(bitsPerSample, 0);
                    int greenMask = TIFFDecompressor.createMask(bitsPerSample, 1);
                    int blueMask = TIFFDecompressor.createMask(bitsPerSample, 2);
                    int alphaMask = samplesPerPixel == 4 ? TIFFDecompressor.createMask(bitsPerSample, 3) : 0;
                    int transferType = TIFFDecompressor.getDataTypeFromNumBits(totalBits, false);
                    boolean alphaPremultiplied = false;
                    if (extraSamples != null && extraSamples[0] == 1) {
                        alphaPremultiplied = true;
                    }
                    return ImageTypeSpecifier.createPacked(rgb, redMask, greenMask, blueMask, alphaMask, transferType, alphaPremultiplied);
                }
                if (samplesPerPixel == 3) {
                    int[] bandOffsets = new int[]{0, 1, 2};
                    dataType = TIFFDecompressor.getDataTypeFromNumBits(maxBitsPerSample, isSigned);
                    return ImageTypeSpecifier.createInterleaved(rgb, bandOffsets, dataType, false, false);
                }
                if (samplesPerPixel == 4) {
                    int[] bandOffsets = new int[]{0, 1, 2, 3};
                    dataType = TIFFDecompressor.getDataTypeFromNumBits(maxBitsPerSample, isSigned);
                    boolean alphaPremultiplied = false;
                    if (extraSamples != null && extraSamples[0] == 1) {
                        alphaPremultiplied = true;
                    }
                    return ImageTypeSpecifier.createInterleaved(rgb, bandOffsets, dataType, true, alphaPremultiplied);
                }
            } else {
                dataType2 = TIFFDecompressor.getDataTypeFromNumBits(maxBitsPerSample, isSigned);
                SampleModel sm = TIFFDecompressor.createInterleavedSM(dataType2, samplesPerPixel);
                BogusColorSpace cs = new BogusColorSpace(samplesPerPixel);
                ColorModel cm = TIFFDecompressor.createComponentCM(cs, samplesPerPixel, dataType2, false, false);
                return new ImageTypeSpecifier(cm, sm);
            }
        }
        return null;
    }

    public void setReader(ImageReader reader) {
        this.reader = reader;
    }

    public void setMetadata(IIOMetadata metadata) {
        this.metadata = metadata;
    }

    public void setPhotometricInterpretation(int photometricInterpretation) {
        this.photometricInterpretation = photometricInterpretation;
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }

    public void setPlanar(boolean planar) {
        this.planar = planar;
    }

    public void setSamplesPerPixel(int samplesPerPixel) {
        this.samplesPerPixel = samplesPerPixel;
    }

    public void setBitsPerSample(int[] bitsPerSample) {
        this.bitsPerSample = bitsPerSample == null ? null : (int[])bitsPerSample.clone();
    }

    public void setSampleFormat(int[] sampleFormat) {
        int[] nArray;
        if (sampleFormat == null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            nArray = (int[])sampleFormat.clone();
        }
        this.sampleFormat = nArray;
    }

    public void setExtraSamples(int[] extraSamples) {
        this.extraSamples = extraSamples == null ? null : (int[])extraSamples.clone();
    }

    public void setColorMap(char[] colorMap) {
        this.colorMap = colorMap == null ? null : (char[])colorMap.clone();
    }

    public void setStream(ImageInputStream stream) {
        this.stream = stream;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setByteCount(int byteCount) {
        this.byteCount = byteCount;
    }

    public void setSrcMinX(int srcMinX) {
        this.srcMinX = srcMinX;
    }

    public void setSrcMinY(int srcMinY) {
        this.srcMinY = srcMinY;
    }

    public void setSrcWidth(int srcWidth) {
        this.srcWidth = srcWidth;
    }

    public void setSrcHeight(int srcHeight) {
        this.srcHeight = srcHeight;
    }

    public void setSourceXOffset(int sourceXOffset) {
        this.sourceXOffset = sourceXOffset;
    }

    public void setDstXOffset(int dstXOffset) {
        this.dstXOffset = dstXOffset;
    }

    public void setSourceYOffset(int sourceYOffset) {
        this.sourceYOffset = sourceYOffset;
    }

    public void setDstYOffset(int dstYOffset) {
        this.dstYOffset = dstYOffset;
    }

    public void setSubsampleX(int subsampleX) {
        if (subsampleX <= 0) {
            throw new IllegalArgumentException("subsampleX <= 0!");
        }
        this.subsampleX = subsampleX;
    }

    public void setSubsampleY(int subsampleY) {
        if (subsampleY <= 0) {
            throw new IllegalArgumentException("subsampleY <= 0!");
        }
        this.subsampleY = subsampleY;
    }

    public void setSourceBands(int[] sourceBands) {
        this.sourceBands = sourceBands == null ? null : (int[])sourceBands.clone();
    }

    public void setDestinationBands(int[] destinationBands) {
        this.destinationBands = destinationBands == null ? null : (int[])destinationBands.clone();
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void setDstMinX(int dstMinX) {
        this.dstMinX = dstMinX;
    }

    public void setDstMinY(int dstMinY) {
        this.dstMinY = dstMinY;
    }

    public void setDstWidth(int dstWidth) {
        this.dstWidth = dstWidth;
    }

    public void setDstHeight(int dstHeight) {
        this.dstHeight = dstHeight;
    }

    public void setActiveSrcMinX(int activeSrcMinX) {
        this.activeSrcMinX = activeSrcMinX;
    }

    public void setActiveSrcMinY(int activeSrcMinY) {
        this.activeSrcMinY = activeSrcMinY;
    }

    public void setActiveSrcWidth(int activeSrcWidth) {
        this.activeSrcWidth = activeSrcWidth;
    }

    public void setActiveSrcHeight(int activeSrcHeight) {
        this.activeSrcHeight = activeSrcHeight;
    }

    public void setColorConverter(TIFFColorConverter colorConverter) {
        this.colorConverter = colorConverter;
    }

    public ImageTypeSpecifier getRawImageType() {
        ImageTypeSpecifier its = TIFFDecompressor.getRawImageTypeSpecifier(this.photometricInterpretation, this.compression, this.samplesPerPixel, this.bitsPerSample, this.sampleFormat, this.extraSamples, this.colorMap);
        return its;
    }

    public BufferedImage createRawImage() {
        if (this.planar) {
            int bps = this.bitsPerSample[this.sourceBands[0]];
            int dataType = this.sampleFormat[0] == 3 ? 4 : (bps <= 8 ? 0 : (bps <= 16 ? (this.sampleFormat[0] == 2 ? 2 : 1) : 3));
            ColorSpace csGray = ColorSpace.getInstance(1003);
            ImageTypeSpecifier its = null;
            if (bps == 1 || bps == 2 || bps == 4) {
                int bits = bps;
                int size = 1 << bits;
                byte[] r = new byte[size];
                byte[] g = new byte[size];
                byte[] b = new byte[size];
                for (int j = 0; j < r.length; ++j) {
                    r[j] = 0;
                    g[j] = 0;
                    b[j] = 0;
                }
                IndexColorModel cmGray = new IndexColorModel(bits, size, r, g, b);
                MultiPixelPackedSampleModel smGray = new MultiPixelPackedSampleModel(0, 1, 1, bits);
                its = new ImageTypeSpecifier(cmGray, smGray);
            } else {
                its = ImageTypeSpecifier.createInterleaved(csGray, new int[]{0}, dataType, false, false);
            }
            return its.createBufferedImage(this.srcWidth, this.srcHeight);
        }
        ImageTypeSpecifier its = this.getRawImageType();
        if (its == null) {
            return null;
        }
        return its.createBufferedImage(this.srcWidth, this.srcHeight);
    }

    public abstract void decodeRaw(byte[] var1, int var2, int var3, int var4) throws IOException;

    public void decodeRaw(short[] s, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        int bytesPerRow = (this.srcWidth * bitsPerPixel + 7) / 8;
        int shortsPerRow = bytesPerRow / 2;
        byte[] b = new byte[bytesPerRow * this.srcHeight];
        this.decodeRaw(b, 0, bitsPerPixel, bytesPerRow);
        int bOffset = 0;
        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < this.srcHeight; ++j) {
                for (int i = 0; i < shortsPerRow; ++i) {
                    short sval;
                    short hiVal = b[bOffset++];
                    short loVal = b[bOffset++];
                    s[dstOffset + i] = sval = (short)(hiVal << 8 | loVal & 0xFF);
                }
                dstOffset += scanlineStride;
            }
        } else {
            for (int j = 0; j < this.srcHeight; ++j) {
                for (int i = 0; i < shortsPerRow; ++i) {
                    short sval;
                    short loVal = b[bOffset++];
                    short hiVal = b[bOffset++];
                    s[dstOffset + i] = sval = (short)(hiVal << 8 | loVal & 0xFF);
                }
                dstOffset += scanlineStride;
            }
        }
    }

    public void decodeRaw(int[] i, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        int numBands = bitsPerPixel / 32;
        int intsPerRow = this.srcWidth * numBands;
        int bytesPerRow = intsPerRow * 4;
        byte[] b = new byte[bytesPerRow * this.srcHeight];
        this.decodeRaw(b, 0, bitsPerPixel, bytesPerRow);
        int bOffset = 0;
        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < this.srcHeight; ++j) {
                for (int k = 0; k < intsPerRow; ++k) {
                    int ival;
                    int v0 = b[bOffset++] & 0xFF;
                    int v1 = b[bOffset++] & 0xFF;
                    int v2 = b[bOffset++] & 0xFF;
                    int v3 = b[bOffset++] & 0xFF;
                    i[dstOffset + k] = ival = v0 << 24 | v1 << 16 | v2 << 8 | v3;
                }
                dstOffset += scanlineStride;
            }
        } else {
            for (int j = 0; j < this.srcHeight; ++j) {
                for (int k = 0; k < intsPerRow; ++k) {
                    int ival;
                    int v3 = b[bOffset++] & 0xFF;
                    int v2 = b[bOffset++] & 0xFF;
                    int v1 = b[bOffset++] & 0xFF;
                    int v0 = b[bOffset++] & 0xFF;
                    i[dstOffset + k] = ival = v0 << 24 | v1 << 16 | v2 << 8 | v3;
                }
                dstOffset += scanlineStride;
            }
        }
    }

    public void decodeRaw(float[] f, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        int numBands = bitsPerPixel / 32;
        int floatsPerRow = this.srcWidth * numBands;
        int bytesPerRow = floatsPerRow * 4;
        byte[] b = new byte[bytesPerRow * this.srcHeight];
        this.decodeRaw(b, 0, bitsPerPixel, bytesPerRow);
        int bOffset = 0;
        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            for (int j = 0; j < this.srcHeight; ++j) {
                for (int i = 0; i < floatsPerRow; ++i) {
                    float fval;
                    int v0 = b[bOffset++] & 0xFF;
                    int v1 = b[bOffset++] & 0xFF;
                    int v2 = b[bOffset++] & 0xFF;
                    int v3 = b[bOffset++] & 0xFF;
                    int ival = v0 << 24 | v1 << 16 | v2 << 8 | v3;
                    f[dstOffset + i] = fval = Float.intBitsToFloat(ival);
                }
                dstOffset += scanlineStride;
            }
        } else {
            for (int j = 0; j < this.srcHeight; ++j) {
                for (int i = 0; i < floatsPerRow; ++i) {
                    float fval;
                    int v3 = b[bOffset++] & 0xFF;
                    int v2 = b[bOffset++] & 0xFF;
                    int v1 = b[bOffset++] & 0xFF;
                    int v0 = b[bOffset++] & 0xFF;
                    int ival = v0 << 24 | v1 << 16 | v2 << 8 | v3;
                    f[dstOffset + i] = fval = Float.intBitsToFloat(ival);
                }
                dstOffset += scanlineStride;
            }
        }
    }

    public void beginDecoding() {
        int b;
        this.adjustBitDepths = false;
        int numBands = this.destinationBands.length;
        int[] destBitsPerSample = null;
        if (this.planar) {
            int totalNumBands = this.bitsPerSample.length;
            destBitsPerSample = new int[totalNumBands];
            int dbps = this.image.getSampleModel().getSampleSize(0);
            for (int b2 = 0; b2 < totalNumBands; ++b2) {
                destBitsPerSample[b2] = dbps;
            }
        } else {
            destBitsPerSample = this.image.getSampleModel().getSampleSize();
        }
        if (this.photometricInterpretation != 5 || this.bitsPerSample[0] != 1 && this.bitsPerSample[0] != 2 && this.bitsPerSample[0] != 4) {
            for (b = 0; b < numBands; ++b) {
                if (destBitsPerSample[this.destinationBands[b]] == this.bitsPerSample[this.sourceBands[b]]) continue;
                this.adjustBitDepths = true;
                break;
            }
        }
        if (this.adjustBitDepths) {
            if (!(!this.isFirstBitDepthTable && this.planar == this.planarCache && TIFFDecompressor.areIntArraysEqual(destBitsPerSample, this.destBitsPerSampleCache) && TIFFDecompressor.areIntArraysEqual(this.sourceBands, this.sourceBandsCache) && TIFFDecompressor.areIntArraysEqual(this.bitsPerSample, this.bitsPerSampleCache) && TIFFDecompressor.areIntArraysEqual(this.destinationBands, this.destinationBandsCache))) {
                this.isFirstBitDepthTable = false;
                this.planarCache = this.planar;
                this.destBitsPerSampleCache = (int[])destBitsPerSample.clone();
                this.sourceBandsCache = this.sourceBands == null ? null : (int[])this.sourceBands.clone();
                this.bitsPerSampleCache = this.bitsPerSample == null ? null : (int[])this.bitsPerSample.clone();
                this.destinationBandsCache = this.destinationBands == null ? null : (int[])this.destinationBands.clone();
                this.bitDepthScale = new int[numBands][];
                for (b = 0; b < numBands; ++b) {
                    int maxInSample = (1 << this.bitsPerSample[this.sourceBands[b]]) - 1;
                    int halfMaxInSample = maxInSample / 2;
                    int maxOutSample = (1 << destBitsPerSample[this.destinationBands[b]]) - 1;
                    this.bitDepthScale[b] = new int[maxInSample + 1];
                    for (int s = 0; s <= maxInSample; ++s) {
                        this.bitDepthScale[b][s] = (s * maxOutSample + halfMaxInSample) / maxInSample;
                    }
                }
            }
        } else {
            this.bitDepthScale = null;
        }
        boolean sourceBandsNormal = false;
        boolean destinationBandsNormal = false;
        if (numBands == this.samplesPerPixel) {
            sourceBandsNormal = true;
            destinationBandsNormal = true;
            for (int i = 0; i < numBands; ++i) {
                if (this.sourceBands[i] != i) {
                    sourceBandsNormal = false;
                }
                if (this.destinationBands[i] == i) continue;
                destinationBandsNormal = false;
            }
        }
        this.isBilevel = ImageUtil.isBinary(this.image.getRaster().getSampleModel());
        this.isContiguous = this.isBilevel ? true : ImageUtil.imageIsContiguous(this.image);
        this.isImageSimple = this.colorConverter == null && this.subsampleX == 1 && this.subsampleY == 1 && this.srcWidth == this.dstWidth && this.srcHeight == this.dstHeight && this.dstMinX + this.dstWidth <= this.image.getWidth() && this.dstMinY + this.dstHeight <= this.image.getHeight() && sourceBandsNormal && destinationBandsNormal && !this.adjustBitDepths;
    }

    public void decode() throws IOException {
        SampleModel sm;
        boolean isDirectCopy;
        byte[] byteData = null;
        short[] shortData = null;
        int[] intData = null;
        float[] floatData = null;
        int dstOffset = 0;
        int pixelBitStride = 1;
        int scanlineStride = 0;
        this.rawImage = null;
        if (this.isImageSimple) {
            if (this.isBilevel) {
                this.rawImage = this.image;
            } else if (this.isContiguous) {
                this.rawImage = this.image.getSubimage(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight);
            }
        }
        boolean bl = isDirectCopy = this.rawImage != null;
        if (this.rawImage == null) {
            this.rawImage = this.createRawImage();
            if (this.rawImage == null) {
                throw new IIOException("Couldn't create image buffer!");
            }
        }
        WritableRaster ras = this.rawImage.getRaster();
        if (this.isBilevel) {
            Rectangle rect = this.isImageSimple ? new Rectangle(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight) : ras.getBounds();
            byteData = ImageUtil.getPackedBinaryData(ras, rect);
            dstOffset = 0;
            pixelBitStride = 1;
            scanlineStride = (rect.width + 7) / 8;
        } else {
            DataBufferInt dbi;
            DataBufferUShort dbus;
            DataBufferByte dbb;
            sm = ras.getSampleModel();
            DataBuffer db = ras.getDataBuffer();
            boolean isSupportedType = false;
            if (sm instanceof ComponentSampleModel) {
                ComponentSampleModel csm = (ComponentSampleModel)sm;
                dstOffset = csm.getOffset(-ras.getSampleModelTranslateX(), -ras.getSampleModelTranslateY());
                scanlineStride = csm.getScanlineStride();
                if (db instanceof DataBufferByte) {
                    dbb = (DataBufferByte)db;
                    byteData = dbb.getData();
                    pixelBitStride = csm.getPixelStride() * 8;
                    isSupportedType = true;
                } else if (db instanceof DataBufferUShort) {
                    dbus = (DataBufferUShort)db;
                    shortData = dbus.getData();
                    pixelBitStride = csm.getPixelStride() * 16;
                    isSupportedType = true;
                } else if (db instanceof DataBufferShort) {
                    DataBufferShort dbs = (DataBufferShort)db;
                    shortData = dbs.getData();
                    pixelBitStride = csm.getPixelStride() * 16;
                    isSupportedType = true;
                } else if (db instanceof DataBufferInt) {
                    dbi = (DataBufferInt)db;
                    intData = dbi.getData();
                    pixelBitStride = csm.getPixelStride() * 32;
                    isSupportedType = true;
                } else if (db instanceof DataBufferFloat) {
                    DataBufferFloat dbf = (DataBufferFloat)db;
                    floatData = dbf.getData();
                    pixelBitStride = csm.getPixelStride() * 32;
                    isSupportedType = true;
                }
            } else if (sm instanceof MultiPixelPackedSampleModel) {
                MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sm;
                dstOffset = mppsm.getOffset(-ras.getSampleModelTranslateX(), -ras.getSampleModelTranslateY());
                pixelBitStride = mppsm.getPixelBitStride();
                scanlineStride = mppsm.getScanlineStride();
                if (db instanceof DataBufferByte) {
                    dbb = (DataBufferByte)db;
                    byteData = dbb.getData();
                    isSupportedType = true;
                } else if (db instanceof DataBufferUShort) {
                    dbus = (DataBufferUShort)db;
                    shortData = dbus.getData();
                    isSupportedType = true;
                } else if (db instanceof DataBufferInt) {
                    dbi = (DataBufferInt)db;
                    intData = dbi.getData();
                    isSupportedType = true;
                }
            } else if (sm instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
                dstOffset = sppsm.getOffset(-ras.getSampleModelTranslateX(), -ras.getSampleModelTranslateY());
                scanlineStride = sppsm.getScanlineStride();
                if (db instanceof DataBufferByte) {
                    dbb = (DataBufferByte)db;
                    byteData = dbb.getData();
                    pixelBitStride = 8;
                    isSupportedType = true;
                } else if (db instanceof DataBufferUShort) {
                    dbus = (DataBufferUShort)db;
                    shortData = dbus.getData();
                    pixelBitStride = 16;
                    isSupportedType = true;
                } else if (db instanceof DataBufferInt) {
                    dbi = (DataBufferInt)db;
                    intData = dbi.getData();
                    pixelBitStride = 32;
                    isSupportedType = true;
                }
            }
            if (!isSupportedType) {
                throw new IIOException("Unsupported raw image type: SampleModel = " + sm + "; DataBuffer = " + db);
            }
        }
        if (this.isBilevel) {
            this.decodeRaw(byteData, dstOffset, pixelBitStride, scanlineStride);
        } else {
            byte[] buf;
            int bytesPerRow;
            sm = ras.getSampleModel();
            if (TIFFDecompressor.isDataBufferBitContiguous(sm)) {
                if (byteData != null) {
                    this.decodeRaw(byteData, dstOffset, pixelBitStride, scanlineStride);
                } else if (floatData != null) {
                    this.decodeRaw(floatData, dstOffset, pixelBitStride, scanlineStride);
                } else if (shortData != null) {
                    if (TIFFDecompressor.areSampleSizesEqual(sm) && sm.getSampleSize(0) == 16) {
                        this.decodeRaw(shortData, dstOffset, pixelBitStride, scanlineStride);
                    } else {
                        int bpp = TIFFDecompressor.getBitsPerPixel(sm);
                        bytesPerRow = (bpp * this.srcWidth + 7) / 8;
                        buf = new byte[bytesPerRow * this.srcHeight];
                        this.decodeRaw(buf, 0, bpp, bytesPerRow);
                        TIFFDecompressor.reformatData(buf, bytesPerRow, this.srcHeight, shortData, null, dstOffset, scanlineStride);
                    }
                } else if (intData != null) {
                    if (TIFFDecompressor.areSampleSizesEqual(sm) && sm.getSampleSize(0) == 32) {
                        this.decodeRaw(intData, dstOffset, pixelBitStride, scanlineStride);
                    } else {
                        int bpp = TIFFDecompressor.getBitsPerPixel(sm);
                        bytesPerRow = (bpp * this.srcWidth + 7) / 8;
                        buf = new byte[bytesPerRow * this.srcHeight];
                        this.decodeRaw(buf, 0, bpp, bytesPerRow);
                        TIFFDecompressor.reformatData(buf, bytesPerRow, this.srcHeight, null, intData, dstOffset, scanlineStride);
                    }
                }
            } else {
                int bpp = TIFFDecompressor.getBitsPerPixel(sm);
                bytesPerRow = (bpp * this.srcWidth + 7) / 8;
                buf = new byte[bytesPerRow * this.srcHeight];
                this.decodeRaw(buf, 0, bpp, bytesPerRow);
                TIFFDecompressor.reformatDiscontiguousData(buf, bytesPerRow, this.srcWidth, this.srcHeight, ras);
            }
        }
        if (this.colorConverter != null) {
            float x2;
            float x1;
            int idx;
            float[] rgb = new float[3];
            if (byteData != null) {
                for (int j = 0; j < this.dstHeight; ++j) {
                    idx = dstOffset;
                    for (int i = 0; i < this.dstWidth; ++i) {
                        float x0 = byteData[idx] & 0xFF;
                        x1 = byteData[idx + 1] & 0xFF;
                        x2 = byteData[idx + 2] & 0xFF;
                        this.colorConverter.toRGB(x0, x1, x2, rgb);
                        byteData[idx] = (byte)rgb[0];
                        byteData[idx + 1] = (byte)rgb[1];
                        byteData[idx + 2] = (byte)rgb[2];
                        idx += 3;
                    }
                    dstOffset += scanlineStride;
                }
            } else if (shortData != null) {
                if (this.sampleFormat[0] == 2) {
                    for (int j = 0; j < this.dstHeight; ++j) {
                        idx = dstOffset;
                        for (int i = 0; i < this.dstWidth; ++i) {
                            float x0 = shortData[idx];
                            x1 = shortData[idx + 1];
                            x2 = shortData[idx + 2];
                            this.colorConverter.toRGB(x0, x1, x2, rgb);
                            shortData[idx] = (short)rgb[0];
                            shortData[idx + 1] = (short)rgb[1];
                            shortData[idx + 2] = (short)rgb[2];
                            idx += 3;
                        }
                        dstOffset += scanlineStride;
                    }
                } else {
                    for (int j = 0; j < this.dstHeight; ++j) {
                        idx = dstOffset;
                        for (int i = 0; i < this.dstWidth; ++i) {
                            float x0 = shortData[idx] & 0xFFFF;
                            x1 = shortData[idx + 1] & 0xFFFF;
                            x2 = shortData[idx + 2] & 0xFFFF;
                            this.colorConverter.toRGB(x0, x1, x2, rgb);
                            shortData[idx] = (short)rgb[0];
                            shortData[idx + 1] = (short)rgb[1];
                            shortData[idx + 2] = (short)rgb[2];
                            idx += 3;
                        }
                        dstOffset += scanlineStride;
                    }
                }
            } else if (intData != null) {
                for (int j = 0; j < this.dstHeight; ++j) {
                    idx = dstOffset;
                    for (int i = 0; i < this.dstWidth; ++i) {
                        float x0 = intData[idx];
                        x1 = intData[idx + 1];
                        x2 = intData[idx + 2];
                        this.colorConverter.toRGB(x0, x1, x2, rgb);
                        intData[idx] = (int)rgb[0];
                        intData[idx + 1] = (int)rgb[1];
                        intData[idx + 2] = (int)rgb[2];
                        idx += 3;
                    }
                    dstOffset += scanlineStride;
                }
            } else if (floatData != null) {
                for (int j = 0; j < this.dstHeight; ++j) {
                    idx = dstOffset;
                    for (int i = 0; i < this.dstWidth; ++i) {
                        float x0 = floatData[idx];
                        x1 = floatData[idx + 1];
                        x2 = floatData[idx + 2];
                        this.colorConverter.toRGB(x0, x1, x2, rgb);
                        floatData[idx] = rgb[0];
                        floatData[idx + 1] = rgb[1];
                        floatData[idx + 2] = rgb[2];
                        idx += 3;
                    }
                    dstOffset += scanlineStride;
                }
            }
        }
        if (this.photometricInterpretation == 0) {
            int offset;
            if (byteData != null) {
                int bytesPerRow = (this.srcWidth * pixelBitStride + 7) / 8;
                for (int y = 0; y < this.srcHeight; ++y) {
                    offset = dstOffset + y * scanlineStride;
                    for (int i = 0; i < bytesPerRow; ++i) {
                        int n = offset + i;
                        byteData[n] = (byte)(byteData[n] ^ 0xFF);
                    }
                }
            } else if (shortData != null) {
                int y;
                int shortsPerRow = (this.srcWidth * pixelBitStride + 15) / 16;
                if (this.sampleFormat[0] == 2) {
                    for (y = 0; y < this.srcHeight; ++y) {
                        offset = dstOffset + y * scanlineStride;
                        for (int i = 0; i < shortsPerRow; ++i) {
                            int shortOffset = offset + i;
                            shortData[shortOffset] = (short)(Short.MAX_VALUE - shortData[shortOffset]);
                        }
                    }
                } else {
                    for (y = 0; y < this.srcHeight; ++y) {
                        offset = dstOffset + y * scanlineStride;
                        for (int i = 0; i < shortsPerRow; ++i) {
                            int n = offset + i;
                            shortData[n] = (short)(shortData[n] ^ 0xFFFF);
                        }
                    }
                }
            } else if (intData != null) {
                int intsPerRow = (this.srcWidth * pixelBitStride + 15) / 16;
                for (int y = 0; y < this.srcHeight; ++y) {
                    offset = dstOffset + y * scanlineStride;
                    for (int i = 0; i < intsPerRow; ++i) {
                        int intOffset = offset + i;
                        intData[intOffset] = Integer.MAX_VALUE - intData[intOffset];
                    }
                }
            } else if (floatData != null) {
                int floatsPerRow = (this.srcWidth * pixelBitStride + 15) / 16;
                for (int y = 0; y < this.srcHeight; ++y) {
                    offset = dstOffset + y * scanlineStride;
                    for (int i = 0; i < floatsPerRow; ++i) {
                        int floatOffset = offset + i;
                        floatData[floatOffset] = 1.0f - floatData[floatOffset];
                    }
                }
            }
        }
        if (this.isBilevel) {
            Rectangle rect = this.isImageSimple ? new Rectangle(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight) : ras.getBounds();
            ImageUtil.setPackedBinaryData(byteData, ras, rect);
        }
        if (isDirectCopy) {
            return;
        }
        WritableRaster src = this.rawImage.getRaster();
        Raster srcChild = src.createChild(0, 0, this.srcWidth, this.srcHeight, this.srcMinX, this.srcMinY, this.planar ? null : this.sourceBands);
        WritableRaster dst = this.image.getRaster();
        WritableRaster dstChild = dst.createWritableChild(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight, this.dstMinX, this.dstMinY, this.destinationBands);
        if (this.subsampleX == 1 && this.subsampleY == 1 && !this.adjustBitDepths) {
            srcChild = srcChild.createChild(this.activeSrcMinX, this.activeSrcMinY, this.activeSrcWidth, this.activeSrcHeight, this.dstMinX, this.dstMinY, null);
            dstChild.setRect(srcChild);
        } else if (this.subsampleX == 1 && !this.adjustBitDepths) {
            int sy = this.activeSrcMinY;
            int dy = this.dstMinY;
            while (sy < this.srcMinY + this.srcHeight) {
                Raster srcRow = srcChild.createChild(this.activeSrcMinX, sy, this.activeSrcWidth, 1, this.dstMinX, dy, null);
                dstChild.setRect(srcRow);
                sy += this.subsampleY;
                ++dy;
            }
        } else {
            int[] p = srcChild.getPixel(this.srcMinX, this.srcMinY, (int[])null);
            int numBands = p.length;
            int sy = this.activeSrcMinY;
            int dy = this.dstMinY;
            while (sy < this.activeSrcMinY + this.activeSrcHeight) {
                int sx = this.activeSrcMinX;
                int dx = this.dstMinX;
                while (sx < this.activeSrcMinX + this.activeSrcWidth) {
                    srcChild.getPixel(sx, sy, p);
                    if (this.adjustBitDepths) {
                        for (int band = 0; band < numBands; ++band) {
                            p[band] = this.bitDepthScale[band][p[band]];
                        }
                    }
                    dstChild.setPixel(dx, dy, p);
                    sx += this.subsampleX;
                    ++dx;
                }
                sy += this.subsampleY;
                ++dy;
            }
        }
    }

    public void decodeSpecial(byte[] dstData, int dstOffset, int bitsPerSample, int predictor) throws IOException {
        int usedSamplesPerPixel = this.planar ? 1 : this.samplesPerPixel;
        ByteOrder order = this.stream.getByteOrder();
        if (predictor == 1 && this.sampleFormat[0] == 3) {
            if (bitsPerSample == 16) {
                byte[] dstData2 = new byte[dstData.length];
                for (int y = 0; y < this.srcHeight; ++y) {
                    int count2 = (dstOffset + usedSamplesPerPixel * y * this.srcWidth) * 2;
                    int count4 = (dstOffset + usedSamplesPerPixel * y * this.srcWidth) * 4;
                    for (int x = 0; x < this.srcWidth * usedSamplesPerPixel; ++x) {
                        int v1;
                        int v0;
                        if (order == ByteOrder.LITTLE_ENDIAN) {
                            v0 = ((dstData[count2 + 1] & 0xFF) << 8 | dstData[count2] & 0xFF) & 0xFFFF;
                            v1 = FloatAdvancer.int16ToInt32(v0);
                            dstData2[count4] = (byte)(v1 & 0xFF);
                            dstData2[count4 + 1] = (byte)(v1 >> 8 & 0xFF);
                            dstData2[count4 + 2] = (byte)(v1 >> 16 & 0xFF);
                            dstData2[count4 + 3] = (byte)(v1 >> 24 & 0xFF);
                        } else {
                            v0 = ((dstData[count2] & 0xFF) << 8 | dstData[count2 + 1] & 0xFF) & 0xFFFF;
                            v1 = FloatAdvancer.int16ToInt32(v0);
                            dstData2[count4 + 3] = (byte)(v1 & 0xFF);
                            dstData2[count4 + 2] = (byte)(v1 >> 8 & 0xFF);
                            dstData2[count4 + 1] = (byte)(v1 >> 16 & 0xFF);
                            dstData2[count4] = (byte)(v1 >> 24 & 0xFF);
                        }
                        count2 += 2;
                        count4 += 4;
                    }
                }
                System.arraycopy(dstData2, 0, dstData, 0, dstData2.length);
                this.adjustBitDepths = false;
            } else if (bitsPerSample == 24) {
                byte[] dstData2 = new byte[dstData.length];
                for (int y = 0; y < this.srcHeight; ++y) {
                    int count3 = (dstOffset + usedSamplesPerPixel * y * this.srcWidth) * 3;
                    int count4 = (dstOffset + usedSamplesPerPixel * y * this.srcWidth) * 4;
                    for (int x = 0; x < this.srcWidth * usedSamplesPerPixel; ++x) {
                        int v1;
                        int v0;
                        if (order == ByteOrder.BIG_ENDIAN) {
                            v0 = (dstData[count3] & 0xFF) << 16 | (dstData[count3 + 1] & 0xFF) << 8 | dstData[count3 + 2] & 0xFF;
                            v1 = FloatAdvancer.int24ToInt32(v0);
                            dstData2[count4 + 3] = (byte)(v1 & 0xFF);
                            dstData2[count4 + 2] = (byte)(v1 >> 8 & 0xFF);
                            dstData2[count4 + 1] = (byte)(v1 >> 16 & 0xFF);
                            dstData2[count4] = (byte)(v1 >> 24 & 0xFF);
                        } else {
                            v0 = (dstData[count3 + 2] & 0xFF) << 16 | (dstData[count3 + 1] & 0xFF) << 8 | dstData[count3] & 0xFF;
                            v1 = FloatAdvancer.int24ToInt32(v0);
                            dstData2[count4] = (byte)(v1 & 0xFF);
                            dstData2[count4 + 1] = (byte)(v1 >> 8 & 0xFF);
                            dstData2[count4 + 2] = (byte)(v1 >> 16 & 0xFF);
                            dstData2[count4 + 3] = (byte)(v1 >> 24 & 0xFF);
                        }
                        count3 += 3;
                        count4 += 4;
                    }
                }
                System.arraycopy(dstData2, 0, dstData, 0, dstData2.length);
                this.adjustBitDepths = false;
            } else {
                this.adjustBitDepths = false;
            }
        } else if (predictor == 2) {
            if (bitsPerSample == 8) {
                for (int y = 0; y < this.srcHeight; ++y) {
                    int count = dstOffset + usedSamplesPerPixel * (y * this.srcWidth + 1);
                    for (int x = usedSamplesPerPixel; x < this.srcWidth * usedSamplesPerPixel; ++x) {
                        int n = count;
                        dstData[n] = (byte)(dstData[n] + dstData[count - usedSamplesPerPixel]);
                        ++count;
                    }
                }
            } else if (bitsPerSample == 16) {
                int spp2 = usedSamplesPerPixel * 2;
                for (int j = 0; j < this.srcHeight; ++j) {
                    int count = (dstOffset + usedSamplesPerPixel * (j * this.srcWidth + 1)) * 2;
                    for (int i = usedSamplesPerPixel; i < this.srcWidth * usedSamplesPerPixel; ++i) {
                        int v0 = ((dstData[count - spp2 + 1] & 0xFF) << 8 | dstData[count - spp2] & 0xFF) & 0xFFFF;
                        int v1 = ((dstData[count + 1] & 0xFF) << 8 | dstData[count] & 0xFF) & 0xFFFF;
                        int s = v1 + v0 & 0xFFFF;
                        dstData[count + 1] = (byte)(s >> 8 & 0xFF);
                        dstData[count] = (byte)(s & 0xFF);
                        count += 2;
                    }
                }
            } else if (bitsPerSample == 32) {
                int spp2 = usedSamplesPerPixel * 4;
                for (int j = 0; j < this.srcHeight; ++j) {
                    int count = (dstOffset + usedSamplesPerPixel * (j * this.srcWidth + 1)) * 4;
                    for (int i = usedSamplesPerPixel; i < this.srcWidth * usedSamplesPerPixel; ++i) {
                        int v0 = (dstData[count - spp2 + 3] & 0xFF) << 24 | (dstData[count - spp2 + 2] & 0xFF) << 16 | (dstData[count - spp2 + 1] & 0xFF) << 8 | dstData[count - spp2] & 0xFF;
                        int v1 = (dstData[count + 3] & 0xFF) << 24 | (dstData[count + 2] & 0xFF) << 16 | (dstData[count + 1] & 0xFF) << 8 | dstData[count] & 0xFF;
                        int s = v1 + v0 & 0xFFFFFFFF;
                        dstData[count + 3] = (byte)(s >> 24 & 0xFF);
                        dstData[count + 2] = (byte)(s >> 16 & 0xFF);
                        dstData[count + 1] = (byte)(s >> 8 & 0xFF);
                        dstData[count] = (byte)(s & 0xFF);
                        count += 4;
                    }
                }
            }
        } else if (predictor == 3) {
            int y;
            byte[] dstData2 = new byte[dstData.length];
            this.adjustBitDepths = false;
            int bytes = 0;
            int spread = 4;
            if (bitsPerSample == 8) {
                throw new IIOException("TIFF with 8-bit floating predictor is not supported!");
            }
            if (bitsPerSample == 16) {
                bytes = 2;
            } else if (bitsPerSample == 24) {
                bytes = 3;
            } else if (bitsPerSample == 32) {
                bytes = 4;
            }
            for (y = 0; y < this.srcHeight; ++y) {
                int yOff = this.srcWidth * bytes * y * usedSamplesPerPixel;
                for (int col = 1; col < this.srcWidth * bytes; ++col) {
                    for (int sample = 0; sample < usedSamplesPerPixel; ++sample) {
                        int sPos = col * usedSamplesPerPixel + sample + yOff;
                        int dPos = (col - 1) * usedSamplesPerPixel + sample + yOff;
                        int n = sPos;
                        dstData[n] = (byte)(dstData[n] + dstData[dPos]);
                    }
                }
            }
            for (y = 0; y < this.srcHeight; ++y) {
                int off = y * this.srcWidth * usedSamplesPerPixel * bytes;
                int rowOff = this.srcWidth * usedSamplesPerPixel;
                for (int c = 0; c < rowOff; ++c) {
                    for (int b = 0; b < bytes; ++b) {
                        int p0 = bytes * c + b + off;
                        dstData2[p0] = order == ByteOrder.BIG_ENDIAN ? dstData[b * rowOff + c + off] : dstData[(bytes - b - 1) * rowOff + c + off];
                    }
                }
            }
            if (bytes != 4) {
                for (y = 0; y < this.srcHeight; ++y) {
                    int yOffS = y * this.srcWidth * usedSamplesPerPixel * bytes;
                    int yOffD = y * this.srcWidth * usedSamplesPerPixel * 4;
                    int x = 0;
                    int s = 0;
                    int d = 0;
                    while (x < this.srcWidth * usedSamplesPerPixel) {
                        int fbits;
                        int hbits;
                        int source = s + yOffS;
                        int dest = d + yOffD;
                        if (bytes == 2) {
                            if (order == ByteOrder.LITTLE_ENDIAN) {
                                hbits = (dstData2[source + 1] & 0xFF) << 8 | dstData2[source] & 0xFF;
                                fbits = FloatAdvancer.int16ToInt32(hbits);
                                dstData[dest] = (byte)(fbits & 0xFF);
                                dstData[dest + 1] = (byte)(fbits >> 8 & 0xFF);
                                dstData[dest + 2] = (byte)(fbits >> 16 & 0xFF);
                                dstData[dest + 3] = (byte)(fbits >> 24 & 0xFF);
                            } else {
                                hbits = (dstData2[source] & 0xFF) << 8 | dstData2[source + 1] & 0xFF;
                                fbits = FloatAdvancer.int16ToInt32(hbits);
                                dstData[dest + 3] = (byte)(fbits & 0xFF);
                                dstData[dest + 2] = (byte)(fbits >> 8 & 0xFF);
                                dstData[dest + 1] = (byte)(fbits >> 16 & 0xFF);
                                dstData[dest] = (byte)(fbits >> 24 & 0xFF);
                            }
                        } else if (bytes == 3) {
                            if (order == ByteOrder.LITTLE_ENDIAN) {
                                hbits = (dstData2[source + 2] & 0xFF) << 16 | (dstData2[source + 1] & 0xFF) << 8 | dstData2[source] & 0xFF;
                                fbits = FloatAdvancer.int24ToInt32(hbits);
                                dstData[dest] = (byte)(fbits & 0xFF);
                                dstData[dest + 1] = (byte)(fbits >> 8 & 0xFF);
                                dstData[dest + 2] = (byte)(fbits >> 16 & 0xFF);
                                dstData[dest + 3] = (byte)(fbits >> 24 & 0xFF);
                            } else {
                                hbits = (dstData2[source] & 0xFF) << 16 | (dstData2[source + 1] & 0xFF) << 8 | dstData2[source + 2] & 0xFF;
                                fbits = FloatAdvancer.int24ToInt32(hbits);
                                dstData[dest + 3] = (byte)(fbits & 0xFF);
                                dstData[dest + 2] = (byte)(fbits >> 8 & 0xFF);
                                dstData[dest + 1] = (byte)(fbits >> 16 & 0xFF);
                                dstData[dest] = (byte)(fbits >> 24 & 0xFF);
                            }
                        }
                        ++x;
                        s += bytes;
                        d += 4;
                    }
                }
            } else {
                System.arraycopy(dstData2, 0, dstData, 0, dstData.length);
            }
        }
    }
}

