/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.I18N;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.IIOException;

public class TIFFDeflateDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    Inflater inflater = new Inflater();
    int predictor;

    public TIFFDeflateDecompressor(int predictor) throws IIOException {
        if (predictor != 1 && predictor != 2 && predictor != 3) {
            throw new IIOException("Illegal value (" + predictor + ") for Predictor in " + "TIFF file");
        }
        this.predictor = predictor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        int bufOffset;
        byte[] buf;
        if (this.predictor == 2) {
            int len = this.bitsPerSample.length;
            for (int i = 0; i < len; ++i) {
                if (this.bitsPerSample[i] == 8 || this.bitsPerSample[i] == 16 || this.bitsPerSample[i] == 24 || this.bitsPerSample[i] == 32) continue;
                throw new IIOException(this.bitsPerSample[i] + "-bit samples " + "are not supported for Horizontal " + "differencing Predictor (DEF)");
            }
        }
        this.stream.seek(this.offset);
        byte[] srcData = new byte[this.byteCount];
        this.stream.readFully(srcData);
        int bytesPerRow = (this.srcWidth * bitsPerPixel + 7) / 8;
        if (bytesPerRow == scanlineStride) {
            buf = b;
            bufOffset = dstOffset;
        } else {
            buf = new byte[bytesPerRow * this.srcHeight];
            bufOffset = 0;
        }
        Inflater inflater = this.inflater;
        synchronized (inflater) {
            this.inflater.setInput(srcData);
            try {
                this.inflater.inflate(buf, bufOffset, bytesPerRow * this.srcHeight);
            }
            catch (DataFormatException dfe) {
                throw new IIOException(I18N.getString("TIFFDeflateDecompressor0"), dfe);
            }
            this.inflater.reset();
        }
        this.decodeSpecial(buf, bufOffset, this.bitsPerSample[0], this.predictor);
        if (bytesPerRow != scanlineStride) {
            int off = 0;
            for (int y = 0; y < this.srcHeight; ++y) {
                System.arraycopy(buf, off, b, dstOffset, bytesPerRow);
                off += bytesPerRow;
                dstOffset += scanlineStride;
            }
        }
    }
}

