/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class TIFFFieldNode
extends IIOMetadataNode {
    private final boolean isIFD;
    private volatile boolean isInitialized = false;
    private final TIFFField field;

    private static String getNodeName(TIFFField f) {
        return f.getData() instanceof TIFFDirectory ? "TIFFIFD" : "TIFFField";
    }

    public TIFFFieldNode(TIFFField field) {
        super(TIFFFieldNode.getNodeName(field));
        this.isIFD = field.getData() instanceof TIFFDirectory;
        this.field = field;
        TIFFTag tag = field.getTag();
        int tagNumber = tag.getNumber();
        String tagName = tag.getName();
        if (this.isIFD) {
            TIFFDirectory dir;
            TIFFTagSet[] tagSets;
            if (tagNumber != 0) {
                this.setAttribute("parentTagNumber", Integer.toString(tagNumber));
            }
            if (tagName != null) {
                this.setAttribute("parentTagName", tagName);
            }
            if ((tagSets = (dir = (TIFFDirectory)field.getData()).getTagSets()) != null) {
                StringBuilder tagSetNames = new StringBuilder();
                for (int i = 0; i < tagSets.length; ++i) {
                    tagSetNames.append(tagSets[i].getClass().getName());
                    if (i == tagSets.length - 1) continue;
                    tagSetNames.append(',');
                }
                this.setAttribute("tagSets", tagSetNames.toString());
            }
        } else {
            this.setAttribute("number", Integer.toString(tagNumber));
            this.setAttribute("name", tagName);
        }
    }

    private void initialize() {
        if (this.isInitialized) {
            return;
        }
        if (this.isIFD) {
            TIFFDirectory dir = (TIFFDirectory)this.field.getData();
            TIFFField[] fields = dir.getTIFFFields();
            if (fields != null) {
                for (TIFFField f : fields) {
                    Node node = f.getAsNativeNode();
                    if (node == null) continue;
                    this.appendChild(node);
                }
            }
        } else {
            IIOMetadataNode child;
            int count = this.field.getCount();
            if (this.field.getType() == 7) {
                child = new IIOMetadataNode("TIFFUndefined");
                byte[] data = this.field.getAsBytes();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < count; ++i) {
                    sb.append(Integer.toString(data[i] & 0xFF));
                    if (i >= count - 1) continue;
                    sb.append(",");
                }
                child.setAttribute("value", sb.toString());
            } else {
                child = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.field.getType()) + "s");
                TIFFTag tag = this.field.getTag();
                if (count <= 100000) {
                    for (int i = 0; i < count; ++i) {
                        int value;
                        String name;
                        IIOMetadataNode cchild = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.field.getType()));
                        cchild.setAttribute("value", this.field.getValueAsString(i));
                        if (tag.hasValueNames() && this.field.isIntegral() && (name = tag.getValueName(value = this.field.getAsInt(i))) != null) {
                            cchild.setAttribute("description", name);
                        }
                        child.appendChild(cchild);
                    }
                }
            }
            this.appendChild(child);
        }
        this.isInitialized = true;
    }

    @Override
    public Node appendChild(Node newChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        return super.insertBefore(newChild, null);
    }

    @Override
    public boolean hasChildNodes() {
        this.initialize();
        return super.hasChildNodes();
    }

    @Override
    public int getLength() {
        this.initialize();
        return super.getLength();
    }

    @Override
    public Node getFirstChild() {
        this.initialize();
        return super.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        this.initialize();
        return super.getLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        this.initialize();
        return super.getPreviousSibling();
    }

    @Override
    public Node getNextSibling() {
        this.initialize();
        return super.getNextSibling();
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        this.initialize();
        return super.insertBefore(newChild, refChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) {
        this.initialize();
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node removeChild(Node oldChild) {
        this.initialize();
        return super.removeChild(oldChild);
    }

    @Override
    public Node cloneNode(boolean deep) {
        this.initialize();
        return super.cloneNode(deep);
    }
}

