/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TIFFJPEGCMYKDecompressor
extends TIFFDecompressor {
    protected static final int SOI = 216;
    protected static final int EOI = 217;
    protected boolean hasJPEGTables = false;
    protected byte[] tables = null;
    private byte[] data = new byte[0];

    @Override
    public void beginDecoding() {
        TIFFImageMetadata tmetadata = (TIFFImageMetadata)this.metadata;
        TIFFField f = tmetadata.getTIFFField(347);
        if (f != null) {
            this.hasJPEGTables = true;
            this.tables = f.getAsBytes();
        } else {
            this.hasJPEGTables = false;
        }
    }

    @Override
    public void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        ByteArrayInputStream imageInputStream;
        this.stream.seek(this.offset);
        if (this.hasJPEGTables) {
            int dataLength = this.tables.length + this.byteCount;
            if (this.data.length < dataLength) {
                this.data = new byte[dataLength];
            }
            int dataOffset = this.tables.length;
            for (int i = this.tables.length - 2; i > 0; --i) {
                if ((this.tables[i] & 0xFF) != 255 || (this.tables[i + 1] & 0xFF) != 217) continue;
                dataOffset = i;
                break;
            }
            System.arraycopy(this.tables, 0, this.data, 0, dataOffset);
            byte byte1 = (byte)this.stream.read();
            byte byte2 = (byte)this.stream.read();
            if ((byte1 & 0xFF) != 255 || (byte2 & 0xFF) != 216) {
                this.data[dataOffset++] = byte1;
                this.data[dataOffset++] = byte2;
            }
            this.stream.readFully(this.data, dataOffset, this.byteCount - 2);
            imageInputStream = new ByteArrayInputStream(this.data);
        } else {
            byte[] data2 = new byte[this.byteCount];
            this.stream.read(data2);
            imageInputStream = new ByteArrayInputStream(data2);
            data2 = null;
        }
        JPEGImageDecoder dec = JPEGCodec.createJPEGDecoder((InputStream)imageInputStream);
        Raster r = dec.decodeAsRaster();
        JPEGDecodeParam dp = dec.getJPEGDecodeParam();
        DataBuffer db = r.getDataBuffer();
        ColorSpace cs = ColorSpace.getInstance(1004);
        ComponentColorModel cm = new ComponentColorModel(cs, true, true, 1, db.getDataType());
        if (dp.getEncodedColorID() == 9) {
            int dblen = db.getSize();
            for (int p = 0; p < dblen; p += 4) {
                db.setElem(0, p, 255 - db.getElem(0, p));
                db.setElem(0, p + 1, 255 - db.getElem(0, p + 1));
                db.setElem(0, p + 2, 255 - db.getElem(0, p + 2));
            }
        }
        this.rawImage = new BufferedImage(cm, (WritableRaster)r, true, null);
        ((InputStream)imageInputStream).close();
        dec = null;
        r = null;
        db = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

