/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.imageioimpl;

import com.sun.media.jai.imageioimpl.I18N;
import com.sun.media.jai.imageioimpl.PixelReplacementImage;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.CRIFImpl;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.WritablePropertySource;

public final class ImageWriteCRIF
extends CRIFImpl {
    public static void main(String[] args) throws Throwable {
        File inFile = new File(args[0]);
        File outFile = new File(args[1]);
        String format = args.length > 2 ? args[2] : "png";
        String mode = args.length > 3 ? args[3] : "rendered";
        int imageIndex = 0;
        ImageInputStream inStream = ImageIO.createImageInputStream(inFile);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(inStream);
        ImageReader reader = iter.next();
        reader.setInput(inStream);
        BufferedImage image = reader.read(imageIndex);
        IIOMetadata streamMetadata = reader.getStreamMetadata();
        IIOMetadata imageMetadata = reader.getImageMetadata(imageIndex);
        BufferedImage[] thumbnails = null;
        if (reader.hasThumbnails(imageIndex)) {
            int numThumbnails = reader.getNumThumbnails(imageIndex);
            thumbnails = new BufferedImage[numThumbnails];
            for (int i = 0; i < numThumbnails; ++i) {
                thumbnails[i] = reader.readThumbnail(imageIndex, i);
            }
        }
        ImageWriteCRIF crif = new ImageWriteCRIF();
        ParameterBlock pb = new ParameterBlock();
        if (mode.equalsIgnoreCase("rendered")) {
            pb.addSource(image);
        } else if (mode.equalsIgnoreCase("renderable")) {
            ParameterBlock renderablePB = new ParameterBlock();
            renderablePB.addSource(image);
            RenderableOp renderable = JAI.createRenderable((String)"renderable", (ParameterBlock)renderablePB);
            pb.addSource(renderable);
        }
        pb.add(outFile);
        pb.add(format);
        pb.add(Boolean.TRUE);
        pb.add(Boolean.TRUE);
        pb.add(Boolean.TRUE);
        pb.add(Boolean.TRUE);
        pb.add(null);
        pb.add(streamMetadata);
        pb.add(imageMetadata);
        pb.add(thumbnails);
        pb.add(null);
        pb.add(null);
        pb.add(null);
        pb.add(null);
        if (mode.equalsIgnoreCase("rendered")) {
            crif.create(pb, null);
        } else if (mode.equalsIgnoreCase("renderable")) {
            AffineTransform transform = new AffineTransform(256.0f, 0.0f, 0.0f, 512.0f, 0.0f, 0.0f);
            crif.create(new RenderContext(transform), pb);
        }
    }

    static ImageOutputStream getImageOutputStream(Object output) {
        ImageOutputStream stream = null;
        if (output instanceof ImageOutputStream) {
            stream = (ImageOutputStream)output;
        } else {
            if (output instanceof String) {
                try {
                    output = new RandomAccessFile((String)output, "rw");
                }
                catch (Exception e) {
                    throw new RuntimeException(I18N.getString("ImageWriteCRIF0") + " " + output);
                }
            }
            if (output instanceof Socket) {
                try {
                    output = ((Socket)output).getOutputStream();
                }
                catch (Exception e) {
                    throw new RuntimeException(I18N.getString("ImageWriteCRIF1") + " " + output);
                }
            }
            try {
                stream = ImageIO.createImageOutputStream(output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return stream;
    }

    public RenderedImage create(ParameterBlock pb, RenderingHints rh) {
        return ImageWriteCRIF.create(0, false, pb, rh);
    }

    private static ImageWriteParam getWriteParam(ImageWriteParam param, ImageWriter writer) {
        ImageWriteParam newParam = param;
        if (param == null) {
            newParam = writer.getDefaultWriteParam();
        } else if (param.getClass().getName().equals("javax.imageio.ImageWriteParam")) {
            newParam = writer.getDefaultWriteParam();
            if (param.hasController()) {
                newParam.setController(param.getController());
            }
            newParam.setDestinationOffset(param.getDestinationOffset());
            newParam.setDestinationType(param.getDestinationType());
            newParam.setSourceBands(param.getSourceBands());
            newParam.setSourceRegion(param.getSourceRegion());
            newParam.setSourceSubsampling(param.getSourceXSubsampling(), param.getSourceYSubsampling(), param.getSubsamplingXOffset(), param.getSubsamplingYOffset());
            if (param.canWriteCompressed()) {
                int compressionMode = param.getCompressionMode();
                newParam.setCompressionMode(compressionMode);
                if (compressionMode == 2) {
                    newParam.setCompressionQuality(param.getCompressionQuality());
                    newParam.setCompressionType(param.getCompressionType());
                }
            }
            if (param.canWriteProgressive()) {
                newParam.setProgressiveMode(param.getProgressiveMode());
            }
            if (param.canWriteTiles()) {
                int tilingMode = param.getTilingMode();
                newParam.setTilingMode(tilingMode);
                if (tilingMode == 2) {
                    newParam.setTiling(param.getTileWidth(), param.getTileHeight(), param.getTileGridXOffset(), param.getTileGridYOffset());
                }
            }
        }
        return newParam;
    }

    private static ImageWriteParam setTileSize(ImageWriteParam param, ImageWriter writer, Dimension tileSize, RenderedImage source) {
        ImageWriteParam returnParam = ImageWriteCRIF.getWriteParam(param, writer);
        if (returnParam.canWriteTiles()) {
            if (tileSize != null) {
                if (tileSize.width <= 0 || tileSize.height <= 0) {
                    throw new IllegalArgumentException("tileSize.width <= 0 || tileSize.height <= 0");
                }
                returnParam.setTilingMode(2);
                returnParam.setTiling(tileSize.width, tileSize.height, 0, 0);
            } else if (param == null) {
                if (source.getNumXTiles() > 1 || source.getNumYTiles() > 1) {
                    returnParam.setTilingMode(2);
                    returnParam.setTiling(source.getTileWidth(), source.getTileHeight(), 0, 0);
                }
            } else if (returnParam.getTilingMode() == 2) {
                boolean setTileSize = false;
                Dimension[] preferredTileSizes = returnParam.getPreferredTileSizes();
                int tileWidth = 0;
                try {
                    tileWidth = returnParam.getTileWidth();
                }
                catch (IllegalStateException e) {
                    setTileSize = true;
                    tileWidth = preferredTileSizes != null && preferredTileSizes.length >= 2 && preferredTileSizes[0].width > 0 && preferredTileSizes[1].width > 0 ? (preferredTileSizes[0].width + preferredTileSizes[1].width) / 2 : source.getTileWidth();
                }
                int tileHeight = 0;
                try {
                    tileHeight = returnParam.getTileHeight();
                }
                catch (IllegalStateException e) {
                    setTileSize = true;
                    tileHeight = preferredTileSizes != null && preferredTileSizes.length >= 2 && preferredTileSizes[0].height > 0 && preferredTileSizes[1].height > 0 ? (preferredTileSizes[0].height + preferredTileSizes[1].height) / 2 : source.getTileHeight();
                }
                if (setTileSize) {
                    returnParam.setTiling(tileWidth, tileHeight, 0, 0);
                }
            }
        }
        return returnParam;
    }

    static RenderedImage create(int imageIndex, boolean writeToSequence, ParameterBlock pb, RenderingHints rh) {
        String format;
        Iterator<ImageWriter> writers;
        ImageWriter writer;
        Object image = null;
        RenderedImage source = pb.getRenderedSource(0);
        ImageWriteParam param = (ImageWriteParam)pb.getObjectParameter(12);
        ImageTypeSpecifier destinationType = null;
        if (param != null) {
            destinationType = param.getDestinationType();
        }
        if (destinationType == null) {
            destinationType = new ImageTypeSpecifier(source);
        }
        if ((writer = (ImageWriter)pb.getObjectParameter(13)) == null && (writers = ImageIO.getImageWriters(destinationType, format = (String)pb.getObjectParameter(1))) != null && writers.hasNext()) {
            writer = writers.next();
        }
        if (writer != null) {
            EventListener[] listeners;
            Locale locale;
            Object thumbnailsProperty;
            Object imageMetadataProperty;
            IIOMetadata imageMetadata;
            ImageOutputStream streamToClose = null;
            if (!writeToSequence) {
                Object output = pb.getObjectParameter(0);
                ImageOutputStream stream = ImageWriteCRIF.getImageOutputStream(output);
                streamToClose = stream != output ? stream : null;
                writer.setOutput(stream != null ? stream : output);
            }
            boolean useProperties = (Boolean)pb.getObjectParameter(2);
            boolean transcode = (Boolean)pb.getObjectParameter(3);
            IIOMetadata streamMetadata = null;
            if (!writeToSequence) {
                Object streamMetadataProperty;
                streamMetadata = (IIOMetadata)pb.getObjectParameter(7);
                if (streamMetadata == null && useProperties && (streamMetadataProperty = source.getProperty("JAI.StreamMetadata")) instanceof IIOMetadata) {
                    streamMetadata = (IIOMetadata)streamMetadataProperty;
                }
                if (streamMetadata != null && transcode) {
                    streamMetadata = writer.convertStreamMetadata(streamMetadata, param);
                }
            }
            if ((imageMetadata = (IIOMetadata)pb.getObjectParameter(8)) == null && useProperties && (imageMetadataProperty = source.getProperty("JAI.ImageMetadata")) instanceof IIOMetadata) {
                imageMetadata = (IIOMetadata)imageMetadataProperty;
            }
            if (imageMetadata != null && transcode) {
                imageMetadata = writer.convertImageMetadata(imageMetadata, destinationType, param);
            }
            BufferedImage[] thumbnails = null;
            if (writer.getNumThumbnailsSupported(destinationType, param, streamMetadata, imageMetadata) > 0 && (thumbnails = (BufferedImage[])pb.getObjectParameter(9)) == null && useProperties && (thumbnailsProperty = source.getProperty("JAI.ImageMetadata")) instanceof BufferedImage[]) {
                thumbnails = (BufferedImage[])thumbnailsProperty;
            }
            if ((locale = (Locale)pb.getObjectParameter(11)) != null) {
                writer.setLocale(locale);
            }
            if ((listeners = (EventListener[])pb.getObjectParameter(10)) != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    EventListener listener = listeners[i];
                    if (listener instanceof IIOWriteProgressListener) {
                        writer.addIIOWriteProgressListener((IIOWriteProgressListener)listener);
                    }
                    if (!(listener instanceof IIOWriteWarningListener)) continue;
                    writer.addIIOWriteWarningListener((IIOWriteWarningListener)listener);
                }
            }
            param = ImageWriteCRIF.setTileSize(param, writer, (Dimension)pb.getObjectParameter(6), source);
            IIOImage iioImage = new IIOImage(source, thumbnails != null ? Arrays.asList(thumbnails) : null, imageMetadata);
            try {
                if (writeToSequence) {
                    writer.writeToSequence(iioImage, param);
                } else {
                    writer.write(streamMetadata, iioImage, param);
                }
                boolean allowPixelReplacement = (Boolean)pb.getObjectParameter(5);
                if (allowPixelReplacement && source instanceof PlanarImage && writer.canReplacePixels(imageIndex)) {
                    image = new PixelReplacementImage(source, rh, param, writer, imageIndex, streamToClose);
                    ((PlanarImage)source).addSink(image);
                } else if (!writeToSequence) {
                    Object writerOutput = writer.getOutput();
                    if (writerOutput != pb.getObjectParameter(0) && writerOutput instanceof ImageOutputStream) {
                        ((ImageOutputStream)writerOutput).flush();
                    }
                    image = source instanceof WritablePropertySource ? source : new RenderedImageAdapter(source);
                }
                WritablePropertySource wps = (WritablePropertySource)image;
                if (wps != null) {
                    wps.setProperty("JAI.ImageWriteParam", (Object)param);
                    wps.setProperty("JAI.ImageWriter", (Object)writer);
                    if (streamMetadata != null) {
                        wps.setProperty("JAI.StreamMetadata", (Object)streamMetadata);
                    }
                    if (imageMetadata != null) {
                        wps.setProperty("JAI.ImageMetadata", (Object)imageMetadata);
                    }
                    if (thumbnails != null) {
                        wps.setProperty("JAI.Thumbnails", (Object)thumbnails);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return image;
    }
}

