/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.operator;

import com.sun.media.jai.operator.I18N;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.EventListener;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.CollectionOp;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class ImageWriteDescriptor
extends OperationDescriptorImpl {
    public static final String PROPERTY_NAME_IMAGE_WRITE_PARAM = "JAI.ImageWriteParam";
    public static final String PROPERTY_NAME_IMAGE_WRITER = "JAI.ImageWriter";
    public static final String PROPERTY_NAME_METADATA_IMAGE = "JAI.ImageMetadata";
    public static final String PROPERTY_NAME_METADATA_STREAM = "JAI.StreamMetadata";
    public static final String PROPERTY_NAME_THUMBNAILS = "JAI.Thumbnails";
    private static final String OPERATION_NAME = "ImageWrite";
    private static final String[][] resources = new String[][]{{"GlobalName", "ImageWrite"}, {"LocalName", "ImageWrite"}, {"Vendor", "com.sun.media.jai"}, {"Description", I18N.getString("ImageWriteDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ImageWriteDescriptor.html"}, {"Version", I18N.getString("DescriptorVersion")}, {"arg0Desc", I18N.getString("ImageWriteDescriptor1")}, {"arg1Desc", I18N.getString("ImageWriteDescriptor2")}, {"arg2Desc", I18N.getString("ImageWriteDescriptor3")}, {"arg3Desc", I18N.getString("ImageWriteDescriptor4")}, {"arg4Desc", I18N.getString("ImageWriteDescriptor5")}, {"arg5Desc", I18N.getString("ImageWriteDescriptor6")}, {"arg6Desc", I18N.getString("ImageWriteDescriptor7")}, {"arg7Desc", I18N.getString("ImageWriteDescriptor8")}, {"arg8Desc", I18N.getString("ImageWriteDescriptor9")}, {"arg9Desc", I18N.getString("ImageWriteDescriptor10")}, {"arg10Desc", I18N.getString("ImageWriteDescriptor11")}, {"arg11Desc", I18N.getString("ImageWriteDescriptor12")}, {"arg12Desc", I18N.getString("ImageWriteDescriptor13")}, {"arg13Desc", I18N.getString("ImageWriteDescriptor14")}};
    private static final String[] paramNames = new String[]{"Output", "Format", "UseProperties", "Transcode", "VerifyOutput", "AllowPixelReplacement", "TileSize", "StreamMetadata", "ImageMetadata", "Thumbnails", "Listeners", "Locale", "WriteParam", "Writer"};
    private static final Class[] renderedParamClasses = new Class[]{Object.class, String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Dimension.class, IIOMetadata.class, IIOMetadata.class, BufferedImage[].class, EventListener[].class, Locale.class, ImageWriteParam.class, ImageWriter.class};
    private static final Object[] renderedParamDefaults = new Object[]{NO_PARAMETER_DEFAULT, null, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, null, null, null, null, null, null, null, null};
    private static final Class[] renderableParamClasses = renderedParamClasses;
    private static final Object[] renderableParamDefaults = renderedParamDefaults;
    private static final Class[] collectionParamClasses = new Class[]{Object.class, String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Dimension.class, IIOMetadata.class, IIOMetadata[].class, BufferedImage[][].class, EventListener[].class, Locale.class, ImageWriteParam.class, ImageWriter.class};
    private static final Object[] collectionParamDefaults = renderedParamDefaults;

    public ImageWriteDescriptor() {
        super(resources, new String[]{"rendered", "renderable", "collection"}, null, (Class[][])new Class[][]{{RenderedImage.class}, {RenderableImage.class}, {Collection.class}}, paramNames, (Class[][])new Class[][]{renderedParamClasses, renderableParamClasses, collectionParamClasses}, (Object[][])new Object[][]{renderedParamDefaults, renderableParamDefaults, collectionParamDefaults}, (Object[][])new Object[][]{null, null, null});
    }

    public static RenderedOp create(RenderedImage source, ImageOutputStream output, String format, Boolean useProperties, Boolean transcode, Boolean verifyOutput, Boolean allowPixelReplacement, Dimension tileSize, IIOMetadata streamMetadata, IIOMetadata imageMetadata, BufferedImage[] thumbnails, EventListener[] listeners, Locale locale, ImageWriteParam writeParam, ImageWriter writer, RenderingHints hints) {
        ParameterBlock args = new ParameterBlock();
        args.addSource(source);
        args.add(output);
        args.add(format);
        args.add(useProperties);
        args.add(transcode);
        args.add(verifyOutput);
        args.add(allowPixelReplacement);
        args.add(tileSize);
        args.add(streamMetadata);
        args.add(imageMetadata);
        args.add(thumbnails);
        args.add(listeners);
        args.add(locale);
        args.add(writeParam);
        args.add(writer);
        return JAI.create((String)OPERATION_NAME, (ParameterBlock)args, (RenderingHints)hints);
    }

    public static Collection createCollection(Collection source, ImageOutputStream output, String format, Boolean useProperties, Boolean transcode, Boolean verifyOutput, Boolean allowPixelReplacement, Dimension tileSize, IIOMetadata streamMetadata, IIOMetadata[] imageMetadata, BufferedImage[][] thumbnails, EventListener[] listeners, Locale locale, ImageWriteParam writeParam, ImageWriter writer, RenderingHints hints) {
        ParameterBlock args = new ParameterBlock();
        args.addSource(source);
        args.add(output);
        args.add(format);
        args.add(useProperties);
        args.add(transcode);
        args.add(verifyOutput);
        args.add(allowPixelReplacement);
        args.add(tileSize);
        args.add(streamMetadata);
        args.add(imageMetadata);
        args.add(thumbnails);
        args.add(listeners);
        args.add(locale);
        args.add(writeParam);
        args.add(writer);
        return JAI.createCollection((String)OPERATION_NAME, (ParameterBlock)args, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source, ImageOutputStream output, String format, Boolean useProperties, Boolean transcode, Boolean verifyOutput, Boolean allowPixelReplacement, Dimension tileSize, IIOMetadata streamMetadata, IIOMetadata imageMetadata, BufferedImage[] thumbnails, EventListener[] listeners, Locale locale, ImageWriteParam writeParam, ImageWriter writer, RenderingHints hints) {
        ParameterBlock args = new ParameterBlock();
        args.addSource(source);
        args.add(output);
        args.add(format);
        args.add(useProperties);
        args.add(transcode);
        args.add(verifyOutput);
        args.add(allowPixelReplacement);
        args.add(tileSize);
        args.add(streamMetadata);
        args.add(imageMetadata);
        args.add(thumbnails);
        args.add(listeners);
        args.add(locale);
        args.add(writeParam);
        args.add(writer);
        return JAI.createRenderable((String)OPERATION_NAME, (ParameterBlock)args, (RenderingHints)hints);
    }

    public boolean isImmediate() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean validateParameters(String modeName, ParameterBlock args, StringBuffer msg) {
        if (!super.validateParameters(modeName, args, msg)) {
            return false;
        }
        output = args.getObjectParameter(0);
        verifyOutput = (Boolean)args.getObjectParameter(4);
        if (verifyOutput.booleanValue()) {
            if (output instanceof File || output instanceof String) {
                file = null;
                path = null;
                if (output instanceof File) {
                    file = (File)output;
                    path = file.getPath();
                } else if (output instanceof String) {
                    path = (String)output;
                    file = new File(path);
                }
                try {
                    if (file.exists()) {
                        if (file.canWrite()) ** GOTO lbl55
                        msg.append(file.getPath() + " " + I18N.getString("ImageWriteDescriptor15"));
                        return false;
                    }
                    if (!file.createNewFile()) {
                        msg.append(file.getPath() + " " + I18N.getString("ImageWriteDescriptor16"));
                        return false;
                    }
                    file.delete();
                }
                catch (IOException ioe) {
                    msg.append(file.getPath() + " " + I18N.getString("ImageWriteDescriptor17") + " " + ioe.getMessage());
                    return false;
                }
                catch (SecurityException se) {
                    msg.append(file.getPath() + " " + I18N.getString("ImageWriteDescriptor18") + " " + se.getMessage());
                    return false;
                }
            } else if (output instanceof Socket) {
                socket = (Socket)output;
                if (socket.isOutputShutdown()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageWriteDescriptor19"));
                    return false;
                }
                if (socket.isClosed()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageWriteDescriptor20"));
                    return false;
                }
                if (!socket.isBound()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageWriteDescriptor21"));
                    return false;
                }
                if (!socket.isConnected()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageWriteDescriptor22"));
                    return false;
                }
            }
        }
lbl55:
        // 8 sources

        format = (String)args.getObjectParameter(1);
        writer = (ImageWriter)args.getObjectParameter(13);
        if (format == null) {
            if (writer != null && (spi = writer.getOriginatingProvider()) != null) {
                format = spi.getFormatNames()[0];
            }
            if (format == null && (output instanceof File || output instanceof String) && (writers = ImageIO.getImageWritersBySuffix(suffix = (name = output instanceof File != false ? ((File)output).getName() : (String)output).substring(name.lastIndexOf(".") + 1))) != null && (writer = writers.next()) != null && (spi = writer.getOriginatingProvider()) != null) {
                format = spi.getFormatNames()[0];
            }
            if (format == null) {
                format = "PNG";
            }
            if (format != null) {
                args.set(format, 1);
            }
        }
        if ((tileSize = (Dimension)args.getObjectParameter(6)) != null && (tileSize.width <= 0 || tileSize.height <= 0)) {
            msg.append(I18N.getString("ImageWriteDescriptor23"));
            return false;
        }
        if (modeName.equalsIgnoreCase("collection") && !((source = (Collection)args.getSource(0)) instanceof CollectionOp)) {
            numRenderedImages = 0;
            iter = source.iterator();
            while (iter.hasNext()) {
                if (!(iter.next() instanceof RenderedImage)) continue;
                ++numRenderedImages;
            }
            if (numRenderedImages == 0) {
                msg.append(I18N.getString("ImageWriteDescriptor24"));
                return false;
            }
            if (numRenderedImages > 1) {
                writer = (ImageWriter)args.getObjectParameter(13);
                if (writer == null && format != null && (writers = ImageIO.getImageWritersByFormatName(format)) != null) {
                    writer = writers.next();
                }
                if (writer != null && !writer.canWriteSequence()) {
                    msg.append(I18N.getString("ImageWriteDescriptor25"));
                    return false;
                }
            }
        }
        return true;
    }
}

