/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.nio.ByteOrder;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJLoader;
import org.libjpegturbo.turbojpeg.TJScalingFactor;
import org.libjpegturbo.turbojpeg.YUVImage;

public class TJDecompressor
implements Closeable {
    private static final String NO_ASSOC_ERROR = "No JPEG image is associated with this instance";
    protected long handle = 0L;
    protected byte[] jpegBuf = null;
    protected int jpegBufSize = 0;
    protected YUVImage yuvImage = null;
    protected int jpegWidth = 0;
    protected int jpegHeight = 0;
    protected int jpegSubsamp = -1;
    protected int jpegColorspace = -1;
    private ByteOrder byteOrder = null;

    public TJDecompressor() throws TJException {
        this.init();
    }

    public TJDecompressor(byte[] byArray) throws TJException {
        this.init();
        this.setSourceImage(byArray, byArray.length);
    }

    public TJDecompressor(byte[] byArray, int n) throws TJException {
        this.init();
        this.setSourceImage(byArray, n);
    }

    public TJDecompressor(YUVImage yUVImage) throws TJException {
        this.init();
        this.setSourceImage(yUVImage);
    }

    public void setSourceImage(byte[] byArray, int n) throws TJException {
        if (byArray == null || n < 1) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.jpegBuf = byArray;
        this.jpegBufSize = n;
        this.decompressHeader(this.jpegBuf, this.jpegBufSize);
        this.yuvImage = null;
    }

    @Deprecated
    public void setJPEGImage(byte[] byArray, int n) throws TJException {
        this.setSourceImage(byArray, n);
    }

    public void setSourceImage(YUVImage yUVImage) {
        if (yUVImage == null) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.yuvImage = yUVImage;
        this.jpegBuf = null;
        this.jpegBufSize = 0;
    }

    public int getWidth() {
        if (this.yuvImage != null) {
            return this.yuvImage.getWidth();
        }
        if (this.jpegWidth < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.jpegWidth;
    }

    public int getHeight() {
        if (this.yuvImage != null) {
            return this.yuvImage.getHeight();
        }
        if (this.jpegHeight < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.jpegHeight;
    }

    public int getSubsamp() {
        if (this.yuvImage != null) {
            return this.yuvImage.getSubsamp();
        }
        if (this.jpegSubsamp < 0) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.jpegSubsamp >= 6) {
            throw new IllegalStateException("JPEG header information is invalid");
        }
        return this.jpegSubsamp;
    }

    public int getColorspace() {
        if (this.yuvImage != null) {
            return 1;
        }
        if (this.jpegColorspace < 0) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.jpegColorspace >= 5) {
            throw new IllegalStateException("JPEG header information is invalid");
        }
        return this.jpegColorspace;
    }

    public byte[] getJPEGBuf() {
        if (this.jpegBuf == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.jpegBuf;
    }

    public int getJPEGSize() {
        if (this.jpegBufSize < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.jpegBufSize;
    }

    public int getScaledWidth(int n, int n2) {
        if (this.jpegWidth < 1 || this.jpegHeight < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Invalid argument in getScaledWidth()");
        }
        TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
        if (n == 0) {
            n = this.jpegWidth;
        }
        if (n2 == 0) {
            n2 = this.jpegHeight;
        }
        int n3 = this.jpegWidth;
        int n4 = this.jpegHeight;
        for (int i = 0; i < tJScalingFactorArray.length; ++i) {
            n3 = tJScalingFactorArray[i].getScaled(this.jpegWidth);
            n4 = tJScalingFactorArray[i].getScaled(this.jpegHeight);
            if (n3 <= n && n4 <= n2) break;
        }
        if (n3 > n || n4 > n2) {
            throw new IllegalArgumentException("Could not scale down to desired image dimensions");
        }
        return n3;
    }

    public int getScaledHeight(int n, int n2) {
        if (this.jpegWidth < 1 || this.jpegHeight < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Invalid argument in getScaledHeight()");
        }
        TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
        if (n == 0) {
            n = this.jpegWidth;
        }
        if (n2 == 0) {
            n2 = this.jpegHeight;
        }
        int n3 = this.jpegWidth;
        int n4 = this.jpegHeight;
        for (int i = 0; i < tJScalingFactorArray.length; ++i) {
            n3 = tJScalingFactorArray[i].getScaled(this.jpegWidth);
            n4 = tJScalingFactorArray[i].getScaled(this.jpegHeight);
            if (n3 <= n && n4 <= n2) break;
        }
        if (n3 > n || n4 > n2) {
            throw new IllegalArgumentException("Could not scale down to desired image dimensions");
        }
        return n4;
    }

    public void decompress(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) throws TJException {
        if (this.jpegBuf == null && this.yuvImage == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (byArray == null || n < 0 || n2 < 0 || n4 < 0 || this.yuvImage != null && (n3 < 0 || n5 < 0) || n6 < 0 || n6 >= 12 || n7 < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        if (this.yuvImage != null) {
            this.decodeYUV(this.yuvImage.getPlanes(), this.yuvImage.getOffsets(), this.yuvImage.getStrides(), this.yuvImage.getSubsamp(), byArray, n, n2, this.yuvImage.getWidth(), n4, this.yuvImage.getHeight(), n6, n7);
        } else if (n > 0 || n2 > 0) {
            this.decompress(this.jpegBuf, this.jpegBufSize, byArray, n, n2, n3, n4, n5, n6, n7);
        } else {
            this.decompress(this.jpegBuf, this.jpegBufSize, byArray, n3, n4, n5, n6, n7);
        }
    }

    @Deprecated
    public void decompress(byte[] byArray, int n, int n2, int n3, int n4, int n5) throws TJException {
        this.decompress(byArray, 0, 0, n, n2, n3, n4, n5);
    }

    public byte[] decompress(int n, int n2, int n3, int n4, int n5) throws TJException {
        if (n2 < 0 || this.yuvImage == null && (n < 0 || n3 < 0) || n4 < 0 || n4 >= 12 || n5 < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        int n6 = TJ.getPixelSize(n4);
        int n7 = this.getScaledWidth(n, n3);
        int n8 = this.getScaledHeight(n, n3);
        if (n2 == 0) {
            n2 = n7 * n6;
        }
        byte[] byArray = new byte[n2 * n8];
        this.decompress(byArray, n, n2, n3, n4, n5);
        return byArray;
    }

    public void decompressToYUV(YUVImage yUVImage, int n) throws TJException {
        if (this.jpegBuf == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (yUVImage == null || n < 0) {
            throw new IllegalArgumentException("Invalid argument in decompressToYUV()");
        }
        int n2 = this.getScaledWidth(yUVImage.getWidth(), yUVImage.getHeight());
        int n3 = this.getScaledHeight(yUVImage.getWidth(), yUVImage.getHeight());
        if (n2 != yUVImage.getWidth() || n3 != yUVImage.getHeight()) {
            throw new IllegalArgumentException("YUVImage dimensions do not match one of the scaled image sizes that TurboJPEG is capable of generating.");
        }
        if (this.jpegSubsamp != yUVImage.getSubsamp()) {
            throw new IllegalArgumentException("YUVImage subsampling level does not match that of the JPEG image");
        }
        this.decompressToYUV(this.jpegBuf, this.jpegBufSize, yUVImage.getPlanes(), yUVImage.getOffsets(), yUVImage.getWidth(), yUVImage.getStrides(), yUVImage.getHeight(), n);
    }

    @Deprecated
    public void decompressToYUV(byte[] byArray, int n) throws TJException {
        YUVImage yUVImage = new YUVImage(byArray, this.jpegWidth, 4, this.jpegHeight, this.jpegSubsamp);
        this.decompressToYUV(yUVImage, n);
    }

    public YUVImage decompressToYUV(int n, int[] nArray, int n2, int n3) throws TJException {
        if (n3 < 0) {
            throw new IllegalArgumentException("Invalid argument in decompressToYUV()");
        }
        if (this.jpegWidth < 1 || this.jpegHeight < 1 || this.jpegSubsamp < 0) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.jpegSubsamp >= 6) {
            throw new IllegalStateException("JPEG header information is invalid");
        }
        if (this.yuvImage != null) {
            throw new IllegalStateException("Source image is the wrong type");
        }
        int n4 = this.getScaledWidth(n, n2);
        int n5 = this.getScaledHeight(n, n2);
        YUVImage yUVImage = new YUVImage(n4, null, n5, this.jpegSubsamp);
        this.decompressToYUV(yUVImage, n3);
        return yUVImage;
    }

    public YUVImage decompressToYUV(int n, int n2, int n3, int n4) throws TJException {
        if (n4 < 0) {
            throw new IllegalArgumentException("Invalid argument in decompressToYUV()");
        }
        if (this.jpegWidth < 1 || this.jpegHeight < 1 || this.jpegSubsamp < 0) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.jpegSubsamp >= 6) {
            throw new IllegalStateException("JPEG header information is invalid");
        }
        if (this.yuvImage != null) {
            throw new IllegalStateException("Source image is the wrong type");
        }
        int n5 = this.getScaledWidth(n, n3);
        int n6 = this.getScaledHeight(n, n3);
        YUVImage yUVImage = new YUVImage(n5, n2, n6, this.jpegSubsamp);
        this.decompressToYUV(yUVImage, n4);
        return yUVImage;
    }

    @Deprecated
    public byte[] decompressToYUV(int n) throws TJException {
        YUVImage yUVImage = new YUVImage(this.jpegWidth, 4, this.jpegHeight, this.jpegSubsamp);
        this.decompressToYUV(yUVImage, n);
        return yUVImage.getBuf();
    }

    public void decompress(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) throws TJException {
        if (this.jpegBuf == null && this.yuvImage == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (nArray == null || n < 0 || n2 < 0 || n4 < 0 || this.yuvImage != null && (n3 < 0 || n5 < 0) || n6 < 0 || n6 >= 12 || n7 < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        if (this.yuvImage != null) {
            this.decodeYUV(this.yuvImage.getPlanes(), this.yuvImage.getOffsets(), this.yuvImage.getStrides(), this.yuvImage.getSubsamp(), nArray, n, n2, this.yuvImage.getWidth(), n4, this.yuvImage.getHeight(), n6, n7);
        } else {
            this.decompress(this.jpegBuf, this.jpegBufSize, nArray, n, n2, n3, n4, n5, n6, n7);
        }
    }

    public void decompress(BufferedImage bufferedImage, int n) throws TJException {
        int n2;
        int n3;
        int n4;
        if (bufferedImage == null || n < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        if (this.yuvImage != null) {
            if (n5 != this.yuvImage.getWidth() || n6 != this.yuvImage.getHeight()) {
                throw new IllegalArgumentException("BufferedImage dimensions do not match the dimensions of the source image.");
            }
            n4 = this.yuvImage.getWidth();
            n3 = this.yuvImage.getHeight();
        } else {
            n4 = this.getScaledWidth(n5, n6);
            n3 = this.getScaledHeight(n5, n6);
            if (n4 != n5 || n3 != n6) {
                throw new IllegalArgumentException("BufferedImage dimensions do not match one of the scaled image sizes that TurboJPEG is capable of generating.");
            }
        }
        boolean bl = false;
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.nativeOrder();
        }
        switch (bufferedImage.getType()) {
            case 5: {
                n2 = 1;
                break;
            }
            case 6: 
            case 7: {
                n2 = 4;
                break;
            }
            case 10: {
                n2 = 6;
                break;
            }
            case 4: {
                n2 = this.byteOrder == ByteOrder.BIG_ENDIAN ? 4 : 2;
                bl = true;
                break;
            }
            case 1: {
                n2 = this.byteOrder == ByteOrder.BIG_ENDIAN ? 5 : 3;
                bl = true;
                break;
            }
            case 2: 
            case 3: {
                n2 = this.byteOrder == ByteOrder.BIG_ENDIAN ? 10 : 8;
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported BufferedImage format");
            }
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (bl) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            int n7 = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            if (this.yuvImage != null) {
                this.decodeYUV(this.yuvImage.getPlanes(), this.yuvImage.getOffsets(), this.yuvImage.getStrides(), this.yuvImage.getSubsamp(), nArray, 0, 0, this.yuvImage.getWidth(), n7, this.yuvImage.getHeight(), n2, n);
            } else {
                if (this.jpegBuf == null) {
                    throw new IllegalStateException(NO_ASSOC_ERROR);
                }
                this.decompress(this.jpegBuf, this.jpegBufSize, nArray, 0, 0, n4, n7, n3, n2, n);
            }
        } else {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)bufferedImage.getSampleModel();
            int n8 = componentSampleModel.getPixelStride();
            if (n8 != TJ.getPixelSize(n2)) {
                throw new IllegalArgumentException("Inconsistency between pixel format and pixel size in BufferedImage");
            }
            int n9 = componentSampleModel.getScanlineStride();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            this.decompress(byArray, 0, 0, n4, n9, n3, n2, n);
        }
    }

    public BufferedImage decompress(int n, int n2, int n3, int n4) throws TJException {
        if (this.yuvImage == null && (n < 0 || n2 < 0) || n4 < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        int n5 = this.getScaledWidth(n, n2);
        int n6 = this.getScaledHeight(n, n2);
        BufferedImage bufferedImage = new BufferedImage(n5, n6, n3);
        this.decompress(bufferedImage, n4);
        return bufferedImage;
    }

    public void close() throws TJException {
        if (this.handle != 0L) {
            this.destroy();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (TJException tJException) {
        }
        finally {
            super.finalize();
        }
    }

    private native void init() throws TJException;

    private native void destroy() throws TJException;

    private native void decompressHeader(byte[] var1, int var2) throws TJException;

    @Deprecated
    private native void decompress(byte[] var1, int var2, byte[] var3, int var4, int var5, int var6, int var7, int var8) throws TJException;

    private native void decompress(byte[] var1, int var2, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10) throws TJException;

    @Deprecated
    private native void decompress(byte[] var1, int var2, int[] var3, int var4, int var5, int var6, int var7, int var8) throws TJException;

    private native void decompress(byte[] var1, int var2, int[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10) throws TJException;

    @Deprecated
    private native void decompressToYUV(byte[] var1, int var2, byte[] var3, int var4) throws TJException;

    private native void decompressToYUV(byte[] var1, int var2, byte[][] var3, int[] var4, int var5, int[] var6, int var7, int var8) throws TJException;

    private native void decodeYUV(byte[][] var1, int[] var2, int[] var3, int var4, byte[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12) throws TJException;

    private native void decodeYUV(byte[][] var1, int[] var2, int[] var3, int var4, int[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12) throws TJException;

    static {
        TJLoader.load();
    }
}

