<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/linkbutton.ftl">
<#include "/macros/formtable.ftl">

 <#if showsettings??>
  
  <@tableHeader Heading="Request Processor Settings"/>
  
  <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
   <tr> 
    <td class="pad1" colspan="3">
     <#if message??>
       ${message}
     <#else>
       The request processor settings configure the behaviour of FSI Servers image delivery component. This component is 
       responsible for accepting HTTP requests from client applications (e.g. browsers, FSI Viewer instances) and 
       rendering the responses using the data from FSI Servers internal storage.  
     </#if>
    </td>
   </tr> 
   <tr>
	 <td class="sectionheader" colspan="3">General Settings</td>
   </tr>
   <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
   <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1" colspan="2"><#if enabled ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
   </tr>
   <#if enabled >
   <tr>
	    <td class="pad1">Storage Directory</td>
	    <td class="pad1" colspan="2">${storage}</td>
   </tr>
   <tr>
	    <td class="pad1">Source Manager</td>
	    <td class="pad1" colspan="2">${sourcemanager}</td>
   </tr>
   <tr>
	    <td class="pad1">Request Processor Tokens</td>
	    <td class="pad1" colspan="2">${requestprocessortokens}</td>
   </tr>
   <tr>
	    <td class="pad1">Copyright Notice</td>
	    <td class="pad1" colspan="2">${copyrightnotice}</td>
   </tr>
   <tr>
	    <td class="pad1"></td>
	    <td class="pad1" colspan="2" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="requestprocessorsettings">
      		<input type="hidden" name="editsettings" value="1">
      		<@formsubmit value="Edit" helpid="requestprocessorsettings_edit" />
      	  </form>
	    </td>
   </tr>
   </#if>
   
      <tr> 
        <td class="sectionheader" colspan="3">Search Database Settings</td>
	  </tr>
	  <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1" colspan="2"><#if searchenabled ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <#if searchenabled >
	  <tr>
	    <td class="pad1">Type</td>
	    <td class="pad1" colspan="2">${type}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Solr Server URI</td>
	    <td class="pad1" colspan="2">${solrserveruri}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Core</td>
	    <td class="pad1" colspan="2">${core}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Authentication</td>
	    <td class="pad1" colspan="2"><#if authentication?starts_with("true") ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <#if authentication?starts_with("true") >
	   <tr>
	    <td class="pad1" colspan="2">
	      <table>
	       <tr>
	        <td class="pad1">Type</td>
	        <td class="pad1" colspan="2">${authentication_type}</td>
	       </tr>
	       <tr>
	        <td class="pad1">Username</td>
	        <td class="pad1" colspan="2">${username}</td>
	       </tr>
	       <tr>
	        <td class="pad1">Password</td>
	        <td class="pad1" colspan="2">${password}</td>
	       </tr>
	      </table>
	    </td>
	   </tr>
	  </#if>
	  <tr>
	    <td class="pad1">Use proxy</td>
	    <td class="pad1" colspan="2"><#if proxy?starts_with("true") ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  <#if proxy?starts_with("true") >
	   <tr>
	    <td class="pad1" colspan="2">
	      <table>
	       <tr>
	        <td class="pad1">Hostname and Port</td>
	        <td class="pad1" colspan="2">${proxyhostname} : ${proxy_port}</td>
	       </tr>
	       <tr>
	        <td class="pad1">SSL</td>
	        <td class="pad1" colspan="2"><#if proxyssl?starts_with("true") ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	       </tr>
	       <tr>
	        <td class="pad1">Authentication</td>
	        <td class="pad1" colspan="2"><#if proxyauthentication?starts_with("true") ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	       </tr>
	       <tr>
	        <td class="pad1">Username</td>
	        <td class="pad1" colspan="2">${proxyusername}</td>
	       </tr>
	       <tr>
	        <td class="pad1">Type</td>
	        <td class="pad1" colspan="2">${proxypassword}</td>
	       </tr>
	      </table>
	    </td>
	   </tr>
	  </#if>
	  <tr>
	    <td class="pad1">Connection Pool Size</td>
	    <td class="pad1" colspan="2">${connectionpoolmax}</td>
	  </tr>
	  </#if>
      <tr>
	    <td class="pad1"></td>
	    <td class="pad1" colspan="2" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="requestprocessorsettings" />
      		<input type="hidden" name="editsearch" value="1" />
      		<@formsubmit value="Edit" helpid="requestprocessorsettings_edit_searchsettings" />
      	  </form>
	    </td>
	  </tr>
	
	  
      <tr>
	    <td class="sectionheader" colspan="3">Color Management System</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1" colspan="2"><#if cmsenabled ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  
	  <#if cmsenabled >
	  <tr>
	    <td class="pad1">Default CMYK Profile</td>
	    <td class="pad1" colspan="2">${defaultcmykprofile}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Default RGB Profile</td>
	    <td class="pad1" colspan="2">${defaultrgbprofile}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Default Gray Profile</td>
	    <td class="pad1" colspan="2">${defaultgrayprofile}</td>
	  </tr>
	  <tr>
	    <td class="pad1">Fallback ICC Conversion</td>
	    <td class="pad1" colspan="2"><#if fallbackICCConversion ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
	  </tr>
	  </#if>
	  <tr>
	    <td class="pad1"></td>
	    <td class="pad1" colspan="2" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="requestprocessorsettings" />
      		<input type="hidden" name="editcms" value="1" />
      		<@formsubmit value="Edit" helpid="requestprocessorsettings_edit_cmssettings" />
      	  </form>
	    </td>
	  </tr>
	  
	  
	  
   <tr>
	 <td class="sectionheader" colspan="3">Limits and Defaults</td>
   </tr>
   <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
   <tr>
	    <td class="pad1">Default Renderer</td>
	    <td class="pad1" colspan="2">${defaultrenderer}</td>
   </tr>
   <tr>
	    <td class="pad1">Default Image Width</td>
	    <td class="pad1" colspan="2">${defaultwidth}</td>
   </tr>
   <tr>
	    <td class="pad1">Default Image Height</td>
	    <td class="pad1" colspan="2">${defaultheight}</td>
   </tr>
   <tr>
	    <td class="pad1">Maximum Image Width</td>
	    <td class="pad1" colspan="2">${maxwidth}</td>
   </tr>
   <tr>
	    <td class="pad1">Maximum Image Height</td>
	    <td class="pad1" colspan="2">${maxheight}</td>
   </tr>
    <tr>
	    <td class="pad1">Sort Collator</td>
	    <td class="pad1" colspan="2">${sortcollatortext}</td>
   </tr>
   <tr>
	    <td class="pad1"></td>
	    <td class="pad1" colspan="2" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="requestprocessorsettings">
      		<input type="hidden" name="editlimits" value="1">
      		<@formsubmit value="Edit" helpid="requestprocessorsettings_edit_limits" />
      	  </form>
	    </td>
   </tr>
   
  <tr>
	 <td class="sectionheader" colspan="3">Request Processor Cache Settings</td>
  </tr>
   <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
   <#if uses_source_manager_cache>
    <tr><td colspan="2">This request processor instance is sharing its cache with the Source Manager. Please configure the cache settings there.</td></tr>
   <#else>
     <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1" colspan="2"><#if requestprocessorcacheenabled ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
     </tr>
     <#if requestprocessorcacheenabled >
     <tr>
	    <td class="pad1">Max Threads</td>
	    <td class="pad1" colspan="2">${threads}</td>
     </tr>
     <tr>
	    <td class="pad1">Max Memory</td>
	    <td class="pad1" colspan="2">${memory}</td>
     </tr>
     <tr>
	    <td class="pad1">Direct Cache</td>
	    <td class="pad1" colspan="2"><#if direct ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
     </tr>
     </#if>
     <tr>
	    <td class="pad1"></td>
	    <td class="pad1" colspan="2" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="requestprocessorsettings">
      		<input type="hidden" name="editrequestprocessorcache" value="1">
      		<@formsubmit value="Edit" helpid="requestprocessorsettings_edit_requestprocessorcache" />
      	  </form>
	    </td>
     </tr>
   </#if>
   
   <tr>
	 <td class="sectionheader" colspan="3">Advanced Settings</td>
   </tr>
   <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
  <tr>
	    <td class="pad1">Java Management Extension</td>	    
      <td class="pad1" colspan="2"><#if jmx?starts_with("true") ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
   </tr>
   <tr>
	    <td class="pad1">Byteorder</td>
	    <td class="pad1" colspan="2">${byteorder}</td>
   </tr>
   <tr>
	    <td class="pad1">Cache Templates</td>
	    <td class="pad1" colspan="2"><#if cachetemplates?starts_with("true") ><img src="images/icons/yes.gif"><#else><img src="images/icons/nope.gif"></#if></td>
   </tr>
   <tr>
	    <td class="pad1">Priority</td>
	    <td class="pad1" colspan="2">${priority}</td>
   </tr>
   <tr>
	    <td class="pad1">max CPU</td>
	    <td class="pad1" colspan="2">${maxcpu}</td>
   </tr>
   <tr>
	    <td class="pad1">max IO</td>
	    <td class="pad1" colspan="2">${maxio}</td>
   </tr>                                                      
   <tr>
	    <td class="pad1">Temporary Directory</td>
	    <td class="pad1" colspan="2">${tempdirectory}</td>
   </tr>
   <tr>
	    <td class="pad1"></td>
	    <td class="pad1" colspan="2" align="right">
	      <form action="pt.do" method="post" onsubmit="this.submit();">
      		<@printRequiredParams method="post" />
      		<input type="hidden" name="action" value="requestprocessorsettings">
      		<input type="hidden" name="editadvanced" value="1">
      		<@formsubmit value="Edit" helpid="requestprocessorsettings_edit_advanced" />
      	  </form>
	    </td>
   </tr>
   
  </table>
  <@tableFooter/>

  <#elseif show_uses_source_manager_cache_message?? >
  
    <@tableHeader Heading="Request Processor Cache Settings" />
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
	  <tr>
  		<td class="sectionheader">Request Processor Cache Settings</td>
  	  </tr>
      <tr><td><hr size="1" class="hr1"/></td></tr>
        <tr><td class="pad1">This request processor instance is sharing its cache with the Source Manager. Please configure the cache settings there.</td></tr>
      </tr>
    </table>
    <@tableFooter/>
   
  <#elseif show_form??>
  
    <@tableHeader Heading="Edit Request Processor Settings" />

  	<form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="requestprocessorsettings">
    <input type="hidden" name="editsettings" value="1">
    <input type="hidden" name="save" value="1">

    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
	  <tr>
	    <td class="sectionheader firstsection" colspan="3">General Settings</td>
	  </tr>
	  <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
	  <tr>
        <td class="pad1" colspan="3">
         <p class="warning">Warning: If you disable the software here, you won't be able to connect to this interface any longer.<br />
         You will need direct access to the server to make any further modifications. 
         </p>
        </td>
      </tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1">
	      <@formcheckbox  objid="enabled" preselect=enabled?string helpid="requestprocessorsettings_enabled" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Storage Directory</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="storage" name="storage" <#if storage??>value="${storage}"</#if> help="<@appID/>:requestprocessorsettings_storage">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Source Manager</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="sourcemanager" name="sourcemanager" <#if sourcemanager??>value="${sourcemanager}"</#if> help="<@appID/>:requestprocessorsettings_sourcemanager">	    
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Request Processor Tokens</td>
	    <td class="pad1">
	      <@formgfxselect width="378" objid="requestprocessortokens" itemlist=available_requestprocessortokens preselect=requestprocessortokens helpid="requestprocessorsettings_requestprocessortokens" />
	    </td>
	  </tr> 	 
	  <tr>
	    <td class="pad1">Copyright Notice</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="copyrightnotice" name="copyrightnotice" <#if copyrightnotice??>value="${copyrightnotice}"</#if> help="<@appID/>:requestprocessorsettings_copyrightnotice">
	    </td>
	  </tr>
	  <tr><td class="pad1" colspan="3" style="padding-top:30px;"><hr size="1" class="hr1"></td></tr>
	  <tr>
	    <td class="pad1" colspan="3" align="right">
	      <@linkbutton value="Cancel" targeturl="pt.do?action=requestprocessorsettings" helpid="requestprocessorsettings_cancel" />
	      <@formsubmit value="Save Changes" helpid="requestprocessorsettings_save" />
	    </td>
	  </tr>
     </table>
    </form>
  <@tableFooter/>
  
   <#elseif show_cmssettings_form??>
  
    <@tableHeader Heading="Edit Source Manager Color Management Settings" />
  
  	<form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="requestprocessorsettings">
    <input type="hidden" name="editcms" value="1">
    <input type="hidden" name="save" value="1">
  
     <table cellspacing="0" cellpadding="0" border="0" width="500px">
	  <tr>
	    <td class="sectionheader firstsection" colspan="3">Color Management Settings</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1">
	      <@formcheckbox  objid="enabled" preselect=cmsenabled?string helpid="sourcemanagersettings_cmsenabled" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Default CMYK Profile</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="defaultcmykprofile" name="defaultcmykprofile" <#if defaultcmykprofile??>value="${defaultcmykprofile}"</#if> help="<@appID/>:requestprocessorsettings_defaultcmykprofile">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Default RGB Profile</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="defaultrgbprofile" name="defaultrgbprofile" <#if defaultrgbprofile??>value="${defaultrgbprofile}"</#if> help="<@appID/>:requestprocessorsettings_defaultrgbprofile">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Default Gray Profile</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="defaultgrayprofile" name="defaultgrayprofile" <#if defaultgrayprofile??>value="${defaultgrayprofile}"</#if> help="<@appID/>:requestprocessorsettings_defaultgrayprofile">
	    </td>
	  </tr>
      <tr>
	    <td class="pad1">Fallback ICC Conversion</td>
	    <td class="pad1">
	      <@formcheckbox  objid="fallbackICCConversion" preselect=fallbackICCConversion?string helpid="requestprocessorsettings_fallbackICCConversion" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1" style="text-align: right; padding-top: 20px;" colspan="2">
	      <@linkbutton value="Cancel" targeturl="pt.do?action=requestprocessorsettings" helpid="requestprocessorsettings_cancel" />
          <@formsubmit value="Save Changes" helpid="requestprocessorsettings_save" />
	    </td>
	  </tr>
     </table>
    </form>
    <@tableFooter/>
    
  <#elseif show_limitssettings_form??>
  
    <@tableHeader Heading="Edit Limit Settings" />
  
  	<form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="requestprocessorsettings">
    <input type="hidden" name="editlimits" value="1">
    <input type="hidden" name="save" value="1">
  
     <table cellspacing="0" cellpadding="0" border="0" width="500px">
	  <tr>
	    <td class="sectionheader firstsection" colspan="3">Limits And Defaults</td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Default Renderer</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="defaultrenderer" name="defaultrenderer" <#if defaultrenderer??>value="${defaultrenderer}"</#if> help="<@appID/>:requestprocessorsettings_defaultrenderer">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Default Width</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="defaultwidth" name="defaultwidth" <#if defaultwidth??>value="${defaultwidth}"</#if> help="<@appID/>:requestprocessorsettings_defaultwidth">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Default Height</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="defaultheight" name="defaultheight" <#if defaultheight??>value="${defaultheight}"</#if> help="<@appID/>:requestprocessorsettings_defaultheight">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Maximum Width</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="maxwidth" name="maxwidth" <#if maxwidth??>value="${maxwidth}"</#if> help="<@appID/>:requestprocessorsettings_maxwidth">
	    </td>
	  </tr>
 	  <tr>
	    <td class="pad1">Maximum Height</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" maxlength="30" id="maxheight" name="maxheight" <#if maxheight??>value="${maxheight}"</#if> help="<@appID/>:requestprocessorsettings_maxheight">
	    </td>
	  </tr>
 	  <tr>
	    <td class="pad1">Sort Collator</td>
	    <td class="pad1">
	      <!-- <input type="text" class="inwhite" maxlength="30" id="sortcollator" name="sortcollator" <#if sortcollator??>value="${sortcollator}"</#if> help="<@appID/>:requestprocessorsettings_maxheight"> -->
        <@formgfxselect width="378" objid="sortcollator" itemlist=available_sortcollatorstrings preselect=sortcollator helpid="requestprocessorsettings_sortcollator" />
	    </td>
	  </tr>

	  <tr>
	    <td class="pad1" style="text-align: right; padding-top: 20px;" colspan="2">
	      <@linkbutton value="Cancel" targeturl="pt.do?action=requestprocessorsettings" helpid="requestprocessorsettings_cancel" />
          <@formsubmit value="Save Changes" helpid="requestprocessorsettings_save" />
	    </td>
	  </tr>
     </table>
    </form>
    <@tableFooter/>
    
    
  <#elseif show_requestprocessorcachesettings_form??>
  
    <@tableHeader Heading="Edit Request Processor Cache Settings" />
  
 	<form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="requestprocessorsettings">
    <input type="hidden" name="editrequestprocessorcache" value="1">
    <input type="hidden" name="save" value="1">

    <table cellspacing="0" cellpadding="0" border="0" width="500px">
	  <tr>
	    <td class="sectionheader firstsection" colspan="3">Request Processor Cache Settings</td>
	  </tr>
	  <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>   
   	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1">
	      <@formcheckbox  objid="requestprocessorcacheenabled" preselect=requestprocessorcacheenabled?string helpid="requestprocessorcachesettings_requestprocessorcacheenabled" /> 
	    </td>
	 </tr>                 
   <tr>
	    <td class="pad1">Max Threads</td>
	    <td class="pad1" colspan="2">
	      <input type="text" class="inwhite" id="threads" name="threads" <#if threads??>value="${threads}"</#if> help="<@appID/>:requestprocessorcachesettings_threads">	    
	    </td>      
   </tr>
   <tr>
	    <td class="pad1">Max Memory</td>
	    <td class="pad1" colspan="2">
	      <input type="text" class="inwhite" id="memory" name="memory" <#if memory??>value="${memory}"</#if> help="<@appID/>:requestprocessorcachesettings_memory">	    
	    </td>      
   </tr>
   <tr>
	    <td class="pad1">Direct Cache</td>
      <td class="pad1" colspan="2">
        <@formcheckbox  objid="direct" preselect=direct?string helpid="requestprocessorcachesettings_direct" />	    
	    </td>
   </tr>
    
   	<tr>
	    <td class="pad1" style="text-align: right; padding-top: 20px" colspan="3" >
	      <@linkbutton value="Cancel" targeturl="pt.do?action=requestprocessorsettings" helpid="requestprocessorcachesettings_cancel" />
          <@formsubmit value="Save Changes" helpid="requestprocessorcachesettings_save" />
	    </td>
	  </tr>                 
    </table>
    </form>
    
    <@tableFooter/>    
    
      
    
  <#elseif show_advancedsettings_form??>
  
    <@tableHeader Heading="Edit Advanced Settings" />
  
 	  <form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="requestprocessorsettings">
    <input type="hidden" name="editadvanced" value="1">
    <input type="hidden" name="save" value="1">

    <table cellspacing="0" cellpadding="0" border="0" width="500px">
	  <tr>
	    <td class="sectionheader firstsection" colspan="3">Advanced Settings</td>
	  </tr>
	  <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
                   
    <tr>
	    <td class="pad1">Java Management Extension</td>
      <td class="pad1" colspan="2">
        <@formcheckbox  objid="jmx" preselect=jmx?string helpid="requestprocessorsettings_jmx" />	    
	    </td>
   </tr>
   <tr>
	    <td class="pad1">Byteorder</td>
	    <td class="pad1" colspan="2">
	      <!-- <input type="text" class="inwhite" id="byteorder" name="byteorder" <#if byteorder??>value="${byteorder}"</#if> help="<@appID/>:requestprocessorsettings_byteorder"> -->
        <@formgfxselect width="378" objid="byteorder" itemlist=available_byteorders preselect=byteorder helpid="requestprocessorsettings_byteorder" />	    
	    </td>      
   </tr>
   <tr>
	    <td class="pad1">Cache Templates</td>
      <td class="pad1" colspan="2">
        <@formcheckbox  objid="cachetemplates" preselect=cachetemplates?string helpid="requestprocessorsettings_cachetemplates" />	    
	    </td>      
   </tr>
   <tr>
	    <td class="pad1">Priority</td>
	    <td class="pad1" colspan="2">
	      <input type="text" class="inwhite" id="priority" name="priority" <#if priority??>value="${priority}"</#if> help="<@appID/>:requestprocessorsettings_priority">	    
	    </td>      
   </tr>
   <tr>
	    <td class="pad1">max CPU</td>
	    <td class="pad1" colspan="2">
	      <input type="text" class="inwhite" id="maxcpu" name="maxcpu" <#if maxcpu??>value="${maxcpu}"</#if> help="<@appID/>:requestprocessorsettings_maxcpu">	    
	    </td>      
   </tr>
   <tr>
	    <td class="pad1">max IO</td>
	    <td class="pad1" colspan="2">
	      <input type="text" class="inwhite" id="maxio" name="maxio" <#if maxio??>value="${maxio}"</#if> help="<@appID/>:requestprocessorsettings_maxio">	    
	    </td>      
   </tr>                                                      
   <tr>
	    <td class="pad1">Temporary Directory</td>
	    <td class="pad1" colspan="2">
	      <input type="text" class="inwhite" id="tempdirectory" name="tempdirectory" <#if tempdirectory??>value="${tempdirectory}"</#if> help="<@appID/>:requestprocessorsettings_tempdirectory">	    
	    </td>      
   </tr>
   <tr>
	    <td class="pad1" style="text-align: right; padding-top: 20px" colspan="3" >
	      <@linkbutton value="Cancel" targeturl="pt.do?action=requestprocessorsettings" helpid="requestprocessorsettings_cancel" />
          <@formsubmit value="Save Changes" helpid="requestprocessorsettings_save" />
	    </td>
	  </tr>                 
    </table>
    </form>
    
    <@tableFooter/>
                      
  <#elseif show_searchsettings_form??>
  
    <script type="text/javascript">
      function toggle_sections() {
      	var authBox = document.getElementById("authentication");
      	var authTable = document.getElementById("authtable");
      	if (authBox.value == "false") {
      	  authTable.style.display = "none";
      	} else {
      	  authTable.style.display = "table-row";
      	}
      	var proxyBox = document.getElementById("proxy");
      	var proxyTable = document.getElementById("proxytable");
      	if (proxyBox.value == "false") {
      	  proxyTable.style.display = "none";
      	} else {
      	  proxyTable.style.display = "table-row";
      	}
      }
    </script>
  
    <@tableHeader Heading="Edit Search Database Settings" />
  
  	<form action="pt.do" method="post" onsubmit="this.submit();">
    <@printRequiredParams method="post" />
    <input type="hidden" name="action" value="requestprocessorsettings">
    <input type="hidden" name="editsearch" value="1">
    <input type="hidden" name="save" value="1">
  
     <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
	  <tr>
	    <td class="sectionheader firstsection" colspan="3">Search Database Settings</td>
	  </tr>
	  <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">Enabled</td>
	    <td class="pad1" colspan="2">
	      <@formcheckbox  objid="enabled" preselect=searchenabled?string helpid="searchsettings_enabled" /> 
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Solr Server URI</td>
	    <td class="pad1" colspan="2">
	      <input type="text" class="inwhite" id="solrserveruri" name="solrserveruri" <#if solrserveruri??>value="${solrserveruri}"</#if> help="<@appID/>:searchsettings_solr_solrserveruri">
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1">Core</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" id="core" name="core" <#if core??>value="${core}"</#if> help="<@appID/>:searchsettings_solr_core">  
	    </td>
	  </tr>
	  
	  <tr>
	    <td class="pad1">Use Authentication</td>
	    <td class="pad1" colspan="2">
	      <@formcheckbox  objid="authentication" preselect=authentication callbackonchange="toggle_sections" helpid="searchsettings_solr_authentication" /> 
	    </td>
	  </tr>
	  <tr id="authtable" <#if authentication?starts_with("true")>style="display: table-row;"<#else>style="display: none;"</#if>>
	    <td class="pad1" colspan="2">
	    <table>
	      <tr>
	        <td class="pad1">Authentication Type</td>
	        <td class="pad1" colspan="2">
	          <@formgfxselect objid="authenticationtype" itemlist=authentication_types preselect=authenticationtype helpid="searchsettings_solr_authenticationtype" /> 
	        </td>
	      </tr>
	      <tr>
	        <td class="pad1">Username</td>
	        <td class="pad1" colspan="2">
	          <input type="text" class="inwhite" id="authenticationusername" name="authenticationusername" <#if authenticationusername??>value="${authenticationusername}"</#if> help="<@appID/>:searchsettings_solr_authenticationusername"> 
	        </td>
	      </tr>
          <tr>
	        <td class="pad1">Password</td>
	        <td class="pad1" colspan="2">
	          <input type="text" class="inwhite" id="authenticationpassword" name="authenticationpassword" <#if authenticationpassword??>value="${authenticationpassword}"</#if> help="<@appID/>:searchsettings_solr_authenticationpassword"> 
	        </td>
	      </tr>
		</table>
	    </td>	      
	  </tr>
	  
	  <tr>
	    <td class="pad1">Use Proxy</td>
	    <td class="pad1" colspan="2">
	      <@formcheckbox  objid="proxy" preselect=proxy callbackonchange="toggle_sections" helpid="searchsettings_solr_proxy" /> 
	    </td>
	  </tr>
	  <tr id="proxytable" <#if proxy?starts_with("true")>style="display: table-row;"<#else>style="display: none;"</#if>>
	    <td class="pad1" colspan="2">
	    <table>
	      <tr>
	        <td class="pad1">Hostname</td>
	        <td class="pad1" colspan="2">
	          <input type="text" class="inwhite" id="proxyhostname" name="proxyhostname" <#if proxyhostname??>value="${proxyhostname}"</#if> help="<@appID/>:searchsettings_solr_proxyhostname">
	        </td>
	      </tr>
	      <tr>
	        <td class="pad1">Port</td>
	        <td class="pad1">
	          <input type="text" class="inwhite" id="proxyport" name="proxyport" <#if port??>value="${proxyport}"</#if> help="<@appID/>:searchsettings_solr_proxyport">	    
	        </td>
	      </tr>
	      <tr>
	        <td class="pad1">Access Proxy Using SSL</td>
	        <td class="pad1" colspan="2">
	          <@formcheckbox  objid="proxyssl" preselect=proxyssl helpid="searchsettings_solr_proxyssl" /> 
	        </td>
	      </tr>
	      <tr>
	        <td class="pad1">Proxy Requires Authentication</td>
	        <td class="pad1" colspan="2">
	          <@formcheckbox  objid="proxyauthentication" preselect=proxyauthentication helpid="searchsettings_solr_proxyauthentication" /> 
	        </td>
	      </tr>
	      <tr>
	        <td class="pad1">Username</td>
	        <td class="pad1" colspan="2">
	          <input type="text" class="inwhite" id="proxyusername" name="proxyusername" <#if proxyusername??>value="${proxyusername}"</#if> help="<@appID/>:searchsettings_solr_proxyusername"> 
	        </td>
	      </tr>
          <tr>
	        <td class="pad1">Password</td>
	        <td class="pad1" colspan="2">
	          <input type="text" class="inwhite" id="proxypassword" name="proxypassword" <#if proxypassword??>value="${proxypassword}"</#if> help="<@appID/>:searchsettings_solr_proxypassword"> 
	        </td>
	      </tr>
		</table>
		</td>	      
	  </tr>
	  
	  <tr>
	    <td class="pad1">Connection Pool Size</td>
	    <td class="pad1">
	      <input type="text" class="inwhite" id="connectionpoolmax" name="connectionpoolmax" <#if connectionpoolmax??>value="${connectionpoolmax}"</#if> help="<@appID/>:sourcemanagersettings_solr_connectionpoolmax">	    
	    </td>
	  </tr>
	  <tr>
	    <td class="pad1" style="text-align: right; padding-top: 20px" colspan="3" >
	      <@linkbutton value="Cancel" targeturl="pt.do?action=requestprocessorsettings" helpid="requestprocessorsettings_cancel" />
          <@formsubmit value="Save Changes" helpid="requestprocessorsettings_save" />
	    </td>
	  </tr>
     </table>
    </form>
  <@tableFooter/>
  
  
  
  <#elseif show_confirmation??>
  
    <@tableHeader Heading="Edit Request Processor Settings" />
  
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
	  <tr>
	    <td class="sectionheader">Settings saved</td>
	  </tr>
	  <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
	  <tr>
	    <td class="pad1">
          The changes to the settings have been saved. Please wait while the application is restarted for the
          changes to take effect.
        </td>
      </tr>
    </table>
	
	<@tableFooter/>
    <#assign timeout="5" />
    <#assign postprogresslocation="action=requestprocessorsettings">
    <#include "/sub/progressbar.ftl">
  
  </#if>
	
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">