/*!
 * FSI Server Interface
 * http://www.fsi-viewer.com
 *
 * Copyright (C) 2000-2016 NeptuneLabs GmbH - All rights reserved.
 *
 * Version: 3.0.0
 */
;function FolderTree(interfaceControl){var self=this;var ic=interfaceControl;var urlListRequest;var strCurrentPath="/";var bReturnFocus=false;var translator;var oSpecialNodeData;var favNodeActive;var nLastSplitterPos=250;var elActiveCurrent,elActiveElementID;var curDropTargetEL,curDropTargetSrcEL,curDropTargetELCanDrop,curElDropTreeItem;var nDropOpenCount=0;var contextMenuFocusNode;var oConnectorNodes={};var strActiveSection;var bFirstLoad=true;var strLastSearchQuery="";var bSearchTabEnabled=true;var startPath;var bHasConnectorInfo;var bReady;var oConnectorInfoEntries;var connectorInfoHeight;var oTotalFiles={};var oConnectorInfoCache={};var oRootNode={title:ic.getRootBrowsePath(),displayTitle:(ic.getBaseServerDomain().length>0)?ic.getBaseServerDomain():"FSI Server",connectorType:"ROOT",addClass:"treeNodeClassRoot",permissions:{read:{renderedImages:true,basicMetadata:true,extendedMetadata:true,totalAssetsCount:true},write:{},list:{},tasks:{}},publicPermissions:{read:{},write:{},list:{},tasks:{}},key:"root"};this.getRootNodeObject=function(){return oRootNode};var translate=function(key){if(!translator){return key}return translator.translateTextValue("foldertree",key,true)};this.browseFolderUp=function(){var tree=getControl();var node=tree.getActiveNode();if(node&&node.parent){node.parent.activate();return true}return false};this.getCurrentPath=function(){return strCurrentPath};this.reloadAll=function(tree,strPath){bReady=bHasConnectorInfo=false;if(!tree){tree=getControl()}if(tree==getControl()){oConnectorNodes={}}tree.tnRoot.activate();tree.resetContent();tree.tnRoot.appendAjax(tree.options.initAjax);tree.tnRoot.activate(true,true);if(tree==getControl()){strCurrentPath=ic.getRootBrowsePath();ic.setBasePath(strCurrentPath)}if(strPath!=undefined){bFirstLoad=true;startPath=strPath}};this.getConnectorNodeByName=function(strConnectorName){if(oConnectorNodes[strConnectorName]!=undefined){return oConnectorNodes[strConnectorName]}var tree=getControl();var node;if(strConnectorName==undefined||strConnectorName.length==0||strConnectorName=="_root"){node=tree.tnRoot}else{node=tree.tnRoot.getChildByTitle(strConnectorName)}if(node&&node.data.connectorType){oConnectorNodes[strConnectorName]=node;return node}};this.getConnectorTypeByName=function(strConnectorName){if(strConnectorName=="search"){return"SEARCH"}var node=self.getConnectorNodeByName(strConnectorName);if(!node){var nodeRoot=getControl().tnRoot;if(nodeRoot&&strConnectorName==nodeRoot.data.title){return"ROOT"}return""}return node.data.connectorType};this.getConnectorMayRenderImages=function(oConnectorInfo){return(oConnectorInfo&&oConnectorInfo.permissions&&oConnectorInfo.permissions.read&&oConnectorInfo.permissions.read.renderedImages)};this.getConnectorInfoByEntry=function(entry){if(!entry){return{}}ic.getThumbView().getImagePath(entry);return self.getConnectorInfoByPath(decodeURIComponent(entry.fullsrc))};this.getConnectorInfoByPath=function(strPath){if(strPath.length==undefined){return{}}var str=strPath.split("/").shift();return self.getConnectorInfoByName(str)};this.getConnectorInfoByName=function(strConnectorName){if(strConnectorName.length==0){strConnectorName="_root"}if(oConnectorInfoCache[strConnectorName]){return oConnectorInfoCache[strConnectorName]}var oInfo={};oInfo._bStandardConnectorType=true;oInfo.connectorName=strConnectorName;var node=self.getConnectorNodeByName(strConnectorName);var bRootNode=false;if(node&&node.data){switch(node.data.connectorType){case"ROOT":bRootNode=true;oInfo._bStandardConnectorType=false;break;case"SEARCH":case"TRASH":case"DOWNLOADS":oInfo._bStandardConnectorType=false;break}}oInfo.permissions={};oInfo.properties={};if(bRootNode){oInfo.nTotalFilesVisible=oInfo.nTotalFiles=oTotalFiles.nOverallFilesVisible;oInfo.connectorType="ROOT"}else{if(node){oInfo.nTotalFilesVisible=oInfo.nTotalFiles=node.data.connectorTotalContent}}if(node){if(node.data.publicPermissions){oInfo.publicPermissions=node.data.publicPermissions}if(node.data.permissions){oInfo.permissions=node.data.permissions}if(node.data.properties){oInfo.properties=node.data.properties;if(oInfo.properties.hideApps&&oInfo.properties.hideApps.length!=undefined){var ar=oInfo.properties.hideApps;ar.sort();var o={};for(var i=0;i<ar.length;i++){o[ar[i]]=true}oInfo.properties.hideApps=o;if(oInfo.properties.hidePublishingTabs&&oInfo.properties.hidePublishingTabs.length>0){oInfo.properties.hidePublishingTabs.sort()}}}if(node.data.comment){oInfo.comment=node.data.comment}}if(strConnectorName=="search"){oInfo.connectorType="SEARCH";oInfo._bMixedSourceConnectors=true;oInfo.permissions=ic.getSearchPermissions()}else{oInfo._bMixedSourceConnectors=false;if(node&&node.data){if(node.data.displayTitle){oInfo.displayTitle=node.data.displayTitle}else{oInfo.displayTitle=strConnectorName}oInfo.connectorType=node.data.connectorType}}if(oInfo.permissions&&oInfo.permissions.read&&oInfo.permissions.write){oInfo.permissions._bReadWriteExtendedMetaData=(oInfo.permissions.read.extendedMetadata&&oInfo.permissions.write.extendedMetadata)}oConnectorInfoCache[strConnectorName]=oInfo;return oInfo};var reloadParentByPath=this.reloadParentByPath=function(path,nParentsUp,tree){if(typeof(path)!="string"||path.length<1){return false}if(!tree){tree=getControl()}if(nParentsUp==undefined){nParentsUp=1}for(var i=0;i<nParentsUp;i++){var tmp=path.lastIndexOf("/");if(tmp==-1){return false}path=path.substr(0,tmp)}return reloadByPath(path,tree)};var reloadByPath=this.reloadByPath=function(path,tree){if(typeof(path)!="string"||path.length<1){return false}if(!tree){tree=getControl()}var node=tree.findNodeByPath(path);if(node&&path==node.NELA_nodePath){reloadNode(node,false,tree);return true}return false};this.reloadCurrent=function(tree){if(!tree){tree=getControl()}var tNodeCurrent;if(ic.getBasePathType()=="dir"){tNodeCurrent=tree.findNodeByPath(ic.getBasePath())}reloadNode(tNodeCurrent,false,tree);if(tree==getControl()){ic.reloadThumbs()}};var reloadNode=this.reloadNode=function(dtnode,bActivateAndGetCallback,tree){if(!dtnode||!dtnode.data||!dtnode.data.isFolder){return false}if(!tree){tree=getControl()}var nodeActive=tree.getActiveNode();var activePath;if(nodeActive){activePath=nodeActive.getPath()}var path=dtnode.getPath();var bActivateChild=(activePath.indexOf(path)==0);var key=dtnode.data.key;if(key=="favorites"){return false}if(key=="root"){self.reloadAll(tree);return}var bExpanded=dtnode.bExpanded;dtnode.bRefreshed=true;dtnode.expand(false);dtnode.isRead=false;var childList=dtnode.getChildList();if(childList&&childList.length>0){dtnode.removeChildren()}if(dtnode.data.isLazy){dtnode.expand(true);if(!bExpanded){dtnode.expand(false)}}if(bActivateChild){expandToPath(activePath)}else{if(activePath){var nodeToActivate=tree.findNodeByPath(activePath);if(nodeToActivate&&activePath==nodeToActivate.NELA_nodePath){if(activePath!=nodeToActivate.getPath()){nodeToActivate.activate(false,false)}}}}};this.selectAndRefreshParentNode=function(node,tree){if(!tree){tree=getControl()}if(node==undefined){node=tree.getActiveNode()}if(!node||!node.parent){return}reloadNode(node.parent,true,tree)};this.checkSubdirectoryCount=function(nDirs){var tree=getControl();var dtnode=tree.getActiveNode();if(!dtnode){return}var nChildren=0;if(dtnode.childList){nChildren=dtnode.childList.length}if(nChildren==0){dtnode.expand(false)}if(nDirs==nChildren){return}};this.onAfterCreateDirectory=function(dtnode,bFromTree,tree){if(!tree){tree=getControl()}if(dtnode==undefined&&!bFromTree){dtnode=tree.getActiveNode()}if(dtnode==undefined){return}if(!dtnode.data.isLazy){dtnode.data.isLazy=true;self.reloadNode(dtnode,false,tree)}else{self.reloadNode(dtnode,false,tree)}if(tree==getControl()){ic.reloadThumbs()}};this.checkThumbReloadForParentNodeOf=function(tnode){if(!tnode||!tnode.parent){return}checkThumbReloadForNode(tnode.parent)};var checkThumbReloadForNode=this.checkThumbReloadForNode=function(tnode){if(!tnode){return}var path=ic.getBasePath();if(tnode.getPath()==path){ic.getThumbView().reloadVisibleThumbs()}};this.expandAll=function(){var tree=getControl();tree.getRoot().visit(function(dtnode){dtnode.expand(true)})};this.expandActiveNode=function(){var tree=getControl();var node=tree.getActiveNode();if(node){node.visit(function(dtnode){dtnode.expand(true)})}};this.collapseAll=function(){var tree=getControl();tree.getRoot().visit(function(dtnode){dtnode.expand(false)});self.setTheFocus()};this.onResize=function(){if(ic){var windowDim=ic.getViewPortDim();if(windowDim&&windowDim.height){var w=ic.getSplitterPos();setSize(w,windowDim.height-connectorInfoHeight);ic.getSearchCTL().resize(w,windowDim.height)}}};var setSize=function(w,h){var myContainer=ic.getElementById("foldertreecontainer");if(myContainer){myContainer.style.width=Math.max(0,w)+"px";myContainer.style.height=Math.max(0,h)+"px"}ic.getElementById("connectorInfoContainer").style.width=w+"px"};var selectNodeByPath=function(path){var tNode=getControl().findNodeByPath(path);if(tNode!=null){tNode.expand(true);tNode.activate()}return tNode};this.focusActiveNode=function(){var tree=getControl();var node=tree.getActiveNode();if(!node){return}node.focus()};this.browseToPath=function(path){if(path.length<1){return}stopAutoExpanding();favNodeActive=null;path=fixPath(path);expandToPath(path)};this.onPathChanged=function(path){path=ic.stripRootPath(path);if(path==strCurrentPath){return}stopAutoExpanding();var tNode=getControl().findNodeByPath(path);var thePath;if(tNode){thePath=tNode.getPath();if(thePath!=path){expandToPath(path)}else{tNode.expand(true);tNode.activate(false,false);if(favNodeActive){favNodeActive.activate(false,true);favNodeActive=null}}}strCurrentPath=path};var getControl=this.getControl=function(){if(translator==undefined){return{}}return $("#foldertreecontainer").dynatree("getTree")};var fixPath=function(path){return ic.simplifyPath(path)};var onExpandPathReached=function(node,pathReached,bPathReached){var bFocus=ic.getLocationBar().hasFocus();strCurrentPath=pathReached;ic.getLocationBar().setPath(ic.getRootBrowsePath()+pathReached,true);bPathReached=true;if(favNodeActive!=null){node.expand(true);favNodeActive=null;node.activate(false,!bPathReached);ic.setBasePath(ic.getRootBrowsePath()+pathReached)}else{node.activate(false,!bPathReached)}if(bFocus){ic.getLocationBar().regainFocus();return true}};var expandToPath=this.expandToPath=function(path,dtnodeStart){var tree=getControl();tree.expandToPath(path,dtnodeStart,onExpandPathReached)};var appendSpecialNode=function(dtnode){if(dtnode.childList&&dtnode.childList.length>0){var lst=dtnode.childList;for(var i=0;i<lst.length;i++){var nd=lst[i];if(nd&&nd.data&&nd.data.connectorType){switch(nd.data.connectorType){case"TRASH":nd.data.displayTitle=translate("recycleBin");nd.data.addClass="treeNodeClassRecycle";nd.render(false,true,false);break;case"STATIC":switch(nd.data.title){case"_viewers":nd.data.displayTitle="FSI Viewer";nd.data.addClass="treeNodeClassFSIViewer";nd.render(false,true,false);break;case"_configs":nd.data.displayTitle="FSI Configs";nd.data.addClass="treeNodeClassFSIViewer";nd.render(false,true,false);break;case"_service_files":nd.data.displayTitle="Service Files";nd.render(false,true,false);break;case"_documentation":nd.data.displayTitle=translate("documentation");nd.render(false,true,false);break}break;case"STORAGE":if(nd.data.title=="_service"){nd.data.displayTitle="Service Images";nd.render(false,true,false)}break;case"DOWNLOADS":nd.data.displayTitle=translate("downloads");nd.data.addClass="treeNodeClassDownload";nd.render(false,true,false);break}}}}for(var oSpecial in oSpecialNodeData){for(var o in oSpecialNodeData[oSpecial]){addSpecialNode(oSpecial,o,false)}}var tree=getControl();var nodeFavParent=tree.getNodeByKey("favorites");if(nodeFavParent){nodeFavParent.render(true,true,false)}if(bFirstLoad){bFirstLoad=undefined;var bExpand=false;if(startPath==undefined){startPath=ic.getLastSessionPath()}if(startPath!=undefined&&startPath.length>0){var oInfo=self.getConnectorInfoByPath(startPath);if(oInfo.connectorType&&oInfo.connectorType.length>0){bExpand=true;expandToPath(startPath)}startPath=undefined}if(!bExpand){ic.setBasePath(ic.getRootBrowsePath())}}};var appendSpecialRootNodes=function(dtnode){var nodes=[{title:translate("favoritesFolder"),addClass:"treeNodeClassFav",action:"none",key:"favorites",noPath:true,hidden:true}];dtnode.append(nodes)};var onRootListLoaded=function(){bReady=true;if(!bHasConnectorInfo&&oConnectorInfoEntries!=undefined){self.updateConnectorInfo(oConnectorInfoEntries)}};this.addFavoriteCurrent=function(strSubFolderName){if(ic.getBasePathType()!="dir"){return}var path=ic.stripRootPath(ic.getBasePath());if(strSubFolderName!=undefined){if(path.length>0){path+="/"}path+=strSubFolderName}if(path.length<2){return}if(oSpecialNodeData.favorites[path]){var tree=getControl();var nodeFavParent=tree.getNodeByKey("favorites");var existingNode;if(nodeFavParent){existingNode=nodeFavParent.getChildByTitle(path)}if(existingNode){existingNode.activate(false,true);nodeFavParent.focus();existingNode.focus()}return}addSpecialNode("favorites",path,true);oSpecialNodeData.favorites[path]=1;saveData()};var addFavoriteFromTreeNode=function(dtnode){if(!dtnode){return}var path=dtnode.getPath();if(oSpecialNodeData.favorites[path]){var tree=getControl();var nodeFavParent=tree.getNodeByKey("favorites");var existingNode;if(nodeFavParent){existingNode=nodeFavParent.getChildByTitle(path)}if(existingNode){existingNode.activate(false,true);nodeFavParent.focus();existingNode.focus()}return}addSpecialNode("favorites",path,true);oSpecialNodeData.favorites[path]=1;saveData()};var addSpecialNode=function(strParentID,path,bRender){var tree=getControl();var nodeFavParent=tree.getNodeByKey(strParentID);if(!nodeFavParent){return}var favData;switch(strParentID){case"favorites":favData={title:path,action:"favorite",isFolder:false};break}var newNode=nodeFavParent._addNode(favData,!bRender);if(bRender){newNode.makeVisible();newNode.activate(false,true);nodeFavParent.focus();newNode.focus()}};var onAfterAjaxRead=function(dtnode){if(dtnode.bRefreshed){delete dtnode.bRefreshed;if(dtnode.childList==null){delete dtnode.data.isLazy;dtnode.render()}}if(ic.getLocationBar().hasFocus()){if(!getControl().isAutoExpanding()){ic.getLocationBar().autoCompleteAfterLoad(dtnode)}}if(curDropTargetEL!=undefined&&curDropTargetEL==dtnode.span){$(curDropTargetEL).addClass("currentDropTargetTree")}connectorInfoHeight=parseInt(ic.calcObjDim(document.getElementById("folderTree_connectorInfo")).height)+1};var stopAutoExpanding=function(){var tree=getControl();tree.stopAutoExpanding()};var onLoadError=function(dtnode){dtnode.data.loadFailed=true;ic.getLocationBar().onLoadError(dtnode);if(ic.getBasePath()==undefined){ic.setBasePath(ic.getRootBrowsePath())}};this.regainFocus=function(){if(contextMenuFocusNode&&contextMenuFocusNode.span){try{contextMenuFocusNode.span.getElementsByTagName("a")[0].focus()}catch(e){}if(!getControl().tnFocused&&contextMenuFocusNode.parent){contextMenuFocusNode.parent.span.getElementsByTagName("a")[0].focus()}if(!getControl().tnFocused){self.setTheFocus()}}else{self.setTheFocus()}};var onCloseContextMenu=function(elMenu){if(!ic.isLocked()){self.regainFocus()}};var onBeforeContextMenu=function(elMenu,event){var tree=getControl();var node=getContextMenuNode();if(!node){return}contextMenuFocusNode=node;var isTrash=(node.data.connectorType=="TRASH");var arToEnable=[];var arToDisable=[];var oEnable={};var enable=function(keys,bEnable){keys=keys.split(",");for(var i=0;i<keys.length;i++){oEnable[keys[i]]=bEnable}};var isRoot=node.data.connectorType=="ROOT";var isRootChild=(node.parent&&node.parent.data.key=="root");if(isRootChild&&node.data.action&&node.data.key=="favorites"){enable("delete,refreshall,collapseall",true);enable("rename,createfolder,createfav,refreshfolder",false)}else{var cn=node.getConnectorNode();if(!cn||!cn.data){return}var nfo=self.getConnectorInfoByName(cn.data.title);if(!nfo){return}var permWrite={};var permRead={};if(nfo.permissions){if(nfo.permissions.write){permWrite=nfo.permissions.write}if(nfo.permissions.read){permRead=nfo.permissions.read}}enable("createfav,refreshfolder",true);enable("rename",!isRootChild&&permWrite.rename);enable("delete",!isRootChild&&permWrite["delete"]);enable("createfolder",permWrite.createDirectory)}for(var o in oEnable){if(oEnable[o]){arToEnable.push("#"+o)}else{arToDisable.push("#"+o)}}if(arToDisable.length>0){$(elMenu).disableContextMenuItems(arToDisable.join(","))}if(arToEnable.length>0){$(elMenu).enableContextMenuItems(arToEnable.join(","))}var enabledVisibleItems=$("#contextmenu_foldertree").find('LI:not([style*="none"]):not(.disabled)');var ret=(enabledVisibleItems.length>0);return ret};var getContextMenuNode=function(){var tree=getControl();var node=tree.tnFocused;if(!node){node=tree.getActiveNode()}return node};var handleContextMenuAction=function(action,el,pos){if(!action){return}var i=action.indexOf("#");if(i!=-1){action=action.substr(i+1)}var tree=getControl();var node=contextMenuFocusNode;if(!node){return}switch(action){case"delete":deleteNode(node);break;case"reimportselected":ic.askReimportSelectedFromTree(node,node.getPath(),node.data.title);break;case"refreshall":self.reloadAll();break;case"refreshfolder":reloadNode(node,false);break;case"rename":ic.askRenameSelectedFromTree(node,tree,node.getPath(),node.data.title);break;case"collapseall":self.collapseAll();break;case"createfav":addFavoriteFromTreeNode(node);break;case"createfolder":ic.askCreateDirectoryFromTree(node);break}};this.setTabFocus=function(){if(strActiveSection=="folderTree_TreeContainer"){self.setTheFocus()}else{ic.getSearchCTL().setFocus()}};this.setTheFocus=function(){var tree=getControl();if(!tree||!tree.getActiveNode){return}var node=tree.getActiveNode();if(!node){node=tree.getRoot()}if(node){node.focus()}};var deleteNode=function(node){if(!node){return}switch(node.data.key){case"root":break;case"favorites":deleteSpecialNodesFrom(node.data.key);break;default:switch(node.data.action){case"favorite":deleteSpecialNode(node);break;default:ic.askDeleteSelectedFromTree(node,node.getPath(),node.data.title,getControl());break}}};this.deleteSelectedNode=function(){var tree=getControl();var node=tree.getActiveNode();if(!node){return}deleteNode(node)};var deleteSpecialNode=function(node){if(!node){return}if(!node||node.data.action==undefined){node=favNodeActive;if(!node){return}}var tree=getControl();var bIsActiveNode=(node==tree.getActiveNode());var bChanged=false;switch(node.data.action){case"favorite":var path=node.data.title;if(oSpecialNodeData.favorites[path]){bChanged=true;delete oSpecialNodeData.favorites[path]}if(bIsActiveNode){activatePreviousSiblingOrParent(node,true,false)}node.remove();break}if(bChanged){saveData()}};var activatePreviousSiblingOrParent=function(node,bByUser,bNoCallback){if(!node){return}var prevSibling=node.prevSibling();if(prevSibling){prevSibling.activate(bByUser,bNoCallback);return}if(node.parent){node.parent.activate(bByUser,bNoCallback);return}};var deleteSpecialNodesFrom=function(strNodeKey){var oSpecialData=oSpecialNodeData[strNodeKey];if(!oSpecialData){return}var tree=getControl();var nodeParent=tree.getNodeByKey(strNodeKey);if(!nodeParent){return}oSpecialNodeData[strNodeKey]={};nodeParent.removeChildren();saveData()};var createContextMenu=function(){var cmComponent=ic.getComponents().getComponent("contextmenus");var menuComponent=$(cmComponent).find("#contextmenu_foldertree").get(0);var bodyID=ic.getDocumentBody();if(!menuComponent||!bodyID){return}var myMenu=menuComponent;bodyID.appendChild(myMenu);var myContextMenu=$("#folderTree_TreeContainer").contextMenu({menu:"contextmenu_foldertree",inSpeed:-1,outSpeed:250},handleContextMenuAction,onBeforeContextMenu,onCloseContextMenu)};var setMousePosContextMenuEvent=function(e){e.pageX=ic.getSplitterPos();e.pageY=ic.getViewportOffsetTop()};var readData=function(){oSpecialNodeData=ic.getInterfacePref("Favorites");if(oSpecialNodeData==undefined){oSpecialNodeData={}}if(oSpecialNodeData.favorites==undefined){oSpecialNodeData.favorites={}}};var saveData=function(){ic.setInterfacePref("Favorites",oSpecialNodeData)};var activateFolderTab=this.activateFolderTab=function(e,bNoSetPath){if(elActiveElementID!="#folderTree_TreeContainer"){self.activateSection($("#folderTree_FolderTab").get(0),"folderTree_TreeContainer",bNoSetPath)}};var checkConnectorChange=this.checkConnectorChange=function(dtnode){var np=dtnode.getConnectorNode();if(np!=undefined&&np.data!=undefined&&np.data.connectorType!=undefined){oConnectorNodes[np.data.title]=np;var nTotalItems=np.data.connectorTotalContent;ic.checkConnectorChange(np.data.connectorType,np.data.title,nTotalItems)}};var updateConnectorInfo=this.updateConnectorInfo=function(entries){if(!entries||!entries.length){return}oConnectorInfoEntries=entries;if(!bReady){return}bHasConnectorInfo=true;var nOverallFiles=0;var nOverallFilesVisible=0;oConnectorInfoCache={};for(var i=0;i<entries.length;i++){var itm=entries[i];var node=self.getConnectorNodeByName(itm.title);var nImages=parseInt(itm.connectorTotalContent);if(!isNaN(nImages)){if(!node||!node.data){ffDump("No data for: "+itm.title)}else{if(node.data.permissions.read.totalAssetsCount){nOverallFilesVisible+=nImages}}nOverallFiles+=nImages}if(node){node.data.__canDropOnConnector=undefined;if(node.data.connectorTotalContent!=itm.connectorTotalContent){node.data.connectorTotalContent=itm.connectorTotalContent;if(node.data.title==ic.getCurrentConnectorName()){ic.refreshCurrentConnectorInfo();ic.updateConnectorContentInfo()}}}else{ffDump("updateConnectorInfo: "+itm.title+" not found")}}if(ic.getCurrentConnectorType()=="ROOT"){if(oTotalFiles.nOverallFilesVisible!=nOverallFilesVisible||oTotalFiles.nOverallFiles!=nOverallFiles){oTotalFiles.nOverallFilesVisible=nOverallFilesVisible;oTotalFiles.nOverallFiles=nOverallFiles;ic.refreshCurrentConnectorInfo();ic.updateConnectorContentInfo()}}else{oTotalFiles.nOverallFilesVisible=nOverallFilesVisible;oTotalFiles.nOverallFiles=nOverallFiles}};var showRestrictionIconHelp=function(){var id=$(this).attr("id");ic.showHelpSection("#2")};var setImageTitle=function(id,str){$("#"+id).attr("title",str).attr("alt",str).click(showRestrictionIconHelp)};var initTree=function(){translator=ic.getTranslator();readData();urlListRequest=ic.getBaseServerURL()+"?type=list&tpl=interface_treeview_directories.json&typefilter=directory";urlListRequest=ic.appendHeaderParam(urlListRequest,"list");addEvent($("#folderTree_FolderTab").get(0),"dragenter",activateFolderTab);var el=document.getElementById("foldertreecontainer");ic.makeDropTarget(el,"copyMove",onDragDrop,onDragOver,canDrop);addEvent(el,"keydown",keyDownListener);connectorInfoHeight=parseInt(ic.calcObjDim(document.getElementById("folderTree_connectorInfo")).height)+1;$(function(){$("#foldertreecontainer").dynatree({oRootNode:oRootNode,rootVisible:true,persist:false,autoCollapse:false,autoFocus:false,autoGetFocus:function(){return(!ic.getThumbView().isFocussed()&&!ic.getLocationBar().hasFocus())},fx:null,debugLevel:0,ajaxDefaults:{cache:true,dataType:"json",ifModified:false},initAjax:{url:urlListRequest,data:{source:ic.getRootBrowsePath()},beforeSuccessHandler:function(dtnode){appendSpecialRootNodes(dtnode)},afterSuccessHandler:function(dtnode){oConnectorNodes=new Object();if(dtnode.data.key=="root"){appendSpecialNode(dtnode)}onRootListLoaded()}},strings:{loading:"Loading...",loadError:"error loading content"},onBeforeFocus:function(dtnode){return false;bReturnFocus=ic.getLocationBar().hasFocus();return false},onAfterFocus:function(dtnode){},onActivate:function(dtnode,bByUser){if(bByUser){stopAutoExpanding()}if(!dtnode||!dtnode.data||!dtnode.data.key){return}checkConnectorChange(dtnode);if(bByUser){favNodeActive=null}switch(dtnode.data.action){case"none":break;case"favorite":if(bByUser){favNodeActive=dtnode;expandToPath(dtnode.data.title)}break;default:var nodePath=dtnode.getPath();strCurrentPath=nodePath;if(nodePath!=null){ic.setBasePath(ic.getRootBrowsePath()+nodePath)}}},onExpand:function(span,bExpand,dtnode){if(curDropTargetEL!=undefined&&curDropTargetEL==this){$(curDropTargetEL).addClass("currentDropTargetTree")}},onLazyRead:function(dtnode){var nodePath=dtnode.getPath();dtnode.appendAjax({url:urlListRequest,data:{source:ic.getRootBrowsePath()+nodePath},success:function(dtnode){onAfterAjaxRead(dtnode)},error:function(dtnode,XMLHttpRequest,textStatus,errorThrown){onLoadError(dtnode)}})}})});createContextMenu()};var onDragDrop=function(el,event){if(curDropTargetEL==undefined){return}var itm=curDropTargetEL.treeitem;if(itm==undefined){return}var connectorNode=itm.getConnectorNode();var bToTrash=false;if(connectorNode&&connectorNode.data&&connectorNode.data.connectorType){if(connectorNode.data.connectorType=="TRASH"){return ic.handleFolderDrop(itm.getPath(),event,"delete")}}ic.handleFolderDrop(itm.getPath(),event)};this.onAfterCopyMove=function(targetPath){var tree=getControl();var dtnode=tree.findNodeByPath(targetPath);if(dtnode==undefined||dtnode.data==undefined){return}dtnode.data.isLazy=true;reloadNode(dtnode)};var findDataNode=function(el){var n=10;var res;if(!el||!el.tagName){return}if(el.tagName=="DIV"){el=el.firstChild;while(el&&n>0){if(el.treeitem!=undefined){return el}el=el.firstChild;n--}return}while(el&&n>0){if(el.treeitem!=undefined){return el}el=el.parentNode;n--}};var onDragOver=function(elControl,event,bOver){var el=event.srcElement;if(el==undefined){el=event.originalTarget}if(!bOver){if(curDropTargetEL!=undefined){$(curDropTargetEL).removeClass("currentDropTargetTree");curElDropTreeItem=curDropTargetEL=curDropTargetSrcEL=undefined;nDropOpenCount=0}return false}if(curDropTargetSrcEL==el){nDropOpenCount++;if(nDropOpenCount==30){var itm=curDropTargetEL.treeitem;if(itm&&itm.data&&itm.data.isFolder){itm.expand(true)}}return curDropTargetELCanDrop}$(curDropTargetEL).removeClass("currentDropTargetTree");var elItem=findDataNode(el);if(elItem==undefined){curElDropTreeItem=curDropTargetEL=curDropTargetSrcEL=undefined;nDropOpenCount=0;return false}curElDropTreeItem=elItem.treeitem;curDropTargetSrcEL=el;curDropTargetEL=elItem;curDropTargetELCanDrop=canDrop(curDropTargetEL,event);if(curDropTargetELCanDrop){$(curDropTargetEL).addClass("currentDropTargetTree")}return curDropTargetELCanDrop};var canDrop=function(el,event){if(curElDropTreeItem==undefined){return false}var oDragInfo=ic.getThumbView().getDragInfo();if(!oDragInfo&&!browser.fileAPI){return false}var connector=curElDropTreeItem.getConnectorNode();return canDropOnConnector(connector,oDragInfo)};var canDropOnConnector=function(dtNodeConnector,oDragInfo){if(dtNodeConnector==undefined||dtNodeConnector.data==undefined){return false}var data=dtNodeConnector.data;var nfo;var sourceWritePerms={};var bSourceMayDrag=true;if(oDragInfo){if(oDragInfo.oConnectorInfo&&oDragInfo.oConnectorInfo.permissions&&oDragInfo.oConnectorInfo.permissions.write){sourceWritePerms=oDragInfo.oConnectorInfo.permissions.write}switch(data.connectorType){case"TRASH":bSourceMayDrag=(oDragInfo.oConnectorInfo.connectorName!="TRASH"&&sourceWritePerms["delete"]===true||sourceWritePerms.recycle===true);break;case"STORAGE":case"STATIC":case"MULTIRESOLUTION":nfo=self.getConnectorInfoByName(data.title);if(oDragInfo.mode!=="copy"){if(oDragInfo.oConnectorInfo.connectorName==nfo.connectorName){bSourceMayDrag=sourceWritePerms.moveWithinConnector}else{bSourceMayDrag=sourceWritePerms["delete"]}}break;default:bSourceMayDrag=false;break}}if(data.__canDropOnConnector!=undefined){return(data.__canDropOnConnector&&bSourceMayDrag)}data.__canDropOnConnector=false;nfo=self.getConnectorInfoByName(data.title);switch(data.connectorType){case"ROOT":data.__canDropOnConnector=false;break;case"TRASH":data.__canDropOnConnector=true;break;case"DOWNLOADS":data.__canDropOnConnector=false;break;default:if(nfo.permissions&&nfo.permissions.write&&(nfo.permissions.write.paste||nfo.permissions.write.upload||nfo.permissions.write.moveWithinConnector)){data.__canDropOnConnector=true}}return(data.__canDropOnConnector&&bSourceMayDrag)};this.onAfterUserResize=function(){var n=ic.getSplitterPos();if(n==0){return}nLastSplitterPos=n};this.toggleShow=function(){if(!ic.canTreeBeShown()){return}if(ic.getSplitterPos()<ic.getSashTreeMin()){ic.setSplitterPos(nLastSplitterPos)}else{ic.setSplitterPos(0)}ic.saveSplitterPos(true)};this.onHSplitterDBLClick=function(){self.toggleShow()};this.activateSectionByName=function(sectionName,bNoSetPath){var idTab,strSection;switch(sectionName){case"search":idTab="folderTree_SearchTab";strSection="folderTree_SearchContainer";break;default:idTab="folderTree_FolderTab";strSection="folderTree_TreeContainer"}var el=ic.getElementById(idTab);if(strActiveSection==strSection){return}if(el){self.activateSection(el,strSection,bNoSetPath)}};this.enableSearchTab=function(bEnable){if(bSearchTabEnabled==bEnable){return}bSearchTabEnabled=bEnable;if(!bEnable){activateFolderTab();$("#folderTree_SearchTab").hide()}else{$("#folderTree_SearchTab").show()}};this.activateSection=function(el,strSection,bNoSetPath){if(strActiveSection==strSection){return}if(!bSearchTabEnabled&&strSection=="folderTree_SearchContainer"){return}strActiveSection=strSection;if(elActiveCurrent){$(elActiveCurrent).removeClass("active");$(elActiveElementID).hide()}elActiveCurrent=$(el);elActiveElementID="#"+strSection;$(elActiveCurrent).addClass("active");$(elActiveElementID).show();var searchCTL=ic.getSearchCTL();if(strSection=="folderTree_SearchContainer"&&searchCTL){ic.getThumbView().reset();ic.getScrollControl().reset();ic.checkConnectorChange("SEARCH","search");if(!bNoSetPath){searchCTL.startSearch()}if(searchCTL&&searchCTL.setActive){searchCTL.setActive(true);addEvent(el,"mouseup",setSearchFocus,false)}}else{if(searchCTL&&searchCTL.setActive){searchCTL.setActive(false)}var tree=getControl();if(tree&&tree.getActiveNode){var node=tree.getActiveNode();if(node){checkConnectorChange(node);if(!bNoSetPath){ic.setBasePath(ic.getRootBrowsePath()+strCurrentPath)}}}self.setTheFocus()}};var setSearchFocus=function(){removeEvent(this,"mouseup",setSearchFocus,false);var searchCTL=ic.getSearchCTL();if(searchCTL&&searchCTL.setFocus){searchCTL.setFocus()}};var keyDownListener=function(evt){var keycode=evt.keyCode|evt.which;if(keycode==9){if(!evt.shiftKey){if(evt.preventDefault){evt.preventDefault()}ic.getThumbView().setTheFocus();return false}else{if(getControl().tnFocused!=getControl().tnRoot){if(evt.preventDefault){evt.preventDefault()}getControl().tnRoot.focus();return false}}}};var buildSearchQuery=function(strSearchValue){return ic.getSearchURLPrefix()+encodeURIComponent(strSearchValue)};this.onSearchQuery=function(strSearchValue){var tree=getControl();var query=buildSearchQuery(strSearchValue);ic.setBasePath(query,"search");strLastSearchQuery=query};self.activateSection(ic.getElementById("folderTree_FolderTab"),"folderTree_TreeContainer");initTree()};