/*!
 * FSI Server Interface
 * http://www.fsi-viewer.com
 *
 * Copyright (C) 2000-2016 NeptuneLabs GmbH - All rights reserved.
 *
 * Version: 3.0.0
 */
;function ThumbView(interfaceControl){var self=this;var ic=interfaceControl;var translator=ic.getTranslator();var scrollControl;var baseServerURL=ic.getBaseServerURL();var viewDim;var itemWidth=100;var itemHeight=100;var thumbMargin;var thumbRowSpacing=18;var thumbColumnSpacing=6;var labelHeight=20;var menuHeight=34;var thumbSizeFX=0.91;var thumbSizeFY=0.68;var virtualPos=0;var thumbsX=0,thumbsY=0,newThumbsX=0,newThumbsY=0,realRowHeight=0;var nLoadDirContentChunkSize=2000;var selcountCMDLast=undefined;var canvasOffsetTop=0;var listRowHeight;var currentThumbSize;var bConnectorDropAllow=false;var bConnectorDropWithinFolderAllow=false;var bConnectorUploadDropAllow=false;var bNoDropAllow=false;var imageListBase,imageCount,directoryCount,completeCount,lastModified;var entryCount;var imageList;var lastStatusBarSelectedCount;var buildThumbContainer;var buildThumb;var getEntryLabel;var seedThumb;var redrawTimer;var redrawLock=false;var strMostRecentRequest;var lastLoadedListStartIndex;var timeoutSelectChunk;var sortField;var sortOrder;var bUpdatePictureviewAfterListLoad;var bConnectorReadRenderedImage;var defaultViewPropertiesByConnectorType={ROOT:{viewMode:"thumb"},STATIC:{viewMode:"list"},TRASH:{viewMode:"list",sortField:"DELETEDATE",sortOrder:"desc"},DOWNLOADS:{viewMode:"list",sortField:"LASTMODIFIED",sortOrder:"desc"},MULTIRESOLUTION:{viewMode:"thumb"},STORAGE:{viewMode:"thumb"},DEFAULT:{viewMode:"thumb",sortField:"FILENAME",sortOrder:"asc"}};var viewMode;var oViewPropertiesByConnector={};var currentConnectorType;var currentConnectorName;var nViewMode=0;var viewModeThumbs=0;var viewModeCatalog=1;var viewModeList=2;var oSelection;var oSelectionElementLast;var oSelectionElementLastShift;var strVisibleRange;var lastMatrixUpdateX,lastMatrixUpdateY;var browsePath;var oLastMarkSelectionRange;var bBlockNextMouseUp;var bLastCTRLSelectWasSelect;var oSelectionElementLastDeselected;var myFocusElement;var thumbMatrix;var thumbXOffsets,thumbYOffsets;var typeFilter="";var maxThumbPadding={};var viewPortStats={};var oCurrentFillRange={};var nVisibleThumbs;var thumbBody;var thumbBodyFake;var nStartIndexFillThumbs=0;var oFirstImageEntry;var dataOffset;var basePathType;var chunkLoadProgressDiv;var dataArray;var bDataAvailable;var oSummary;var thumbDivReg;var oToolTipData={};var toolTipOffsetX;var oClipboard;var hasFocus=false;var bHideLoadingImages=false;this.listLoadProps=undefined;var strLastListMessage;this.bMouseOverThumb=false;var bToolTipsLocked=false;var bNewContent;var curDropTargetEL,curDropTargetELThumb,curDropTargetELThumbEntry;var curDropTargetELCanDrop;var oDragInfo;var fileUploadCTL;var isRootDir;var oFirstSelectedThumb;var myContextMenu;var oFileListRoot;var oFileListDefault;var oFileListNoStatus;var oFileListTrash;var oFileListDownload;var oCurrentTextList;var strImageTableClass;var bVisibleFocusUpdateLocked=false;var strListTemplate="interface_thumbview_default.json";var bUpdateFirstSelectedThumbMulti;var bContentVisible=true;var oCursor={};var oItemWatch={};oItemWatch.nItems=0;oItemWatch.bDirty=false;oItemWatch.nLockCount=0;oItemWatch.bLocked=true;oItemWatch.nUpdateTime=3000;oItemWatch.nWatchID=0;var oWatchedItems={};var bValidateTreeAfterReload=false;var strHeaderQueryList,strHeaderQueryNoCache,strHeaderQueryImage;var nResetID=0;var checkThumbNeedsWatching;var getFirstImageEntryForDir_Key,getFirstImageEntryForDir_Content,getFirstImageEntryForDir_Entry;var oFirstImageCache={};var strFirstSelectedThumbFullsrc;var entryOnHideContent;var bAddImageNotDraggable=(browser.isIE&&!browser.bDragImageOnly);var bMouseDownOnThumb=false;var thumbMaxSizeX,thumbMaxSizeY;var bMixedSourceConnectors=false;var oConnectorInfo={};var timeoutUpdateViewPortStats;this.isContentVisible=function(){return bContentVisible};this.showContent=function(bShow){if(bShow==bContentVisible){return bContentVisible}if(bShow){bContentVisible=bShow;$("#thumbcanvastr").removeClass("hidecontent");$("#thumbCanvas").show();$("#superIDcontentMenu").show();self.rearrangeThumbview(false);scrollControl.setThumbViewState(thumbsX,thumbsY,realRowHeight);if(entryOnHideContent){this.scrollToEntry(entryOnHideContent)}entryOnHideContent=undefined}else{var n=nStartIndexFillThumbs;var entry;if(imageList&&n>-1&&n<imageList.length){entry=imageList[n]}entryOnHideContent=entry;$("#thumbCanvas").hide();$("#superIDcontentMenu").hide();scrollControl.showScroller(false);onLooseFocus();$("#thumbcanvastr").addClass("hidecontent");bContentVisible=bShow}self.onVisibleRangeChanged();return bContentVisible};var isFocussed=this.isFocussed=function(){return hasFocus};var getFocus=this.getFocus=function(){try{myFocusElement.focus()}catch(e){}};var onGetFocus=function(){if(!bContentVisible){return}if(!bVisibleFocusUpdateLocked&&bContentVisible){$("#thumbcanvastr").addClass("focussed")}hasFocus=true};var onLooseFocus=function(){if(!bVisibleFocusUpdateLocked&&$("#contextmenu_thumbview").is(":hidden")){$("#thumbcanvastr").removeClass("focussed")}hasFocus=false};var onLooseFocusByElement=function(evt){onLooseFocus()};this.init=function(initialViewMode,initialSortField,initialSortOrder){strHeaderQueryList=ic.appendHeaderParam("","list");strHeaderQueryNoCache=ic.appendHeaderParam("","nocache");strHeaderQueryImage=ic.appendHeaderParam("","image");checkThumbNeedsWatching=doNothing;resetCursor();viewMode=(initialViewMode!=undefined)?initialViewMode:"thumb";sortField=(initialSortField!=undefined)?initialSortField:"FILENAME";updateSortFieldSelect();sortOrder=(initialSortOrder!=undefined)?initialSortOrder:"asc";if(sortOrder=="desc"){toggleSortOrderArrow()}initTextLists();fileUploadCTL=ic.getFileUploadCTL();bHideLoadingImages=true;if(!browser.isIE){$("#thumbInnerCanvas").css("table-layout","fixed")}myFocusElement=ic.getElementById("thumbViewFocusElement");myFocusElement.onfocus=onGetFocus;myFocusElement.onblur=onLooseFocusByElement;scrollControl=ic.getScrollControl();oSelection=new ItemSelection();thumbBody=ic.getElementById("thumbbody");createContextMenu();if(thumbBody&&thumbBody.lastChild){removeChildSafe(thumbBody.lastChild)}setViewModeParameters();dataOffset=0;resetDataArray(0,0);self.invalidateFillRange();toolTipOffsetX=(browser.isIE)?0:2;if(browser.dragSupport){addEvent(thumbBody,"dragstart",onDragStart);addEvent(thumbBody,"dragend",onDragEnd);ic.makeDropTarget(ic.getElementById("thumbCanvas"),"copyMove",onThumbDropOnDir,thumbDropMouseHandler,canDrop)}if(!browser.touchDevice){addEvent(thumbBody,"click",setTheFocus)}addEvent(thumbBody,"mousedown",onCanvasMouseDown);addEvent(thumbBody,"mouseup",onCanvasMouseUp);var hitEvent;if(browser.touchDevice){hitEvent="click"}else{hitEvent="dblclick"}addEvent(thumbBody,hitEvent,onCanvasDoubleClick);setTheFocus()};var onCanvasMouseDown=function(evt){self.setTheFocus();bVisibleFocusUpdateLocked=true;var el=evt.srcElement;if(el==undefined){el=evt.originalTarget}var elSrc=el;el=self.getThumbTableFromEventElement(el);var button=ic.getEventButton(evt);resetCursorPos();if(!ic.getShiftKey(evt)&&el){thumbPress(evt,el)}else{if(button==1&&!ic.getCTRLKey(evt)&&!ic.getShiftKey(evt)){selectNone()}}evt.FSILETPASS=true;var bDrag=true;if(nViewMode==viewModeList){if(browser.bDragImageOnly){bDrag=false}else{bDrag=($(elSrc).attr("draggable")=="true")}}if(!el){bMouseDownOnThumb=false}else{bMouseDownOnThumb=true}if(!bDrag||!el){ic.doThumbSelectionStart(evt)}};var onCanvasMouseUp=function(evt){bVisibleFocusUpdateLocked=false;if(!bMouseDownOnThumb||ic.getEventButton(evt)!=1){return}bMouseDownOnThumb=false;if(!$("#thumbSelector").is(":hidden")){$("#thumbSelector").hide();return}var el=evt.srcElement;if(el==undefined){el=evt.originalTarget}el=self.getThumbTableFromEventElement(el);if(!el){return}if(oSelection.isMulti()){if(!ic.getShiftKey(evt)&&!ic.getCTRLKey(evt)){selectNone();thumbPress(evt,el)}}if(ic.getShiftKey(evt)&&el){thumbPress(evt,el)}return false};var onCanvasDoubleClick=function(evt){var el=evt.srcElement;if(el==undefined){el=evt.originalTarget}var elSrc=el;el=self.getThumbTableFromEventElement(el);if(!el||el.listEntry==undefined||el.listEntryIndex==undefined){return false}doubleClickOnThumb(el,elSrc);return false};var getEntryFromListEntryIndex=function(index){var entry;index-=dataOffset;if(index>-1&&index<imageList.length){entry=imageList[index]}return entry};this.getConnectorInfoForEntry=function(entry){if(!entry){return}getImagePath(entry);var src=decodeURIComponent(entry.fullsrc).split("/")[0];var info=ic.getFolderTree().getConnectorInfoByName(src);if(info){info.connectorName=src;return info}};var doubleClickOnThumb=function(el,elSrc,bSelectFirstAfterChDir){if(!el){return}if(currentConnectorType=="DOWNLOADS"){ic.downloadSelected(el);return}var clickOnLabel=false;if(elSrc&&elSrc.className=="imgtxt"){clickOnLabel=true}var entry=getEntryFromListEntryIndex(el.listEntryIndex);if(!entry){return}if(!clickOnLabel){switch(el.listEntry.type){case"directory":getImagePath(entry);var fullsrc=entry.fullsrc;ic.getFolderTree().activateFolderTab(null,true);self.enterDirectory(fullsrc);if(bSelectFirstAfterChDir){resetCursor();setCursorMoveAfterFill(0,0,0,0)}getFocus();break;default:var bOpenInWindow=false;var connectorName;if(currentConnectorType=="STATIC"){bOpenInWindow=true;connectorName=ic.getCurrentConnectorName()}else{if(currentConnectorType=="SEARCH"){var info=self.getConnectorInfoForEntry(entry);if(info&&info.connectorType=="STATIC"){bOpenInWindow=true;connectorName=info.connectorName}}}if(bOpenInWindow){openStaticEntryInNewWindow(entry,connectorName);return}bShowTab=!(elSrc&&elSrc.className=="imgtxt");if(bShowTab){self.displayPicture(entry,true)}break}}};var openStaticEntryInNewWindow=function(entry,connectorName){if(!entry||!entry.type||entry.type!="file"){return}if(connectorName==undefined){var info=self.getConnectorInfoForEntry(entry);if(info){connectorName=info.connectorName}}var url=ic.getPictureView().getPublicURL(connectorName,decodeURIComponent(getImagePath(entry)));if(url&&url.length>0){window.open(url,"_blank")}};var onThumbPressEnter=function(){var el=$("#thumbCanvas").find(strImageTableClass+".marked").get(0);doubleClickOnThumb(el,undefined,true)};var handleLabelDblClick=function(evt){renameSelectedThumb();if(evt.stopPropagation){evt.stopPropagation()}evt.cancelBubble=true;return false};var translateEx=this.translateEx=function(key,strReplace){if(!translator){return key}return translator.translateScriptText(key,true).replace(/\[\.\.\.\]/,strReplace)};var reloadVisibleThumbs=this.reloadVisibleThumbs=function(bNoValidateTree){self.invalidateFillRange();var nItems=thumbsX*thumbsY;if(!bNoValidateTree){bValidateTreeAfterReload=true}self.retrieveThumbList(Math.max(0,scrollControl.oVisibleRange.start),nItems);if(!oSelection.isMulti()){bUpdatePictureviewAfterListLoad=true}};var ensureVisibleRangeLoaded=function(){var ret=getUnknownRange(scrollControl.oVisibleRange.start,scrollControl.oVisibleRange.end);if(ret===true){return true}var nItems=scrollControl.oVisibleRange.end-scrollControl.oVisibleRange.start+1;self.retrieveThumbList(scrollControl.oVisibleRange.start,nItems);return false};this.protectSelection=function(){oSelection.lock(true)};this.unprotectSelection=function(){oSelection.lock(false)};this.clear=function(msg){self.reset();showNoContent(true,msg)};var dumpObject=function(obj){if(!obj){return}for(var o in obj){if(typeof(obj[o])=="object"){console.log(">>> "+o);dumpObject(obj[o])}else{console.log(o+" = "+obj[o])}}};this.reset=function(){cancelItemWatching();browsePath=undefined;entryCount=imageCount=directoryCount=completeCount=0;lastModified=undefined;self.listLoadProps=ic.getListLoadProps();var strPath;if(ic.getCurrentConnectorType()!="SEARCH"){strPath=ic.getBasePath()}else{strPath="search"}var oConnectorInfo=ic.getFolderTree().getConnectorInfoByPath(strPath);bMixedSourceConnectors=oConnectorInfo._bMixedSourceConnectors;hideToolTip();oToolTipData.lastDisplayedElement=undefined;clearTimeout(timeoutSelectChunk);scrollControl.reset();bDataAvailable=false;lastModified=0;resetDataArray(0,0);selectNone();self.invalidateFillRange()};var resetDataArray=function(entryCount,lastModified){nResetID++;oFirstImageEntry=undefined;if(!bDoUseClientDirectoryCache){return}if(dataArray==undefined){dataArray=new FragmentedArray(entryCount,lastModified)}else{dataArray.clear(entryCount,lastModified)}};this.getViewPortStats=function(){return viewPortStats};var getImagePath=this.getImagePath=function(entry,strListBase){if(!entry||!entry.src){return""}if(entry.fullsrc!=undefined){return entry.fullsrc}if(strListBase==undefined){strListBase=imageListBase}entry.fullsrc=encodeURIComponent(strListBase+entry.src);return entry.fullsrc};this.changeListTo=function(newBrowsePath,limitStart,nImages,newBasePathType){bUpdatePictureviewAfterListLoad=false;self.reset();bNewContent=true;basePathType=newBasePathType;browsePath=newBrowsePath;resetCursorPos();nImages=Math.max(nImages,self.listLoadProps.nMinItems);this.retrieveThumbList(limitStart,nImages)};this.setTypeFilter=function(filter,bNoUpdate){if(typeFilter==filter){return}typeFilter=filter;selectNone();bDataAvailable=false;resetDataArray(0,0);if(!bNoUpdate){self.rearrangeThumbview(true);thumbMatrix=undefined;self.invalidateFillRange();scrollControl.oRangeLoaded.start=scrollControl.oRangeLoaded.end=-1;scrollControl.refreshLimitPos()}};this.retrieveThumbList=function(limitStart,nImages,bJustLoadData,fnCallback,fnCallbackData){if(browsePath==undefined){return}strLastListMessage=undefined;var retURL=getChunkListBaseURL();var oPassThrough={};oPassThrough.url=retURL;oPassThrough.bJustLoadData=bJustLoadData;oPassThrough.fnCallback=fnCallback;oPassThrough.fnCallbackData=fnCallbackData;var oLoadListChunkData={};oLoadListChunkData.limitStart=oLoadListChunkData.limitStartInitial=limitStart;oLoadListChunkData.nImagesTotal=oLoadListChunkData.nImages=oLoadListChunkData.nImagesTotalInitial=nImages;oLoadListChunkData.bLimitAvailable=(typeof(limitStart)!="undefined"&&typeof(nImages)!="undefined");oLoadListChunkData.chunkSize=nLoadDirContentChunkSize;oLoadListChunkData.oPassThrough=oPassThrough;oLoadListChunkData.baseURL=retURL;oLoadListChunkData.sortQuery="&sort="+sortField+"&sortorder="+sortOrder;oLoadListChunkData.lastModifiedCacheID="cache:"+basePathType+"_"+browsePath;oLoadListChunkData.nResetID=nResetID;oLoadListChunkData.bJustLoadData=bJustLoadData;ic.lockInterface(true);loadThumbListChunk(oLoadListChunkData);return oLoadListChunkData};var setCancelOperationProgress=function(percent){if(percent==undefined){return}$(chunkLoadProgressDiv).css("width",percent+"%")};var loadThumbListChunk=function(oLoadListChunkData){if(!oLoadListChunkData||!oLoadListChunkData.nImages){if(oLoadListChunkData.nImages){showNoContent(true)}ic.unlockInterface();return}oLoadListChunkData.oPassThrough.oLoadListChunkData=oLoadListChunkData;var retURL=getChunkListURL(oLoadListChunkData);strMostRecentRequest=oLoadListChunkData.oPassThrough.url=retURL;lockWatching(true);nelajax.GETJSONAsync(baseServerURL,retURL,undefined,onListDataLoaded,oLoadListChunkData.oPassThrough)};var getChunkListBaseURL=function(){var retURL;if(browsePath.indexOf("type=")==-1){retURL="source="+encodeURIComponent(browsePath);retURL+="&type=list"}else{retURL=browsePath}retURL+="&tpl="+strListTemplate+strHeaderQueryList;return retURL};var getChunkListURL=function(oLoadListChunkData){var retURL=oLoadListChunkData.baseURL;if(!oLoadListChunkData.bLoadInOneBlock&&bDoUseClientDirectoryCache&&oLoadListChunkData.bLimitAvailable&&oLoadListChunkData.nImagesTotal>oLoadListChunkData.chunkSize){oLoadListChunkData.bDone=false;oLoadListChunkData.nImages=oLoadListChunkData.chunkSize;retURL+="&limit="+oLoadListChunkData.limitStart+","+oLoadListChunkData.nImages}else{oLoadListChunkData.bDone=true;if(oLoadListChunkData.bLimitAvailable){retURL+="&limit="+oLoadListChunkData.limitStart+","+oLoadListChunkData.nImages}}if(typeFilter&&typeFilter!=""){retURL+="&typefilter="+typeFilter}if(oLoadListChunkData.sortQuery){retURL+=oLoadListChunkData.sortQuery}return retURL};var loadNextThumbListChunk=function(oLoadListChunkData,nLoadedDataSets){if(oLoadListChunkData.bCanceled==true){return}oLoadListChunkData.limitStart+=nLoadedDataSets;oLoadListChunkData.nImagesTotal-=nLoadedDataSets;oLoadListChunkData.nImages=Math.min(oLoadListChunkData.chunkSize,oLoadListChunkData.nImagesTotal);var progress=100-oLoadListChunkData.nImagesTotal/oLoadListChunkData.nImagesTotalInitial*100;setCancelOperationProgress(progress);loadThumbListChunk(oLoadListChunkData)};var onListDataLoaded=function(responseObj){if(!responseObj){return}var bReCheckVisibleRangeLoaded;var oDataPassed;var bContentChanged=false;var bReceivedOK=false;var bOutdated=false;var strError;if(responseObj&&responseObj.oDataPassThrough){oDataPassed=responseObj.oDataPassThrough;if(oDataPassed.url&&oDataPassed.url!=strMostRecentRequest){bOutdated=true;if(!bDoUseClientDirectoryCache||nResetID!=oDataPassed.oLoadListChunkData.nResetID){return}}}var loadedImageList=[];var oRoot;if((responseObj.status==200||responseObj.status==304)&&responseObj.response){try{oRoot=JSON.parse(responseObj.response);bReceivedOK=true}catch(e){console.error("JSON error on retrieving image list: "+e.message)}if(bReceivedOK){oSummary=oRoot.summary;loadedImageList=oRoot.entries;strLastListMessage=oSummary.message;loadedImageList.pop();bDataAvailable=true;imageListBase=ic.simplifyPath(oSummary.dir);if(!imageListBase){imageListBase=""}else{if(imageListBase.length>0){imageListBase+="/"}}entryCount=oSummary.entryCount;imageCount=oSummary.imageCount;directoryCount=oSummary.directoryCount;completeCount=oSummary.completeCount;lastModified=oSummary.lastModified;var limitStart=oDataPassed.oLoadListChunkData.limitStart;var n=limitStart;for(var i=0;i<loadedImageList.length;i++){loadedImageList[i].absoluteid=n++}isRootDir=(ic.getBasePath()==""||ic.getBasePath()=="/")?true:false;if(bDoUseClientDirectoryCache&&oDataPassed&&!oDataPassed.bJustLoadData){if(dataArray.getLastModified()!=lastModified||dataArray.getSize()!=entryCount){var bItemCountNotAsExpected;bItemCountNotAsExpected=(loadedImageList.length<oDataPassed.oLoadListChunkData.nImages&&(oDataPassed.oLoadListChunkData.limitStart+loadedImageList.length)<entryCount);if(bItemCountNotAsExpected){ffDump("ERROR: Thumbview: Received item count does not match request count: "+loadedImageList.length+" / "+oDataPassed.oLoadListChunkData.nImages+" total: "+entryCount)}if(!bItemCountNotAsExpected){resetDataArray(entryCount,lastModified);var nEnd=limitStart+loadedImageList.length-1;scrollControl.setLoadedDataStats(limitStart,nEnd,entryCount);scrollControl.setThumbViewState(thumbsX,thumbsY,realRowHeight,true);bReCheckVisibleRangeLoaded=true}}}if((!oDataPassed||!oDataPassed.bJustLoadData)&&ic.getStatusBarControl){viewPortStats.filesTotal=imageCount;viewPortStats.directoriesTotal=directoryCount;updateViewPortStats();ic.getStatusBarControl().setFolderStats(imageCount,directoryCount,completeCount,lastModified,oSelection.getCount(),strVisibleRange)}if(bValidateTreeAfterReload){bValidateTreeAfterReload=false;ic.getFolderTree().checkSubdirectoryCount(oSummary.directoryCount)}}}else{try{console.error("Failed loading list data: HTTP "+responseObj.status);strError="ERROR: HTTP "+responseObj.status}catch(e){}try{var o=JSON.parse(responseObj.response);if(o&&o.cause){strError="ERROR: "+o.cause}}catch(e){console.error("JSON error on retrieving image list: "+e.message)}}if(!bReceivedOK){if(!bDataAvailable){entryCount=imageCount=directoryCount=completeCount=0;lastModified=undefined;ic.getStatusBarControl().setFolderStats(imageCount,directoryCount,completeCount,lastModified,oSelection.getCount(),strVisibleRange)}}var nLoadedDataSets=loadedImageList.length;var nEnd=oDataPassed.oLoadListChunkData.limitStart+nLoadedDataSets-1;if(bDoUseClientDirectoryCache){if(bReceivedOK&&nEnd>-1){dataArray.addRange(loadedImageList,oDataPassed.oLoadListChunkData.limitStart,nEnd);dataArray.defragRanges()}if(!bOutdated){imageList=dataArray.getData()}if(oDataPassed.oLoadListChunkData!=undefined){if(nLoadedDataSets>0&&!oDataPassed.oLoadListChunkData.bDone){loadNextThumbListChunk(oDataPassed.oLoadListChunkData,nLoadedDataSets);return}}}else{imageList=loadedImageList}if(bOutdated){return}lastLoadedListStartIndex=oDataPassed.oLoadListChunkData.limitStart;if(!bDoUseClientDirectoryCache){dataOffset=lastLoadedListStartIndex}else{dataOffset=0}if(bReCheckVisibleRangeLoaded&&entryCount>0){if(!ensureVisibleRangeLoaded()){return}}if(oDataPassed&&!oDataPassed.bJustLoadData){hideToolTip();prepareThumbview(nLoadedDataSets)}if(oDataPassed&&oDataPassed.fnCallback){oDataPassed.fnCallback(oDataPassed.fnCallbackData)}ic.unlockInterface();if(bNewContent){bNewContent=false}lockWatching(false);if(bUpdatePictureviewAfterListLoad){bUpdatePictureviewAfterListLoad=false;if(ic.getPictureView().getActiveSection()=="Meta"){ic.getPictureView().refreshView()}}if(strError!=undefined){showNoContent(true,strError)}};var prepareThumbview=function(nLoadedDataSets){if(!entryCount||entryCount<1){showNoContent(true)}else{showNoContent(false)}if(!bDoUseClientDirectoryCache){dataOffset=lastLoadedListStartIndex}else{dataOffset=0}if(!self.rearrangeThumbview()){if(ic.getReady()){if(scrollControl.getVisibleRangeStartAtLoad()!=scrollControl.oVisibleRange.start){scrollControl.refreshLimitPos()}else{var nEnd=lastLoadedListStartIndex+nLoadedDataSets-1;scrollControl.setLoadedDataStats(lastLoadedListStartIndex,nEnd,entryCount);scrollControl.setThumbViewState(thumbsX,thumbsY,realRowHeight,true);self.updateThumbContent(scrollControl.getVisibleRangeStartAtLoad())}}}};var showNoContent=function(bShow,msg){if(bShow){var message="No content.";if(translator){if(basePathType=="dir"){message=translator.translateScriptText("DirEmpty",true)}else{var replace=new RegExp(ic.getSearchURLPrefix());if(browsePath!=undefined){var searchItem=browsePath.replace(replace,"");message=translateEx("SearchNoResult",'<div class="searchQuery">'+decodeURIComponent(searchItem)+"</div>");if(strLastListMessage!=undefined){message+="<br/><br/><b>"+strLastListMessage+"</b>"}}}}if(msg!=undefined){message=msg}$("#thumbCanvasNoContentText").html(message);$("#thumbInnerCanvas").hide();$("#thumbCanvasNoContentTable").show();scrollControl.reset()}else{$("#thumbCanvasNoContentTable").hide();$("#thumbInnerCanvas").show()}};this.getDataArray=function(){return dataArray};this.rearrangeThumbview=function(totalRefresh){var ret=false;var rowHeight=(itemHeight+thumbRowSpacing);var nColumnWidth=(itemWidth+thumbColumnSpacing);viewDim=ic.getThumbViewDim();var heightAvailable=viewDim.height-canvasOffsetTop;if(nViewMode==viewModeList){newThumbsX=1}else{newThumbsX=Math.floor(viewDim.width/nColumnWidth)}newThumbsY=Math.floor(heightAvailable/rowHeight);var subWidthSense=((itemWidth+4)*newThumbsX)+newThumbsX*4;if(viewDim.width<subWidthSense){newThumbsX--}if(nViewMode==viewModeCatalog){newThumbsX=Math.floor(newThumbsX/2)*2}var subHeightSense=((itemHeight+4)*newThumbsY)-newThumbsY*4;if(heightAvailable<subHeightSense){newThumbsY--}if(heightAvailable>0&&itemWidth>ic.getMinThumbSize()&&(newThumbsX<1||newThumbsY<1)){interfaceControl.increaseThumbSize(-18,-1);return}newThumbsX=Math.max(1,newThumbsX);newThumbsY=Math.max(1,newThumbsY);if(totalRefresh||newThumbsX!=thumbsX||newThumbsY!=thumbsY){self.invalidateThumbMatrix();ret=true;redrawThumbview(newThumbsX,newThumbsY,thumbsX,thumbsY,totalRefresh);thumbsX=newThumbsX;thumbsY=newThumbsY;nVisibleThumbs=newThumbsX*newThumbsY;realRowHeight=heightAvailable/thumbsY;if(ic.getReady()){scrollControl.setThumbViewState(thumbsX,thumbsY,realRowHeight,false)}}else{scrollControl.recalc()}invalidateThumbOffsets();currentThumbSize=itemWidth;return ret};this.markSelection=function(bCtrl,startX,startY,width,height){if(!thumbMatrix||!thumbXOffsets){return}var x,y;var rowStartX=thumbsX;var rowStopX=-1;var xStart=startX-itemWidth;var xEnd=startX+width;var i;if(nViewMode==viewModeList){rowStartX=rowStopX=0}else{for(i=0;i<thumbsX;i++){x=thumbXOffsets[i];if(x>xStart){rowStartX=i;break}}for(i=thumbsX;i>=rowStartX;i--){x=thumbXOffsets[i];if(x<xEnd){rowStopX=i;break}}}var rowStartY=thumbsY;var rowStopY=-1;var yStart=startY-itemHeight;var yEnd=startY+height;for(i=0;i<thumbsY;i++){y=thumbYOffsets[i];if(y>yStart){rowStartY=i;break}}for(i=thumbsY;i>=rowStartY;i--){y=thumbYOffsets[i];if(y<yEnd){rowStopY=i;break}}if(rowStartX==oLastMarkSelectionRange.rowStartX&&rowStopX==oLastMarkSelectionRange.rowStopX&&rowStartY==oLastMarkSelectionRange.rowStartY&&rowStopY==oLastMarkSelectionRange.rowStopY){return}showThumbRangeSelected(rowStopX+1,oLastMarkSelectionRange.rowStopX,oLastMarkSelectionRange.rowStartY,oLastMarkSelectionRange.rowStopY,undefined);showThumbRangeSelected(oLastMarkSelectionRange.rowStartX,rowStartX-1,oLastMarkSelectionRange.rowStartY,oLastMarkSelectionRange.rowStopY,undefined);showThumbRangeSelected(oLastMarkSelectionRange.rowStartX,oLastMarkSelectionRange.rowStopX,oLastMarkSelectionRange.rowStartY,rowStartY-1,undefined);showThumbRangeSelected(oLastMarkSelectionRange.rowStartX,oLastMarkSelectionRange.rowStopX,rowStopY+1,oLastMarkSelectionRange.rowStopY,undefined);oLastMarkSelectionRange.rowStartX=rowStartX;oLastMarkSelectionRange.rowStopX=rowStopX;oLastMarkSelectionRange.rowStartY=rowStartY;oLastMarkSelectionRange.rowStopY=rowStopY;showThumbRangeSelected(rowStartX,rowStopX,rowStartY,rowStopY,!bCtrl)};var showThumbRangeSelected=function(rowStartX,rowStopX,rowStartY,rowStopY,bSelectIn){var bSelect=bSelectIn;for(var y=rowStartY;y<=rowStopY;y++){for(var x=rowStartX;x<=rowStopX;x++){var elTable=thumbMatrix[x][y];if(elTable&&elTable.realThumb){if(bSelectIn==undefined){bSelect=oSelection.itemExists(elTable.listEntry.src)}showThumbSelected(elTable,bSelect)}}}};this.setSelectionFromElementStates=function(){self.updateThumbMatrix();for(var y=0;y<thumbsY;y++){for(var x=0;x<thumbsX;x++){var elTable=thumbMatrix[x][y];if(elTable&&elTable.realThumb){var key=elTable.listEntry.src;var bItemIsInSelection=oSelection.itemExists(key);if(isThumbSelected(elTable)){if(!bItemIsInSelection){selectThumb(elTable,true)}}else{if(bItemIsInSelection){selectThumb(elTable,false)}}}}}updateViewPortStats()};this.getEntryForPath=function(strPath){if(!strPath||strPath.length<1){return undefined}var strListPath=strPath.split("/");strName=strListPath.pop();if(strName.length==0){strName=strListPath.pop()}strListPath=strListPath.join("/");var gp="type=list&tpl="+strListTemplate+strHeaderQueryNoCache+"&source="+encodeURIComponent(strListPath)+"&items="+encodeURIComponent(strName);ffDump("REQUEST: "+gp);var responseObj=nelajax.GETJSONSync(baseServerURL,gp);var entry;if(responseObj.status==200||responseObj.status==304){try{var data=JSON.parse(responseObj.response);entry=data.entries[0];getImagePath(entry,ic.simplifyPath(strListPath)+"/")}catch(e){}}return entry};this.getFirstImageEntryForDir=function(browsePath,strBasePathType){var retURL;if(strBasePathType=="dir"){retURL="source="+encodeURIComponent(browsePath);retURL+="&type=list"}else{retURL=browsePath}retURL+="&tpl="+strListTemplate+strHeaderQueryList+"&limit=0,1&typefilter=file";var d=new Date();if(oFirstImageCache.url==retURL){d=new Date();if(d-oFirstImageCache.time<500){oFirstImageCache.time=d;return oFirstImageCache.entry}}var oEntry=false;var key=retURL+"___"+browsePath;var responseObj=nelajax.GETJSONSync(baseServerURL,retURL,null);var tempImageList;if(responseObj.status==200&&responseObj.response){if(oFirstImageCache.key==key&&oFirstImageCache.response==responseObj.response){oEntry=oFirstImageCache.entry}else{var bReceivedOK=false;try{var oRoot=JSON.parse(responseObj.response);tempImageList=oRoot.entries;bReceivedOK=true}catch(e){ffDump("JSON error on retrieving image list: "+e.message)}if(bReceivedOK&&tempImageList[0]!=undefined&&tempImageList[0].src!=undefined){oEntry={};for(var o in tempImageList[0]){oEntry[o]=tempImageList[0][o]}getImagePath(oEntry,ic.simplifyPath(browsePath)+"/")}else{oEntry=false}oFirstImageCache.key=key;oFirstImageCache.response=responseObj.response;oFirstImageCache.url=retURL;oFirstImageCache.entry=oEntry}oFirstImageCache.time=new Date()}return oEntry};this.getImageAlphaChannels=function(entry){var o={arClippingPaths:[],arAlphaChannels:[]};if(!entry||entry.type!="file"){return o}if(entry.__oAlphaChannels!=undefined){return entry.__oAlphaChannels}var url=ic.getPictureView().getMetaDataURL(entry);var responseObj=nelajax.GETJSONSync(url,null,null);if(responseObj.status==200&&responseObj.response){try{var oData=JSON.parse(responseObj.response);if(oData.general){if(oData.general.selections){o.arClippingPaths=oData.general.selections}if(oData.general.alphachannels){o.arAlphaChannels=oData.general.alphachannels}}entry.__oAlphaChannels=o}catch(e){ffDump("JSON error on retrieving image chanels: "+e.message)}}return o};this.getBrowsePath=function(){return browsePath};this.getFirstImageEntry=function(){if(!ic.getReady()){return undefined}if(oFirstImageEntry!=undefined){return oFirstImageEntry}oFirstImageEntry=self.getFirstImageEntryForDir(ic.getBasePath(),ic.getBasePathType());return oFirstImageEntry};this.getImageCount=function(){return imageCount};this.dirContainsImages=function(){return imageCount>0};this.getSortOrder=function(){return sortOrder};var getViewProperty=this.getViewProperty=function(connectorName,propertyName){var op=oViewPropertiesByConnector[connectorName];var ret;if(op!=undefined&&op[propertyName]!=undefined){return op[propertyName]}var theConnectorType=ic.getFolderTree().getConnectorTypeByName(connectorName);o=defaultViewPropertiesByConnectorType[theConnectorType];if(o!=undefined&&o[propertyName]!=undefined){setViewProperty(connectorName,propertyName,o[propertyName]);return o[propertyName]}ret=defaultViewPropertiesByConnectorType.DEFAULT[propertyName];setViewProperty(connectorName,propertyName,ret);return ret};var setViewProperty=this.setViewProperty=function(connectorName,propertyName,value){if(connectorName==undefined||propertyName==undefined){return}var bChanged=false;if(oViewPropertiesByConnector[connectorName]==undefined){bChanged=true;oViewPropertiesByConnector[connectorName]={}}if(oViewPropertiesByConnector[connectorName][propertyName]!=value){bChanged=true;oViewPropertiesByConnector[connectorName][propertyName]=value}if(bChanged){ic.setInterfacePref("viewProperties",oViewPropertiesByConnector)}};this.setCurrentViewProperty=function(propertyName,value){setViewProperty(currentConnectorName,propertyName,value)};this.cleanupViewProperties=function(){var fn=ic.getFolderTree().getConnectorTypeByName;for(var o in oViewPropertiesByConnector){if(fn(o)==""){oViewPropertiesByConnector[o]=undefined}}};this.setViewProperties=function(oSettings){if(typeof(oSettings)!="object"){return false}oViewPropertiesByConnector=oSettings;return true};this.toggleSortOrder=function(bByScript,bNoRefresh){if(sortOrder=="asc"){sortOrder="desc"}else{sortOrder="asc"}if(bByScript){toggleSortOrderArrow()}if(!bNoRefresh){bDataAvailable=false;resetDataArray(0,0);reloadVisibleThumbs()}if(viewMode=="list"&&oCurrentTextList){oCurrentTextList.updateSortIndicator()}setViewProperty(currentConnectorName,"sortOrder",sortOrder)};var setSortOrder=function(strOrder,bByScript,bNoRefresh){if(sortOrder!=strOrder){self.toggleSortOrder(bByScript,bNoRefresh)}};var toggleSortOrderArrow=function(){var btn=ic.getElementById("btnSortOrderToggle");if(btn){ic.getComponents().setCheckBoxChecked(btn,(sortOrder=="desc"))}};this.getSortField=function(){return sortField};this.setSortField=function(newSortField,bChangeSelect,bNoRefresh){if(sortField==newSortField){return}sortField=newSortField;if(!bNoRefresh){bDataAvailable=false;resetDataArray(0,0);reloadVisibleThumbs()}if(bChangeSelect){updateSortFieldSelect()}if(viewMode=="list"&&oCurrentTextList){oCurrentTextList.updateSortIndicator()}setViewProperty(currentConnectorName,"sortField",sortField)};var updateSortFieldSelect=function(){var elSelect=ic.getElementById("sortingSelector");var options=elSelect.options;for(var i=0;i<options.length;i++){if(options[i].value==sortField){elSelect.selectedIndex=i;break}}};this.scrollToEntry=function(entry){if(entry==undefined||(nViewMode==viewModeCatalog&&entry.type=="directory")){return false}return scrollControl.scrollToIndex(entry.absoluteid,false,true)};this.getViewMode=function(){return viewMode};var setViewModeParameters=function(){var filter;var bImageMode=true;var nImageOffset=0;switch(viewMode){case"catalog":filter="file";nImageOffset=1;nViewMode=viewModeCatalog;break;case"list":filter="";bImageMode=false;nViewMode=viewModeList;thumbRowSpacing=0;thumbColumnSpacing=0;buildThumbContainer=buildThumbContainerText;buildThumb=buildThumbText;seedThumb=seedThumbList;$("#thumbInnerCanvas").attr("class","supermaxwidth");oCurrentTextList.showHeader(true);canvasOffsetTop=listRowHeight;strImageTableClass="table.txtcnt";break;default:filter="";nViewMode=viewModeThumbs}self.setThumbSize(itemWidth);if(bImageMode){strImageTableClass="table.imgcnt";oCurrentTextList.showHeader(false);$("#thumbInnerCanvas").attr("class","supermax");thumbRowSpacing=18;thumbColumnSpacing=6;buildThumbContainer=buildThumbContainerImage;seedThumb=seedThumbImage;buildThumb=buildThumbImage;canvasOffsetTop=0}scrollControl.setImageOffset(nImageOffset);self.setTypeFilter(filter,true);updateThumbViewModeButton()};var updateThumbViewModeButton=function(){var id=viewMode+"View";var el=ic.getElementById(id);if(el){ic.getComponents().setButtonState(el,"pressed")}};this.adjustCanvasOffset=function(obj){if(nViewMode!==viewModeList){return}var el=$("div.textlistheadrow").get(0);if(el&&el.offsetHeight){obj.canvasOffTop+=el.offsetHeight}};var setViewMode=this.setViewMode=function(mode,bNoUpdate){if(mode!=viewMode){viewMode=mode;if(viewMode=="list"){oCurrentTextList.updateSortIndicator();$("#tdThumbResize1").hide();$("#tdThumbResize2").hide();$("#sortSelectTable").hide();$("#thumbcanvastr").addClass("list");$("#thumbCanvasNoContentText").addClass("onWhite")}else{$("#thumbcanvastr").removeClass("list");$("#thumbCanvasNoContentText").removeClass("onWhite");$("#tdThumbResize1").show();$("#tdThumbResize2").show();if(currentConnectorType!="ROOT"){$("#sortSelectTable").show()}else{$("#sortSelectTable").hide()}}setViewModeParameters();self.rearrangeThumbview(true);thumbMatrix=undefined;self.invalidateFillRange();if(!bNoUpdate){scrollControl.oRangeLoaded.start=scrollControl.oRangeLoaded.end=-1;scrollControl.refreshLimitPos()}var icc=ic.getComponents();var btn=$("#"+viewMode+"View").get(0);if(btn){icc.btnDownDo(btn)}else{ffDump("error: Invalid ViewMode: "+viewMode)}}if(currentConnectorName!=undefined){setViewProperty(currentConnectorName,"viewMode",viewMode)}};this.removeFocus=function(){myFocusElement.blur()};var setTheFocus=this.setTheFocus=function(){if(ic.isLocked()||browser.touchDevice){return}if(!hasFocus){if(document.activeElement&&document.activeElement.blur&&myFocusElement!=document.activeElement){if(document.activeElement&&document.activeElement.focus){getFocus()}}else{if(myFocusElement){myFocusElement.focus();onGetFocus()}}}};this.keyUpListener=function(evt,bByScript){if(ic.isLocked()||(!bByScript&&!isFocussed())){return}oCursor.bDirectionKeyDown=false;var keycode=evt.keyCode|evt.which;var bCTRLKey=evt.ctrlKey;oCursor.bShift=(evt.shiftKey==1);oCursor.shiftKey=evt.shiftKey;oCursor.bCTRL=bCTRLKey;if(bCTRLKey){oCursor.ctrlKey=1}switch(keycode){case 39:case 37:case 38:case 40:case 33:case 34:case 35:case 36:if(oCursor.oMoveAfterFill==undefined){if(oCursor.elThumbToMarkOnKeyUp!=undefined){onEndCursorMove()}}else{oCursor.bWaitForFill=true;scrollControl.refreshLimitPos(true)}oCursor.nKeyRepeat=0;oCursor.lastKey=undefined;break}if(bCTRLKey&&evt.shiftKey!=1&&evt.altKey!=1){switch(keycode){case 36:if(!isRootDir){resetCursor();setCursorMoveAfterFill(0,0,0,0);ic.setBasePath("")}break;case 37:case 38:if(ic.getFolderTree().browseFolderUp()){resetCursor();setCursorMoveAfterFill(0,0,0,0)}break}}};this.keyListener=function(evt,bByScript){if(ic.isLocked()){return}hideToolTip();var bPreventDefault=false;var keycode=evt.keyCode|evt.which;if(keycode==116){ic.getFolderTree().reloadCurrent();return false}if(!bByScript&&!isFocussed()){return}var bCTRLKey=evt.ctrlKey;oCursor.bShift=(evt.shiftKey==1);oCursor.shiftKey=evt.shiftKey;oCursor.bCTRL=bCTRLKey;if(bCTRLKey){oCursor.ctrlKey=1}if(evt.altKey!=1&&!bCTRLKey){switch(keycode){case 13:case 32:onThumbPressEnter();break;case 9:if(!evt.shiftKey){ic.getFolderTree().setTabFocus();if(evt.preventDefault){evt.preventDefault()}evt.cancelBubble=true;evt.returnValue=false;return false}break;case 39:case 37:case 38:case 40:case 33:case 34:case 35:case 36:moveCursorByKeyboard(keycode,bByScript);if(evt.preventDefault){evt.preventDefault()}break}}switch(keycode){case 46:if(!oSelection.isEmpty()&&ic.getConnectorPermission("write","delete")){ic.askDeleteSelected()}break}if(evt.shiftKey!=1&&evt.altKey!=1&&!bCTRLKey){switch(keycode){case 113:if(!oSelection.isEmpty()){renameSelectedThumb()}break}}else{if(evt.shiftKey!=1&&evt.altKey!=1&&bCTRLKey){switch(keycode){case 65:self.selectAll();bPreventDefault=true;break;case 67:copySelectionToClipboard();bPreventDefault=true;break;case 88:self.cutSelectionToClipboard();bPreventDefault=true;break;case 86:pasteFromClipboard();bPreventDefault=true;break}}}if(bPreventDefault){if(evt.preventDefault){evt.preventDefault();evt.stopPropagation()}evt.keyCode=0;evt.returnValue=false;evt.cancelBubble=true;return false}};this.getClipboard=function(){return oClipboard};this.getDragInfo=function(){return oDragInfo};this.getMinHeight=function(){if(nViewMode==viewModeList){return 5*self.getTextListRowHeight()}else{return ic.getMinThumbSize()+14}};this.getThumbSize=function(){return itemWidth};this.getTextListRowHeight=function(){return listRowHeight};this.setThumbSize=function(ts){ts=Math.round(ts);if(nViewMode==viewModeList){itemWidth=ts;itemHeight=listRowHeight;thumbMargin=0;$("#thumbInnerCanvas").css("lineHeight",itemHeight+"px")}else{$("#thumbInnerCanvas").css("lineHeight","normal");thumbMargin=2;itemWidth=itemHeight=ts}thumbMaxSizeX=itemWidth-thumbMargin;thumbMaxSizeY=itemHeight-labelHeight-thumbMargin;ic.calcVSplitterMax()};this.updateThumbsize=function(){if(currentThumbSize==itemWidth){return}self.rearrangeThumbview(true)};var updateFirstSelectedThumb=this.updateFirstSelectedThumb=function(){var entry=getFirstSelectionElement();getImagePath(entry);if(oFirstSelectedThumb&&entry&&strFirstSelectedThumbFullsrc==entry.fullsrc&&bUpdateFirstSelectedThumbMulti==self.isSelectionMulti()){return false}if(bUpdateFirstSelectedThumbMulti!=self.isSelectionMulti()){if(ic.getPictureView().getActiveSection()=="Meta"){ic.getPictureView().clearLastEntry()}}bUpdateFirstSelectedThumbMulti=self.isSelectionMulti();oFirstSelectedThumb=entry;if(entry){strFirstSelectedThumbFullsrc=entry.fullsrc}else{strFirstSelectedThumbFullsrc=undefined}ic.getPictureView().activate(entry);return true};this.getFirstSelectedThumb=function(){return oFirstSelectedThumb};this.getLastSelectedThumb=function(){return(oSelectionElementLast!=undefined)?oSelectionElementLast.data:undefined};this.getSelectedItemCount=function(){return oSelection.getCount()};this.getSelection=function(){return oSelection};this.getSelectionDataArray=function(){return oSelection.getArray()};this.getThumbsX=function(){return thumbsX};this.getThumbsY=function(){return thumbsY};this.shiftThumbCanvas=function(offsetY,vPos){var obj=ic.getElementById("thumbInnerCanvas");virtualPos=vPos;if(browser.touchDevice&&browser.iOS){obj.style.webkitTransform="translate(0, "+offsetY+"px)"}else{if(obj){obj.style.top=offsetY+"px"}}};this.resetThumbCanvas=function(){var obj=ic.getElementById("thumbInnerCanvas");var cPos=obj.style.top;var fRow=Math.floor(virtualPos/realRowHeight);var offsetY=virtualPos-fRow*realRowHeight;if(fRow>0){if(browser.touchDevice&&browser.iOS){obj.style.webkitTransform="translate(0, "+offsetY+"px)"}else{if(obj){obj.style.top=offsetY+"px"}}}};var scrollReadyElementCache={};var createScrollReadyElement=function(strTagAndClassName){if(!scrollReadyElementCache[strTagAndClassName]){var ar=strTagAndClassName.split(".");var t=scrollReadyElementCache[strTagAndClassName]=document.createElement(ar[0]);t.setAttribute("NELAscroll","thumbcanvas");if(ar[0]=="table"){t.setAttribute("cellPadding","0");t.setAttribute("cellSpacing","0");t.setAttribute("border","0")}if(ar[1]){t.className=ar[1]}}return scrollReadyElementCache[strTagAndClassName].cloneNode(false)};this.getThumbOffsetsX=function(){var ret=updateThumbOffsets();return(!ret)?false:thumbXOffsets};this.getThumbOffsetsY=function(){var ret=updateThumbOffsets();return(!ret)?false:thumbYOffsets};var invalidateThumbOffsets=function(){thumbXOffsets=thumbYOffsets=undefined};this.invalidateThumbMatrix=function(){lastMatrixUpdateX=undefined};var updateThumbOffsets=this.updateThumbOffsets=function(){var i;var el;if(thumbMatrix==undefined){return false}if(thumbXOffsets!=undefined){return true}thumbXOffsets=new Array(thumbsX);for(i=0;i<thumbsX;i++){el=thumbMatrix[i][0];thumbXOffsets[i]=el.offsetLeft+el.parentNode.offsetLeft}thumbYOffsets=new Array(thumbsY);for(i=0;i<thumbsY;i++){el=thumbMatrix[0][i];thumbYOffsets[i]=el.offsetTop+el.parentNode.offsetTop}return true};this.updateThumbMatrix=function(){var x,y;oLastMarkSelectionRange={};if(thumbMatrix&&lastMatrixUpdateX==thumbsX&&lastMatrixUpdateY==thumbsY){return}if(thumbsX>0&&thumbsY>0){thumbMatrix=new Array(thumbsX);for(x=0;x<thumbsX;x++){thumbMatrix[x]=new Array(thumbsY)}}else{ffDump("no space to display thumbs: "+thumbsX+" x "+thumbsY);return}lastMatrixUpdateX=thumbsX;lastMatrixUpdateY=thumbsY;x=0;y=0;var xEnd=thumbsX-1;$("#thumbCanvas").find("td.imgcontainer").each(function(){thumbMatrix[x][y]=$(this).get(0).firstChild;x++;if(x>xEnd){x=0;y++}})};this.getMaxThumbPadding=function(){return maxThumbPadding};var redrawThumbview=function(dimX,dimY,oldX,oldY,totalRedraw){if(redrawLock==false){redrawLock=true;if(thumbBody){viewPortStats.visibleEntries=dimX*dimY;updateViewPortStats();resetCursorPos();if(totalRedraw){for(var y=0;y<oldY;y++){removeChildSafe(thumbBody.lastChild)}oldX=0;oldY=0}var addX=dimX-oldX;var addY=dimY-oldY;if(addY>0){for(var r=0;r<addY;r++){thumbBody.appendChild(createScrollReadyElement("tr"))}}else{if(addY<0){for(var r=addY;r<0;r++){removeChildSafe(thumbBody.lastChild)}}}var tbtrs=thumbBody.childNodes;if(tbtrs){for(var r=0,c=0;r<tbtrs.length;r++){var trobj=tbtrs[r];if(trobj.nodeType==1){var tbtrscn=tbtrs[r].childNodes;if(tbtrscn.length<dimX){for(var a=tbtrscn.length;a<dimX;a++,c++){if(nViewMode==viewModeCatalog){var alignment=a%2==1?"left":"right";trobj.appendChild(buildThumbContainer(alignment))}else{trobj.appendChild(buildThumbContainer("center"))}}}else{if(tbtrscn.length>dimX){for(var a=tbtrscn.length;a>dimX;a--){removeChildSafe(trobj.lastChild)}}}}}self.invalidateFillRange()}}redrawLock=false}};var redrawFakeview=function(virtualYPos,virtualYRow){};this.getFillRange=function(){return oCurrentFillRange};var cancelItemWatching=function(){invalidateWatchList();clearInterval(oItemWatch.nIntervalWatch);oItemWatch.nIntervalWatch=undefined};var invalidateWatchList=function(){oWatchedItems={};oItemWatch.nItems=0;oItemWatch.bDirty=false;oItemWatch.nWatchID++};this.invalidateFillRange=function(){invalidateWatchList();oCurrentFillRange.start=oCurrentFillRange.end=-1;oCurrentFillRange.dataOffset=-1};var updateFillRange=function(){var nStart=nStartIndexFillThumbs;var nEnd=Math.min(entryCount-1,nStart+nVisibleThumbs-1);oCurrentFillRange.start=nStart;oCurrentFillRange.end=nEnd;oCurrentFillRange.dataOffset=dataOffset};this.updateThumbContent=function(newStartListIndex){fillThumbs(Math.max(0,newStartListIndex-dataOffset))};var fillThumbs=function(newStartListIndex){if(imageList==undefined){return}var nImageOffset=scrollControl.getImageOffset();var previousStart=oCurrentFillRange.start;var previousEnd=oCurrentFillRange.end;var previousDataOffset=oCurrentFillRange.dataOffset;self.resetThumbCanvas();nStartIndexFillThumbs=newStartListIndex;updateFillRange();if(previousDataOffset==oCurrentFillRange.dataOffset&&previousStart==oCurrentFillRange.start&&previousEnd==oCurrentFillRange.end){return}invalidateWatchList();invalidateToolTip();thumbDivReg={};var collection=new Array();var thumbContainer=getThumbContainerNodes(thumbBody,collection);var len=collection.length;var c=len-1;var c2=c;var container;var s=0;if(scrollControl.oVisibleRange.start==-1){container=collection[c];$(container.parentNode).removeAttr("ThumbIndex");seedThumb(container);container=collection[c-s];$(container).removeAttr("ThumbIndex");buildThumb(container,-1);s=1}var nEnd=nStartIndexFillThumbs+len-s;for(var a=nStartIndexFillThumbs;a<nEnd;a++,c--){if(c>=0){container=collection[c-s];seedThumb(container);buildThumb(container,a);$(container.parentNode).attr("ThumbIndex",(c2-c)+s)}}if(oCursor.oMoveAfterFill!=undefined){moveCursorAfterFill()}if(!oItemWatch.bLocked&&oItemWatch.nItems>0){clearInterval(oItemWatch.nIntervalWatch);oItemWatch.nIntervalWatch=setInterval(checkWatchedItems,oItemWatch.nUpdateTime)}};var seedThumbImage=function(n){if(n){while(n.firstChild){removeChildSafe(n.firstChild)}}};var seedThumbList=function(n){};var removeChildSafe=function(el){if(el){while(el.firstChild){removeChildSafe(el.firstChild)}if(el.parentNode!=null){el.parentNode.removeChild(el);el=null}else{el=null}}};var getThumbContainerNodes=function(n,col){if(n.nodeType==1&&n.name=="thumbWrapCnt"){col[col.length]=n}else{var kids=n.childNodes;var numkids=kids.length;for(var i=numkids-1;i>=0;i--){getThumbContainerNodes(kids[i],col)}}};var buildThumbContainerImage=function(alignment){var newTD=createScrollReadyElement("td.imgcontainer "+alignment);var newITable=createScrollReadyElement("table");var newITableBody=createScrollReadyElement("tbody");newITable.alignment=alignment;newITable.setAttribute("draggable","true");newITable.setAttribute("name","imgcnttbl");newITable.style.width=itemWidth+"px";newITable.style.height=itemHeight+"px";addEvent(newITable,"mouseover",function(evt){thumbMouseOver(newITable)});addEvent(newITable,"mouseout",thumbMouseOut);if(browser.touchDevice){addEvent(newITable,"click",doNothing)}newITableBody.name="thumbWrapCnt";newTD.appendChild(newITable);newITable.appendChild(newITableBody);return newTD};var buildThumbContainerText=function(alignment){var newTD=createScrollReadyElement("td.imgcontainer "+alignment);var newITable=createScrollReadyElement("table");var newITableBody=createScrollReadyElement("tbody");newITable.style.height=itemHeight+"px";newITable.alignment=alignment;newITable.setAttribute("name","imgcnttbl");newITable.setAttribute("class","txtcnt");newITableBody.name="thumbWrapCnt";newTD.appendChild(newITable);newITable.appendChild(newITableBody);var newITableTR1=createScrollReadyElement("tr");var newITableTD1=createScrollReadyElement("td.thumb");newITableTD1.appendChild(oCurrentTextList.getEmptyRow());if(browser.touchDevice){addEvent(newITableTD1.firstChild,"click",doNothing)}newITableTR1.appendChild(newITableTD1);newITableBody.appendChild(newITableTR1);return newTD};var doNothing=function(){};var thumbPress=function(evt,elThumb,bForceCTRL){hideToolTip();if(ic.getEventButton(evt)!=1){self.handleRightClick(elThumb);return}if(!browser.dragSupport||(ic.getCTRLKey(evt)||!isThumbSelected(elThumb))){markThumb(evt,elThumb)}};function doCheckThumbNeedsWatching(entry,listNumber,parentObj){if(!entry){return}var itemStatus=entry[oItemWatch.watchField];if(itemStatus==undefined||(itemStatus!="2"&&itemStatus!="4")){return}if(oWatchedItems[listNumber]!=undefined){var o=oWatchedItems[listNumber];o.entry=entry;o.myParent=parentObj;return}oItemWatch.bDirty=true;var o=oWatchedItems[listNumber]={};o.entry=entry;o.myParent=parentObj;o.listNumber=listNumber;oItemWatch.nItems++}var lockWatching=this.lockWatching=function(bLock){if(bLock){oItemWatch.nLockCount++}else{oItemWatch.nLockCount--}if(oItemWatch.nLockCount<1){oItemWatch.nLockCount=0;oItemWatch.bLocked=false;if(oItemWatch.nItems>0){clearInterval(oItemWatch.nIntervalWatch);oItemWatch.nIntervalWatch=setInterval(checkWatchedItems,oItemWatch.nUpdateTime)}}else{if(oItemWatch.nIntervalWatch!=undefined){clearInterval(oItemWatch.nIntervalWatch);oItemWatch.nIntervalWatch=undefined}oItemWatch.bLocked=true}};var checkWatchedItems=function(){if(oItemWatch.nItems==0){cancelItemWatching()}if(oDragInfo!=undefined){return}if(oItemWatch.bLocked||!oItemWatch.nItems){return}if(imageList==undefined){return}if(oItemWatch.bDirty){oItemWatch.bDirty=false;var gp="type=list&sort="+sortField+"&sortorder="+sortOrder+"&tpl="+strListTemplate+strHeaderQueryNoCache+"&source="+encodeURIComponent(browsePath);var ar=new Array();for(var o in oWatchedItems){ar.push(encodeURIComponent(oWatchedItems[o].entry.src))}gp+="&items="+ar.join(",");oItemWatch.getParam=gp}oItemWatch.nWatchID++;var myID=oItemWatch.nWatchID;nelajax.POSTJSONAsync(baseServerURL,oItemWatch.getParam,undefined,onWatchListLoaded,myID)};var onWatchListLoaded=function(responseObj){if(!responseObj||!responseObj.oDataPassThrough||(responseObj.status!=200&&responseObj.status!=304)||oItemWatch.nItems<1||oItemWatch.bLocked){return}if(responseObj.oDataPassThrough!=oItemWatch.nWatchID){ffDump("outdated watch reply: "+responseObj.oDataPassThrough+" / "+oItemWatch.nWatchID);return}var bReceivedOK=false;try{var oData=JSON.parse(responseObj.response);bReceivedOK=true}catch(e){ffDump("JSON error on retrieving watch list: "+e.message)}if(!bReceivedOK||!oData.entries){return}var field=oItemWatch.strIdentField;var entries=oData.entries;var oEntries={};for(var i=0;i<entries.length-1;i++){var entry=entries[i];oEntries[entry[field]]=entry}var nItemsBefore=oItemWatch.nItems;var nMatched=0;for(var o in oWatchedItems){var itm=oWatchedItems[o];var oldEntry=itm.entry;var newEntry=oEntries[oldEntry[field]];if(newEntry!=undefined&&imageList[itm.listNumber][field]==oldEntry[field]){nMatched++;if(oItemWatch.bUpdateAlways||newEntry[oItemWatch.watchField]!=oldEntry[oItemWatch.watchField]){imageList[itm.listNumber]=newEntry;seedThumb(itm.myParent);buildThumb(itm.myParent,itm.listNumber);if(newEntry[oItemWatch.watchField]=="2"||newEntry[oItemWatch.watchField]=="4"){}else{itm.entry=newEntry;ic.getPictureView().checkClearLastEntry(newEntry);delete oWatchedItems[o];oItemWatch.nItems--;oItemWatch.bDirty=true}}}else{delete oWatchedItems[o];oItemWatch.nItems--;oItemWatch.bDirty=true}}if(nItemsBefore!=nMatched){ffDump("ERROR watching: "+nItemsBefore+" items, "+nMatched+" matched, "+(entries.length-1)+" in list");reloadVisibleThumbs()}if(oItemWatch.nItems<1){clearInterval(oItemWatch.nIntervalWatch);oItemWatch.nIntervalWatch=undefined}};var buildThumbImage=function(parentObj,listNumber){var spacer;var newITableTR1=createScrollReadyElement("tr");var newITableTD1=createScrollReadyElement("td.thumb");if(listNumber>-1&&listNumber<imageList.length){var alignment=parentObj.parentNode.alignment;var cname;if(nViewMode==viewModeCatalog){if(listNumber==0){cname="imgcnt first"}else{if(listNumber==entryCount-1&&entryCount%2==0){cname="imgcnt last"}else{cname="imgcnt "+alignment}}}else{cname="imgcnt "+alignment}parentObj.parentNode.className=cname;var entry=imageList[listNumber];if(!entry){ffDump("ERROR: "+listNumber);return}checkThumbNeedsWatching(entry,listNumber,parentObj);parentObj.parentNode.realThumb=true;var newITableImg=createScrollReadyElement("img.thumb");var imgURL=baseServerURL;var thumbSizeX=thumbMaxSizeX;var thumbSizeY=thumbMaxSizeY;var bMayRenderImage;if(!bMixedSourceConnectors){bMayRenderImage=bConnectorReadRenderedImage}else{var oConnectorInfo=ic.getFolderTree().getConnectorInfoByEntry(entry);bMayRenderImage=ic.getFolderTree().getConnectorMayRenderImages(oConnectorInfo)}var bDir=false;if(!bMayRenderImage){imgURL+="?type=image";if(entry.type&&entry.type!="directory"){imgURL+="&source=asset.eis"}else{bDir=true;imgURL+="&source=folderopen.eis"}imgURL+="&width="+thumbSizeX+"&height="+thumbSizeY+"&backgroundcolor=FFFFFF&effects=pad(cc,FFFFFFFF)&renderer=_private"}else{if(entry.type&&entry.type!="directory"){imgURL+="?type=image"}else{bDir=true;imgURL+="?type=directoryimage"}imgURL+=strHeaderQueryImage+"&source="+getImagePath(entry);if(entry.importstatus!=undefined&&entry.importstatus=="1"){if(entry.width&&entry.height){var aspectX=thumbSizeX/entry.width;var aspectY=thumbSizeY/entry.height;if(aspectX<aspectY){if(entry.width<thumbSizeX){thumbSizeX=entry.width}thumbSizeY=Math.round(thumbSizeX*entry.height/entry.width);imgURL+="&width="+thumbSizeX}else{if(entry.height<thumbSizeY){thumbSizeY=entry.height}thumbSizeX=Math.round(thumbSizeY*entry.width/entry.height);imgURL+="&height="+thumbSizeY}}else{imgURL+="&width="+thumbSizeX+"&height="+thumbSizeY+"&effects=pad(cc,FFFFFFFF)"}}else{if(bDir){imgURL+="&width="+thumbSizeX+"&height="+thumbSizeY+"&effects=pad(cc,FFEEEEEE),Matte(EEEEEE)"}else{imgURL+="&width="+thumbSizeX+"&height="+thumbSizeY+"&effects=pad(cc,FFFFFFFF),Matte(FFFFFF)"}}if(entry.lastmodified!=undefined){imgURL+="&lmhash="+entry.lastmodified}if(entry.importstatus!=undefined){imgURL+="&imstatus="+entry.importstatus}}imgURL+="&quality="+thumbQuality;if(!browser.isIE){newITableImg.setAttribute("draggable","false")}newITableImg.setAttribute("width",thumbSizeX);newITableImg.setAttribute("height",thumbSizeY);newITableImg.setAttribute("name","imgdsp");if(bHideLoadingImages){$(newITableTD1).addClass("loading");newITableImg.style.display="none";if(newITableImg.addEventListener){newITableImg.addEventListener("load",self.onLoadTImg,false)}else{newITableImg.onreadystatechange=function(){if(/^(complete|loaded)$/i.test(newITableImg.readyState)){newITableImg.detachEvent("onreadystatechange",arguments.callee);newITableImg.setAttribute("style","display:none;visibility:visible;display:inline");self.onThumbImageLoaded(newITableImg)}}}}newITableImg.setAttribute("src",imgURL);if(bAddImageNotDraggable){newITableImg.setAttribute("draggable","false")}thumbDivReg[entry.src]=newITableTD1;parentObj.parentNode.listEntry=entry;parentObj.parentNode.listEntryIndex=dataOffset+listNumber;spacer=false}else{parentObj.parentNode.realThumb=false;parentObj.parentNode.className="";spacer=true;newITableImg=null}var newITableTR2=createScrollReadyElement("tr");var newITableTD2=createScrollReadyElement("td.imgtxt");if(bDir){var n=0;if(entry&&entry.images!=undefined){n=entry.images}$(parentObj.parentNode).addClass("directory")}var newITableDIV2=createScrollReadyElement("div.imgtxt");if(spacer==false){newITableDIV2.innerHTML=getEntryLabel(entry);if(!browser.touchDevice){addEvent(newITableDIV2,"dblclick",handleLabelDblClick)}}if(newITableImg){newITableTD1.appendChild(newITableImg);parentObj.parentNode.myTextTD=newITableTD2;if(oSelection.itemExists(entry.src)){$(parentObj.parentNode).addClass("marked");$(parentObj.parentNode.myTextTD).addClass("marked")}parentObj.parentNode.style.visibility="visible"}else{parentObj.parentNode.style.visibility="hidden"}parentObj.appendChild(newITableTR1);newITableTR1.appendChild(newITableTD1);parentObj.appendChild(newITableTR2);newITableTR2.appendChild(newITableTD2);newITableTD2.appendChild(newITableDIV2)};var buildThumbText=function(parentObj,listNumber){var newITableTD1=parentObj.firstChild.firstChild;var containerDiv=newITableTD1.firstChild;if(listNumber>-1&&listNumber<imageList.length){if(!parentObj.parentNode.realThumb){containerDiv.firstChild.FSIItemType="file";$(containerDiv).find("div.textlisticon").attr("class","textlisticon file");$(containerDiv).find("div.textlisticon2").attr("class","textlisticon2")}var entry=imageList[listNumber];checkThumbNeedsWatching(entry,listNumber,parentObj);parentObj.parentNode.realThumb=true;thumbDivReg[entry.src]=newITableTD1;var columns=newITableTD1.firstChild.childNodes;oCurrentTextList.fillRow(columns,entry);parentObj.parentNode.listEntry=entry;parentObj.parentNode.listEntryIndex=dataOffset+listNumber;if(oSelection.itemExists(entry.src)){$(parentObj.parentNode).addClass("marked")}else{$(parentObj.parentNode).removeClass("marked")}}else{if(parentObj.parentNode.realThumb){$(parentObj.parentNode).removeClass("marked");$(containerDiv).find("div").html("&nbsp;");$(containerDiv).find("div.textlisticon").attr("class","textlisticon");var el=$(containerDiv).find("div.textlisticon2");if(el&&el[0]){$(el).attr("class","textlisticon2").get(0).FSIHasStatus=undefined}parentObj.parentNode.realThumb=false}}var hitEvent;if(browser.touchDevice){hitEvent="click"}else{hitEvent="dblclick"}};this.onLoadTImg=function(evt){var target=evt.currentTarget;target.removeEventListener("load",self.onLoadTImg,false);self.onThumbImageLoaded(target);if(bHideLoadingImages){target.setAttribute("style","visibility:visible;display:inline")}};this.onThumbImageLoaded=function(img){$(img).parent().removeClass("loading")};var loadFallbackImage=function(el){if(!el||!el.nela_entry){return false}var thumbSizeX=thumbMaxSizeX;var thumbSizeY=thumbMaxSizeY;el.setAttribute("width",thumbMaxSizeX);el.setAttribute("height",thumbSizeY);var src;if(el.nela_entry.type=="file"){src="_service/FSI Pages Mobile/instructions/landscape.tif"}else{src="_service/geomap.png"}var imgURL=baseServerURL+"?type=image"+strHeaderQueryImage+"&source="+src;imgURL+="&width="+thumbMaxSizeX+"&height="+thumbSizeY+"&effects=pad(cc,FFFFFFFF)";el.src=imgURL;return true};var thumbDropMouseHandler=function(elControl,evt,bOver){if(!bOver){if(curDropTargetEL!=undefined){$(curDropTargetELThumb).removeClass("currentDropTarget");curDropTargetELThumb=curDropTargetEL=undefined}curDropTargetELCanDrop=canDrop(undefined,evt);return curDropTargetELCanDrop}var el=evt.srcElement;if(el==undefined){el=evt.originalTarget}if(!el){curDropTargetELCanDrop=canDrop(undefined,evt);return curDropTargetELCanDrop}if(curDropTargetEL==el){return curDropTargetELCanDrop}var elThumb=getThumbItemTableFromChildEl(el);if(elThumb==undefined){curDropTargetEL=el;curDropTargetELCanDrop=canDrop(undefined,evt);return curDropTargetELCanDrop}$(curDropTargetELThumb).removeClass("currentDropTarget");curDropTargetEL=el;curDropTargetELThumb=elThumb;curDropTargetELCanDrop=canDrop(curDropTargetELThumb,evt);if(curDropTargetELCanDrop&&curDropTargetELThumbEntry&&curDropTargetELThumbEntry.type=="directory"){$(curDropTargetELThumb).addClass("currentDropTarget")}return curDropTargetELCanDrop};var canDrop=function(el,evt){if(bNoDropAllow){return false}if(curDropTargetELThumb!=undefined){curDropTargetELThumbEntry=curDropTargetELThumb.listEntry}else{curDropTargetELThumbEntry=undefined}var bIsDir=(curDropTargetELThumbEntry!=undefined&&curDropTargetELThumbEntry.type=="directory");if(isRootDir){if(!bIsDir||oDragInfo!=undefined){return false}else{var nfo=self.getConnectorInfoForEntry(curDropTargetELThumbEntry);if(nfo&&nfo.permissions&&nfo.permissions.write&&nfo.permissions.write.upload){return true}else{return false}}}if(oDragInfo!=undefined){if(!bIsDir||$(curDropTargetELThumb).hasClass("marked")){return false}var nfo=ic.getCurrentConnectorInfo();if(oDragInfo.mode!=="copy"){return bConnectorDropWithinFolderAllow}return(bConnectorDropAllow&&oDragInfo.oConnectorInfo.permissions.read.copy)}else{if(!browser.fileAPI){return false}return bConnectorUploadDropAllow}return false};var onThumbDropOnDir=function(el,evt){if(curDropTargetELThumb==undefined&&oDragInfo!=undefined){return}var entry,path;if(curDropTargetELThumb!=undefined){entry=getEntryFromHTMLNode(curDropTargetELThumb)}if(!oDragInfo){if(entry!=undefined&&entry.type=="directory"){path=getImagePath(entry)}if(path!=undefined){ic.handleFolderDrop(decodeURIComponent(path),evt)}else{ic.handleFolderDrop(browsePath,evt)}}else{if(!entry){return}path=getImagePath(entry);if(path==undefined){return}ic.handleFolderDrop(decodeURIComponent(path),evt)}};var reimportSelected=this.reimportSelected=function(domObjectCaller){var bWriteExtendedMeta=ic.getConnectorPermission("write","extendedMetadata");if(!bWriteExtendedMeta&&!ic.getConnectorPermission("tasks","reimportFiles")){return}ic.askReimportSelected()};var renameSelectedThumb=this.renameSelectedThumb=function(domObjectCaller){if(domObjectCaller&&domObjectCaller.nodeType!=1){domObjectCaller=undefined}if(!ic.getConnectorPermission("write","rename")){return}if(oSelection.isEmpty()){return}if(currentConnectorType=="DOWNLOADS"||currentConnectorType=="TRASH"){return}startProcessingSelection("renameItem",self.onEndProcess,self.onEndProcess)};this.onEndProcess=function(oProcessStruct){if(!oProcessStruct||!oProcessStruct.finalAction){return}if(oProcessStruct.finalAction==2){ic.getFolderTree().reloadCurrent()}else{reloadVisibleThumbs()}};var startProcessingSelection=function(strTask,fnCancel,fnDone){if(strTask==undefined||strTask.length<1||oSelection.isEmpty()){return}var oProcessStruct={};oProcessStruct.strTask=strTask;oProcessStruct.arItems=oSelection.getArray();oProcessStruct.nItems=oProcessStruct.arItems.length;oProcessStruct.nCurrentItem=0;oProcessStruct.fnCancel=fnCancel;oProcessStruct.fnDone=fnDone;self.processNextSelectedItem(oProcessStruct)};this.processNextSelectedItem=function(oProcessStruct){if(!oProcessStruct){return false}var entry=oProcessStruct.arItems[oProcessStruct.nCurrentItem];if(!entry||oProcessStruct.nCurrentItem==oProcessStruct.nItems){updateFirstSelectedThumb();if(oProcessStruct.fnDone){oProcessStruct.fnDone(oProcessStruct)}return false}oProcessStruct.currentEntry=entry;switch(oProcessStruct.strTask){case"renameItem":ic.askRenameSelected(oProcessStruct);break}oProcessStruct.nCurrentItem++;return true};this.handleRightClick=function(someHTMLELement){if(oSelection.isMulti()){return}var elTable=self.getThumbTableFromEventElement(someHTMLELement);if(!elTable||isThumbSelected(elTable)){return}selectNone(true);selectThumb(elTable,true);updateViewPortStats()};this.lockToolTip=function(bLocked){bToolTipsLocked=bLocked;if(bLocked){hideToolTip()}};var onDragEnd=function(evt){setTheFocus();oDragInfo=undefined;return false};var onDragStart=function(evt){if(browser.bDragImageOnly){evt.cancelBubble=true}var el=evt.srcElement;if(el==undefined){el=evt.originalTarget}var thumb=getThumbItemTableFromChildEl(el);if(!thumb){return}hideToolTip();if(evt!=undefined&&evt.dataTransfer!=undefined){var bCTRLKey=ic.getCTRLKey(evt);var bShift=ic.getShiftKey(evt);var bCopy=(!bShift);try{evt.dataTransfer.setData("application/x-fsi","FSIThumbSelection")}catch(e){evt.dataTransfer.setData("Text","TEST")}if(bCopy){evt.dataTransfer.effectAllowed="copy";evt.dataTransfer.dropEffect="copy"}else{evt.dataTransfer.effectAllowed="move";evt.dataTransfer.dropEffect="move"}if(!isThumbSelected(this)){selectThumb(thumb,true)}var mode=(bCopy)?"copy":"cut";oDragInfo={};oDragInfo.bCTRL=bCTRLKey;oDragInfo.bShiftKey=bShift;oDragInfo.mode=mode;oDragInfo.oConnectorInfo=ic.getCurrentConnectorInfo();oDragInfo.element=this;doCopySelectionToClipboard(mode)}if(evt.stopPropagation){evt.stopPropagation()}return true};var thumbMouseOver=function(s){self.bMouseOverThumb=true;if(bToolTipsLocked||nViewMode==viewModeList){return}if(!s.realThumb||browser.touchDevice){oToolTipData.lastEntrySrcOver=undefined;return}clearToolTipTimeout();oToolTipData.bShow=true;oToolTipData.lastOverElement=s;if(!oToolTipData.bVisible){oToolTipData.idTimeout=setTimeout(showHideToolTip,800)}else{showHideToolTip()}};var tipArrowClick=function(evt){var elTable=oToolTipData.lastOverElement;if(!elTable){return}markThumb(evt,elTable)};var thumbMouseOut=function(){self.bMouseOverThumb=false;if(oToolTipData.bShow){clearToolTipTimeout();if(oToolTipData.bVisible){oToolTipData.bShow=false;oToolTipData.idTimeout=setTimeout(showHideToolTip,350)}}};var clearToolTipTimeout=function(){if(oToolTipData.idTimeout==undefined){return}clearTimeout(oToolTipData.idTimeout);oToolTipData.idTimeout=undefined};var hideToolTip=this.hideToolTip=function(){clearToolTipTimeout();if(!oToolTipData.bVisible){return}oToolTipData.bShow=false;showHideToolTip()};var toolTipOuterOver=function(){thumbMouseOver(oToolTipData.lastOverElement)};var onTipOver=function(){hideToolTip()};var invalidateToolTip=this.invalidateToolTip=function(){oToolTipData.lastDisplayedElement=undefined};var showHideToolTip=function(){var arrow;var bodyID=ic.getDocumentBody();if(!bodyID){return}var elTipDiv=document.getElementById("picturetooltipContainer");if(oToolTipData.bShow){if(!elTipDiv&&oToolTipData.lastOverElement){var cmpTip=ic.getComponents().getComponent("picturetooltip");bodyID.appendChild(cmpTip.firstChild.cloneNode(true));elTipDiv=document.getElementById("picturetooltipContainer");var elTipDivContent=document.getElementById("picturetooltipContent");elTipDivContent.onmouseover=onTipOver;oToolTipData.elArrowUp=document.getElementById("picturetooltiparrowup");if(oToolTipData.elArrowUp){oToolTipData.elArrowUp.style.width=itemWidth;oToolTipData.elArrowUp.onmouseover=toolTipOuterOver;oToolTipData.elArrowUp.onmouseout=thumbMouseOut;oToolTipData.elArrowUp.ondblclick=renameSelectedThumb;oToolTipData.elArrowUp.onclick=tipArrowClick}oToolTipData.elArrowDown=document.getElementById("picturetooltiparrowdown");if(oToolTipData.elArrowDown){oToolTipData.elArrowDown.style.width=itemWidth;oToolTipData.elArrowDown.onmouseover=toolTipOuterOver;oToolTipData.elArrowDown.onmouseout=thumbMouseOut;oToolTipData.elArrowDown.ondblclick=renameSelectedThumb;oToolTipData.elArrowDown.onclick=tipArrowClick}}if(elTipDiv){var elTipDivContent=document.getElementById("picturetooltipContent");var elTable=oToolTipData.lastOverElement;var left=ic.getViewportOffsetLeft()+elTable.offsetLeft+elTable.parentNode.offsetLeft-4;var top=ic.getThumbViewDim().top+elTable.offsetTop+elTable.parentNode.offsetTop+elTable.offsetHeight;var arrowOffsetLeft=0;if(oToolTipData.lastOverElement!=oToolTipData.lastDisplayedElement){oToolTipData.lastDisplayedElement=oToolTipData.lastOverElement;var entry=oToolTipData.lastOverElement.listEntry;var content=ic.getMainCTL().getImageInfoContent(entry,"picturetooltip","",30);elTipDivContent.innerHTML=content;if(content.length>0){elTipDiv.style.width="380px";elTipDiv.style.minWidth="380px";elTipDiv.style.maxWidth="380px";elTipDiv.style.display="block";if(elTipDivContent.firstChild.offsetWidth+2<elTable.offsetWidth-toolTipOffsetX){elTipDiv.style.width=elTable.offsetWidth-toolTipOffsetX}else{elTipDiv.style.width=(elTipDivContent.firstChild.offsetWidth+2)+"px"}}}if(elTipDivContent&&elTipDivContent.firstChild){var dim=ic.getWindowSize();if(left+elTipDiv.offsetWidth>dim.width){left-=elTipDiv.offsetWidth-elTable.offsetWidth;arrowOffsetLeft=elTipDiv.offsetWidth-Math.round(elTable.offsetWidth/2)-7}else{arrowOffsetLeft=Math.round(elTable.offsetWidth/2)-9}elTipDiv.style.display="block";elTipDiv.style.left=(left+toolTipOffsetX)+"px";if(top+elTipDivContent.offsetHeight>dim.height){$(oToolTipData.elArrowUp).hide();$(oToolTipData.elArrowDown).show();$(oToolTipData.elArrowDown).css("left",arrowOffsetLeft+"px");elTipDiv.style.top=(top-elTable.offsetHeight-elTipDivContent.offsetHeight-6)+"px";$(elTipDivContent).removeClass("borderBottom");$(elTipDivContent).addClass("borderTop")}else{$(oToolTipData.elArrowUp).show();$(oToolTipData.elArrowUp).css("left",arrowOffsetLeft+"px");$(oToolTipData.elArrowDown).hide();$(elTipDivContent).addClass("borderBottom");$(elTipDivContent).removeClass("borderTop");elTipDiv.style.top=(top-11)+"px"}}else{if(elTipDiv){oToolTipData.lastDisplayedElement=undefined;bodyID.removeChild(elTipDiv)}}}}else{if(elTipDiv){oToolTipData.lastDisplayedElement=undefined;bodyID.removeChild(elTipDiv)}}oToolTipData.bVisible=oToolTipData.bShow};var markThumb=function(evt,s,bForceCTRL){if(bBlockNextMouseUp){bBlockNextMouseUp=false}self.setTheFocus();if(s.realThumb){oCursor.el=s;var bCTRLKey=ic.getCTRLKey(evt);if(ic.getShiftKey(evt)&&oSelectionElementLast!=undefined){selectRangeFromElement(s,bCTRLKey)}else{if(!bCTRLKey){selectNone(true);selectThumb(s,true);bLastCTRLSelectWasSelect=true}else{var bSelect=bLastCTRLSelectWasSelect=!isThumbSelected(s);selectThumb(s,bSelect)}updateViewPortStats()}}};var inRange=function(val,oRange){if(isNaN(val)){return}return(val>=oRange.start&&val<=oRange.end)};var getUnknownRange=function(nStart,nEnd){var ret;if(nStart>nEnd){var t=nEnd;nEnd=nStart;nStart=t}var ret;if(!bDoUseClientDirectoryCache){if(inRange(nStart,scrollControl.oRangeLoaded)&&inRange(nEnd,scrollControl.oRangeLoaded)){ret=true}else{ret={};ret.start=nStart;ret.end=nEnd}}else{ret=dataArray.getRangeToLoad(nStart,nEnd);if(ret==undefined){ret=true}}return ret};var isListIndexValid=function(entry){if(!entry){return false}return(bDoUseClientDirectoryCache)?(dataArray.getLastModified()==lastModified):(entry.listLastModified==lastModified)};var selectRangeFromElement=function(el,ctrlKey){var itemLast=(bLastCTRLSelectWasSelect)?oSelectionElementLast:oSelectionElementLastDeselected;if(oSelectionElementLast==undefined||oSelection.isLocked()){return}var clickedIndex=el.listEntryIndex;var lastShiftClickedIndex;if(oSelectionElementLastShift!=undefined){lastShiftClickedIndex=oSelectionElementLastShift.listEntryIndex}else{lastShiftClickedIndex=undefined}var noShiftClickedIndex=itemLast.listEntryIndex;var nStartSelect=noShiftClickedIndex;var nEndSelect=clickedIndex;var nStartDeselect=undefined;var nEndDeselect=undefined;if(lastShiftClickedIndex!=undefined){if(!ctrlKey){if(clickedIndex>=lastShiftClickedIndex){var tmp=lastShiftClickedIndex;if(lastShiftClickedIndex<noShiftClickedIndex){nStartDeselect=lastShiftClickedIndex;nEndDeselect=noShiftClickedIndex-1;tmp=noShiftClickedIndex}nStartSelect=tmp;nEndSelect=clickedIndex}else{if(clickedIndex<noShiftClickedIndex){nStartSelect=clickedIndex;nEndSelect=noShiftClickedIndex;nStartDeselect=noShiftClickedIndex;nEndDeselect=lastShiftClickedIndex}else{nStartSelect=nEndSelect=undefined;nStartDeselect=clickedIndex+1;nEndDeselect=lastShiftClickedIndex}}}else{}}else{}if(bLastCTRLSelectWasSelect){if(ctrlKey){nStartDeselect=nEndDeselect=undefined}self.selectRange(nStartDeselect,nEndDeselect,nStartSelect,nEndSelect)}else{self.selectRange(nStartSelect,nEndSelect,undefined,undefined)}oSelectionElementLastShift=oSelection.getItem(el.listEntry.src)};var isValidDataIndex=function(val){if(val==undefined||isNaN(val)||val<0||val>=entryCount){return false}return true};this.selectRange=function(nStartDeselect,nEndDeselect,nStartSelect,nEndSelect){if(oSelection.isLocked()){return}if(nStartDeselect<0){nStartDeselect=0}if(nStartSelect<0){nStartSelect=0}var bDontNeedHelpFromServer=true;var bSomethingToSelect=(isValidDataIndex(nStartSelect)&&isValidDataIndex(nEndSelect));var bSomethingToDeselect=(!oSelection.isEmpty()&&isValidDataIndex(nStartDeselect)&&isValidDataIndex(nEndDeselect));if(!bSomethingToSelect&&!bSomethingToDeselect){}var rngLoadDeselect;var rngLoadSelect;if(bSomethingToSelect){rngLoadSelect=getUnknownRange(nStartSelect,nEndSelect)}else{rngLoadSelect=true}if(bSomethingToDeselect){rngLoadDeselect=getUnknownRange(nStartDeselect,nEndDeselect)}else{rngLoadDeselect=true}bDontNeedHelpFromServer=(rngLoadSelect===true&&rngLoadDeselect===true);if(!bDontNeedHelpFromServer){var oQueuedSelectionData={};oQueuedSelectionData.nStartDeselect=nStartDeselect;oQueuedSelectionData.nEndDeselect=nEndDeselect;oQueuedSelectionData.nStartSelect=nStartSelect;oQueuedSelectionData.nEndSelect=nEndSelect;oQueuedSelectionData.bSomethingToSelect=bSomethingToSelect;oQueuedSelectionData.rngLoadSelect=rngLoadSelect;var nItems=rngLoadSelect.end-rngLoadSelect.start+1;ic.getDialogs().showCancelDlg(cancelLoadingSelectionData,oQueuedSelectionData);chunkLoadProgressDiv=$("#innercanceloperationProgress");$(chunkLoadProgressDiv).css("width","0%");oQueuedSelectionData.oLoadChunk=self.retrieveThumbList(rngLoadSelect.start,nItems,true,onSelectRangeDataAvailable,oQueuedSelectionData);return}else{doSelectRange(nStartDeselect,nEndDeselect,nStartSelect,nEndSelect)}};var cancelLoadingSelectionData=function(oQueuedSelectionData){oQueuedSelectionData.oLoadChunk.bCanceled=true;oQueuedSelectionData.bCanceled=true};var onDeselectRangeDataAvailable=function(oQueuedSelectionData){if(!oQueuedSelectionData){return}if(oQueuedSelectionData.bCanceled){return}};var onSelectRangeDataAvailable=function(oQueuedSelectionData){if(!oQueuedSelectionData){return}if(oQueuedSelectionData.bCanceled){return}$(chunkLoadProgressDiv).css("width","50%");doSelectRange(oQueuedSelectionData.nStartDeselect,oQueuedSelectionData.nEndDeselect,oQueuedSelectionData.nStartSelect,oQueuedSelectionData.nEndSelect);if(timeoutSelectChunk==undefined){ic.getDialogs().closeCancelDlg()}};var doSelectRange=function(nStartDeselect,nEndDeselect,nStartSelect,nEndSelect){var bSomethingToSelect=(isValidDataIndex(nStartSelect)&&isValidDataIndex(nEndSelect));var bSomethingToDeselect=(!oSelection.isEmpty()&&isValidDataIndex(nStartDeselect)&&isValidDataIndex(nEndDeselect));var nRealStartElement=scrollControl.oVisibleRange.start;var nRealEndElement=scrollControl.oVisibleRange.end;var bUpdateStats=true;if(bSomethingToDeselect){if(nStartDeselect>nEndDeselect){var t=nEndDeselect;nEndDeselect=nStartDeselect;nStartDeselect=t}var nS=Math.max(nStartDeselect,nRealStartElement);var nE=Math.min(nEndDeselect,nRealEndElement);for(var i=nS;i<=nE;i++){var entry=imageList[i-dataOffset];var elTable=getTableElementByEntrySrc(entry.src);if(elTable){showThumbSelected(elTable,false)}}var o;for(var i=nStartDeselect-dataOffset;i<=nEndDeselect-dataOffset;i++){oSelection.removeItem(imageList[i].src)}}if(bSomethingToSelect){if(nStartSelect>nEndSelect){var t=nEndSelect;nEndSelect=nStartSelect;nStartSelect=t}var nS=Math.max(nStartSelect,nRealStartElement);var nE=Math.min(nEndSelect,nRealEndElement);for(var i=nS;i<=nE;i++){var entry=imageList[i-dataOffset];var elTable=getTableElementByEntrySrc(entry.src);if(elTable){showThumbSelected(elTable,true)}}var oRangeToSelect={};oRangeToSelect.startInitial=oRangeToSelect.start=nStartSelect-dataOffset;oRangeToSelect.chunkSize=5000;oRangeToSelect.currentChunkEnd=oRangeToSelect.start+oRangeToSelect.chunkSize;oRangeToSelect.end=nEndSelect-dataOffset;oRangeToSelect.nTotalItems=oRangeToSelect.end-oRangeToSelect.start;if(oRangeToSelect.currentChunkEnd>oRangeToSelect.end){oRangeToSelect.currentChunkEnd=oRangeToSelect.end}else{bUpdateStats=false}continueSelectRange(oRangeToSelect)}if(bUpdateStats){updateViewPortStats()}};function continueSelectRange(oRangeToSelect){var t=oRangeToSelect.currentChunkEnd-oRangeToSelect.startInitial;var prg=Math.round(100*t/oRangeToSelect.nTotalItems);$(chunkLoadProgressDiv).css("width",prg+"%");for(var i=oRangeToSelect.start;i<=oRangeToSelect.currentChunkEnd;i++){var entry=imageList[i];if(entry){var o=oSelection.addItem(entry.src,entry);o.listEntryIndex=i+dataOffset;o.listLastModified=lastModified}}if(oRangeToSelect.currentChunkEnd<oRangeToSelect.end){ic.lockInterface(false,false,0.35);oRangeToSelect.start=oRangeToSelect.currentChunkEnd+1;oRangeToSelect.currentChunkEnd=Math.min(oRangeToSelect.end,oRangeToSelect.currentChunkEnd+oRangeToSelect.chunkSize);clearTimeout(timeoutSelectChunk);timeoutSelectChunk=setTimeout(function(){continueSelectRange(oRangeToSelect)},25)}else{oSelectionElementLast=o;ic.getDialogs().closeCancelDlg();ic.unlockInterface();updateViewPortStats()}}this.addItemToSelection=function(entry){oSelection.addItem(entry.src,entry)};this.removeItemFromSelection=function(src){oSelection.removeItem(src)};var getFirstSelectionElement=function(){return oSelection.getFirstItemData()};this.isSelectionEmpty=function(){return oSelection.isEmpty()};this.isSelectionMulti=function(){return oSelection.isMulti()};var isThumbSelected=function(el){if(!el){return false}return $(el).hasClass("marked")};var getDivElementByEntrySrc=function(src){return thumbDivReg[src]};var getThumbItemTableFromChildEl=function(el){var ret=undefined;var n=0;while(el&&el.id!="thumbbody"&&n<30){if(el.listEntry!=undefined){ret=el;break}n++;el=el.parentNode}return ret};var getTableElementByEntrySrc=function(src){var el=undefined;if(src!=undefined){var el=getDivElementByEntrySrc(src);if(el){while(el&&el.nodeName!="TABLE"){el=el.parentNode}}}return el};this.getEntryCount=function(){return entryCount};var resetCursorPos=function(){oCursor.lastIndex=undefined;oCursor.el=undefined;oCursor.bShift=oCursor.shiftKey=oCursor.bCTRL=oCursor.ctrlKey=undefined};var resetCursor=function(){oCursor={};oCursor.nKeyRepeat=0};var moveCursorByKeyboard=function(keycode,bByScript){if(oCursor.lastKey==keycode){oCursor.nKeyRepeat++}else{oCursor.lastKey=keycode}switch(keycode){case 39:moveCursorRelative(1,0,bByScript);break;case 37:moveCursorRelative(-1,0,bByScript);break;case 38:moveCursorRelative(0,-1,bByScript);break;case 40:moveCursorRelative(0,1,bByScript);break;case 33:moveCursorRelative(0,-thumbsY,bByScript);break;case 34:moveCursorRelative(0,thumbsY,bByScript);break;case 35:if(oCursor.nKeyRepeat==0){moveCursorRelative(entryCount,entryCount,bByScript)}break;case 36:if(oCursor.nKeyRepeat==0){moveCursorRelative(-entryCount,-entryCount,bByScript)}break}oCursor.bDirectionKeyDown=true};var moveCursorRelative=function(x,y,bByScript){if(oCursor.bWaitForFill||entryCount==0){return}if(!oCurrentFillRange){return}var el;var elNext;var row,col,index,newIndex;if(oCursor.oMoveAfterFill!=undefined){var o=oCursor.oMoveAfterFill;o.dx+=x;o.dy+=y;newIndex=calcCursorMovement(o.row,o.col,o.dx,o.dy);return}else{if(oCursor.el!=undefined){if(oCursor.nKeyRepeat==0){if(!$(oCursor.el).hasClass("marked")){oCursor.el=undefined}}el=oCursor.el;if(!oCursor.bShift&&oSelection.isMulti()){selectNone(true)}}if(el==undefined){el=$("#thumbCanvas "+strImageTableClass+".marked").get(0);if(!oCursor.bShift&&oSelection.isMulti()){selectNone(true);if(el){selectThumb(el,true);oCursor.el=el;oCursor.elThumbToMarkOnKeyUp=el}}if(el==undefined){el=$("#thumbCanvas "+strImageTableClass).get(0);if(!oSelection.isEmpty()){selectNone(true)}selectThumb(el,true);oCursor.el=el;oCursor.elThumbToMarkOnKeyUp=el;return}}index=parseInt($(el).attr("thumbindex"));row=Math.floor(index/thumbsX);col=index%thumbsX;newIndex=calcCursorMovement(row,col,x,y)}if(newIndex==undefined&&!oCursor.bShift){selectThumb(el,false);return}var elNext=$("#thumbCanvas").find(strImageTableClass+'[thumbindex="'+newIndex+'"]').get(0);if($(elNext).get(0)&&newIndex!=index){if(!oCursor.bShift||oCursor.lastIndex==undefined){oCursor.lastIndex=index+scrollControl.oVisibleRange.start}if(!oCursor.bShift){selectThumb(el,false)}else{oCursor.bNextWasSelected=$(elNext).hasClass("marked");if(oCursor.bNextWasSelected){selectThumb(el,false)}}selectThumb(elNext,true);oCursor.el=elNext;oCursor.elThumbToMarkOnKeyUp=elNext}};var calcCursorMovement=function(row,col,x,y){var rangeStart=scrollControl.oVisibleRange.start;var rangeEnd=scrollControl.oVisibleRange.end;var nImageOffset=scrollControl.getImageOffset();var nMinColumn=(rangeStart<0)?nImageOffset:0;var fillEndRel=rangeEnd-rangeStart;var cells=thumbsX*thumbsY;var newCol=col+x;var newRow=row+y;var oldIndex=row*thumbsX+col;var newIndex=newRow*thumbsX+newCol;if(newIndex>fillEndRel){if(rangeEnd+1>=entryCount){if(y!=0){var thumbsInLastRow=fillEndRel%thumbsX;var lastRow=Math.floor(fillEndRel/thumbsX);if(newRow>lastRow){newIndex+=(lastRow-newRow)*thumbsX}if(thumbsY>1&&col>thumbsInLastRow){newIndex-=thumbsX}}newIndex=Math.min(newIndex,fillEndRel)}else{var nRowsToScroll=Math.ceil((newIndex+1-cells)/thumbsX);nRowsToScroll=scrollControl.scrollByRow(nRowsToScroll,false);setCursorMoveAfterFill(row-nRowsToScroll,col,x,y);return}}else{if(newIndex<nMinColumn){if(rangeStart<1){if(-y>row){newIndex+=(-y-row)*thumbsX}newIndex=Math.max(nMinColumn,newIndex)}else{var nRowsToScroll=Math.ceil(-newIndex/thumbsX);nRowsToScroll=scrollControl.scrollByRow(-nRowsToScroll,false);setCursorMoveAfterFill(row-nRowsToScroll,col,x,y);return}}}return newIndex};var setCursorMoveAfterFill=function(row,col,dx,dy){if(row==undefined||col==undefined){return}if(dx==undefined){dx=0}if(dy==undefined){dy=0}var o=oCursor.oMoveAfterFill={};o.row=row;o.col=col;o.dx=dx;o.dy=dy};var onEndCursorMove=function(){var indexCurrent=parseInt($(oCursor.el).attr("thumbindex"))+scrollControl.oVisibleRange.start;if(oCursor.bShift&&Math.abs(indexCurrent-oCursor.lastIndex)>1){if(oCursor.bNextWasSelected){self.selectRange(oCursor.lastIndex,indexCurrent);selectThumb(oCursor.el,true)}else{self.selectRange(undefined,undefined,oCursor.lastIndex,indexCurrent)}}updateViewPortStats();oCursor.elThumbToMarkOnKeyUp=undefined;oCursor.lastIndex=indexCurrent};var moveCursorAfterFill=function(){oCursor.bWaitForFill=false;var o=oCursor.oMoveAfterFill;var newIndex=calcCursorMovement(o.row,o.col,o.dx,o.dy);oCursor.oMoveAfterFill=undefined;var elNext=$("#thumbCanvas").find(strImageTableClass+'[thumbindex="'+newIndex+'"]').get(0);if($(elNext).get(0)){oCursor.bNextWasSelected=$(elNext).hasClass("marked");selectThumb(elNext,true);oCursor.el=elNext;if(oCursor.bDirectionKeyDown){oCursor.elThumbToMarkOnKeyUp=elNext}else{onEndCursorMove(elNext)}}};var selectThumb=function(el,bSelect){if(!el||oSelection.isLocked()){return}var thumbEntry=getEntryFromHTMLNode(el);if(!thumbEntry||!thumbEntry.src){return}var src=thumbEntry.src;oSelectionElementLastShift=undefined;if(bSelect){oSelectionElementLast=oSelection.addItem(src,thumbEntry);oSelectionElementLast.listEntryIndex=el.listEntryIndex;oSelectionElementLast.listLastModified=lastModified;showThumbSelected(el,true)}else{oSelectionElementLastDeselected=oSelection.getItem(src);oSelection.removeItem(src);showThumbSelected(el,false);if(oSelection.isEmpty()){oSelectionElementLast=undefined}}};var showThumbSelected=function(el,bSelected){if(bSelected){$(el).addClass("marked");$(el.myTextTD).addClass("marked")}else{$(el).removeClass("marked");$(el.myTextTD).removeClass("marked")}};var selectNone=this.selectNone=function(bNoUpdate){if(oSelection.isEmpty()||oSelection.isLocked()){return}var bDone=false;if(!oSelection.isMulti()){var entry=getFirstSelectionElement();var el=getTableElementByEntrySrc(entry.src);if(el!=undefined){selectThumb(el,false);bDone=true}}oSelection.clear();oSelectionElementLast=undefined;oSelectionElementLastShift=undefined;oSelectionElementLastDeselected=undefined;if(!bNoUpdate){updateViewPortStats()}if(bDone){return}$("#thumbCanvas").find("table.marked").each(function(){$(this).removeClass("marked");$(this.myTextTD).removeClass("marked")})};this.selectAll=function(){if(oSelection.getCount()==(imageCount+directoryCount)){return}self.selectRange(undefined,undefined,0,entryCount-1)};this.selectAllVisible=function(bShift){if(!bShift){selectNone(true)}self.selectRange(undefined,undefined,scrollControl.oVisibleRange.start,scrollControl.oVisibleRange.end)};this.displayPicture=function(entry,bShowPanel){if(!entry){return}getImagePath(entry);ic.getPictureView().activate(entry,"Viewer",bShowPanel)};this.enterDirectory=function(fullsrc){if(!fullsrc){return}ic.setBasePath(decodeURIComponent(fullsrc))};var getShortURL=function(str){return str};var getEntryFromHTMLNode=function(node){if(!node){return}if(node.listEntry){return node.listEntry}return undefined};var getlistEntryIndexFromHTMLNode=function(node){if(!node){return}if(node.listEntryIndex!=undefined){return node.listEntryIndex}return undefined};this.elementIsPartOfRealThumb=function(el){if(!el){return false}var table=$(el).closest("table");if($(table).length==0||$(table).attr("name")!="imgcnttbl"){return false}return true};this.getThumbTableFromEventElement=function(el){if(!el){return undefined}var table=$(el).closest("table");if($(table).length==0||$(table).attr("name")!="imgcnttbl"){return undefined}var ret=$(table).get(0);if(!ret.realThumb){return undefined}return ret};this.onVisibleRangeChanged=function(){var strVisibleRangeNew;if(scrollControl.getVisible()){strVisibleRangeNew=scrollControl.getRangeText()}if(strVisibleRangeNew==strVisibleRange){return}strVisibleRange=strVisibleRangeNew;lastStatusBarSelectedCount="refresh";updateViewPortStats()};var updateViewPortStats=this.updateViewPortStats=function(){if(oCursor.bDirectionKeyDown||oCursor.oMoveAfterFill!=undefined){return}updateFirstSelectedThumb();var selcount=oSelection.getCount();if(selcount!=lastStatusBarSelectedCount){var selcountCMD=selcount;if(selcount>1){selcountCMD=1}if(selcountCMDLast!=selcountCMD){selcountCMDLast=selcountCMD;updateButtonStates(selcountCMD)}lastStatusBarSelectedCount=selcount;ic.getStatusBarControl().setFolderStats(imageCount,directoryCount,completeCount,lastModified,selcount,strVisibleRange)}ic.viewPortChangeManager()};var updateButtonStates=function(selcountCMD){var bEnable=(selcountCMD==1);enableButtonArray(["btnCMRename","btnCMCopy","btnCMCut","btnCMDelete"],bEnable,true)};var updatePasteButtonState=function(bEnable){enableButtonArray(["btnCMPaste"],bEnable,true)};this.emptyClipBoard=function(){if(isClipboardEmpty()){return}oClipboard=undefined;updateViewPortStats();updatePasteButtonState(false)};var isClipboardEmpty=this.isClipboardEmpty=function(){var ret=(oClipboard==undefined);return ret};this.cutSelectionToClipboard=function(domObjectCaller){if(currentConnectorType=="TRASH"){return}if(!ic.getConnectorPermission("write","delete")||!ic.getConnectorPermission("read","copy")){return}copySelectionToClipboard(domObjectCaller,"cut")};var copySelectionToClipboard=this.copySelectionToClipboard=function(domObjectCaller,strMode){if(!oSelection||oSelection.isEmpty()){return}if(strMode==undefined||strMode!="cut"){strMode="copy"}doCopySelectionToClipboard(strMode)};var doCopySelectionToClipboard=function(strMode){oClipboard={};oClipboard.basePathType=basePathType;oClipboard.basePath=browsePath;oClipboard.arEntries=oSelection.getArray();oClipboard.strMode=strMode;oClipboard.fromConnector=currentConnectorName;updatePasteButtonState(true);updateViewPortStats()};var pasteFromClipboard=this.pasteFromClipboard=function(domObjectCaller){if(!oClipboard||!oClipboard.arEntries||oClipboard.arEntries.length<1||basePathType!="dir"){return}if(browsePath==oClipboard.basePath){ic.getDialogs().showAlert("Source and Target are identical");return}ic.askMoveItems(oClipboard,browsePath);return};var createContextMenu=function(){var cmComponent=ic.getComponents().getComponent("contextmenus");var menuComponent=$(cmComponent).find("#contextmenu_thumbview").get(0);var bodyID=ic.getDocumentBody();if(!menuComponent||!bodyID){return}var myMenu=menuComponent;bodyID.appendChild(myMenu);myContextMenu=$("#thumbCanvas").contextMenu({menu:"contextmenu_thumbview",inSpeed:-1,outSpeed:250},handleContextMenuAction,onBeforeContextMenu,onContextMenuClose);$("#thumbViewFocusElement").on("contextmenu",function(){var evt1=jQuery.Event("mousedown");evt1.button=2;$("#thumbCanvas").triggerHandler(evt1);var evt2=jQuery.Event("mouseup");evt2.button=2;setMousePosContextMenuEvent(evt2);$("#thumbCanvas").triggerHandler(evt2);return false})};var setMousePosContextMenuEvent=function(evt){evt.pageX=ic.getViewportOffsetLeft();evt.pageY=ic.getViewportOffsetTop()};this.showContextMenu=function(){return;var o={};o.button=2;var res=fireEvent($("#thumbCanvas").get(0),"mousedown",o)};this.getSingleSelectedItem=function(){if(!oSelection.isEmpty()&&!oSelection.isMulti()){return oSelection.getFirstItemData()}return undefined};this.getSingleSelectedItemType=function(){var entry=self.getSingleSelectedItem();if(entry){return entry.type}return undefined};var onContextMenuClose=function(){setTheFocus();self.lockToolTip(false)};var hideContextMenuItem=function(nam,bHide){if(bHide){$("#contextmenu_thumbview").find("LI A[href='#"+nam+"']").parent().hide().addClass("disabled")}else{$("#contextmenu_thumbview").find("LI A[href='#"+nam+"']").parent().show().removeClass("disabled")}};var entryMayBeDownloaded=function(entry,oConnectorInfo){if(!entry||!oConnectorInfo||!oConnectorInfo.permissions||!oConnectorInfo.permissions.read){return false}if(entry.type=="directory"){return false}return(oConnectorInfo.permissions.read.downloadSource===true)};var onBeforeContextMenu=function(elMenu,evt){var bEnable;self.lockToolTip(true);if(viewMode=="list"){hideContextMenuItem("selectColumns",false)}else{hideContextMenuItem("selectColumns",true)}var arToDisable=new Array();var arToEnable=new Array();var oEnable={};var enable=function(keys,bEnable){keys=keys.split(",");for(var i=0;i<keys.length;i++){oEnable[keys[i]]=bEnable}};var singleSelectedItemType=self.getSingleSelectedItemType();var entry=getFirstSelectionElement();var oProfilInfo=ic.getFolderTree().getConnectorInfoByEntry(entry);var oCurrentConnectorInfo=ic.getCurrentConnectorInfo();switch(currentConnectorType){case"TRASH":enable("deleteTrash",!oSelection.isEmpty()&&ic.getConnectorPermission("write","delete"));enable("restore",!oSelection.isEmpty());break;case"DOWNLOADS":enable("deleteTrash",!oSelection.isEmpty()&&ic.getConnectorPermission("write","delete"));bEnable=(!oSelection.isMulti()&&!oSelection.isEmpty());if(bEnable){bEnable=(ic.getConnectorPermission("tasks","batchRendering")||ic.getConnectorPermission("tasks","createArchive"))}if(!bEnable){enable("canceljob,restartjob",false)}else{enable("canceljob",(entry&&(entry.status==2||entry.status==4)));enable("restartjob",(entry&&entry.status!=2))}break;case"STATIC":enable("openItemInNewWindow",(!oSelection.isEmpty()&&!oSelection.isMulti()&&singleSelectedItemType!="directory"));break}enable("create",ic.getConnectorPermission("write","createDirectory"));if(isClipboardEmpty()){enable("paste",false)}else{if(oClipboard.strMode!="copy"){var bWithinSameConnector=(oClipboard.fromConnector==currentConnectorName);if(bWithinSameConnector){bEnable=ic.getConnectorPermission("write","moveWithinConnector")}else{var info=ic.getFolderTree().getConnectorInfoByName(oClipboard.fromConnector);bEnable=(ic.getConnectorPermission("write","paste")&&info&&info.permissions&&info.permissions.write&&info.permissions.write["delete"])}}else{var info=ic.getFolderTree().getConnectorInfoByName(oClipboard.fromConnector);bEnable=(ic.getConnectorPermission("write","paste")&&info&&info.permissions&&info.permissions.read&&info.permissions.read.copy)}enable("paste",bEnable)}var bDelete=(ic.getConnectorPermission("write","delete")||ic.getConnectorPermission("write","moveToTrash"));enable("delete",bDelete&&!oSelection.isEmpty());enable("cut",!oSelection.isEmpty()&&ic.getConnectorPermission("read","copy")&&(ic.getConnectorPermission("write","moveWithinConnector")||ic.getConnectorPermission("write","delete")));enable("copy",!oSelection.isEmpty()&&ic.getConnectorPermission("read","copy"));var bWriteExtendedMeta=ic.getConnectorPermission("write","extendedMetadata");var bEnable=(!oSelection.isEmpty()&&(bWriteExtendedMeta||ic.getConnectorPermission("tasks","reimportFiles")));if(bEnable&&currentConnectorType!="STORAGE"){bEnable=bWriteExtendedMeta}enable("reimportselected",bEnable);enable("rename",!oSelection.isEmpty()&&ic.getConnectorPermission("write","rename"));enable("downloadselected",!oSelection.isEmpty()&&!oSelection.isMulti()&&entryMayBeDownloaded(entry,oProfilInfo));enable("adddownload",(!oSelection.isEmpty()&&(oCurrentConnectorInfo._bMixedSourceConnectors||(ic.getConnectorPermission("tasks","createArchive")&&ic.getConnectorPermission("read","downloadSource")))));if(oCurrentConnectorInfo._bMixedSourceConnectors){enable("addbatch",true)}else{if(currentConnectorType=="STORAGE"||currentConnectorType=="MULTIRESOLUTION"){enable("addbatch",(!oSelection.isEmpty()&&ic.getConnectorPermission("tasks","batchRendering")))}else{enable("addbatch",false)}}enable("selectall",(entryCount>0)&&!oSelection.isLocked());enable("selectnone",!oSelection.isEmpty()&&!oSelection.isLocked());for(var o in oEnable){if(oEnable[o]){arToEnable.push("#"+o)}else{arToDisable.push("#"+o)}}if(arToDisable.length>0){$(elMenu).disableContextMenuItems(arToDisable.join(","))}if(arToEnable.length>0){$(elMenu).enableContextMenuItems(arToEnable.join(","))}var enabledVisibleItems=$("#contextmenu_thumbview").find('LI:not([style*="none"]):not(.disabled)');var ret=(enabledVisibleItems.length>0);return ret};this.refreshFolder=function(){var treeCTL=ic.getFolderTree();if(treeCTL){treeCTL.reloadCurrent()}};var handleContextMenuAction=function(action,el,pos){if(!action){return}var i=action.indexOf("#");if(i!=-1){action=action.substr(i+1)}switch(action){case"delete":case"deleteTrash":ic.askDeleteSelected(el);break;case"reimportselected":reimportSelected(el);break;case"refreshfolder":setTheFocus();self.refreshFolder();break;case"rename":renameSelectedThumb(el);break;case"create":ic.askCreateDirectory(el);break;case"createfav":self.addFavorite();break;case"viewtypeimages":ic.controlView("thumb");break;case"viewtypecatalog":ic.controlView("catalog");break;case"selectall":self.selectAll();break;case"selectallvisible":self.selectAllVisible();break;case"selectnone":self.selectNone();break;case"copy":copySelectionToClipboard(el);break;case"cut":self.cutSelectionToClipboard(el);break;case"paste":pasteFromClipboard(el);break;case"addbatch":copySelectionToClipboard(el);ic.getPictureView().onBatchTabDragEnter();ic.getFileBatchCTL().addItemsFromClipboard();break;case"adddownload":copySelectionToClipboard(el);ic.getPictureView().onTabDragEnter();ic.getFileDownloadCTL().addItemsFromClipboard();break;case"downloadselected":ic.downloadSelected(el);break;case"restore":ic.askRestoreItems();break;case"selectColumns":ic.getDialogs().showSelectListColumnsDlg(oCurrentTextList);break;case"canceljob":ic.sendDownloadJobCommand("cancel");break;case"restartjob":ic.sendDownloadJobCommand("restart");break;case"openParentFolder":openSearchParentFolder(getFirstSelectionElement());break;case"openItemInNewWindow":openStaticEntryInNewWindow(getFirstSelectionElement());break}};var openSearchParentFolder=function(entry){if(!entry||!entry.src){return}var dir=entry.src.split("/");dir.pop();dir=dir.join("/");ic.getFolderTree().activateSection(ic.getElementById("folderTree_FolderTab"),"folderTree_TreeContainer");ic.setBasePath(dir)};this.addFavorite=function(){if(oSelection.isEmpty()){ic.getFolderTree().addFavoriteCurrent()}else{if(!oSelection.isMulti()){var entry=oSelection.getFirstItemData();if(entry&&entry.type=="directory"){ic.getFolderTree().addFavoriteCurrent(entry.src)}}}return};var getDownloadOrigin=this.getDownloadOrigin=function(){var nfo=ic.getCurrentConnectorInfo();return(nfo.permissions.read.downloadSource===true)};var initTextLists=function(){listRowHeight=(browser.touchDevice)?26:18;var elAddListHeaderTo=ic.getElementById("thumbCanvas");var arColumns;var component=ic.getComponents().getComponent("listView");document.body.appendChild(component);arColumns=[["src","50%"],["lastModified","20%"],["connectorType","30%"]];var options={sort:false};oFileListRoot=new TextList(ic,"root",elAddListHeaderTo,"textListRoot",arColumns,options);arColumns=[["src","44%"],["width","10%"],["height","10%"],["dimension","12%",false],["size","10%"],["lastModified","17%"],["importStatus","9%"]];oFileListDefault=new TextList(ic,"default",elAddListHeaderTo,"textListDefault",arColumns);arColumns=[["src","63%"],["size","15%"],["lastModified","22%"]];oFileListNoStatus=new TextList(ic,"nostatus",elAddListHeaderTo,"textListNoStatus",arColumns);arColumns=[["fileName","18%"],["deletePath","38%"],["deleteDate","17%"],["size","10%"],["lastModified","17%"]];oFileListTrash=new TextList(ic,"trash",elAddListHeaderTo,"textListTrash",arColumns);arColumns=[["fileName","15%"],["size","10%"],["creationDate","15%"],["createdBy","10%"],["scheduleDate","10%"],["startDate","10%"],["creationDuration","10%"],["queuePos","5%"],["progress","5%"],["creationStatus","10%"]];oFileListDownload=new TextList(ic,"download",elAddListHeaderTo,"textListDownload",arColumns);oCurrentTextList=oFileListDefault;oCurrentTextList.updateSortIndicator();removeChildSafe(component)};var enableButtonArray=function(ar,bEnabled,bTemp){if(!ar||!ar.length){return}var state=(bEnabled)?"enabled":"disabled";var components=ic.getComponents();for(var i=0;i<ar.length;i++){var btn=ic.getElementById(ar[i]);if(btn){if(!bTemp){btn.bEnabledStatic=bEnabled}else{if(!btn.bEnabledStatic&&bEnabled){return}}components.setButtonState(btn,state)}}};this.getEntryLabel=function(entry){return getEntryLabel(entry)};var getEntryLabelDefault=function(entry){var ret=ic.htmlEntities(entry.src);if(entry.images!=undefined){ret+=' <span class="dircount">('+ic.makeNiceInt(entry.images)+")</span>"}return ret};var getEntryLabelRoot=function(entry){var ret;switch(entry.connectorType){case"TRASH":ret=translator.translateTextValue("foldertree","recycleBin",true);break;case"STATIC":switch(entry.src){case"_viewers":ret="FSI Viewer";break;case"_configs":ret="FSI Configs";break;case"_documentation":ret=translator.translateTextValue("foldertree","documentation",true);break;case"_service_files":ret="Service Files";break;default:ret=entry.src}break;case"STORAGE":switch(entry.src){case"_service":ret="Service Images";break;default:ret=entry.src}break;case"DOWNLOADS":ret=translator.translateTextValue("foldertree","downloads",true);break;default:ret=entry.src}ret=ic.htmlEntities(ret);if(entry.images!=undefined){ret+=' <span class="dircount">('+ic.makeNiceInt(entry.images)+")</span>"}return ret};this.onConnectorTypeChange=function(connectorType,connectorName){if(currentConnectorType==connectorType){return}var arHideContextMenuItems;switch(currentConnectorType){case"TRASH":case"DOWNLOADS":$("#viewModeTable").show();ic.showLocationBar(true);break;case"STATIC":case"SEARCH":case"ROOT":$("#catalogView").show();break}enableButtonArray(["btnCMCreateFolder","btnCMRename","btnCMCopy","btnCMCut","btnCMPaste","btnCMDelete"],false);strListTemplate="interface_thumbview_default.json";getEntryLabel=getEntryLabelDefault;var bConnectorAllowsBatchDownload=false;switch(connectorType){case"ROOT":arHideContextMenuItems=["restore","deleteTrash","canceljob","restartjob","openParentFolder"];setCurrentTextList(oFileListRoot,false);getEntryLabel=getEntryLabelRoot;$("#catalogView").hide();break;case"TRASH":strListTemplate="interface_thumbview_trash.json";setCurrentTextList(oFileListTrash,false);arHideContextMenuItems=["copy","cut","paste","downloadselected","addbatch","adddownload","rename","createfav","reimportselected","create","delete","canceljob","restartjob","openParentFolder"];enableButtonArray(["btnCMDelete"],true);$("#viewModeTable").hide();ic.showLocationBar(false);break;case"DOWNLOADS":strListTemplate="interface_thumbview_downloads.json";setCurrentTextList(oFileListDownload,false);arHideContextMenuItems=["paste","addbatch","adddownload","rename","createfav","reimportselected","create","delete","restore","openParentFolder"];enableButtonArray(["btnCMCut","btnCMCopy","btnCMDelete"],true);$("#viewModeTable").hide();ic.showLocationBar(false);break;case"STATIC":arHideContextMenuItems=["restore","deleteTrash","addbatch","canceljob","restartjob","openParentFolder"];setCurrentTextList(oFileListNoStatus,false);enableButtonArray(["btnCMCreateFolder","btnCMRename","btnCMCopy","btnCMCut","btnCMPaste","btnCMDelete"],true);bConnectorAllowsBatchDownload=true;$("#catalogView").hide();break;case"SEARCH":arHideContextMenuItems=["restore","deleteTrash","canceljob","restartjob","createfav","create"];setCurrentTextList(oFileListDefault,false);enableButtonArray(["btnCMRename","btnCMCopy","btnCMCut","btnCMDelete"],true);bConnectorAllowsBatchDownload=true;$("#catalogView").hide();break;default:arHideContextMenuItems=["restore","deleteTrash","canceljob","restartjob","openParentFolder"];setCurrentTextList(oFileListDefault,false);enableButtonArray(["btnCMCreateFolder","btnCMRename","btnCMCopy","btnCMCut","btnCMPaste","btnCMDelete"],true);bConnectorAllowsBatchDownload=true}if(ic.getSystemPref("batch-processing")!=="true"){arHideContextMenuItems.push("addbatch")}if(connectorType!="STATIC"){arHideContextMenuItems.push("openItemInNewWindow")}if(bLiveUpdateLists&&(connectorType=="STORAGE"||connectorType=="DOWNLOADS")){checkThumbNeedsWatching=doCheckThumbNeedsWatching;if(connectorType=="STORAGE"){oItemWatch.strIdentField="src";oItemWatch.watchField="importstatus";oItemWatch.bUpdateAlways=false}else{oItemWatch.strIdentField="src";oItemWatch.watchField="status";oItemWatch.bUpdateAlways=true}}else{checkThumbNeedsWatching=doNothing}ic.getFileDownloadCTL().enableByConnector(bConnectorAllowsBatchDownload);$("#contextmenu_thumbview LI").show().removeClass("disabled");if(arHideContextMenuItems!=undefined){for(var i=0;i<arHideContextMenuItems.length;i++){var hrefVal=arHideContextMenuItems[i];hideContextMenuItem(hrefVal,true)}}updateButtonStates();updatePasteButtonState(!isClipboardEmpty());currentConnectorType=connectorType};this.onConnectorChange=function(connectorName,connectorType){if(currentConnectorName==connectorName){return}var nfo=ic.getCurrentConnectorInfo();bConnectorUploadDropAllow=bConnectorDropAllow=bConnectorDropWithinFolderAllow=false;if(nfo&&nfo.permissions&&nfo.permissions.write){bConnectorDropAllow=nfo.permissions.write.paste;bConnectorUploadDropAllow=nfo.permissions.write.upload;bConnectorDropWithinFolderAllow=nfo.permissions.write.moveWithinConnector}bNoDropAllow=(!bConnectorUploadDropAllow&&!bConnectorDropAllow&&!bConnectorDropWithinFolderAllow);bConnectorReadRenderedImage=ic.getConnectorPermission("read","renderedImages");ic.storeResizeSliderPos();currentConnectorName=connectorName;var newViewMode=getViewProperty(connectorName,"viewMode");viewMode=undefined;setViewMode(newViewMode,true);var newSortField=getViewProperty(connectorName,"sortField");self.setSortField(newSortField,true,true);var newSortOrder=getViewProperty(connectorName,"sortOrder");setSortOrder(newSortOrder,true,true);if(viewMode=="list"){oCurrentTextList.updateSortIndicator()}var props=getViewProperty(connectorName,"listView");oCurrentTextList.setColumnProps(props);var newPos=getViewProperty(connectorName,"thumbSizeSliderPos");if(newPos!=undefined&&newPos!=ic.getResizeSliderPos()){ic.setResizeSliderPos(newPos);self.rearrangeThumbview(true)}};var setCurrentTextList=function(oTextList,bRefresh,bNotSortable){if(!oTextList||!oCurrentTextList){return false}oTextList.setSortable((bNotSortable!==true));if(oTextList.getId()==oCurrentTextList.getId()){return false}oCurrentTextList.showHeader(false);oCurrentTextList=oTextList;if(bRefresh){viewMode=undefined;setViewMode("list")}else{oCurrentTextList.updateSortIndicator();if(viewMode=="list"){oCurrentTextList.showHeader(true);self.rearrangeThumbview(true)}}return true}}function FragmentedArray(nEntries,newLastModified){var data;var arRanges;var lastModified;var nRangeLengthLastDefrag;var self=this;var blockAddSize;this.clear=function(nEntries,newLastModified){data=new Array(nEntries);arRanges=new Array();lastModified=newLastModified;this.length=nEntries;nRangeLengthLastDefrag=-1;if(this.length>50000){blockAddSize=50000}else{blockAddSize=this.length}};self.clear(nEntries,newLastModified);this.getRangeCount=function(){return arRanges.length};this.getLastModified=function(){return lastModified};this.getSize=function(){return self.length};this.dumpArray=function(){var ret="<table width='100%'>";for(var i=0;i<self.length;i++){ret+="<tr><td>"+i+")</td><td>";if(data[i]==undefined){ret+="---</td><td>"}else{ret+=data[i].id+"</td><td align='right'>"+data[i].lastmodified}ret+="</td></tr>"}ret+="</table>";return ret};this.dumpExistingRanges=function(){return dumpRanges(arRanges)};var dumpRangesHTML=function(ar){if(ar.length>100){return""}var ret="<table>";for(var i=0;i<ar.length;i++){ret+="<tr><td>"+i+")</td><td>";var o=ar[i];if(o){ret+=o.start+"</td><td>"+o.end}else{ret+="---</td><td>---"}ret+="</td></tr>"}ret+="</table>";return ret};var dumpRanges=function(ar){var ret="";for(var i=0;i<ar.length;i++){ret=i+") ";var o=ar[i];if(o){ret+=o.start+" to "+o.end}else{ret+="--- to  ---"}ffDump(ret)}};var rangeSort=function(a,b){return b.start-a.start};this.getData=function(){return data};this.defragRanges=function(){if(nRangeLengthLastDefrag==arRanges.length){return}arRanges.sort(rangeSort);var r1,r2;var nRanges=arRanges.length;for(var i=arRanges.length-1;i>0;i--){r1=arRanges[i];r2=arRanges[i-1];var d=r2.start-r1.end;if(d<2){r2.start=r1.start;r2.end=Math.max(r1.end,r2.end);arRanges.splice(i,1)}}nRangeLengthLastDefrag=arRanges.length};this.loadRequired=function(nStart,nEnd){return true};this.getRangeToLoad=function(nStart,nEnd){self.defragRanges();if(arRanges.length==0){var res={};res.start=Math.max(0,nStart);res.end=(self.length>0)?Math.min(nEnd,self.length-1):nEnd;return res}nStart=Math.min(self.length-1,Math.max(0,nStart));nEnd=Math.min(self.length-1,Math.max(0,nEnd));var oRangeFirst=false;var oRangeEnd=false;for(var i=arRanges.length-1;i>-1;i--){var r=arRanges[i];if(r.start>nEnd){break}if(!oRangeFirst&&r.end>=nStart){oRangeFirst=r}}oRangeEnd=arRanges[i+1];if(oRangeEnd){if(oRangeEnd.start<=nEnd&&oRangeEnd.end>=nEnd){nEnd=oRangeEnd.start-1}}if(oRangeFirst){if(oRangeFirst.start<=nStart){nStart=oRangeFirst.end+1}}var res=undefined;if(nEnd>=nStart){var res={};res.start=Math.max(0,nStart);res.end=Math.min(nEnd,self.length-1)}return res};this.addRange=function(ar,nStart,nEnd){var n;if(!ar||!ar.length||nStart<0||nStart>=self.length||nEnd<0||nEnd>=self.length||nEnd<nStart){ffDump("ERROR: cannot add the range: "+nStart+" to "+nEnd+" ("+typeof(ar)+") self.len: "+self.length);return false}var nItems=ar.length;if(nItems<blockAddSize){n=0;for(var i=nStart;i<=nEnd;i++,n++){data[i]=ar[n]}}else{var arStart;if(nStart>0){arStart=data.slice(0,nStart)}else{arStart=undefined}var arEnd;if(nEnd<self.length-1){arEnd=data.slice(nStart+nItems)}else{arEnd=undefined}var newArray=new Array();if(arStart){newArray=newArray.concat(arStart)}newArray=newArray.concat(ar);if(arEnd){newArray=newArray.concat(arEnd)}data=newArray}var oRange={};oRange.start=nStart;oRange.end=nEnd;arRanges.push(oRange);return true}}function ItemSelection(){var bLocked=false;var items;var count;this.clear=function(){if(bLocked){return}items={};count=0;bLocked=false};this.clear();this.isMulti=function(){return count>1};this.isEmpty=function(){return count<1};this.getCount=function(){return count};this.addItem=function(key,data){if(bLocked||!key||!data){return false}if(items[key]){return items[key]}var o=items[key]={};o.data=data;o.id=count;count++;return o};this.itemExists=function(key){return(items[key]!=undefined)};this.removeItem=function(key){if(bLocked||!items[key]){return false}delete items[key];count--;return true};this.getFirstItemData=function(){for(var o in items){o=items[o].data;break}return o};this.getItem=function(key){return items[key]};this.getItemData=function(key){if(!items[key]){return}return items[key].data};this.getItems=function(){return items};this.getArray=function(){var ret=new Array();if(count<1){return ret}for(var o in items){ret.push(items[o].data)}return ret};this.isLocked=function(){return bLocked};this.lock=function(bNewLocked){bLocked=bNewLocked}}function TextList(ic,argID,elHeaderParentArgument,idTemplates,arColumnDef,options){var self=this;var myID=argID;var myTemplateId=idTemplates;var ic=ic;var thumbView=ic.getThumbView();var translator=ic.getTranslator();var elHeaderParent=elHeaderParentArgument;var oOptions=options;var strSortIndicator="";var entry=undefined;var entryIsDir;var arColumns=new Array();var arColumnSizes;var oHiddenColumnsDefault={};var arColumnSizesDefault;var arContentFN;var elHeader;var elRowTemplate;var oHeaderDrag;var oDate=new Date();var txtNBSP="\u00A0";var nTotalWithPercentInitial=0;var minSizePercent=3;var oHiddenColumns={};var currentProps;var bSortable=true;var elHeader=ic.getElementById(idTemplates+"Header").cloneNode(true);var elRowTemplate=ic.getElementById(idTemplates+"RowTemplate").cloneNode(true);var itemStatusData={};var downloadStatusData={};var init=function(arColumDef){itemStatusData["0"]={text:thumbView.translateEx("statusUnknown"),className:"unknown"};itemStatusData["1"]={text:undefined,className:"ok"};itemStatusData["2"]={text:thumbView.translateEx("statusImporting"),className:"importing"};itemStatusData["3"]={text:thumbView.translateEx("statusBroken"),className:"broken"};itemStatusData["4"]={text:thumbView.translateEx("statusReimporting"),className:"reimporting"};downloadStatusData["0"]={text:thumbView.translateEx("statusUnknown"),className:"unknown"};downloadStatusData["1"]={text:undefined,className:"ok"};downloadStatusData["2"]={text:thumbView.translateEx("statusRunning"),className:"importing"};downloadStatusData["3"]={text:thumbView.translateEx("statusError"),className:"broken"};downloadStatusData["4"]={text:thumbView.translateEx("statusQueued"),className:"queued"};downloadStatusData["5"]={text:thumbView.translateEx("statusStopped"),className:"stopped"};var templateColumnCount=elRowTemplate.childNodes.length;var nEnd=Math.min(templateColumnCount,arColumDef.length);for(var i=0;i<nEnd;i++){addColumn(arColumDef[i])}if(templateColumnCount!=arColumDef.length){ffDump("### WARNING, TextList row template column count "+templateColumnCount+" does not match the TexList column count "+arColumDef.length+"! Correcting...");while(elRowTemplate.childNodes.length>arColumns.length){addColumn()}}if(nTotalWithPercentInitial!=100){ffDump("### WARNING, TextList column width definition for "+myTemplateId+" does not sum up to 100% ("+nTotalWithPercentInitial+")! Correcting...");if(nTotalWithPercentInitial<100){arColumns[0].initialWidth+=(100-nTotalWithPercentInitial)}else{var subtract=nTotalWithPercentInitial-100;for(var i=0;i<arColumns.length;i++){var d=Math.min(subtract,Math.max(0,arColumns[i].initialWidth-minSizePercent));if(d>0){arColumns[i].initialWidth=roundColumnWidth(arColumns[i].initialWidth-d);subtract=roundColumnWidth(subtract-d);if(subtract==0){break}}}}}arColumnSizes=new Array(arColumns.length);arContentFN=new Array(arColumns.length);var fn;var sortField;for(var i=0;i<arColumns.length;i++){arColumnSizes[i]=arColumns[i].initialWidth+"%";if(i<arColumDef.length){var def=arColumDef[i];if(def.length>2&&def[2]===false){oHiddenColumnsDefault[i]=true}}sortField=undefined;var content=arColumns[i].content;switch(content){case"src":fn=setTextListContent_src;sortField="FILENAME";break;case"fileName":fn=setTextListContent_fileName;sortField="FILENAME";break;case"lastModified":fn=setTextListContent_lastModified;sortField="LASTMODIFIED";break;case"size":fn=setTextListContent_size;sortField="FILESIZE";break;case"dimension":fn=setTextListContent_dimension;sortField="DIMENSION";break;case"width":fn=setTextListContent_width;sortField="WIDTH";break;case"height":fn=setTextListContent_height;sortField="HEIGHT";break;case"importStatus":fn=setTextListContent_importStatus;sortField="IMPORTSTATUS";break;case"deletePath":fn=setTextListContent_deletePath;sortField="DELETEPATH";break;case"deleteDate":fn=setTextListContent_deleteDate;sortField="DELETEDATE";break;case"connectorType":fn=setTextListContent_connectorType;sortField="CONNECTORTYPE";break;case"createdBy":fn=setTextListContent_createdBy;sortField="CREATEDBY";break;case"creationDate":fn=setTextListContent_creationDate;sortField="CREATIONDATE";break;case"startDate":fn=setTextListContent_startDate;sortField="STARTDATE";break;case"scheduleDate":fn=setTextListContent_scheduleDate;sortField="SCHEDULEDATE";break;case"queuePos":fn=setTextListContent_queuePos;sortField="QUEUEPOS";break;case"progress":fn=setTextListContent_progress;sortField="PROGRESS";break;case"creationDuration":fn=setTextListContent_creationDuration;sortField="DURATION";break;case"creationStatus":fn=setTextListContent_creationStatus;sortField="IMPORTSTATUS";break;default:fn=setTextListContent_none;sortField=undefined}if(options&&options.sort==false){sortField=undefined}arContentFN[i]=fn;arColumns[i].sortField=sortField}arColumnSizesDefault=new Array();arColumnSizesDefault=arColumnSizesDefault.concat(arColumnSizes);var h=thumbView.getTextListRowHeight();var h2=(browser.webkit)?h:(h-1);$(elHeader).css("height",h+"px");$(elHeader).css("lineHeight",h2+"px");$(elRowTemplate).css("height",h+"px");$(elRowTemplate).css("lineHeight",h2+"px");addEvent(elHeader,"mousedown",onListHeaderMouseDown);addEvent(elHeader,"mouseover",onListHeaderMouseOver);setInitialHeaderSizes()};var setInitialHeaderSizes=function(){var children=elHeader.childNodes;for(var i=0;i<children.length;i++){children[i].style.width=arColumnSizes[i]}updateTemplateColumns()};this.getId=function(){return myID};var addColumn=function(ar){if(ar==undefined||ar.push==undefined){ar=["",""]}while(ar.length<2){ar.push("")}if(ar.length<2){ar=["",""]}var content=ar[0];var initialWidth=roundColumnWidth(parseFloat(ar[1]));if(isNaN(initialWidth)){initialWidth=minSizePercent}var oColumn={};oColumn.initialWidth=initialWidth;oColumn.content=content;if(ar.length<3||ar[2]!==false){nTotalWithPercentInitial+=initialWidth}arColumns.push(oColumn)};this.fillRow=function(columns,listEntry){entry=listEntry;entryIsDir=(entry.type=="directory");for(var i=0;i<arContentFN.length;i++){arContentFN[i](columns[i])}};this.getHeaderEl=function(){return elHeader};this.getEmptyRow=function(){var row=elRowTemplate.cloneNode(true);row.firstChild.FSIItemType!="directory";return row};this.showHeader=function(bShow){if(bShow){if(elHeader&&(!elHeader.parentNode||elHeader.parentNode!=elHeaderParent)){if(!elHeaderParent.firstChild){elHeaderParent.appendChild(elHeader)}else{elHeaderParent.insertBefore(elHeader,elHeaderParent.firstChild)}}}else{if(elHeader&&elHeader.parentNode==elHeaderParent){elHeaderParent.removeChild(elHeader)}}};this.getColumnVisibility=function(){var headerChildren=elHeader.childNodes;var o={};for(var i=0;i<arColumns.length;i++){var txt=headerChildren[i].innerHTML;var vis;if(i==0){vis="disabled"}else{vis=($(headerChildren[i]).css("display")!="none")}o[txt]=vis}return o};var saveSettings=function(){thumbView.setCurrentViewProperty("listView",getColumnProps())};var getColumnProps=function(){var ret={};ret.arColumnSizes=new Array();ret.arColumnSizes=ret.arColumnSizes.concat(arColumnSizes);ret.oHiddenColumns={};for(var o in oHiddenColumns){ret.oHiddenColumns[o]=oHiddenColumns[o]}return ret};this.setColumnProps=function(oProps){if(oProps==undefined){oProps={}}currentProps={};currentProps.arColumnSizes=new Array();currentProps.oHiddenColumns={};if(oProps.arColumnSizes==undefined||oProps.arColumnSizes.length!=arColumns.length){currentProps.arColumnSizes=currentProps.arColumnSizes.concat(arColumnSizesDefault)}else{currentProps.arColumnSizes=currentProps.arColumnSizes.concat(oProps.arColumnSizes)}if(oProps.oHiddenColumns==undefined){oProps.oHiddenColumns=oHiddenColumnsDefault}for(var o in oProps.oHiddenColumns){currentProps.oHiddenColumns[o]=oProps.oHiddenColumns[o]}oHiddenColumns={};var oChanged={};for(var i=0;i<arColumns.length;i++){oChanged[i]=false}var cVis=self.getColumnVisibility();var n=0;var nVis;for(var o in cVis){if(currentProps.oHiddenColumns[n]!=undefined){nVis=false}else{if(cVis[o]!="disabled"){nVis=true}else{nVis="disabled"}}if(cVis[o]!=nVis){oChanged[n]=true;cVis[o]=nVis}n++}self.setColumnVisibility(cVis,true,true);oHiddenColumns={};for(var o in currentProps.oHiddenColumns){oHiddenColumns[o]=currentProps.oHiddenColumns[o]}for(var i=0;i<arColumnSizes.length;i++){if(arColumnSizes[i]!=currentProps.arColumnSizes[i]){oChanged[i]=true}}var arChanged=new Array();for(var o in oChanged){if(oChanged[o]==true){arChanged.push(o)}}if(arChanged.length>0){arColumnSizes=new Array();arColumnSizes=arColumnSizes.concat(currentProps.arColumnSizes);setInitialHeaderSizes();updateBodyColumns(arChanged)}saveSettings()};this.setColumnVisibility=function(oColumnVisibility,bNoSave,bNoResize){if(!oColumnVisibility){return}var childrenHeader=elHeader.childNodes;var oCur=self.getColumnVisibility();var arChanged=new Array();var oChanged={};var n=0;var dWidth=0;for(var o in oCur){if(oCur[o]!=oColumnVisibility[o]){var display=(oColumnVisibility[o]!==false)?"block":"none";arChanged.push(n);var td=childrenHeader[n];if(!oColumnVisibility[o]){oHiddenColumns[n]=true}else{delete oHiddenColumns[n]}if(oColumnVisibility[o]){dWidth-=parseFloat(td.style.width)}else{dWidth+=parseFloat(td.style.width)}td.style.display=display}n++}if(bNoResize||arChanged.length==0){return}for(var i=0;i<arChanged.length;i++){oChanged[arChanged[i]]=true}if(dWidth>0){childrenHeader[0].style.width=roundColumnWidth(parseFloat(childrenHeader[0].style.width)+dWidth)+"%";oChanged[0]=true}else{var subtract=-dWidth;for(var i=0;i<arColumns.length;i++){var td=childrenHeader[i];var w=parseFloat(td.style.width);var d=Math.min(subtract,Math.max(0,w-minSizePercent));if(d>0){oChanged[i]=true;td.style.width=roundColumnWidth(parseFloat(td.style.width)-d)+"%";subtract=roundColumnWidth(subtract-d);if(subtract==0){break}}}}arChanged=new Array();for(var o in oChanged){arChanged.push(o)}for(var i=0;i<arChanged.length;i++){arColumnSizes[arChanged[i]]=roundColumnWidth(parseFloat(childrenHeader[arChanged[i]].style.width))+"%"}updateTemplateColumns();updateBodyColumns(arChanged);if(!bNoSave){saveSettings()}};var setTextListContent_src=function(td){td.innerHTML=thumbView.getEntryLabel(entry);if(td.FSIItemType!=entry.type){td.FSIItemType=entry.type;if(entryIsDir){if($(td).hasClass("file")){$(td).removeClass("file").addClass("folder")}}else{if($(td).hasClass("folder")){$(td).removeClass("folder").addClass("file")}}}};var setTextListContent_fileName=function(td){if(entry.fileName==undefined){setTextListColumnText(td,txtNBSP)}else{td.innerHTML=ic.htmlEntities(entry.fileName)}if(td.FSIItemType!=entry.type){td.FSIItemType=entry.type;if(entryIsDir){if($(td).hasClass("file")){$(td).removeClass("file").addClass("folder")}}else{if($(td).hasClass("folder")){$(td).removeClass("folder").addClass("file")}}}};var setTextListContent_lastModified=function(td){if(entry.lastmodified==undefined){return setTextListColumnText(td,txtNBSP)}oDate.setTime(entry.lastmodified);setTextListColumnText(td,translator.formatLocaleShortDate(oDate))};var setTextListContent_size=function(td){if(entryIsDir){return setTextListColumnText(td,txtNBSP)}setTextListColumnText(td,ic.makeNiceFilesSize(entry.size))};var setTextListContent_dimension=function(td){if(entry.width==undefined||entry.height==undefined){return setTextListColumnText(td,txtNBSP)}setTextListColumnText(td,ic.makeNiceInt(entry.width)+" x "+ic.makeNiceInt(entry.height)+" px")};var setTextListContent_width=function(td){if(entry.width==undefined){return setTextListColumnText(td,txtNBSP)}setTextListColumnText(td,ic.makeNiceInt(entry.width)+" px")};var setTextListContent_height=function(td){if(entry.height==undefined){return setTextListColumnText(td,txtNBSP)}setTextListColumnText(td,ic.makeNiceInt(entry.height)+" px")};var setTextListContent_importStatus=function(td){if(td.FSIHasStatus!=undefined){if(td.FSIHasStatus==entry.importstatus){return}$(td).removeClass(itemStatusData[td.FSIHasStatus].className);delete td.FSIHasStatus}if(entryIsDir||entry.importstatus==undefined){return setTextListColumnText(td,txtNBSP)}if(entry.importstatus.length>0){var txt="";var o=itemStatusData[entry.importstatus];if(o!=undefined){$(td).addClass(o.className);txt=o.text;td.FSIHasStatus=entry.importstatus}setTextListColumnText(td,txt)}else{setTextListColumnText(td,txtNBSP)}};var setTextListContent_deleteDate=function(td){if(entry.deleted==undefined){return setTextListColumnText(td,txtNBSP)}oDate.setTime(entry.deleted);setTextListColumnText(td,translator.formatLocaleShortDate(oDate))};var setTextListContent_connectorType=function(td){if(entry.connectorType==undefined){return setTextListColumnText(td,txtNBSP)}setTextListColumnText(td,entry.connectorType)};var setTextListContent_deletePath=function(td){if(entry.sourcePath==undefined){return setTextListColumnText(td,txtNBSP)}td.innerHTML=ic.htmlEntities(entry.sourcePath)};var setTextListContent_createdBy=function(td){if(entry.createdBy==undefined){return setTextListColumnText(td,txtNBSP)}td.innerHTML=ic.htmlEntities(entry.createdBy)};var setTextListContent_creationDuration=function(td){if(entry.duration==undefined){return setTextListColumnText(td,txtNBSP)}setTextListColumnText(td,translator.formatLocaleDuration(entry.duration,3))};var setTextListContent_creationDate=function(td){if(entry.creationDate==undefined){return setTextListColumnText(td,txtNBSP)}oDate.setTime(entry.creationDate);setTextListColumnText(td,translator.formatLocaleShortDate(oDate))};var setTextListContent_scheduleDate=function(td){if(entry.scheduleDate==undefined){return setTextListColumnText(td,txtNBSP)}oDate.setTime(entry.scheduleDate);setTextListColumnText(td,translator.formatLocaleShortDate(oDate))};var setTextListContent_startDate=function(td){if(entry.startDate==undefined){return setTextListColumnText(td,txtNBSP)}oDate.setTime(entry.startDate);setTextListColumnText(td,translator.formatLocaleShortDate(oDate))};var setTextListContent_queuePos=function(td){if(entry.queuePos==undefined){return setTextListColumnText(td,txtNBSP)}setTextListColumnText(td,entry.queuePos)};var setTextListContent_progress=function(td){if(entry.progress==undefined){return setTextListColumnText(td,txtNBSP)}setTextListColumnText(td,entry.progress+"%")};var setTextListContent_creationStatus=function(td){if(td.FSIHasStatus!=undefined){if(td.FSIHasStatus==entry.status){return}$(td).removeClass(downloadStatusData[td.FSIHasStatus].className);delete td.FSIHasStatus}if(entry.status==undefined){return setTextListColumnText(td,txtNBSP)}if(entry.status.length>0){var txt="";var o=downloadStatusData[entry.status];if(o!=undefined){$(td).addClass(o.className);txt=o.text;td.FSIHasStatus=entry.status}setTextListColumnText(td,txt)}else{setTextListColumnText(td,txtNBSP)}};var setTextListContent_none=function(td){td.firstChild.nodeValue=txtNBSP};var setTextListColumnText=function(td,val){if(val==undefined||val.length<1){val=txtNBSP}td.firstChild.nodeValue=val};var updateSortIndicator=this.updateSortIndicator=function(){if(!bSortable){return}var sortOrder=thumbView.getSortOrder();var sortField=thumbView.getSortField();var sortID=sortField+sortOrder;if(strSortIndicator==sortID){return}strSortIndicator=sortID;$(elHeader).children("div.sort").removeClass("sort").removeClass("asc").removeClass("desc");for(var i=0;i<arColumns.length;i++){if(arColumns[i].sortField==sortField){var div=elHeader.childNodes[i];$(div).addClass(sortOrder).addClass("sort");break}}};var roundColumnWidth=function(n){return Math.round(100*n)/100};var updateTemplateColumns=function(){var childrenHeader=elHeader.childNodes;var childrenTemplate=elRowTemplate.childNodes;for(var i=0;i<childrenTemplate.length;i++){childrenTemplate[i].style.width=childrenHeader[i].style.width;childrenTemplate[i].style.display=childrenHeader[i].style.display}};var onListHeaderMouseOver=function(evt){addEvent(elHeader,"mouseout",onListHeaderMouseOut);addEvent(elHeader,"mousemove",onListHeaderMouseMoveCursor)};var onListHeaderMouseMoveCursor=function(evt){if(oHeaderDrag!=undefined){return}var el=evt.srcElement;if(el==undefined){el=evt.originalTarget}var x=evt.offsetX;if(x==undefined){x=evt.layerX}if(x<9||el.offsetWidth-x<9){document.body.style.cursor="col-resize"}else{document.body.style.cursor="default"}};var onListHeaderMouseOut=function(evt){removeEvent(elHeader,"mouseout",onListHeaderMouseOut);removeEvent(elHeader,"mousemove",onListHeaderMouseMoveCursor);if(oHeaderDrag==undefined){document.body.style.cursor="default"}};var onListHeaderMouseDown=function(evt){var o={};o.el=evt.srcElement;if(o.el==undefined){o.el=evt.originalTarget}if(o.el==elHeader){return}var children=o.children=o.el.parentNode.childNodes;var nVisible=children.length;var nLastVisibleColumn=0;for(var i=0;i<children.length;i++){if(children[i]==o.el){o.columnIndex=i}arColumnSizes[i]=children[i].style.width;if(children[i].style.display=="none"){nVisible--}else{nLastVisibleColumn=i}}if(nVisible<2){return}var x=evt.offsetX;if(x==undefined){x=evt.layerX}o.bLeft=(x<o.el.offsetWidth/2);if(o.bLeft){if(x>8){return onHeaderSortClick(evt,o.el,o.columnIndex)}o.columnIndex--;if(o.columnIndex<0){return}}else{if(o.el.offsetWidth-x>8){return onHeaderSortClick(evt,o.el,o.columnIndex)}}if(o.el.setCapture){o.el.setCapture()}o.width=ic.getThumbViewDim().width;var idx=o.columnIndex;var idx2=o.columnIndex+1;while(idx>-1&&oHiddenColumns[idx]){idx--}if(idx<0){return}o.columnIndex=idx;o.colLeft=o.children[idx];idx=idx2;while(idx<nLastVisibleColumn&&oHiddenColumns[idx]){idx++}if(idx>nLastVisibleColumn){return}o.colRight=o.children[idx];o.startX=evt.clientX;o.dxpOffset=0;oHeaderDrag=o;addEvent(document,"mousemove",onListHeaderMouseMove);addEvent(document,"mouseup",onListHeaderMouseUp);$(elHeader).addClass("resizing");document.body.style.cursor="col-resize";thumbView.lockWatching(true)};var updateHeaderColumnWidth=function(evt){var o=oHeaderDrag;var x=evt.clientX;var dx=x-o.startX;var dxp=roundColumnWidth(dx/o.width*100)+o.dxpOffset;if(dxp==0){return}var t,n,i,width,newWidth;if(dxp<0){n=dxp;for(i=o.columnIndex;i>-1;i--){width=parseFloat(o.children[i].style.width);if(width>minSizePercent&&!oHiddenColumns[i]){newWidth=roundColumnWidth(Math.max(minSizePercent,width+n));o.children[i].style.width=newWidth+"%";n+=roundColumnWidth(width-newWidth);if(n<=0){break}}}t=dxp-n;o.colRight.style.width=roundColumnWidth(parseFloat(o.colRight.style.width)-t)+"% ";o.dxpOffset-=t}else{n=dxp;for(i=o.columnIndex+1;i<o.children.length;i++){width=parseFloat(o.children[i].style.width);if(width>minSizePercent&&!oHiddenColumns[i]){newWidth=roundColumnWidth(Math.max(minSizePercent,width-n));o.children[i].style.width=newWidth+"%";n-=roundColumnWidth(width-newWidth);if(n<=0){break}}}t=dxp-n;o.colLeft.style.width=roundColumnWidth(parseFloat(o.colLeft.style.width)+t)+"% ";o.dxpOffset-=t}};var onListHeaderMouseMove=function(evt){updateHeaderColumnWidth(evt);return false};var onListHeaderMouseUp=function(evt){var o=oHeaderDrag;if(o.el.releaseCapture){o.el.releaseCapture()}removeEvent(document,"mousemove",onListHeaderMouseMove);removeEvent(document,"mouseup",onListHeaderMouseUp);document.body.style.cursor="default";$(elHeader).removeClass("resizing");updateHeaderColumnWidth(evt);oHeaderDrag=undefined;checkColumnSizeChange();thumbView.lockWatching(false)};var checkColumnSizeChange=function(){var headerChildren=elHeader.childNodes;var arChangedColumns=new Array();for(var i=0;i<headerChildren.length;i++){var wNow=headerChildren[i].style.width;if(wNow!=arColumnSizes[i]&&!oHiddenColumns[i]){arColumnSizes[i]=wNow;arChangedColumns.push(i)}}var iend=arChangedColumns.length;if(iend==0){return}updateTemplateColumns();updateBodyColumns(arChangedColumns);saveSettings()};var updateBodyColumns=function(arChangedColumns){if(arChangedColumns==undefined||arChangedColumns.length==undefined){return}var iend=arChangedColumns.length;if(iend<1){return}var headerChildren=elHeader.childNodes;var rows=$("#thumbInnerCanvas").find("div.textlistcontentrow");for(var row=0;row<rows.length;row++){var children=rows[row].childNodes;for(var i=0;i<iend;i++){var column=arChangedColumns[i];children[column].style.width=headerChildren[column].style.width;children[column].style.display=headerChildren[column].style.display}}};var onHeaderSortClick=function(evt,el,columnIndex){var btn;if(evt){btn=evt.which||evt.button}if(btn!=1){return}var field=arColumns[columnIndex].sortField;if(field==undefined){return}if(field==thumbView.getSortField()){thumbView.toggleSortOrder(true)}thumbView.setSortField(field,true);updateSortIndicator()};this.setSortable=function(bSet){if(bSet==bSortable){return}bSortable=bSet;if(!bSet){$(elHeader).children("div.sort").removeClass("sort").removeClass("asc").removeClass("desc")}else{self.updateSortIndicator()}};init(arColumnDef)};