/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.io;

import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.Plugin;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.framework.systeminformation.OperatingPlatform;
import com.neptunelabs.fsiserver.framework.systeminformation.SystemInformation;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class PluginLoader {
    private final FSILogger \u00d500000;
    private final URLClassLoader new;
    private final SystemInformation o00000;
    private final Map<String, Plugin> \u00d400000 = new HashMap<String, Plugin>();
    private static final Class<?>[] \u00d300000 = new Class[]{URL.class};

    public PluginLoader(FSILogger fSILogger, ClassLoader classLoader, SystemInformation systemInformation) {
        this.\u00d500000 = fSILogger;
        this.new = this.getClassLoader(classLoader);
        this.o00000 = systemInformation;
    }

    public void loadPlugin(Path path, String string, String string2) {
        Object object;
        Object object2;
        Path path2 = path.resolve(string);
        Path path3 = path2.resolve("config.xml");
        Document document = FileOperations.getXMLFileContent(this.\u00d500000, path3);
        if (document == null) {
            try {
                object2 = this.new.getResourceAsStream(string + "/config.xml");
                object = null;
                try {
                    document = FileOperations.getXMLFileContent(this.\u00d500000, (InputStream)object2);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((InputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object2).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (document != null) {
            object2 = document.getElementsByTagName("plugin");
            object = object2.item(0);
            if (object != null) {
                NamedNodeMap namedNodeMap = object.getAttributes();
                Node node = namedNodeMap.getNamedItem("enabled");
                boolean bl = false;
                if (node != null) {
                    bl = Boolean.valueOf(node.getNodeValue());
                }
                if (bl) {
                    Object object3;
                    int n;
                    Plugin plugin = new Plugin();
                    NodeList nodeList = object.getChildNodes();
                    if (nodeList != null) {
                        for (n = 0; n < nodeList.getLength(); ++n) {
                            Object object4;
                            Object object5;
                            NamedNodeMap namedNodeMap2;
                            Node node2 = nodeList.item(n);
                            if (node2.getNodeType() != 1) continue;
                            String object7 = node2.getNodeName().toLowerCase();
                            if (object7.equalsIgnoreCase("jars") && (object3 = (namedNodeMap2 = node2.getAttributes()).getNamedItem("dir")) != null) {
                                object5 = object3.getNodeValue();
                                plugin.o00000 = this.findIncludes(node2, path2, (String)object5, false);
                            }
                            if (object7.equalsIgnoreCase("libraries")) {
                                NamedNodeMap namedNodeMap3 = node2.getAttributes();
                                object3 = namedNodeMap3.getNamedItem("dir");
                                if (object3 == null) continue;
                                object5 = object3.getNodeValue();
                                object4 = namedNodeMap3.getNamedItem("osdetect");
                                boolean bl2 = object4 != null ? Boolean.valueOf(object4.getNodeValue()) : false;
                                plugin.\u00d200000 = this.findIncludes(node2, path2, (String)object5, bl2);
                                continue;
                            }
                            if (object7.equalsIgnoreCase("init")) {
                                NodeList nodeList2 = node2.getChildNodes();
                                if (nodeList2 == null) continue;
                                for (int i = 0; i < nodeList2.getLength(); ++i) {
                                    object5 = nodeList2.item(i);
                                    if (object5.getNodeType() != 1 || !object5.getNodeName().equalsIgnoreCase("class") || (object4 = PluginLoader.getNodeTextContent(object5.getChildNodes())) == null) continue;
                                    plugin.\u00d500000.add((String)object4);
                                }
                                continue;
                            }
                            if (object7.equalsIgnoreCase("modules")) {
                                NodeList nodeList3 = node2.getChildNodes();
                                if (nodeList3 == null) continue;
                                for (int i = 0; i < nodeList3.getLength(); ++i) {
                                    object5 = nodeList3.item(i);
                                    if (object5.getNodeType() != 1 || !object5.getNodeName().equalsIgnoreCase("context") || (object4 = PluginLoader.getNodeTextContent(object5.getChildNodes())) == null || !string2.equalsIgnoreCase((String)object4)) continue;
                                    plugin.Object = true;
                                }
                                continue;
                            }
                            String string3 = PluginLoader.getNodeTextContent(node2.getChildNodes());
                            if (string3 == null || string3.equals("")) continue;
                            plugin.\u00d600000.put(object7, string3);
                        }
                    }
                    if (plugin.\u00d200000 != null) {
                        try {
                            this.loadPluginLibraries(string, plugin.\u00d200000);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    n = 0;
                    if (plugin.\u00d500000.size() > 0) {
                        n = 1;
                        for (String illegalAccessException : plugin.\u00d500000) {
                            try {
                                Class<?> clazz = Class.forName(illegalAccessException);
                                object3 = clazz.getConstructor(new Class[0]);
                                ((Constructor)object3).newInstance(new Object[0]);
                                plugin.void.put(illegalAccessException, clazz);
                            }
                            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                                n &= 0;
                            }
                        }
                    }
                    if (n == 0 && plugin.Object) {
                        if (this.new != null) {
                            if (plugin.o00000 != null) {
                                try {
                                    this.loadPluginLibs(string, plugin.o00000, this.new);
                                }
                                catch (IOException iOException) {
                                    this.\u00d500000.log(1045, string, iOException.getLocalizedMessage());
                                }
                                this.\u00d500000.log(1046, string);
                                boolean bl3 = false;
                                if (plugin.\u00d500000.size() > 0) {
                                    try {
                                        for (String string4 : plugin.\u00d500000) {
                                            object3 = this.new.loadClass(string4);
                                            ((Class)object3).newInstance();
                                            plugin.void.put(string4, (Class<?>)object3);
                                            this.\u00d500000.log(1047, string, string4);
                                            bl3 = true;
                                        }
                                    }
                                    catch (ClassNotFoundException unsatisfiedLinkError) {
                                        this.\u00d500000.log(1044, string, "CNFE: " + unsatisfiedLinkError.getLocalizedMessage());
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        this.\u00d500000.log(1044, string, "IA: " + illegalAccessException.getLocalizedMessage());
                                    }
                                    catch (InstantiationException instantiationException) {
                                        this.\u00d500000.log(1044, string, "IE: " + instantiationException.getLocalizedMessage());
                                    }
                                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                        this.\u00d500000.log(1044, string, "ULE: " + unsatisfiedLinkError.getLocalizedMessage());
                                    }
                                } else {
                                    bl3 = true;
                                }
                                if (bl3) {
                                    this.\u00d400000.put(string.toLowerCase(), plugin);
                                }
                            }
                        } else {
                            this.\u00d500000.log(1042, string);
                        }
                    } else if (n != 0) {
                        this.\u00d400000.put(string.toLowerCase(), plugin);
                        this.\u00d500000.log(1046, string);
                    } else if (plugin.Object) {
                        this.\u00d500000.log(1048, string);
                    }
                } else {
                    this.\u00d500000.log(1041, string);
                }
            } else {
                this.\u00d500000.log(1043, string, path3);
            }
        } else {
            this.\u00d500000.log(1040, path2);
        }
    }

    public boolean isPluginLoaded(String string) {
        return this.\u00d400000.containsKey(string.toLowerCase());
    }

    public Plugin getPlugin(String string) {
        return this.\u00d400000.get(string.toLowerCase());
    }

    public static List<String> scanForPlugins(Path path) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                for (Path path2 : directoryStream) {
                    if (!Files.isDirectory(path2, new LinkOption[0])) continue;
                    Path path3 = path2.getFileName();
                    Path path4 = Paths.get(path2.toString(), "config.xml");
                    if (!Files.isReadable(path4)) continue;
                    arrayList.add(path3.toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private Path[] findIncludes(Node node, Path path2, String string, boolean bl) {
        Path[] pathArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object5 = nodeList.item(i);
                if (object5.getNodeType() != 1 || !((String)(object4 = object5.getNodeName().toLowerCase())).equals("include") || (object3 = (object2 = object5.getAttributes()).getNamedItem("name")) == null || (object = object3.getNodeValue()) == null || ((String)object).length() <= 0) continue;
                arrayList.add(object);
            }
        }
        if (arrayList.size() > 0) {
            Path path3;
            if (bl) {
                object4 = this.o00000.getOperatingPlatform();
                object5 = object4 == OperatingPlatform.\u00f600000 ? "linux" : (object4 == OperatingPlatform.\u00d600000 ? "win" : (object4 == OperatingPlatform.\u00f400000 ? "mac" : null));
                if (object5 != null) {
                    object5 = this.o00000.is64() ? (String)object5 + "64" : (String)object5 + "32";
                }
                path3 = path2.resolve(string).resolve((String)object5);
            } else {
                path3 = path2.resolve(string);
            }
            object5 = path -> {
                for (String string : arrayList) {
                    if (!FileOperations.wildcardMatch(path.getFileName().toString(), string, false)) continue;
                    return true;
                }
                return false;
            };
            object4 = new ArrayList();
            try {
                object2 = Files.newDirectoryStream(path3, (DirectoryStream.Filter<? super Path>)object5);
                object3 = null;
                try {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Path path4 = (Path)object.next();
                        object4.add(path4);
                    }
                    pathArray = object4.toArray(new Path[0]);
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object3 != null) {
                            try {
                                object2.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object3).addSuppressed(throwable);
                            }
                        } else {
                            object2.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                pathArray = null;
            }
        } else {
            pathArray = null;
        }
        return pathArray;
    }

    private void loadPluginLibraries(String string, Path[] pathArray) throws IOException {
        if (pathArray != null && pathArray.length > 0) {
            try {
                for (Path path : pathArray) {
                    System.load(path.toAbsolutePath().toString());
                    this.\u00d500000.log(1054, path.toAbsolutePath().getFileName().toString(), string);
                }
            }
            catch (Throwable throwable) {
                throw new IOException("Error, could not load library");
            }
        }
    }

    private void loadPluginLibs(String string, Path[] pathArray, URLClassLoader uRLClassLoader) throws IOException {
        if (pathArray != null && pathArray.length > 0) {
            try {
                Class<URLClassLoader> clazz = URLClassLoader.class;
                Method method = clazz.getDeclaredMethod("addURL", \u00d300000);
                method.setAccessible(true);
                for (Path path : pathArray) {
                    URL uRL = path.toUri().toURL();
                    method.invoke((Object)uRLClassLoader, uRL);
                    this.\u00d500000.log(1054, path.toAbsolutePath().toString(), string);
                }
            }
            catch (Throwable throwable) {
                throw new IOException("Error, could not add URL to system classloader");
            }
        }
    }

    private static String getNodeTextContent(NodeList nodeList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            stringBuilder.append(node.getNodeValue());
        }
        return stringBuilder.toString().trim();
    }

    private URLClassLoader getClassLoader(ClassLoader classLoader) {
        if (classLoader != null && classLoader instanceof URLClassLoader) {
            return (URLClassLoader)classLoader;
        }
        return (URLClassLoader)this.getClass().getClassLoader();
    }
}

