/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.encoder;

import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.dither.Ditherer;
import com.neptunelabs.fsiserver.imagemanipulator.dither.FloydSteinberg;
import com.neptunelabs.fsiserver.imagemanipulator.dither.NoDither;
import com.neptunelabs.fsiserver.imagemanipulator.palette.Palette;
import com.neptunelabs.fsiserver.imagemanipulator.palette.PaletteEuclideanSquareRGB;
import com.neptunelabs.fsiserver.imagemanipulator.quantizer.ColorOctree;
import com.neptunelabs.fsiserver.imagemanipulator.quantizer.NeuQuant;
import com.neptunelabs.fsiserver.imagemanipulator.quantizer.Quantizer;
import com.neptunelabs.fsiserver.imagemanipulator.quantizer.Websafe;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import java.awt.color.ICC_Profile;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ImageEncoderUtils {
    protected final FSILogger \u00d2O0000;
    protected FSIImage Object;
    protected ImageWriter \u00d400000;
    private ImageOutputStream oO0000;
    protected OutputStream \u00d200000;
    private boolean void = false;
    protected IIOMetadata OO0000 = null;
    protected int o00000 = 0;
    private String \u00f400000 = null;
    protected String float = null;
    protected String \u00f600000 = null;
    protected byte[] \u00d600000 = null;
    protected byte[] \u00d500000 = null;
    protected byte[] \u00f500000 = null;
    protected byte[] public = null;

    protected ImageEncoderUtils(FSILogger fSILogger) {
        this.\u00d2O0000 = fSILogger;
    }

    public void setImage(FSIImage fSIImage) {
        this.Object = fSIImage;
    }

    public void setImageOutputStream(ImageOutputStream imageOutputStream) {
        this.oO0000 = imageOutputStream;
        this.\u00d400000.setOutput(imageOutputStream);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.\u00d200000 = outputStream;
    }

    public void setDPI(int n) {
        this.o00000 = n;
        this.void = true;
    }

    public void setSoftware(String string) {
        this.float = string;
        this.\u00f400000 = "Generated by " + this.float;
        this.void = true;
    }

    public void setCopyright(String string) {
        this.\u00f600000 = string;
        this.void = true;
    }

    public void setCustomPNGChunk(byte[] byArray, byte[] byArray2) {
        this.\u00d500000 = byArray;
        this.\u00f500000 = byArray2;
        this.void = true;
    }

    public void setICCProfile(ICC_Profile iCC_Profile) {
        this.setICCProfile(iCC_Profile.getData());
    }

    public void setICCProfile(byte[] byArray) {
        this.\u00d600000 = byArray;
        this.void = true;
    }

    protected boolean isPackedByteImage(RenderedImage renderedImage) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            for (int i = 0; i < sampleModel.getNumBands(); ++i) {
                if (sampleModel.getSampleSize(i) <= 8) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static Quantizer getQuantizer(QuantizerMode quantizerMode, int n, int n2, int n3, boolean bl) throws IOException {
        Quantizer quantizer;
        if (quantizerMode == QuantizerMode.o00000) {
            int n4 = n2 <= 0 || n2 > n ? 1 : n2;
            quantizer = new ColorOctree(n3, bl, n4);
        } else if (quantizerMode == QuantizerMode.\u00d300000) {
            int n5 = n2 <= 0 || n2 > n ? 10 : n2;
            quantizer = new NeuQuant(n3, bl, n5);
        } else if (quantizerMode == QuantizerMode.\u00d200000) {
            quantizer = new Websafe(n3, bl);
        } else {
            throw new IOException("Unrecognized Quantizer");
        }
        return quantizer;
    }

    protected static Ditherer getDitherer(DithererMode dithererMode, Palette palette, boolean bl) throws IOException {
        Ditherer ditherer;
        if (dithererMode == DithererMode.\u00d200000) {
            ditherer = new NoDither(palette);
        } else if (dithererMode == DithererMode.o00000) {
            ditherer = new FloydSteinberg(palette, bl);
        } else {
            throw new IOException("Unrecognized Ditherer");
        }
        return ditherer;
    }

    protected static Palette getPalette(PaletteMode paletteMode) throws IOException {
        if (paletteMode != PaletteMode.o00000) {
            throw new IOException("Unrecognized Palette");
        }
        Palette palette = PaletteEuclideanSquareRGB.getInstance();
        return palette;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum PaletteMode {
        o00000;

    }

    public static enum QuantizerMode {
        o00000,
        \u00d300000,
        \u00d200000;

    }

    public static enum DithererMode {
        o00000,
        \u00d200000;

    }
}

