/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.iptc;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.imagereader.iptc.Directory;
import com.neptunelabs.fsiserver.imagereader.iptc.IptcDescriptor;
import com.neptunelabs.fsiserver.imagereader.iptc.Tag;
import com.neptunelabs.fsiserver.imagereader.iptc.exception.IptcDataException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IptcDirectory
extends Directory {
    private final SimpleDateFormat oo0000 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private final DateFormat \u00f8o0000 = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat Stringnew = new SimpleDateFormat("HH:mm:ss Z");
    public static final int null = 346;
    public static final int \u00d8\u00d20000 = 512;
    public static final int \u00f500000 = 517;
    public static final int \u00f8O0000 = 522;
    public static final int \u00d800000 = 527;
    public static final int thisnew = 532;
    public static final int \u00d3\u00d20000 = 537;
    public static final int \u00d3o0000 = 542;
    public static final int newsuper = 547;
    public static final int \u00f5o0000 = 552;
    public static final int \u00f6O0000 = 567;
    public static final int oO0000 = 572;
    public static final int \u00d6o0000 = 574;
    public static final int \u00f5O0000 = 575;
    public static final int \u00d6O0000 = 577;
    public static final int \u00d5o0000 = 592;
    public static final int \u00d500000 = 597;
    public static final int \u00f600000 = 602;
    public static final int for = 604;
    public static final int \u00d5O0000 = 607;
    private static final int returnsuper = 612;
    public static final int \u00d8O0000 = 613;
    public static final int \u00d600000 = 615;
    public static final int \u00d2O0000 = 617;
    public static final int o\u00d20000 = 622;
    public static final int \u00d5\u00d20000 = 627;
    public static final int \u00d6\u00d20000 = 628;
    public static final int whilesuper = 630;
    public static final int \u00f800000 = 632;
    public static final int \u00d3O0000 = 634;
    public static final int ifsuper = 735;
    public static final int \u00d2o0000 = 737;
    public static final int \u00f5\u00d20000 = 732;
    public static final int nullnew = 733;
    public static final int \u00f6o0000 = 734;
    public static final int private = 736;
    private static final Map<Integer, String> \u00d8o0000 = new HashMap<Integer, String>();
    private static final List<String> \u00d2\u00d20000 = new ArrayList<String>();

    private static void registerTag(int n, String string) {
        \u00d8o0000.put(n, string);
        \u00d2\u00d20000.add(string);
    }

    public static String getDefinedTagName(Integer n) {
        if (\u00d8o0000.containsKey(n)) {
            return \u00d8o0000.get(n);
        }
        return "UNKNOWN";
    }

    public IptcDirectory() {
        this.setDescriptor(new IptcDescriptor(this));
    }

    public void setDate(int n, Calendar calendar) {
        this.setCalendar(n, calendar);
    }

    public void setTime(int n, Calendar calendar) {
        this.setCalendar(n, calendar);
    }

    public boolean knowsTag(int n) {
        return \u00d8o0000.containsKey(n);
    }

    @Override
    public final String getName() {
        return "IPTC";
    }

    @Override
    public final Map<Integer, String> getTagNameMap() {
        return \u00d8o0000;
    }

    public final String getTagName(Integer n) {
        if (\u00d8o0000.containsKey(n)) {
            return \u00d8o0000.get(n);
        }
        return null;
    }

    @Override
    public final String getTagName(int n) {
        return this.getTagName(new Integer(n));
    }

    public final Integer[] getTagTypes() {
        return \u00d8o0000.keySet().toArray(new Integer[\u00d8o0000.size()]);
    }

    public final String[] getTagNames() {
        return \u00d8o0000.values().toArray(new String[\u00d8o0000.size()]);
    }

    public final Integer getTagType(String string) {
        try {
            return this.getTagTypesByName(string, true)[0];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Tag[] getCurrentTags() {
        return this.\u00d200000.toArray(new Tag[this.\u00d200000.size()]);
    }

    public final Integer[] getCurrentTagTypes() {
        Integer[] integerArray = new Integer[this.\u00d200000.size()];
        int n = -1;
        for (Tag tag : this.\u00d200000) {
            integerArray[++n] = new Integer(tag.getTagType());
        }
        return integerArray;
    }

    @Override
    public String getDescription(int n) throws IptcDataException {
        switch (n) {
            case 542: 
            case 547: 
            case 567: 
            case 572: 
            case 574: 
            case 575: {
                try {
                    return this.oo0000.format(this.getCalendar(n).getTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return super.getDescription(n);
    }

    public final Integer[] getTagTypesByName(String string, boolean bl) {
        Set<Map.Entry<Integer, String>> set = \u00d8o0000.entrySet();
        if (set.size() > 0) {
            Iterator<Map.Entry<Integer, String>> iterator = set.iterator();
            Map.Entry<Integer, String> entry = null;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (bl) {
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    if (!entry.getValue().equals(string)) continue;
                    arrayList.add(entry.getKey());
                }
            } else {
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    string = string.toLowerCase();
                    if (entry.getValue().toLowerCase().indexOf(string) <= -1) continue;
                    arrayList.add(entry.getKey());
                }
            }
            return arrayList.toArray(new Integer[arrayList.size()]);
        }
        return null;
    }

    public String toString() {
        Tag[] tagArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (Tag tag : tagArray = this.getCurrentTags()) {
            try {
                stringBuilder.append("\n");
                stringBuilder.append(tag.toString());
            }
            catch (Exception exception) {
                stringBuilder.append("[" + tag.getTagType() + "]\t" + exception);
            }
        }
        return stringBuilder.toString();
    }

    public Map<Pair<String, String>, String> getIptcMap() {
        Tag[] tagArray;
        HashMap<Pair<String, String>, String> hashMap = new HashMap<Pair<String, String>, String>();
        for (Tag tag : tagArray = this.getCurrentTags()) {
            try {
                switch (tag.getTagType()) {
                    case 547: 
                    case 572: 
                    case 575: {
                        hashMap.put(new Pair<String, String>(tag.getTagTypeHex(), tag.getTagName()), this.Stringnew.format(this.getCalendar(tag.getTagType()).getTime()));
                        break;
                    }
                    case 542: 
                    case 567: 
                    case 574: {
                        hashMap.put(new Pair<String, String>(tag.getTagTypeHex(), tag.getTagName()), this.\u00f8o0000.format(this.getCalendar(tag.getTagType()).getTime()));
                        break;
                    }
                    default: {
                        hashMap.put(new Pair<String, String>(tag.getTagTypeHex(), tag.getTagName()), this.getString(tag.getTagType()));
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashMap;
    }

    public Map<String, String> getIptcSimpleMap() {
        Tag[] tagArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Tag tag : tagArray = this.getCurrentTags()) {
            try {
                switch (tag.getTagType()) {
                    case 547: 
                    case 572: 
                    case 575: {
                        hashMap.put(tag.getTagName(), this.Stringnew.format(this.getCalendar(tag.getTagType()).getTime()));
                        break;
                    }
                    case 542: 
                    case 567: 
                    case 574: {
                        hashMap.put(tag.getTagName(), this.\u00f8o0000.format(this.getCalendar(tag.getTagType()).getTime()));
                        break;
                    }
                    default: {
                        hashMap.put(tag.getTagName(), this.getString(tag.getTagType()));
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashMap;
    }

    public List<Pair<String, String>> getIptcSortedList() {
        Map<String, String> map = this.getIptcSimpleMap();
        List<Pair<String, String>> list = IptcDirectory.getSortedListFromMap(map);
        return list;
    }

    public static List<Pair<String, String>> getSortedListFromMap(Map<String, String> map) {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        for (String object : \u00d2\u00d20000) {
            String string = map.get(object);
            if (string == null) continue;
            arrayList.add(new Pair<String, String>(object, string));
            map.remove(object);
        }
        for (Map.Entry entry : map.entrySet()) {
            arrayList.add(new Pair(entry.getKey(), entry.getValue()));
        }
        return arrayList;
    }

    static {
        IptcDirectory.registerTag(512, "Directory Version");
        IptcDirectory.registerTag(567, "Date Created");
        IptcDirectory.registerTag(628, "Copyright Notice");
        IptcDirectory.registerTag(634, "Writer");
        IptcDirectory.registerTag(617, "Headline");
        IptcDirectory.registerTag(592, "By-line");
        IptcDirectory.registerTag(597, "By-line Title");
        IptcDirectory.registerTag(622, "Credit");
        IptcDirectory.registerTag(627, "Source");
        IptcDirectory.registerTag(517, "Object Name");
        IptcDirectory.registerTag(527, "Category");
        IptcDirectory.registerTag(532, "Supplemental Category(s)");
        IptcDirectory.registerTag(602, "City");
        IptcDirectory.registerTag(604, "Sublocation");
        IptcDirectory.registerTag(607, "Province/State");
        IptcDirectory.registerTag(612, "Country Code");
        IptcDirectory.registerTag(613, "Country/Primary Location");
        IptcDirectory.registerTag(615, "Original Transmission Reference");
        IptcDirectory.registerTag(522, "Urgency");
        IptcDirectory.registerTag(542, "Release Date");
        IptcDirectory.registerTag(547, "Release Time");
        IptcDirectory.registerTag(572, "Time Created");
        IptcDirectory.registerTag(577, "Originating Program");
        IptcDirectory.registerTag(552, "Special Instructions");
        IptcDirectory.registerTag(537, "Keywords");
        IptcDirectory.registerTag(630, "Contact");
        IptcDirectory.registerTag(632, "Caption");
        IptcDirectory.registerTag(574, "Digital Creation Date");
        IptcDirectory.registerTag(575, "Digital Creation Time");
        IptcDirectory.registerTag(736, "FSI Encoding");
        IptcDirectory.registerTag(737, "FSI Search Data");
        IptcDirectory.registerTag(735, "FSI Extra");
        IptcDirectory.registerTag(732, "FSI Tiles X");
        IptcDirectory.registerTag(733, "FSI Tiles Y");
        IptcDirectory.registerTag(734, "FSI SceneSets");
        IptcDirectory.registerTag(276, "File Format");
        IptcDirectory.registerTag(278, "File Format Version");
        IptcDirectory.registerTag(336, "Time Sent");
        IptcDirectory.registerTag(306, "Product ID");
        IptcDirectory.registerTag(316, "Envelope Priority");
        IptcDirectory.registerTag(286, "Service Identifier");
        IptcDirectory.registerTag(326, "Date Sent");
        IptcDirectory.registerTag(261, "Destination");
        IptcDirectory.registerTag(256, "Record Version");
        IptcDirectory.registerTag(296, "Envelope Number");
        IptcDirectory.registerTag(549, "Expiration Date");
        IptcDirectory.registerTag(550, "Expiration Time");
        IptcDirectory.registerTag(582, "Program Version");
        IptcDirectory.registerTag(698, "Short Document ID");
        IptcDirectory.registerTag(699, "Unique Document ID");
        IptcDirectory.registerTag(695, "Character Set");
    }
}

