/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.metareader;

import com.neptunelabs.fsiserver.framework.io.LittleEndianDataInputStream;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.ImageFormat;
import com.neptunelabs.fsiserver.imagereader.converter.ColorType;
import com.neptunelabs.fsiserver.imagereader.metareader.FSIMetaData;
import com.neptunelabs.fsiserver.imagereader.metareader.FSISubImageMetaData;
import com.neptunelabs.fsiserver.imagereader.metareader.MetaReaderAbstract;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;

public final class MetaReaderBMP
extends MetaReaderAbstract {
    public static final int \u00d4o0000 = 512;

    public MetaReaderBMP(FSILogger fSILogger, ImageFormat imageFormat) {
        super(fSILogger, imageFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanImage(PathCached pathCached, boolean bl) throws IOException {
        block30: {
            this.Object = new FSIMetaData(pathCached);
            try (LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream(Files.newInputStream(pathCached.getPath(), new OpenOption[0]));){
                byte[] byArray = new byte[2];
                littleEndianDataInputStream.read(byArray);
                if (byArray[0] != 66 || byArray[1] != 77) {
                    this.float |= 4;
                }
                if (this.float != 0) break block30;
                FSISubImageMetaData fSISubImageMetaData = this.Object.createImage(0);
                try {
                    littleEndianDataInputStream.skip(12L);
                    int n = littleEndianDataInputStream.readInt();
                    if (n == 12) {
                        fSISubImageMetaData.interface = littleEndianDataInputStream.readShort();
                        fSISubImageMetaData.\u00d4O0000 = Math.abs(littleEndianDataInputStream.readShort());
                    } else {
                        fSISubImageMetaData.interface = littleEndianDataInputStream.readInt();
                        fSISubImageMetaData.\u00d4O0000 = Math.abs(littleEndianDataInputStream.readInt());
                    }
                    littleEndianDataInputStream.skip(2L);
                    short s = littleEndianDataInputStream.readShort();
                    this.Object.if = this.getColorspace(s);
                    fSISubImageMetaData.\u00f800000 = this.getBitsPerSamples(s);
                    fSISubImageMetaData.OO0000 = this.getSamplesPerPixel(s);
                    this.float |= this.validateMetaData(fSISubImageMetaData);
                    if (this.float == 0) {
                        this.Object.addImage(fSISubImageMetaData);
                    }
                }
                catch (IOException iOException) {
                    this.float |= 4;
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                this.\u00d2O0000.logException(noSuchFileException, 3801, this.Object.o00000);
                this.float |= 1;
            }
            catch (IOException iOException) {
                this.\u00d2O0000.logException(iOException, 3802, this.Object.o00000);
                this.float |= 2;
            }
            catch (Exception exception) {
                this.\u00d2O0000.logException(exception, 3850, this.Object.o00000);
                this.float |= 4;
            }
            catch (Error error) {
                this.\u00d2O0000.logError(error, 3850, this.Object.o00000);
                this.float |= 4;
            }
            finally {
                if (this.float != 0) {
                    this.close();
                }
            }
        }
    }

    private void close() {
    }

    private ColorType getColorspace(int n) {
        ColorType colorType = ColorType.int;
        if (n == 1) {
            colorType = ColorType.OO0000;
        } else if (n == 4 || n == 8) {
            colorType = ColorType.\u00f800000;
        } else if (n == 15) {
            colorType = ColorType.\u00d800000;
        } else if (n == 16) {
            colorType = ColorType.\u00d600000;
        } else if (n == 24 || n == 32) {
            colorType = ColorType.\u00d200000;
        }
        return colorType;
    }

    private int getBitsPerSamples(int n) {
        int n2 = 1;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                n2 = -1;
                break;
            }
            case 24: 
            case 32: {
                n2 = 8;
            }
        }
        return n2;
    }

    private int getSamplesPerPixel(int n) {
        int n2 = 1;
        switch (n) {
            case 1: 
            case 4: 
            case 8: 
            case 16: {
                n2 = -1;
                break;
            }
            case 24: 
            case 32: {
                n2 = 3;
            }
        }
        return n2;
    }
}

