/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.filters;

import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.yworks.util.annotation.Obfuscation;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebFilter(filterName="CorsFilter", urlPatterns={"/*"}, asyncSupported=true)
@Obfuscation
public final class CorsFilter
implements Filter {
    private RequestProcessorSettings settings = null;
    private final Collection<String> allowedOrigins = new HashSet<String>();
    private boolean anyOriginAllowed;
    private final Collection<String> allowedHttpMethods = new HashSet<String>();
    private final Collection<String> allowedHttpHeaders = new HashSet<String>();
    private final Collection<String> exposedHeaders = new HashSet<String>();
    private boolean supportsCredentials;
    private long preflightMaxAge;
    private boolean decorateRequest;
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String REQUEST_HEADER_VARY = "Vary";
    private static final String REQUEST_HEADER_ORIGIN = "Origin";
    private static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    private static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private static final String HTTP_REQUEST_ATTRIBUTE_PREFIX = "cors.";
    private static final String HTTP_REQUEST_ATTRIBUTE_ORIGIN = "cors.request.origin";
    private static final String HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST = "cors.isCorsRequest";
    private static final String HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE = "cors.request.type";
    private static final String HTTP_REQUEST_ATTRIBUTE_REQUEST_HEADERS = "cors.request.headers";
    private static final Collection<String> SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES = new HashSet<String>(Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain"));

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        this.settings = (RequestProcessorSettings)servletContext.getAttribute("com.neptunelabs.fsiserver.RequestProcessorSettings");
        if (this.settings != null) {
            try {
                this.parseAndStore();
            }
            catch (Throwable throwable) {
                servletContext.setAttribute("com.neptunelabs.fsiserver.requestprocessor.startError", (Object)throwable.getMessage());
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("CORS doesn't support non-HTTP request or response");
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        CORSRequestType cORSRequestType = this.checkRequestType(httpServletRequest);
        if (this.decorateRequest) {
            CorsFilter.decorateCORSProperties(httpServletRequest, cORSRequestType);
        }
        switch (cORSRequestType) {
            case SIMPLE: {
                this.handleSimpleCORS(httpServletRequest, httpServletResponse, filterChain);
                break;
            }
            case ACTUAL: {
                this.handleSimpleCORS(httpServletRequest, httpServletResponse, filterChain);
                break;
            }
            case PRE_FLIGHT: {
                this.handlePreflightCORS(httpServletRequest, httpServletResponse, filterChain);
                break;
            }
            case NOT_CORS: {
                this.handleNonCORS(httpServletRequest, httpServletResponse, filterChain);
                break;
            }
            default: {
                this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain, "violate specs");
            }
        }
    }

    private void handleSimpleCORS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        String string;
        CORSRequestType cORSRequestType = this.checkRequestType(httpServletRequest);
        if (cORSRequestType != CORSRequestType.SIMPLE && cORSRequestType != CORSRequestType.ACTUAL) {
            throw new IllegalArgumentException("Expects a HttpServletRequest object of type SIMPLE or ACTUAL");
        }
        String string2 = httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN);
        String string3 = httpServletRequest.getMethod();
        if (!this.isOriginAllowed(string2)) {
            this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain, "origin " + string2 + " not allowed");
            return;
        }
        if (!this.allowedHttpMethods.contains(string3)) {
            this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain, "method (0) not allowed");
            return;
        }
        if (this.anyOriginAllowed && !this.supportsCredentials) {
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        } else {
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, string2);
        }
        httpServletResponse.addHeader(REQUEST_HEADER_VARY, REQUEST_HEADER_ORIGIN);
        if (this.supportsCredentials) {
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        }
        if (this.exposedHeaders != null && this.exposedHeaders.size() > 0 && (string = httpServletRequest.getHeader(RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS)) != null) {
            String[] stringArray = string.trim().split(",");
            HashSet<String> hashSet = new HashSet<String>();
            for (String string4 : stringArray) {
                for (String string5 : this.exposedHeaders) {
                    if (!string4.trim().equalsIgnoreCase(string5)) continue;
                    hashSet.add(string4);
                }
            }
            if (!hashSet.isEmpty()) {
                String string6 = CorsFilter.join(hashSet, ",");
                httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_EXPOSE_HEADERS, string6);
            }
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private void handlePreflightCORS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        CORSRequestType cORSRequestType = this.checkRequestType(httpServletRequest);
        if (cORSRequestType != CORSRequestType.PRE_FLIGHT) {
            throw new IllegalArgumentException("Expects a HttpServletRequest object of type " + CORSRequestType.PRE_FLIGHT.name().toLowerCase(Locale.ENGLISH));
        }
        String string = httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN);
        if (!this.isOriginAllowed(string)) {
            this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain, "origin " + string + " not allowed");
            return;
        }
        String string2 = httpServletRequest.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD);
        if (string2 == null) {
            this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain, "access control request methods null");
            return;
        }
        string2 = string2.trim();
        String string3 = httpServletRequest.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
        LinkedList<String> linkedList = new LinkedList<String>();
        if (string3 != null && !string3.trim().isEmpty()) {
            String[] stringArray = string3.trim().split(",");
            for (String string4 : stringArray) {
                linkedList.add(string4.trim().toLowerCase(Locale.ENGLISH));
            }
        }
        if (!this.allowedHttpMethods.contains(string2)) {
            this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain, "method (1) not allowed");
            return;
        }
        if (!linkedList.isEmpty()) {
            for (String string5 : linkedList) {
                if (this.allowedHttpHeaders.contains(string5)) continue;
                this.handleInvalidCORS(httpServletRequest, httpServletResponse, filterChain, "http header not allowed");
                return;
            }
        }
        if (this.supportsCredentials) {
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, string);
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        } else if (this.anyOriginAllowed) {
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        } else {
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, string);
        }
        if (this.preflightMaxAge > 0L) {
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_MAX_AGE, String.valueOf(this.preflightMaxAge));
        }
        httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_METHODS, string2);
        if (this.allowedHttpHeaders != null && !this.allowedHttpHeaders.isEmpty()) {
            httpServletResponse.addHeader(RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS, CorsFilter.join(this.allowedHttpHeaders, ","));
        }
    }

    private void handleNonCORS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private void handleInvalidCORS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain, String string) {
        httpServletResponse.setContentType("text/plain");
        httpServletResponse.setStatus(403);
        httpServletResponse.resetBuffer();
    }

    public void destroy() {
    }

    private static void decorateCORSProperties(HttpServletRequest httpServletRequest, CORSRequestType cORSRequestType) {
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("HttpServletRequest object is null");
        }
        if (cORSRequestType == null) {
            throw new IllegalArgumentException("CORSRequestType object is null");
        }
        switch (cORSRequestType) {
            case SIMPLE: {
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.TRUE);
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN));
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)cORSRequestType.name().toLowerCase(Locale.ENGLISH));
                break;
            }
            case ACTUAL: {
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.TRUE);
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN));
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)cORSRequestType.name().toLowerCase(Locale.ENGLISH));
                break;
            }
            case PRE_FLIGHT: {
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.TRUE);
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_ORIGIN, (Object)httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN));
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_TYPE, (Object)cORSRequestType.name().toLowerCase(Locale.ENGLISH));
                String string = httpServletRequest.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
                if (string == null) {
                    string = "";
                }
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_REQUEST_HEADERS, (Object)string);
                break;
            }
            case NOT_CORS: {
                httpServletRequest.setAttribute(HTTP_REQUEST_ATTRIBUTE_IS_CORS_REQUEST, (Object)Boolean.FALSE);
                break;
            }
        }
    }

    private static String join(Collection<String> collection, String string) {
        String string2 = ",";
        if (collection == null) {
            return null;
        }
        if (string != null) {
            string2 = string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string3 : collection) {
            if (!bl) {
                stringBuilder.append(string2);
            } else {
                bl = false;
            }
            if (string3 == null) continue;
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    private CORSRequestType checkRequestType(HttpServletRequest httpServletRequest) {
        CORSRequestType cORSRequestType = CORSRequestType.INVALID_CORS;
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("HttpServletRequest object is null");
        }
        String string = httpServletRequest.getHeader(REQUEST_HEADER_ORIGIN);
        if (string != null) {
            if (string.isEmpty()) {
                cORSRequestType = CORSRequestType.INVALID_CORS;
            } else if (!CorsFilter.isValidOrigin(string)) {
                cORSRequestType = CORSRequestType.INVALID_CORS;
            } else {
                if (this.isLocalOrigin(httpServletRequest, string)) {
                    return CORSRequestType.NOT_CORS;
                }
                String string2 = httpServletRequest.getMethod();
                if (string2 != null) {
                    if ("OPTIONS".equals(string2)) {
                        String string3 = httpServletRequest.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_METHOD);
                        cORSRequestType = string3 != null && !string3.isEmpty() ? CORSRequestType.PRE_FLIGHT : (string3 != null && string3.isEmpty() ? CORSRequestType.INVALID_CORS : CORSRequestType.ACTUAL);
                    } else if ("GET".equals(string2) || "HEAD".equals(string2)) {
                        cORSRequestType = CORSRequestType.SIMPLE;
                    } else if ("POST".equals(string2)) {
                        String string4 = this.getMediaType(httpServletRequest.getContentType());
                        if (string4 != null) {
                            cORSRequestType = SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES.contains(string4) ? CORSRequestType.SIMPLE : CORSRequestType.ACTUAL;
                        }
                    } else {
                        cORSRequestType = CORSRequestType.ACTUAL;
                    }
                }
            }
        } else {
            cORSRequestType = CORSRequestType.NOT_CORS;
        }
        return cORSRequestType;
    }

    private boolean isLocalOrigin(HttpServletRequest httpServletRequest, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = httpServletRequest.getScheme();
        if (string2 == null) {
            return false;
        }
        string2 = string2.toLowerCase(Locale.ENGLISH);
        stringBuilder.append(string2);
        stringBuilder.append("://");
        String string3 = httpServletRequest.getServerName();
        if (string3 == null) {
            return false;
        }
        stringBuilder.append(string3);
        int n = httpServletRequest.getServerPort();
        if ("http".equals(string2) && n != 80 || "https".equals(string2) && n != 443) {
            stringBuilder.append(':');
            stringBuilder.append(n);
        }
        return string.equalsIgnoreCase(stringBuilder.toString());
    }

    private String getMediaType(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        int n = string2.indexOf(59);
        if (n > -1) {
            string2 = string2.substring(0, n);
        }
        string2 = string2.trim();
        return string2;
    }

    private boolean isOriginAllowed(String string) {
        if (this.anyOriginAllowed) {
            return true;
        }
        return this.allowedOrigins.contains(string);
    }

    private void parseAndStore() throws ServletException {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string2 = this.settings.getPrefsString("application", "corsAllowedOrigins");
        if (string2 != null) {
            if (string2.trim().equals("*")) {
                this.anyOriginAllowed = true;
            } else {
                this.anyOriginAllowed = false;
                object5 = this.parseStringToSet(string2);
                this.allowedOrigins.clear();
                this.allowedOrigins.addAll((Collection<String>)object5);
            }
        }
        if ((object5 = this.settings.getPrefsString("application", "corsAllowedMethods")) != null) {
            object4 = this.parseStringToSet((String)object5);
            this.allowedHttpMethods.clear();
            this.allowedHttpMethods.addAll((Collection<String>)object4);
        }
        if ((object4 = this.settings.getPrefsString("application", "corsAllowedHeaders")) != null) {
            object3 = this.parseStringToSet((String)object4);
            object2 = new HashSet();
            object = object3.iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                String string3 = string.toLowerCase(Locale.ENGLISH);
                object2.add(string3);
            }
            this.allowedHttpHeaders.clear();
            this.allowedHttpHeaders.addAll((Collection<String>)object2);
        }
        if ((object3 = this.settings.getPrefsString("application", "corsExposedHeaders")) != null) {
            object2 = this.parseStringToSet((String)object3);
            this.exposedHeaders.clear();
            this.exposedHeaders.addAll((Collection<String>)object2);
        }
        if ((object2 = this.settings.getPrefsString("application", "corsSupportCredentials")) != null) {
            this.supportsCredentials = Boolean.parseBoolean((String)object2);
        }
        if ((object = this.settings.getPrefsString("application", "corsPreflightMaxage")) != null) {
            try {
                this.preflightMaxAge = !((String)object).isEmpty() ? Long.parseLong((String)object) : 0L;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ServletException("Unable to parse preflightMaxAge", (Throwable)numberFormatException);
            }
        }
        if ((string = this.settings.getPrefsString("application", "corsRequestDecorate")) != null) {
            this.decorateRequest = Boolean.parseBoolean(string);
        }
    }

    private Set<String> parseStringToSet(String string) {
        String[] stringArray = string != null && string.length() > 0 ? string.split(",") : new String[]{};
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray.length > 0) {
            for (String string2 : stringArray) {
                hashSet.add(string2.trim());
            }
        }
        return hashSet;
    }

    private static boolean isValidOrigin(String string) {
        URI uRI;
        if (string.contains("%")) {
            return false;
        }
        if ("null".equals(string)) {
            return true;
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        return uRI.getScheme() != null;
    }

    private static enum CORSRequestType {
        SIMPLE,
        ACTUAL,
        PRE_FLIGHT,
        NOT_CORS,
        INVALID_CORS;

    }
}

