/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.outputcompressors;

import com.neptunelabs.fsiserver.framework.SoftwareVersion;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.fsiserver.imagemanipulator.encoder.png.PNGEncoder;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressorResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.OutputParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import java.io.IOException;
import java.util.Base64;

public class PNGCompressor
extends OutputCompressor {
    public PNGCompressor(FSILogger fSILogger) {
        super(fSILogger);
    }

    @Override
    public OutputCompressorResponse compressImageData(int n, FSIImage fSIImage, Renderer renderer, Parameters parameters, String string) {
        OutputCompressorResponse outputCompressorResponse = new OutputCompressorResponse();
        StringBuilder stringBuilder = new StringBuilder("PNG");
        stringBuilder.append(string);
        PNGEncoder pNGEncoder = new PNGEncoder(this.\u00d200000);
        pNGEncoder.setImage(fSIImage);
        pNGEncoder.setCopyright(string);
        pNGEncoder.setSoftware(SoftwareVersion.getSoftware(false));
        Pair<byte[], byte[]> pair = fSIImage.getCustomData();
        if (pair != null) {
            pNGEncoder.setCustomPNGChunk(pair.getItem1(), pair.getItem2());
        }
        OutputParameters outputParameters = renderer.getOutputParameters();
        if (outputParameters.oO0000 != -1) {
            pNGEncoder.setCompressionLevel(outputParameters.oO0000);
            stringBuilder.append(outputParameters.oO0000);
        }
        if (outputParameters.\u00d5O0000 != -1) {
            pNGEncoder.setFilter(outputParameters.\u00d5O0000);
            stringBuilder.append(outputParameters.\u00d5O0000);
        }
        if (outputParameters.\u00f400000) {
            pNGEncoder.setICCProfile(this.\u00d500000);
            stringBuilder.append("embedicc");
        }
        pNGEncoder.setPalette(ImageEncoderUtils.PaletteMode.o00000);
        pNGEncoder.setMatteColor(this.getParameterBackgroundColor(parameters, outputParameters));
        pNGEncoder.setMaxColors(this.getParameterMaxColors(parameters, outputParameters));
        pNGEncoder.setDitherer(this.getParameterDithererMode(parameters, outputParameters));
        pNGEncoder.setQuantizer(this.getParameterQuantizerMode(parameters, outputParameters));
        pNGEncoder.setQuantizerSampleDepth(outputParameters.\u00d4O0000);
        int n2 = this.getParameterDPI(parameters, outputParameters);
        pNGEncoder.setDPI(n2);
        pNGEncoder.setEncodeAlpha(fSIImage.hasAlpha());
        OutputParameters.Colorspace colorspace = this.getColorSpaceFromRequestParameters(parameters);
        if (colorspace == OutputParameters.Colorspace.\u00d300000) {
            pNGEncoder.setEncodeGray(true);
            stringBuilder.append("gray");
        } else if (colorspace == OutputParameters.Colorspace.\u00d400000 && (colorspace = outputParameters.\u00f800000) == OutputParameters.Colorspace.\u00d300000) {
            pNGEncoder.setEncodeGray(true);
            stringBuilder.append("gray");
        }
        try (ByteArrayOutputStreamFast byteArrayOutputStreamFast = new ByteArrayOutputStreamFast(1024);){
            pNGEncoder.setOutputStream(byteArrayOutputStreamFast);
            pNGEncoder.encode();
            pNGEncoder.dispose();
            OutputParameters.Encoding encoding = this.getEncodingFromRequestParameters(parameters);
            if (encoding == OutputParameters.Encoding.\u00d400000) {
                encoding = outputParameters.\u00d400000;
            }
            if (encoding == OutputParameters.Encoding.new) {
                outputCompressorResponse.setMimeType("text/plain");
                outputCompressorResponse.setImageData(Base64.getEncoder().encode(byteArrayOutputStreamFast.toByteArray()));
                stringBuilder.append("b64");
            } else {
                outputCompressorResponse.setMimeType("image/png");
                outputCompressorResponse.setImageData(byteArrayOutputStreamFast.toByteArray());
            }
            outputCompressorResponse.setETagModifer(stringBuilder.toString());
        }
        catch (IOException iOException) {
            this.\u00d200000.log(3040, iOException.getLocalizedMessage());
            outputCompressorResponse.setError(true);
        }
        return outputCompressorResponse;
    }
}

