/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.deletepool.DeletePool;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.search.solr.SolrUpdater;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashList;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntry;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.ImageListFileWriter;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.URL;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DeleteDaemon
extends Thread {
    public static final String \u00d200000 = ".trashlist";
    private static final long \u00d400000 = 300000L;
    private final SourceManagerSettings class;
    private final DeletePool int;
    private final Map<String, SourceConnectorReader> super;
    private final ImageListFileReader \u00d800000;
    private final ImageListFileWriter \u00f400000;
    private final SolrUpdater \u00d300000;
    private final StorageHelperV1002 \u00f600000;
    private boolean \u00d600000 = true;

    public DeleteDaemon(SourceManagerSettings sourceManagerSettings, DeletePool deletePool, ImageListFileReader imageListFileReader, ImageListFileWriter imageListFileWriter, SolrUpdater solrUpdater) {
        this.class = sourceManagerSettings;
        this.int = deletePool;
        this.\u00d800000 = imageListFileReader;
        this.\u00f400000 = imageListFileWriter;
        this.\u00f600000 = sourceManagerSettings.getStorageHelper();
        this.\u00d300000 = solrUpdater;
        this.super = new HashMap<String, SourceConnectorReader>();
        this.updateProfileMap();
        Path path = sourceManagerSettings.getTrashLocation();
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                sourceManagerSettings.getLogger().log(3199, path);
            }
        }
        this.setDaemon(true);
        this.setName("Delete Control Thread");
    }

    void updateProfileMap() {
        Map<String, SourceConnectorReader> map = this.class.getEnabledConnectors();
        for (Map.Entry<String, SourceConnectorReader> entry : map.entrySet()) {
            SourceConnectorReader sourceConnectorReader = entry.getValue();
            this.super.put(sourceConnectorReader.getPrefix(), sourceConnectorReader);
        }
    }

    @Override
    public void run() {
        while (this.\u00d600000) {
            try {
                List<PathCached> list = FileOperations.listAllFiles(this.class.getTrashLocation());
                if (list != null) {
                    for (PathCached pathCached : list) {
                        if (!this.\u00d600000) break;
                        this.int.addFilepath(0, pathCached.getPath(), true);
                    }
                }
                DeleteDaemon.sleep(300000L);
            }
            catch (IOException | InterruptedException exception) {}
        }
    }

    void removeStorageDirectory(String string, String string2) throws NotConfiguredException, IOException {
        String string3;
        Object object;
        string = this.removeLeadingSlashesFromString(string);
        Pair<SourceConnectorReader, String> pair = this.expandPath(string);
        long l = 0L;
        if (pair != null) {
            object = pair.getItem1();
            string3 = pair.getItem2();
            Path path = ((SourceConnectorReader)object).getInboxDirectory().resolve(string3);
            l = Files.notExists(path, new LinkOption[0]) ? FileOperations.getSafeLastModified(path.getParent()) : FileOperations.getSafeLastModified(path);
        }
        object = this.determineParentPath(string);
        string3 = string;
        if (string3.endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (string3.indexOf(47) != -1) {
            string3 = string3.substring(string3.lastIndexOf("/") + 1);
        }
        this.removeSubs(string, string2);
        this.removeDirListDirEntry((String)object, string3, l, string2);
        this.\u00f400000.forceClearingBuffer(string);
    }

    private String determineParentPath(String string) {
        int n = string.lastIndexOf("/", string.length() - 2);
        String string2 = n != -1 ? string.substring(0, n) : "/";
        return string2;
    }

    private String removeLeadingSlashesFromString(String string) {
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private void removeSubs(String string, String string2) throws NotConfiguredException, IOException {
        PoolList poolList;
        Path path = this.\u00f600000.getDirectoryFile(string);
        try {
            poolList = this.\u00d800000.getListFileContents(path, string);
        }
        catch (IOException iOException) {
            poolList = null;
        }
        if (poolList != null) {
            String string3;
            Collection<PoolFileEntry> collection = poolList.getFilesAsCollection();
            HashSet<String> hashSet = new HashSet<String>();
            for (PoolFileEntry object2 : collection) {
                string3 = string + "/" + object2.o00000;
                hashSet.add(string3);
                Path path2 = this.\u00f600000.getEisFile(string3);
                this.class.getStorageManager().removeFromStorage(path2, string3);
            }
            Set<String> set = poolList.getDirectoryNameSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                if (string3 == null || string3.length() <= 0) continue;
                if (!this.\u00d600000) break;
                this.removeSubs(string + "/" + string3, string2);
                hashSet.add(string + "/" + string3);
            }
            if (this.\u00d300000 != null && hashSet.size() > 0) {
                this.\u00d300000.deleteAssetsAsync(hashSet);
            }
        }
        if (path != null) {
            this.\u00f400000.forceClearingBuffer(string);
            this.class.getStorageManager().removeFromStorage(path, string);
        }
    }

    private void removeDirListDirEntry(String string, String string2, long l, String string3) throws NotConfiguredException {
        if (string != null && string2 != null) {
            Path path = null;
            path = this.\u00f600000.getDirectoryFile(string);
            String string4 = URL.getParentAssetURLPath(string);
            Path path2 = this.\u00f600000.getDirectoryFile(string4);
            this.\u00f400000.removeEntry(path, string, path2, string4, string2, l);
        }
    }

    public boolean removeStorageFileV1002(String string, SourceConnectorReader sourceConnectorReader, boolean bl) throws NotConfiguredException, IOException {
        boolean bl2 = false;
        if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d300000) {
            Path path = this.\u00f600000.getEisFile(string);
            bl2 = this.class.getStorageManager().removeFromStorage(path, string);
        }
        return bl2;
    }

    public void delete(Path path, String string, SourceConnectorReader sourceConnectorReader) throws IOException, NotConfiguredException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            this.deleteFile(path, string, sourceConnectorReader);
        } else {
            List<PathCached> list = FileOperations.listAllFiles(path);
            for (PathCached comparable2 : list) {
                this.delete(comparable2.getPath(), string + "/" + comparable2.getFileName(), sourceConnectorReader);
            }
            Files.delete(path);
            String string2 = URL.getParentAssetURLPath(string);
            Path path2 = this.\u00f600000.getDirectoryFile(string2);
            String string3 = URL.getParentAssetURLPath(string2);
            Path path3 = this.\u00f600000.getDirectoryFile(string3);
            this.\u00f400000.removeEntry(path2, string2, path3, string3, path.getFileName().toString(), FileOperations.getSafeLastModified(path.getParent()));
            Path path4 = this.\u00f600000.getDirectoryFile(string);
            this.\u00f400000.forceClearingBuffer(string);
            this.class.getStorageManager().removeFromStorage(path4, string);
        }
    }

    public void moveToTrash(Path path, String string, SourceConnectorReader sourceConnectorReader) throws IOException, NotConfiguredException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            this.moveFileToTrash(path, string, sourceConnectorReader);
        } else {
            List<PathCached> list = FileOperations.listAllFiles(path);
            for (PathCached comparable : list) {
                this.moveToTrash(comparable.getPath(), string + "/" + comparable.getFileName(), sourceConnectorReader);
            }
            Files.delete(path);
            if (!sourceConnectorReader.isVirtualViewerConnector()) {
                String string2 = URL.getParentAssetURLPath(string);
                Path path2 = this.\u00f600000.getDirectoryFile(string2);
                String string3 = URL.getParentAssetURLPath(string2);
                Path path3 = this.\u00f600000.getDirectoryFile(string3);
                this.\u00f400000.removeEntry(path2, string2, path3, string3, path.getFileName().toString(), FileOperations.getSafeLastModified(path.getParent()));
                Path path4 = this.\u00f600000.getDirectoryFile(string);
                this.\u00f400000.forceClearingBuffer(string);
                this.class.getStorageManager().removeFromStorage(path4, string);
            } else {
                this.class.getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.super, URL.getParentAssetURLPath(string));
            }
        }
    }

    private void deleteFile(Path path, String string, SourceConnectorReader sourceConnectorReader) throws IOException, NotConfiguredException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("This method only can only handle files, not directories.");
        }
        if (Files.deleteIfExists(path)) {
            String string2;
            String string3;
            int n;
            if (sourceConnectorReader != null && sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d300000) {
                this.removeStorageFileV1002(string, sourceConnectorReader, true);
            }
            long l = 0L;
            Path path2 = path.getParent();
            if (Files.exists(path2, new LinkOption[0])) {
                l = FileOperations.getSafeLastModified(path2);
            }
            if ((n = string.lastIndexOf("/")) == -1) {
                string3 = "/";
                string2 = string;
            } else {
                string3 = string.substring(0, n);
                string2 = string.substring(n);
            }
            if (sourceConnectorReader != null && !sourceConnectorReader.isVirtualViewerConnector()) {
                this.removeDirListFileEntryV1002(string3, string2, l);
                Path path3 = this.class.getMetaDataLocation();
                Path path4 = path3.resolve(string + ".meta");
                Files.deleteIfExists(path4);
            } else {
                this.class.getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.super, string3);
            }
            if (this.\u00d300000 != null) {
                this.\u00d300000.deleteAssetAsync(string);
            }
        } else {
            throw new IOException("403 - Could not delete source file");
        }
    }

    private void moveFileToTrash(Path path, String string, SourceConnectorReader sourceConnectorReader) throws IOException, NotConfiguredException {
        String string2;
        String string3;
        int n;
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("This method only can only handle files, not directories.");
        }
        Path path2 = this.\u00f600000.getTrashFolder(sourceConnectorReader);
        String string4 = this.\u00f600000.calculateTrashFileHash(string);
        Path path3 = path2.resolve(string4 + ".src");
        int n2 = 1;
        String string5 = string4;
        while (Files.exists(path3, new LinkOption[0])) {
            string5 = string4 + "_" + n2;
            ++n2;
            path3 = path2.resolve(string5 + ".src");
        }
        long l = FileOperations.getSafeLastModified(path);
        long l2 = Files.size(path);
        Path path4 = path3.getParent();
        if (!Files.exists(path4, new LinkOption[0])) {
            Files.createDirectories(path4, new FileAttribute[0]);
        }
        FileOperations.move(path, path3);
        if (sourceConnectorReader != null && sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d300000) {
            this.moveStorageContentToTrash(path2, string, string5, path);
        }
        long l3 = 0L;
        Path path5 = path.getParent();
        if (Files.exists(path5, new LinkOption[0])) {
            l3 = FileOperations.getSafeLastModified(path5);
        }
        if ((n = string.lastIndexOf("/")) == -1) {
            string3 = "/";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
        }
        if (sourceConnectorReader != null && !sourceConnectorReader.isVirtualViewerConnector()) {
            this.removeDirListFileEntryV1002(string3, string2, l3);
            this.moveCustomMetadataToTrash(string, string5, path2);
        } else {
            this.class.getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.super, string3);
        }
        TrashList trashList = TrashList.getInstance(path2.resolve(\u00d200000));
        int n3 = string.lastIndexOf("/");
        String string6 = string.substring(0, n3);
        String string7 = string.substring(n3 + 1);
        trashList.addEntry(new TrashListEntry(string6, string7, string5, l, System.currentTimeMillis(), l2));
        this.class.getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.super, "_trash");
        if (this.\u00d300000 != null) {
            this.\u00d300000.deleteAssetAsync(string);
        }
    }

    public String getRestorationPath(Path path, String string) throws NoSuchFileException {
        Path path2 = path.resolve(\u00d200000);
        TrashList trashList = TrashList.getInstance(path2);
        TrashListEntry trashListEntry = trashList.getEntryByHash(string);
        if (trashListEntry != null) {
            return trashListEntry.\u00d300000 + "/" + trashListEntry.\u00d600000;
        }
        throw new NoSuchFileException(string);
    }

    private void restoreDirectories(SourceConnectorReader sourceConnectorReader, Path path, String string) throws NotConfiguredException, IOException {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            this.restoreDirectories(sourceConnectorReader, path.getParent(), URL.getParentAssetURLPath(string));
        }
        Files.createDirectory(path, new FileAttribute[0]);
        if (sourceConnectorReader.getMountType().equals((Object)SourceConnectorReader.SourceConnectorType.\u00d300000)) {
            Path path2 = this.\u00f600000.getDirectoryFile(string);
            String string2 = URL.getParentAssetURLPath(string);
            Path path3 = this.\u00f600000.getDirectoryFile(string2);
            this.\u00f400000.updateEntry(path2, string, path3, string2, null, System.currentTimeMillis());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restoreFileFromTrash(Path path, String string, SourceConnectorReader sourceConnectorReader, Path path2) throws IOException, NotConfiguredException {
        Object object;
        Path path3;
        TrashList trashList = TrashList.getInstance(path.resolve(\u00d200000));
        TrashListEntry trashListEntry = trashList.getEntryByHash(string);
        if (trashListEntry == null) throw new NoSuchFileException(string);
        Path path4 = path.resolve(string + ".src");
        if (!Files.exists(path4, new LinkOption[0])) throw new NoSuchFileException(path4.toString());
        if (!Files.exists(path2.getParent(), new LinkOption[0])) {
            this.restoreDirectories(sourceConnectorReader, path2.getParent(), trashListEntry.\u00d300000);
        }
        FileOperations.move(path4, path2);
        Path path5 = path.resolve(string + ".eis");
        String string2 = trashListEntry.\u00d300000 + "/" + trashListEntry.\u00d600000;
        byte by = 0;
        if (Files.exists(path5, new LinkOption[0])) {
            if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d300000) {
                path3 = this.\u00f600000.getEisFile(string2);
                boolean bl = this.class.getStorageManager().moveExternalFileToStorage(path5, string2, path3);
                by = bl ? (byte)1 : 2;
            } else {
                Files.delete(path5);
            }
        }
        if (Files.exists(path3 = path.resolve(string + ".meta"), new LinkOption[0])) {
            Path path6 = this.class.getMetaDataLocation();
            object = path6.resolve(string2 + ".meta");
            FileOperations.move(path3, (Path)object);
        }
        trashList.removeEntry(string);
        if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d300000) {
            Path path7 = this.\u00f600000.getDirectoryFile(trashListEntry.\u00d300000);
            object = new PoolFileEntry(trashListEntry.\u00d600000, trashListEntry.super, trashListEntry.\u00d400000, -1, -1, by);
            String string3 = URL.getParentAssetURLPath(trashListEntry.\u00d300000);
            Path path8 = this.\u00f600000.getDirectoryFile(string3);
            this.\u00f400000.updateEntry(path7, trashListEntry.\u00d300000, path8, string3, (PoolEntry)object, trashListEntry.super);
            this.class.getScannerDaemon().getMetaDataAndUpdateSearchDatabase(string3, false);
        }
        this.class.getScannerDaemon().getMetaDataAndUpdateSearchDatabase(string2, false);
    }

    private void moveCustomMetadataToTrash(String string, String string2, Path path) throws IOException {
        Path path2 = this.class.getMetaDataLocation();
        Path path3 = path2.resolve(string + ".meta");
        if (Files.exists(path3, new LinkOption[0])) {
            Path path4 = path.resolve(string2 + ".meta");
            FileOperations.move(path3, path4);
        }
    }

    private void moveStorageContentToTrash(Path path, String string, String string2, Path path2) throws NotConfiguredException, IOException {
        Path path3 = this.\u00f600000.getEisFile(string);
        Path path4 = path.resolve(string2 + ".eis");
        this.class.getStorageManager().moveStorageFileToTrash(path3, string, path4);
    }

    private void removeDirListFileEntryV1002(String string, String string2, long l) throws NotConfiguredException {
        Path path = this.\u00f600000.getDirectoryFile(string);
        String string3 = URL.getParentAssetURLPath(string);
        Path path2 = this.\u00f600000.getDirectoryFile(string3);
        this.\u00f400000.removeEntry(path, string, path2, string3, string2, l);
    }

    private Pair<SourceConnectorReader, String> expandPath(String string) {
        String string2;
        int n;
        Pair<SourceConnectorReader, String> pair = null;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n = string.indexOf(47)) > 0 && this.super.containsKey(string2 = string.substring(0, n))) {
            String string3 = string.substring(string2.length());
            SourceConnectorReader sourceConnectorReader = this.super.get(string2);
            if (sourceConnectorReader != null) {
                pair = new Pair<SourceConnectorReader, String>(sourceConnectorReader, string3);
            }
        }
        return pair;
    }

    public void halt() {
        this.\u00d600000 = false;
        this.interrupt();
    }
}

