/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.concurrent.PriorityThreadFactory;
import com.neptunelabs.fsiserver.framework.helpers.ExecutorPool;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.area.scale.UniScaler;
import com.neptunelabs.fsiserver.imagemanipulator.encoder.jpeg.JPEGPreparation;
import com.neptunelabs.fsiserver.imagereader.ImageFormat;
import com.neptunelabs.fsiserver.imagereader.converter.FastMath;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageUnlimited;
import com.neptunelabs.fsiserver.imagereader.metareader.FSIMetaData;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.BasicImageMetaData;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.StorageDataProvider;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.RawDataWriterResult;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TagInfo;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TileEncoder;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TileEncoderResult;
import com.neptunelabs.fsiserver.sourcemanager.storage.utils.TileCompression;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.histogram.HistogramUtils;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class EISImageWriter
extends StorageDataProvider {
    private final FSILogger \u00d5\u00d20000;
    private final StorageLogger \u00d8O0000;
    private final UniScaler Stringsuper;
    private final TileCompression \u00d5o0000;
    private final int oo0000;
    private final SourceConnectorReader.LevelQuality \u00d3\u00d20000;
    private final JPEGPreparation \u00f5o0000;
    private final int thissuper;
    private final ByteOrder newnew = ByteOrder.LITTLE_ENDIAN;
    private byte O\u00d20000 = (byte)-1;
    private int \u00d3o0000 = 0;
    private int \u00d3O0000 = 0;
    private FSIMetaData \u00f8o0000 = null;
    private FSIImage forsuper = null;
    private FSIImage \u00f8O0000 = null;
    private FSIImage \u00d8o0000 = null;
    private int \u00d4O0000 = 0;
    private Level[] \u00d4\u00d20000;
    private List<Pair<Integer, Integer>> Oo0000;
    private boolean o\u00d20000 = false;
    private AtomicBoolean \u00f4o0000 = new AtomicBoolean(false);
    private boolean privatesuper = false;
    private ImageFormat \u00f5O0000 = null;
    private int \u00d4o0000 = 1;
    private _o nullsuper;
    private short \u00d5O0000 = 0;
    private boolean \u00f4O0000 = false;
    private final boolean while = true;

    public EISImageWriter(FSILogger fSILogger, StorageLogger storageLogger, TileCompression tileCompression, int n, SourceConnectorReader.LevelQuality levelQuality, JPEGPreparation jPEGPreparation, int n2) {
        this.\u00d5\u00d20000 = fSILogger;
        this.\u00d8O0000 = storageLogger;
        this.\u00d5o0000 = tileCompression;
        this.oo0000 = n;
        this.\u00d3\u00d20000 = levelQuality;
        this.thissuper = n2;
        this.\u00f5o0000 = jPEGPreparation;
        this.nullsuper = _o.\u00d300000;
        this.Stringsuper = new UniScaler(fSILogger);
    }

    public EISImageWriter(SourceManagerSettings sourceManagerSettings, short s, int n) {
        this(sourceManagerSettings.getLogger(), sourceManagerSettings.getStorageManager().getStorageLogger(), null, 0, null, null, n);
        this.\u00d5O0000 = s;
        this.nullsuper = _o.super;
    }

    @Override
    public boolean useTemporaryFile() {
        return true;
    }

    public void setJobType(ImageFormat imageFormat) {
        this.\u00f5O0000 = imageFormat;
    }

    public void setSrcImageCount(int n) {
        this.\u00d4o0000 = n;
    }

    public void setMetaData(FSIMetaData fSIMetaData) {
        this.\u00f8o0000 = fSIMetaData;
    }

    public void setImage(FSIImage fSIImage, FSIMetaData fSIMetaData) {
        this.forsuper = fSIImage;
        this.\u00f8o0000 = fSIMetaData;
        this.\u00d3o0000 = fSIImage.getWidth();
        this.\u00d3O0000 = fSIImage.getHeight();
        switch (fSIImage.getMode()) {
            case o00000: {
                this.O\u00d20000 = 1;
                break;
            }
            case \u00d200000: {
                this.O\u00d20000 = (byte)2;
                break;
            }
            case \u00d400000: {
                this.O\u00d20000 = (byte)3;
                break;
            }
            case \u00d500000: {
                this.O\u00d20000 = (byte)4;
            }
        }
        if (this.\u00d3\u00d20000 == SourceConnectorReader.LevelQuality.\u00d200000) {
            this.\u00d4\u00d20000 = EISImageWriter.calculateZoomLevels(this.\u00d3o0000, this.\u00d3O0000, 32, 0.6666666666666666, this.oo0000);
            this.\u00f4O0000 = false;
        } else if (this.\u00d3\u00d20000 == SourceConnectorReader.LevelQuality.\u00d400000) {
            this.\u00d4\u00d20000 = EISImageWriter.calculateZoomLevels(this.\u00d3o0000, this.\u00d3O0000, 32, 0.5, this.oo0000);
            this.\u00f4O0000 = false;
        } else if (this.\u00d3\u00d20000 == SourceConnectorReader.LevelQuality.super) {
            this.\u00d4\u00d20000 = EISImageWriter.calculateZoomLevels(this.\u00d3o0000, this.\u00d3O0000, 32, 0.6666666666666666, this.oo0000);
            this.\u00f4O0000 = true;
        }
        this.Oo0000 = EISImageWriter.calculateTilesForZoomLevels(this.\u00d4\u00d20000);
    }

    private int[] numberOfTilesPerZoomLevel() {
        int[] nArray = new int[this.\u00d4\u00d20000.length];
        for (int i = 0; i < this.\u00d4\u00d20000.length; ++i) {
            Pair<Integer, Integer> pair = this.Oo0000.get(i);
            nArray[i] = pair.getItem1() * pair.getItem2();
        }
        return nArray;
    }

    private _Oo writeImageTiles(FSIImage fSIImage, int n, SeekableByteChannel seekableByteChannel) throws IOException, ProcessingException, InterruptedException {
        boolean bl = true;
        _Oo _Oo2 = new _Oo();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = fSIImage.getWidth();
        int n3 = fSIImage.getHeight();
        int n4 = 0;
        int n5 = FastMath.ceil((double)n2 / (double)this.oo0000);
        int n6 = FastMath.ceil((double)n3 / (double)this.oo0000);
        _Oo2.\u00d300000 = new Pair[n5][n6];
        block5: for (int i = 0; i < n6 && !this.\u00f4o0000.get(); ++i) {
            Object cancellationException;
            long l4 = System.currentTimeMillis();
            TileEncoderResult[] tileEncoderResultArray = new TileEncoderResult[n5];
            PriorityThreadFactory priorityThreadFactory = new PriorityThreadFactory("EIS Image Writer", false, 1);
            ExecutorService executorService = Executors.newFixedThreadPool(n5, priorityThreadFactory);
            ArrayList arrayList = new ArrayList();
            for (int j = 0; j < n5 && !this.\u00f4o0000.get(); ++j) {
                TileEncoder tileEncoder = new TileEncoder(this.\u00d5\u00d20000, fSIImage, this.newnew, j * this.oo0000, i * this.oo0000, n, j, i, this.oo0000, this.\u00d5o0000, this.\u00f5o0000);
                arrayList.add(CompletableFuture.supplyAsync(tileEncoder, executorService));
            }
            executorService.shutdown();
            executorService.awaitTermination(60L, TimeUnit.SECONDS);
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(arrayList.toArray(new CompletableFuture[arrayList.size()]));
            bl = completableFuture.isDone();
            if (bl) {
                for (CompletableFuture runtimeException : arrayList) {
                    try {
                        cancellationException = (TileEncoderResult)runtimeException.get();
                        tileEncoderResultArray[((TileEncoderResult)cancellationException).String] = cancellationException;
                    }
                    catch (ExecutionException executionException) {
                        throw new ProcessingException(executionException.getCause());
                    }
                    catch (CancellationException cancellationException2) {
                        break;
                    }
                }
            } else {
                throw new IOException("Exception saving image tiles.");
            }
            l += System.currentTimeMillis() - l4;
            for (int j = 0; j < n5; ++j) {
                try {
                    TileEncoderResult tileEncoderResult = tileEncoderResultArray[j];
                    if (tileEncoderResult == null) continue;
                    boolean bl2 = bl = bl && tileEncoderResult.\u00d600000;
                    if (!bl) continue block5;
                    cancellationException = new RawDataWriterResult();
                    long l5 = System.currentTimeMillis();
                    ((RawDataWriterResult)cancellationException).\u00d400000 = System.currentTimeMillis() - l5;
                    long l6 = System.currentTimeMillis();
                    ((RawDataWriterResult)cancellationException).class = this.skipToAlignedStartingPosition(seekableByteChannel);
                    seekableByteChannel.write(ByteBuffer.wrap(tileEncoderResult.o00000));
                    long l7 = System.currentTimeMillis();
                    ((RawDataWriterResult)cancellationException).\u00d200000 = (int)(seekableByteChannel.position() - ((RawDataWriterResult)cancellationException).class);
                    ((RawDataWriterResult)cancellationException).\u00d300000 = l7 - l6;
                    _Oo2.\u00d300000[tileEncoderResult.String][tileEncoderResult.\u00d300000] = new Pair<Long, Long>(((RawDataWriterResult)cancellationException).class, ((RawDataWriterResult)cancellationException).\u00d200000);
                    l3 += ((RawDataWriterResult)cancellationException).\u00d300000;
                    l2 += ((RawDataWriterResult)cancellationException).\u00d400000;
                    ++n4;
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    throw new ProcessingException(runtimeException);
                }
            }
        }
        if (!bl && !this.\u00f4o0000.get()) {
            throw new IOException("Exception saving image tiles.");
        }
        _Oo2.\u00d200000 = n4;
        _Oo2.super = (int)l;
        _Oo2.\u00d400000 = (int)l3;
        _Oo2.class = (int)l2;
        return _Oo2;
    }

    private long skipToAlignedStartingPosition(SeekableByteChannel seekableByteChannel) throws IOException {
        long l = seekableByteChannel.position();
        long l2 = 8L - (l & 7L) & 7L;
        if (l2 == 0L) {
            return l;
        }
        seekableByteChannel.position(l + l2);
        return l + l2;
    }

    private static Level[] calculateZoomLevels(int n, int n2, int n3, double d, int n4) {
        ArrayList<Pair<Integer, Integer>> arrayList = new ArrayList<Pair<Integer, Integer>>();
        int n5 = n;
        int n6 = n2;
        arrayList.add(new Pair<Integer, Integer>(n5, n6));
        double d2 = 1.0;
        while (n5 > n3 && n6 > n3 && n5 > 1 && n6 > 1) {
            double d3 = Math.pow(d, d2);
            n5 = FastMath.ceil((double)n * d3);
            n6 = FastMath.ceil((double)n2 * d3);
            arrayList.add(new Pair<Integer, Integer>(n5, n6));
            d2 += 1.0;
        }
        Level[] levelArray = new Level[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            Pair pair = (Pair)arrayList.get(i);
            levelArray[i] = new Level(i);
            levelArray[i].\u00d400000 = (Integer)pair.getItem1();
            levelArray[i].o00000 = (Integer)pair.getItem2();
            levelArray[i].Object = n4;
            levelArray[i].\u00d200000 = n4;
        }
        return levelArray;
    }

    private static List<Pair<Integer, Integer>> calculateTilesForZoomLevels(Level[] levelArray) {
        ArrayList<Pair<Integer, Integer>> arrayList = new ArrayList<Pair<Integer, Integer>>(levelArray.length);
        for (Level level : levelArray) {
            int n = FastMath.ceil((double)level.\u00d400000 / (double)level.Object);
            int n2 = FastMath.ceil((double)level.o00000 / (double)level.\u00d200000);
            arrayList.add(new Pair<Integer, Integer>(n, n2));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveMetaDataOnlyEISFile() throws IOException, ProcessingException {
        boolean bl = false;
        try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(this.o00000, EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE), new FileAttribute[0]);){
            Object object;
            long l;
            long l2;
            boolean bl2 = true;
            ByteBuffer byteBuffer = this.generateHeader(1);
            this.writeRawDataToChannel(seekableByteChannel, byteBuffer, false);
            long l3 = seekableByteChannel.position();
            seekableByteChannel.position(l3 + 24L);
            String string = null;
            if (this.\u00f8o0000 != null) {
                l2 = this.\u00f8o0000.\u00d500000;
                l = this.\u00f8o0000.while;
                object = this.\u00f8o0000.getICC();
                if (object != null) {
                    string = ((ICCProfileWrap)object).getName();
                }
            } else {
                l2 = -1L;
                l = -1L;
            }
            object = new BasicImageMetaData(this.\u00f5O0000, this.\u00d3o0000, this.\u00d3O0000, l2, l, this.\u00d4o0000, string, this.\u00d5O0000, TileCompression.o00000, -1, JPEGPreparation.ChromaSubsampling.\u00d400000, SourceConnectorReader.LevelQuality.\u00d400000, 0, null);
            ByteBuffer byteBuffer2 = this.getImageMetadataByteBuffer((BasicImageMetaData)object);
            RawDataWriterResult rawDataWriterResult = this.writeRawDataToChannel(seekableByteChannel, byteBuffer2, false);
            Pair<Long, Long> pair = new Pair<Long, Long>(rawDataWriterResult.class, rawDataWriterResult.\u00d200000);
            seekableByteChannel.position(l3);
            ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(24);
            byteBuffer3.order(this.newnew);
            byteBuffer3.putLong(501L);
            byteBuffer3.putLong(pair.getItem1());
            byteBuffer3.putLong(pair.getItem2());
            byteBuffer3.rewind();
            this.writeRawDataToChannel(seekableByteChannel, byteBuffer3, false);
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            this.\u00d5\u00d20000.logException(runtimeException, 3258, this.o00000, runtimeException.getClass().getName(), runtimeException.getLocalizedMessage());
            if (runtimeException.getCause() instanceof IOException) {
                throw (ProcessingException)runtimeException.getCause();
            }
        }
        finally {
            this.\u00d8O0000.log('A', StorageLogger.LogCMD.\u00d300000, this.getAssetURLPath());
        }
        this.o\u00d20000 = true;
        return bl;
    }

    @Override
    public boolean execute() throws IOException, InterruptedException {
        boolean bl = false;
        try {
            if (this.nullsuper == _o.\u00d300000) {
                bl = this.saveEISImageFile();
            } else if (this.nullsuper == _o.super) {
                bl = this.saveMetaDataOnlyEISFile();
            }
        }
        catch (ProcessingException processingException) {
            throw new IOException(processingException);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            throw new InterruptedException();
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private boolean saveEISImageFile() throws IOException, ProcessingException, InterruptedException {
        block65: {
            var1_1 = false;
            var2_2 = 0L;
            var4_3 = 0L;
            var6_4 = 0L;
            var8_5 = 0L;
            var10_6 = 0;
            if (this.o\u00d20000) {
                return var1_1;
            }
            if (this.forsuper == null || this.forsuper.getWidth() < 1 || this.forsuper.getHeight() < 1) {
                throw new IOException("Invalid Image Data");
            }
            this.\u00d4O0000 = this.forsuper.getExtraAlphaCount();
            var11_7 = (long)this.forsuper.getWidth() * (long)this.forsuper.getHeight();
            var13_8 = System.currentTimeMillis();
            try {
                var15_9 = Files.newByteChannel(this.o00000, EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE), new FileAttribute[0]);
                var16_12 = null;
                try {
                    var17_13 = this.\u00f8o0000.getICC();
                    if (var17_13 != null) {
                        var18_17 = var17_13.getBytes();
                        var19_19 = var17_13.getName();
                    } else {
                        var18_17 = null;
                        var19_19 = null;
                    }
                    var20_20 = 0;
                    ++var20_20;
                    ++var20_20;
                    ++var20_20;
                    if (this.\u00f8o0000.getIPTC() != null) {
                        ++var20_20;
                    }
                    if (this.\u00f8o0000.getExif() != null) {
                        ++var20_20;
                    }
                    if (this.\u00f8o0000.getXMP() != null) {
                        ++var20_20;
                    }
                    if (this.\u00f8o0000.getSelections() != null) {
                        ++var20_20;
                    }
                    if (this.\u00f8o0000.getAlphaNames() != null) {
                        ++var20_20;
                    }
                    if (var18_17 != null) {
                        ++var20_20;
                    }
                    if (this.\u00f8o0000.oO0000 != null) {
                        ++var20_20;
                    }
                    var21_21 = this.generateHeader(var20_20);
                    var22_22 = this.writeRawDataToChannel(var15_9, var21_21, false);
                    var23_23 = var15_9.position();
                    var8_5 += var22_22.\u00d300000;
                    var6_4 += var22_22.\u00d400000;
                    var15_9.position(var23_23 + (long)(var20_20 * 24));
                    var25_24 = this.\u00d5o0000;
                    var26_25 = -1;
                    var27_26 = JPEGPreparation.ChromaSubsampling.\u00d400000;
                    if (this.\u00f5o0000 != null) {
                        var26_25 = (int)(this.\u00f5o0000.getQuality() * 100.0f);
                        var27_26 = this.\u00f5o0000.getChromaSubsampling();
                    }
                    var28_27 = new ArrayList<TagInfo>();
                    if (this.forsuper.getExtraAlphaCount() > 0 && this.\u00f8o0000.getAlphaTypes() == null) {
                        var29_28 = new byte[this.forsuper.getExtraAlphaCount()];
                        for (var30_29 = 0; var30_29 < this.forsuper.getExtraAlphaCount(); ++var30_29) {
                            var29_28[var30_29] = 0;
                        }
                    } else {
                        var30_30 = this.\u00f8o0000.getAlphaTypes();
                        if (var30_30 != null) {
                            var29_28 = new byte[var30_30.length];
                            for (var31_32 = 0; var31_32 < var30_30.length; ++var31_32) {
                                var29_28[var31_32] = (byte)var30_30[var31_32];
                            }
                        } else {
                            var29_28 = null;
                        }
                    }
                    var30_31 = new BasicImageMetaData(this.\u00f5O0000, this.\u00d3o0000, this.\u00d3O0000, this.\u00f8o0000.\u00d500000, this.\u00f8o0000.while, this.\u00d4o0000, var19_19, 1, var25_24, var26_25, var27_26, this.\u00d3\u00d20000, this.\u00d4O0000, var29_28);
                    var31_33 = this.getImageMetadataByteBuffer(var30_31);
                    var22_22 = this.writeRawDataToChannel(var15_9, var31_33, false);
                    var8_5 += var22_22.\u00d300000;
                    var6_4 += var22_22.\u00d400000;
                    var28_27.add(new TagInfo(501L, var22_22.class, var22_22.\u00d200000, var22_22.super));
                    var32_34 = this.calculateTileMapLength() + 4;
                    var22_22 = this.writeRawDataToChannel(var15_9, ByteBuffer.allocateDirect(var32_34), false);
                    var6_4 += var22_22.\u00d400000;
                    var28_27.add(new TagInfo(500L, var22_22.class, var22_22.\u00d200000, var22_22.super));
                    var33_35 = var22_22.class;
                    var35_36 = var22_22.\u00d200000;
                    var37_37 = this.\u00f8o0000.getIPTC();
                    if (var37_37 != null) {
                        var22_22 = this.writeRawDataToChannel(var15_9, var37_37, true);
                        var8_5 += var22_22.\u00d300000;
                        var6_4 += var22_22.\u00d400000;
                        var28_27.add(new TagInfo(503L, var22_22.class, var22_22.\u00d200000, var22_22.super));
                    }
                    if ((var38_38 = this.\u00f8o0000.getExif()) != null) {
                        var22_22 = this.writeRawDataToChannel(var15_9, var38_38, true);
                        var8_5 += var22_22.\u00d300000;
                        var6_4 += var22_22.\u00d400000;
                        var28_27.add(new TagInfo(504L, var22_22.class, var22_22.\u00d200000, var22_22.super));
                    }
                    if ((var39_39 = this.\u00f8o0000.getXMP()) != null) {
                        var22_22 = this.writeRawDataToChannel(var15_9, var39_39, true);
                        var8_5 += var22_22.\u00d300000;
                        var6_4 += var22_22.\u00d400000;
                        var28_27.add(new TagInfo(505L, var22_22.class, var22_22.\u00d200000, var22_22.super));
                    }
                    if ((var40_40 = this.\u00f8o0000.getSelections()) != null) {
                        var22_22 = this.writeRawDataToChannel(var15_9, var40_40, true);
                        var8_5 += var22_22.\u00d300000;
                        var6_4 += var22_22.\u00d400000;
                        var28_27.add(new TagInfo(520L, var22_22.class, var22_22.\u00d200000, var22_22.super));
                    }
                    if ((var41_41 = this.\u00f8o0000.getAlphaNames()) != null) {
                        var22_22 = this.writeRawDataToChannel(var15_9, var41_41, true);
                        var8_5 += var22_22.\u00d300000;
                        var6_4 += var22_22.\u00d400000;
                        var28_27.add(new TagInfo(521L, var22_22.class, var22_22.\u00d200000, var22_22.super));
                    }
                    if (var18_17 != null) {
                        var22_22 = this.writeRawDataToChannel(var15_9, var18_17, true);
                        var8_5 += var22_22.\u00d300000;
                        var6_4 += var22_22.\u00d400000;
                        var28_27.add(new TagInfo(506L, var22_22.class, var22_22.\u00d200000, var22_22.super));
                    }
                    if (this.\u00f8o0000.oO0000 != null) {
                        var22_22 = this.writeRawDataToChannel(var15_9, HistogramUtils.writeHistogramToByteBuffer(this.\u00f8o0000.oO0000, this.newnew), true);
                        var8_5 += var22_22.\u00d300000;
                        var6_4 += var22_22.\u00d400000;
                        var28_27.add(new TagInfo(507L, var22_22.class, var22_22.\u00d200000, var22_22.super));
                    }
                    var22_22 = this.writeRawDataToChannel(var15_9, ByteBuffer.allocate(0), true);
                    var6_4 += var22_22.\u00d400000;
                    var28_27.add(new TagInfo(510L, -1L, 0L, false));
                    var42_42 = this.\u00f4O0000 != false;
                    var43_43 = new ArrayList<_Oo>();
                    for (var44_44 = 0; var44_44 < this.\u00d4\u00d20000.length; ++var44_44) {
                        var45_46 = this.\u00d4\u00d20000[var44_44].\u00d400000;
                        var46_48 = this.\u00d4\u00d20000[var44_44].o00000;
                        var47_51 = false;
                        if (var45_46 == this.\u00d3o0000) ** GOTO lbl167
                        var48_55 = this.forsuper instanceof FSIImageUnlimited != false ? ExecutorPool.getMaxIOThreads() : ExecutorPool.getMaxCPUThreads();
                        var49_58 = System.currentTimeMillis();
                        this.\u00d8o0000 = this.Stringsuper.transform(var48_55, UniScaler.Interpolation.o00000, 3.0, this.forsuper, var45_46, var46_48, 0.0, 0.0, 0.0, 0.0, var42_42);
                        var2_2 += System.currentTimeMillis() - var49_58;
                        if (this.\u00d8o0000 != null) {
                            if (this.\u00f4O0000) {
                                var47_51 = true;
                                var42_42 = true;
                            } else if ((var45_46 > 1500 || var46_48 > 1500) && this.\u00f8O0000 == null) {
                                if (this.forsuper != null && !this.forsuper.isDisposed()) {
                                    this.forsuper.dispose();
                                }
                                this.forsuper = this.\u00d8o0000;
                                var47_51 = false;
                            } else if (this.\u00f8O0000 == null) {
                                this.forsuper = this.\u00f8O0000 = this.\u00d8o0000.createCopy();
                                var47_51 = true;
                                var42_42 = true;
                            } else {
                                this.forsuper = this.\u00f8O0000;
                                var47_51 = true;
                                var42_42 = true;
                            }
                        } else {
                            this.privatesuper = true;
                            if (this.forsuper == null) break;
                            this.forsuper.dispose();
                            break;
lbl167:
                            // 1 sources

                            var47_51 = false;
                            var42_42 = this.\u00f4O0000 != false;
                            this.\u00d8o0000 = this.forsuper;
                        }
                        if (!this.\u00f4o0000.get() && this.\u00d8o0000 != null) {
                            var48_56 = null;
                            try {
                                var48_56 = this.writeImageTiles(this.\u00d8o0000, var44_44, var15_9);
                                if (var48_56 != null) {
                                    var43_43.add(var48_56);
                                    var10_6 += var48_56.\u00d200000;
                                    var4_3 += (long)var48_56.super;
                                    var6_4 += (long)var48_56.class;
                                    var8_5 += (long)var48_56.\u00d400000;
                                }
                            }
                            catch (ClosedByInterruptException var49_59) {
                                throw new ClosedByInterruptException();
                            }
                            catch (IOException var49_60) {
                                throw new IOException(var49_60);
                            }
                            finally {
                                if (var47_51) {
                                    this.\u00d8o0000.dispose();
                                }
                            }
                        }
                        if (this.\u00f4o0000.get()) break;
                    }
                    this.disposeAll();
                    if (!this.privatesuper && !this.\u00f4o0000.get()) {
                        var44_45 = ByteBuffer.allocateDirect(var20_20 * 24);
                        var44_45.order(this.newnew);
                        for (TagInfo var46_49 : var28_27) {
                            var47_53 = var46_49.Object != false ? var46_49.\u00d200000 | 4096L : var46_49.\u00d200000;
                            var44_45.putLong(var47_53);
                            var44_45.putLong(var46_49.o00000);
                            var44_45.putLong(var46_49.\u00d400000);
                        }
                        var44_45.rewind();
                        var15_9.position(var23_23);
                        var45_47 = this.writeRawDataToChannel(var15_9, var44_45, false);
                        var6_4 += var45_47.\u00d400000;
                        var8_5 += var45_47.\u00d300000;
                        var46_50 = ByteBuffer.allocateDirect((int)var35_36);
                        var46_50.order(this.newnew);
                        var46_50.putInt(this.\u00d4\u00d20000.length);
                        for (var47_52 = 0; var47_52 < this.\u00d4\u00d20000.length; ++var47_52) {
                            var48_57 = (_Oo)var43_43.get(var47_52);
                            var49_61 = var48_57.\u00d300000;
                            var50_64 = this.Oo0000.get(var47_52).getItem1();
                            var51_63 = this.Oo0000.get(var47_52).getItem2();
                            var46_50.putInt(var50_64);
                            var46_50.putInt(var51_63);
                            for (var52_65 = 0; var52_65 < var51_63; ++var52_65) {
                                for (var53_66 = 0; var53_66 < var50_64; ++var53_66) {
                                    var54_67 = var49_61[var53_66][var52_65];
                                    var46_50.putLong(var54_67.getItem1());
                                    var46_50.putLong(var54_67.getItem2());
                                }
                            }
                        }
                        var46_50.rewind();
                        var15_9.position(var33_35);
                        var47_54 = this.writeRawDataToChannel(var15_9, var46_50, false);
                        var6_4 += var47_54.\u00d400000;
                        var8_5 += var47_54.\u00d300000;
                    }
                    var1_1 = true;
                }
                catch (Throwable var17_15) {
                    var16_12 = var17_15;
                    throw var17_15;
                }
                finally {
                    if (var15_9 != null) {
                        if (var16_12 != null) {
                            try {
                                var15_9.close();
                            }
                            catch (Throwable var17_14) {
                                var16_12.addSuppressed(var17_14);
                            }
                        } else {
                            var15_9.close();
                        }
                    }
                }
            }
            catch (RuntimeException var15_10) {
                this.\u00f4o0000.set(true);
                if (!(var15_10.getCause() instanceof IOException)) break block65;
                throw (ProcessingException)var15_10.getCause();
            }
        }
        if (this.\u00d5\u00d20000.isTraceEnabled()) {
            var15_11 = System.currentTimeMillis() - var13_8;
            var17_16 = this.forsuper != null ? (float)var11_7 / 1000000.0f / ((float)var15_11 / 1000.0f) : -1.0f;
            var18_18 = var15_11 - var2_2 - var8_5 - var4_3 - var6_4;
            this.\u00d5\u00d20000.log(3147, new Object[]{this.\u00f8o0000.o00000, var15_11, Float.valueOf(var17_16), var2_2, var4_3, var8_5, var6_4, var18_18, var10_6});
        }
        this.o\u00d20000 = true;
        return var1_1;
    }

    private RawDataWriterResult writeRawDataToChannel(SeekableByteChannel seekableByteChannel, ByteBuffer byteBuffer, boolean bl) throws ProcessingException {
        RawDataWriterResult rawDataWriterResult = null;
        if (byteBuffer != null && byteBuffer.capacity() > 0) {
            ByteBuffer byteBuffer2;
            boolean bl2 = false;
            if (bl && byteBuffer.capacity() > 128) {
                ByteBuffer byteBuffer3 = EISImageWriter.compressByteBuffer(byteBuffer);
                float f = (float)byteBuffer.capacity() / (float)byteBuffer3.capacity();
                if ((double)f > 1.1) {
                    byteBuffer2 = byteBuffer3;
                    bl2 = true;
                } else {
                    byteBuffer2 = byteBuffer;
                }
                byteBuffer2.rewind();
            } else {
                byteBuffer2 = byteBuffer;
            }
            try {
                long l;
                rawDataWriterResult = new RawDataWriterResult();
                long l2 = seekableByteChannel.position();
                long l3 = 8L - (l2 & 7L) & 7L;
                if (l3 == 0L) {
                    l = l2;
                } else {
                    seekableByteChannel.position(l2 + l3);
                    l = l2 + l3;
                }
                rawDataWriterResult.class = l;
                seekableByteChannel.write(byteBuffer2);
                rawDataWriterResult.\u00d200000 = (int)(seekableByteChannel.position() - rawDataWriterResult.class);
                rawDataWriterResult.\u00d300000 = 0L;
            }
            catch (IOException iOException) {
                throw new ProcessingException(iOException);
            }
            rawDataWriterResult.super = bl2;
        } else {
            rawDataWriterResult = new RawDataWriterResult();
        }
        return rawDataWriterResult;
    }

    private RawDataWriterResult writeRawDataToChannel(SeekableByteChannel seekableByteChannel, ByteArrayWalker byteArrayWalker, boolean bl) throws ProcessingException {
        return this.writeRawDataToChannel(seekableByteChannel, byteArrayWalker.array(), bl);
    }

    private RawDataWriterResult writeRawDataToChannel(SeekableByteChannel seekableByteChannel, byte[] byArray, boolean bl) throws ProcessingException {
        return this.writeRawDataToChannel(seekableByteChannel, ByteBuffer.wrap(byArray), bl);
    }

    /*
     * Exception decompiling
     */
    private ByteBuffer getImageMetadataByteBuffer(BasicImageMetaData var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ByteBuffer generateHeader(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.put(EISEnvironment.\u00d400000);
        if (this.newnew == ByteOrder.LITTLE_ENDIAN) {
            byteBuffer.put((byte)126);
        } else {
            byteBuffer.put((byte)-66);
        }
        byteBuffer.order(this.newnew);
        byteBuffer.put((byte)0);
        byteBuffer.putShort((short)3);
        byteBuffer.putInt(n);
        byteBuffer.rewind();
        return byteBuffer;
    }

    private int calculateTileMapLength() {
        int n = 8;
        if (this.\u00d3o0000 > 0 && this.\u00d3O0000 > 0) {
            int[] nArray = this.numberOfTilesPerZoomLevel();
            int n2 = 0;
            for (int n3 : nArray) {
                int n4 = 8 + n3 * 16;
                n2 += n4;
            }
            n += 1 * n2;
        }
        return n;
    }

    private void disposeAll() {
        if (this.\u00f8O0000 != null && !this.\u00f8O0000.isDisposed()) {
            this.\u00f8O0000.dispose();
        }
        if (this.forsuper != null && !this.forsuper.isDisposed()) {
            this.forsuper.dispose();
        }
        if (this.\u00d8o0000 != null && !this.\u00d8o0000.isDisposed()) {
            this.\u00d8o0000.dispose();
        }
    }

    public void dispose() {
        if (this.forsuper != null) {
            this.forsuper.dispose();
        }
    }

    public void cancel() {
        this.\u00f4o0000.set(true);
    }

    /*
     * Exception decompiling
     */
    private static byte[] compressBytes(byte[] var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ByteBuffer compressByteBuffer(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.position(0);
        byteBuffer.get(byArray);
        byArray = EISImageWriter.compressBytes(byArray);
        return ByteBuffer.wrap(byArray);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class _Oo {
        Pair<Long, Long>[][] \u00d300000;
        int \u00d200000;
        int super;
        int \u00d400000;
        int class;

        _Oo() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static enum _o {
        \u00d300000,
        super;

    }
}

