/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiserver.framework.cache.CacheManager;
import com.neptunelabs.fsiserver.framework.concurrent.Locker;
import com.neptunelabs.fsiserver.framework.concurrent.LockerReadWrite;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.A;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptReverseLookupException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainWriter;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.EISImageCopier;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.EISImageMover;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.StorageDataProvider;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.StorageLockHandler;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StorageManager {
    private final FSIServerSettings \u00d500000;
    private final StorageHelperV1002 \u00d600000;
    private final StorageLogger \u00d200000;
    private final Object String = new Object();
    private final Locker<String> null = new Locker();
    private final StorageLockHandler \u00d300000;
    private final ReentrantLock o00000 = new ReentrantLock();
    private volatile boolean \u00d800000 = true;

    public StorageManager(FSIServerSettings fSIServerSettings, Path path, CacheManager cacheManager) {
        this.\u00d500000 = fSIServerSettings;
        this.\u00d300000 = fSIServerSettings.getStorageLockHandler();
        this.\u00d600000 = fSIServerSettings.getStorageHelper();
        Path path2 = path.resolve(".log");
        this.\u00d200000 = new StorageLogger(fSIServerSettings.getLogger(), path2, 7, cacheManager);
        this.\u00d200000.start();
    }

    public static Path getChainedDestination(Path path, int n) {
        if (n <= 0) {
            return path;
        }
        String[] stringArray = FileOperations.splitFilename(path.getFileName().toString());
        String string = stringArray[0] + '.' + n + '.' + stringArray[1];
        return Paths.get(path.getParent().toString(), string);
    }

    public static Path getDestinationWithoutChainIndex(Path path) {
        Path path2 = path.getParent();
        String[] stringArray = FileOperations.splitFilename(path.getFileName().toString());
        if (stringArray == null) {
            return path;
        }
        String[] stringArray2 = FileOperations.splitFilename(stringArray[0]);
        if (stringArray2 == null) {
            return path;
        }
        String string = stringArray2[0] + "." + stringArray[1];
        return path2.resolve(string);
    }

    public static Map<Integer, String> getReverseLookupEntries(Path path) {
        Map<String, Map<Integer, String>> map;
        try {
            map = StorageManager.readRevLookupFile(path);
        }
        catch (IOException iOException) {
            map = new HashMap<String, Map<Integer, String>>(4);
        }
        return map.get(path.getFileName().toString());
    }

    private static Map<String, Map<Integer, String>> readRevLookupFile(Path path) throws CorruptReverseLookupException, IOException {
        Path path2 = StorageManager.getReverseLookupFile(path);
        return A.\u00d500000(path2);
    }

    private static String getRevLookupAssetURLPathForIndex(Path path, int n) {
        Map<Integer, String> map = StorageManager.getReverseLookupEntries(path);
        if (map != null) {
            return map.get(n);
        }
        return null;
    }

    private static Path getReverseLookupFile(Path path) {
        return Paths.get(path.getParent().toString(), ".reverseLookup");
    }

    private static void cleanStorageDir(Path path) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            int n;
            Iterator<Path> iterator = directoryStream.iterator();
            Path path2 = null;
            for (n = 0; iterator.hasNext() && n != 2; ++n) {
                path2 = iterator.next();
            }
            if (n == 1 && path2 != null && path2.getFileName().toString().equals(".reverseLookup")) {
                Files.delete(path2);
                Files.delete(path);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeStorageDataProvider(Path path, StorageDataProvider storageDataProvider) {
        String string;
        if (!this.\u00d800000) {
            return false;
        }
        Path path2 = null;
        boolean bl = false;
        if (storageDataProvider.useTemporaryFile()) {
            path2 = this.executeProviderWithTemporary(path, storageDataProvider);
        }
        if ((string = storageDataProvider.getAssetURLPath()).startsWith("/")) {
            string = string.substring(1);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        Path path3 = path.getParent();
        LockerReadWrite.Value<String> value = this.\u00d300000.writeLock(path);
        Object object = this.String;
        synchronized (object) {
            block47: {
                try {
                    this.o00000.lock();
                    try {
                        if (!storageDataProvider.useTemporaryFile()) {
                            path2 = path;
                            if (!Files.exists(path3, new LinkOption[0])) {
                                Files.createDirectories(path3, new FileAttribute[0]);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        path2 = null;
                    }
                    finally {
                        this.o00000.unlock();
                    }
                    if (path2 == null) break block47;
                    if (!storageDataProvider.useTemporaryFile()) {
                        try {
                            storageDataProvider.setDestination(path2);
                            storageDataProvider.setFinalDestination(path);
                            storageDataProvider.execute();
                            bl = true;
                        }
                        catch (InterruptedException interruptedException) {
                            bl = false;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            if (this.\u00d800000) {
                                this.\u00d500000.getLogger().logException(exception, 3228, exception.getLocalizedMessage(), storageDataProvider.getAssetURLPath(), path);
                            }
                            bl = false;
                        }
                    } else {
                        bl = true;
                    }
                    if (!bl || !storageDataProvider.useTemporaryFile()) break block47;
                    try {
                        if (!Files.exists(path, new LinkOption[0])) {
                            bl = this.addReverseLookupEntry(path, string, 0);
                            FileOperations.move(path2, path);
                            break block47;
                        }
                        if (EISChainReader.isChainFile(path)) {
                            Map<String, Integer> map = EISChainReader.readAll(path);
                            Integer n = map.get(string);
                            if (n == null) {
                                int n2 = 0;
                                for (Integer n3 : map.values()) {
                                    if (n3 <= n2) continue;
                                    n2 = n3;
                                }
                                Path object3 = StorageManager.getChainedDestination(path, ++n2);
                                FileOperations.move(path2, object3);
                                if (this.addReverseLookupEntry(path, string, n2)) {
                                    EISChainWriter eISChainWriter = new EISChainWriter(this.\u00d500000.getLogger(), path);
                                    eISChainWriter.addEntry(n2, string);
                                }
                            } else {
                                Path path5 = StorageManager.getChainedDestination(path, n);
                                FileOperations.move(path2, path5);
                            }
                            break block47;
                        }
                        int n = -1;
                        Map<Integer, String> map = StorageManager.getReverseLookupEntries(path);
                        if (map != null) {
                            for (Map.Entry entry : map.entrySet()) {
                                if (!((String)entry.getValue()).equals(string)) continue;
                                n = (Integer)entry.getKey();
                            }
                        }
                        if (n >= 0) {
                            FileOperations.move(path2, path);
                            break block47;
                        }
                        String string2 = StorageManager.getRevLookupAssetURLPathForIndex(path, 0);
                        if (string2 != null) {
                            this.removeReverseLookUpEntry(path, 0);
                            Path path4 = StorageManager.getChainedDestination(path, 1);
                            FileOperations.move(path, path4);
                            if (this.addReverseLookupEntry(path, string2, 1)) {
                                EISChainWriter eISChainWriter = new EISChainWriter(this.\u00d500000.getLogger(), path);
                                eISChainWriter.addEntry(1, string2);
                                Path path5 = StorageManager.getChainedDestination(path, 2);
                                FileOperations.move(path2, path5);
                                if (this.addReverseLookupEntry(path, string, 2)) {
                                    EISChainWriter eISChainWriter2 = new EISChainWriter(this.\u00d500000.getLogger(), path);
                                    eISChainWriter2.addEntry(2, string);
                                }
                            }
                            break block47;
                        }
                        bl = false;
                        System.err.println("Index:" + n + " " + path + " " + string);
                    }
                    catch (IOException iOException) {
                        try {
                            Files.delete(path2);
                        }
                        catch (IOException iOException2) {}
                    }
                }
                finally {
                    this.\u00d300000.unlockWrite(value);
                    if (!bl && storageDataProvider.useTemporaryFile() && path2 != null) {
                        try {
                            Files.delete(path2);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path executeProviderWithTemporary(Path path, StorageDataProvider storageDataProvider) {
        Path path2 = path.getParent();
        String string = path.getFileName().toString();
        Path path3 = null;
        try {
            Object object = this.String;
            synchronized (object) {
                if (!Files.exists(path2, new LinkOption[0])) {
                    Files.createDirectories(path2, new FileAttribute[0]);
                }
                path3 = Files.createTempFile(path2, string, ".tmp", new FileAttribute[0]);
            }
            storageDataProvider.setDestination(path3);
            storageDataProvider.setFinalDestination(path);
            storageDataProvider.execute();
        }
        catch (InterruptedException interruptedException) {
            if (path3 != null) {
                try {
                    Object object = this.String;
                    synchronized (object) {
                        Files.deleteIfExists(path3);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            path3 = null;
        }
        catch (Exception exception) {
            if (path3 != null) {
                try {
                    Object object = this.String;
                    synchronized (object) {
                        Files.deleteIfExists(path3);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.\u00d800000) {
                this.\u00d500000.getLogger().logException(exception, 3228, exception.getLocalizedMessage(), storageDataProvider.getAssetURLPath(), path);
            }
            path3 = null;
        }
        return path3;
    }

    public StorageLogger getStorageLogger() {
        return this.\u00d200000;
    }

    public void dispose() {
        this.\u00d800000 = false;
        this.\u00d200000.dispose();
    }

    public Path getRealEISImageFile(String string) throws NotConfiguredException {
        Path path = this.\u00d600000.getEisFile(string);
        int n = -1;
        Map<Integer, String> map = StorageManager.getReverseLookupEntries(path);
        if (map != null) {
            for (Map.Entry<Integer, String> entry : map.entrySet()) {
                if (!entry.getValue().equals(string)) continue;
                n = entry.getKey();
                break;
            }
        }
        if (n < 0) {
            return null;
        }
        return StorageManager.getChainedDestination(path, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveStorageFileToTrash(Path path, String string, Path path2) throws IOException {
        Object object = this.String;
        synchronized (object) {
            int n = -1;
            Locker.Value<String> value = this.null.lock(path.toString());
            try {
                block16: {
                    try {
                        n = EISChainReader.isChainFile(path) ? EISChainReader.findChainEntryNumber(path, string) : 0;
                    }
                    catch (IOException iOException) {
                        if (iOException == null || iOException.getMessage() == null || !iOException.getMessage().equals("Not a valid EIS Chain File (MSFT)")) break block16;
                        n = 0;
                    }
                }
                Path path3 = StorageManager.getChainedDestination(path, n);
                if (path2 == null) {
                    try {
                        Files.delete(path3);
                    }
                    catch (NoSuchFileException noSuchFileException) {}
                } else {
                    try {
                        FileOperations.move(path3, path2);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        // empty catch block
                    }
                }
                if (n > 0) {
                    EISChainWriter eISChainWriter = new EISChainWriter(this.\u00d500000.getLogger(), path);
                    eISChainWriter.removeEntry(string);
                }
                if (n != -1) {
                    this.removeReverseLookUpEntry(path, n);
                }
                this.\u00d200000.log('A', StorageLogger.LogCMD.\u00d300000, string);
                StorageManager.cleanStorageDir(path.getParent());
            }
            finally {
                this.null.unlock(value);
            }
        }
        return true;
    }

    public boolean removeFromStorage(Path path, String string) throws CorruptReverseLookupException, IOException {
        return this.moveStorageFileToTrash(path, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyStorageFile(String string, String string2) throws CorruptReverseLookupException, NotConfiguredException {
        boolean bl;
        if (!string.equals(string2)) {
            EISImageCopier eISImageCopier = new EISImageCopier(this.getRealEISImageFile(string));
            eISImageCopier.setAssetURLPath(string2);
            Path path = this.\u00d600000.getEisFile(string2);
            Locker.Value<String> value = this.null.lock(string);
            try {
                bl = this.executeStorageDataProvider(path, eISImageCopier);
            }
            finally {
                this.null.unlock(value);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean moveExternalFileToStorage(Path path, String string, Path path2) throws CorruptReverseLookupException {
        boolean bl;
        if (Files.exists(path, new LinkOption[0])) {
            EISImageMover eISImageMover = new EISImageMover(path);
            eISImageMover.setAssetURLPath(string);
            bl = this.executeStorageDataProvider(path2, eISImageMover);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveStorageFile(Path path, String string, Path path2, String string2) throws CorruptReverseLookupException, NotConfiguredException, IOException {
        Object object;
        Path path3 = null;
        int n = -1;
        Locker.Value<String> value = this.null.lock(path2.toString());
        try {
            block7: {
                try {
                    n = EISChainReader.findChainEntryNumber(path, string);
                    path3 = StorageManager.getChainedDestination(path, n);
                    object = new EISChainWriter(this.\u00d500000.getLogger(), path);
                    ((EISChainWriter)object).removeEntry(string);
                }
                catch (IOException iOException) {
                    if (iOException.getMessage().startsWith("Not a valid EIS Chain File")) {
                        path3 = path;
                        n = 0;
                    }
                    if (!this.\u00d800000) break block7;
                    this.\u00d500000.getLogger().logException(iOException, 3228, iOException.getLocalizedMessage(), path, path2);
                }
            }
            if (n != -1) {
                this.removeReverseLookUpEntry(path, n);
            }
        }
        finally {
            this.null.unlock(value);
        }
        object = new EISImageMover(path3);
        ((StorageDataProvider)object).setAssetURLPath(string2);
        boolean bl = this.executeStorageDataProvider(path2, (StorageDataProvider)object);
        StorageManager.cleanStorageDir(path.getParent());
        return bl;
    }

    private boolean removeReverseLookUpEntry(Path path, int n) throws CorruptReverseLookupException, IOException {
        String string;
        Path path2 = StorageManager.getReverseLookupFile(path);
        Map<String, Map<Integer, String>> map = StorageManager.readRevLookupFile(path);
        Map<Integer, String> map2 = map.get(string = path.getFileName().toString());
        if (map2 != null) {
            map2.remove(n);
            if (map2.isEmpty()) {
                map.remove(string);
            }
        }
        return A.\u00d300000(map, path2);
    }

    public boolean addReverseLookupEntry(Path path, String string, int n) throws CorruptReverseLookupException, IOException {
        Map<String, Map<Integer, String>> map;
        Path path2 = StorageManager.getReverseLookupFile(path);
        if (Files.exists(path2, new LinkOption[0])) {
            try {
                map = StorageManager.readRevLookupFile(path);
            }
            catch (IOException iOException) {
                map = new HashMap<String, Map<Integer, String>>();
            }
        } else {
            map = new HashMap<String, Map<Integer, String>>(1);
        }
        if (map.containsKey(path.getFileName().toString())) {
            map.get(path.getFileName().toString()).put(n, string);
        } else {
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>(1);
            hashMap.put(n, string);
            map.put(path.getFileName().toString(), hashMap);
        }
        return A.\u00d300000(map, path2);
    }
}

