/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.Groups;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.authentication.PropertySet;
import com.neptunelabs.fsiserver.authentication.PublishingSet;
import com.neptunelabs.fsiserver.authentication.Users;
import com.neptunelabs.fsiserver.framework.helpers.FileEventCallback;
import com.neptunelabs.fsiserver.framework.io.FileEventCursor;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.XMLOperations;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.framework.security.DigestUtils;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.small.FSIKerberosConfig;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.utils.Defines;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.yworks.util.annotation.Obfuscation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpSession;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import org.w3c.dom.Document;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class UserAuthenticationInterface {
    protected final FSIServerSettings \u00f4O0000;
    protected final StorageHelperV1002 \u00d800000;
    protected final FSILogger Oo0000;
    private final Map<String, String> class = new HashMap<String, String>();
    static final Lock \u00d200000 = new ReentrantLock();
    public final Set<Users.User> \u00f600000 = new HashSet<Users.User>();
    protected final Map<String, Group> Objectsuper = new HashMap<String, Group>();
    final Map<String, PermissionSet> \u00f400000 = new HashMap<String, PermissionSet>();
    private final Map<String, PropertySet> \u00f800000 = new HashMap<String, PropertySet>();
    private final Map<String, PublishingSet> \u00d6O0000 = new HashMap<String, PublishingSet>();
    final Map<String, PermissionSet> \u00d300000 = new HashMap<String, PermissionSet>();
    PermissionSet voidsuper = null;
    private final PropertySet OO0000 = null;
    protected Path \u00d600000;
    protected Path do;
    protected Path \u00f6O0000;
    private final List<FileEventCursor.RegisteredPath> \u00d3O0000 = new ArrayList<FileEventCursor.RegisteredPath>();
    private static final PermissionSet \u00d400000 = PermissionSet.getAllForbiddenPermissionsClone();
    private static final PermissionSet \u00d2O0000;
    private static final PermissionSet \u00d4O0000;
    private final Map<String, Map<String, PermissionSet>> interface = new HashMap<String, Map<String, PermissionSet>>();
    private final Map<String, Map<String, PropertySet>> \u00d8O0000 = new HashMap<String, Map<String, PropertySet>>();
    private final Map<String, Map<String, PublishingSet>> \u00f8O0000 = new HashMap<String, Map<String, PublishingSet>>();
    private boolean super;
    private Configuration int;

    protected UserAuthenticationInterface(FSIServerSettings fSIServerSettings) {
        this.\u00f4O0000 = fSIServerSettings;
        this.Oo0000 = fSIServerSettings.getLogger();
        this.\u00d800000 = fSIServerSettings.getStorageHelper();
        this.super = fSIServerSettings.getPrefsBoolean("application", "usekrb");
        if (this.super) {
            this.int = new FSIKerberosConfig(fSIServerSettings.getPrefsBoolean("application", "krbdebug"));
        }
    }

    protected void setupMonitoring(String string, Path[] pathArray, Path[] pathArray2) {
        FileEventCursor fileEventCursor = this.\u00f4O0000.getFileEventCursor();
        FileEventCallback fileEventCallback = new FileEventCallback(this, string, null);
        ArrayList<FileEventCallback> arrayList = new ArrayList<FileEventCallback>();
        arrayList.add(fileEventCallback);
        if (pathArray != null && pathArray.length > 0) {
            for (Path path : pathArray) {
                try {
                    this.\u00d3O0000.add(fileEventCursor.addPathMonitor(path, arrayList));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (pathArray2 != null && pathArray2.length > 0) {
            for (Path path : pathArray2) {
                try {
                    this.\u00d3O0000.add(fileEventCursor.addPathMonitor(path, null, false, arrayList));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isPasswordChangePossible() {
        return !this.super;
    }

    public abstract boolean isUserModificationPossible();

    @Obfuscation
    public void readPermissionConfig() {
        try {
            \u00d200000.lock();
            this.Oo0000.log(2047, new Object[0]);
            this.readPermissionSets();
            this.readUsers();
            this.readGroups();
            SystemMonitor systemMonitor = this.\u00f4O0000.getSystemMonitor();
            if (systemMonitor != null) {
                this.\u00f4O0000.getSystemMonitor().setGroupCount(this.getGroupCount());
            }
        }
        finally {
            \u00d200000.unlock();
        }
    }

    @Obfuscation
    public void readPropertyConfig() {
        this.readPublishingSets();
        boolean bl = this.readPropertySets();
        if (bl && this.\u00f4O0000.getStorageManager() != null) {
            this.\u00f4O0000.getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.super, "/");
        }
    }

    public PropertySet getProperties(SourceConnectorReader sourceConnectorReader, HttpSession httpSession) {
        String string;
        PropertySet propertySet = new PropertySet();
        this.mergePropertiesOverwriteIfNotProtected(propertySet, this.OO0000);
        if (httpSession != null && this.validateSession(string = (String)httpSession.getAttribute("id")) == SessionStatus.\u00d300000) {
            String string2 = this.getUser(string);
            Users.User user = this.getUserByName(string2);
            this.mergePropertiesOverwriteIfNotProtected(propertySet, this.\u00f800000.get(user.propertySet));
            PropertySet propertySet2 = new PropertySet();
            Object object = this.getGroupsForUser(string2).iterator();
            while (object.hasNext()) {
                Group group = object.next();
                propertySet2 = this.mergePropertiesEqually(propertySet2, this.\u00f800000.get(group.getPropertySet()));
            }
            this.mergePropertiesOverwriteIfNotProtected(propertySet, propertySet2);
            if (sourceConnectorReader != null && (object = this.\u00d8O0000.get(string2)) != null) {
                this.mergePropertiesOverwriteIfNotProtected(propertySet, (PropertySet)object.get(sourceConnectorReader.getPrefix()));
            }
        }
        return propertySet;
    }

    public Map<String, PublishingSet> getUserPublishingSets(HttpSession httpSession) {
        String string = this.getUser((String)httpSession.getAttribute("id"));
        return this.\u00f8O0000.get(string);
    }

    public List<PublishingSet> getAllUserPublishingSets() {
        ArrayList<PublishingSet> arrayList = new ArrayList<PublishingSet>();
        for (Map<String, PublishingSet> map : this.\u00f8O0000.values()) {
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    public PermissionSet getPermissions(String string, HttpSession httpSession, boolean bl) throws NotConfiguredException {
        if (string.equals("_trash")) {
            if (httpSession != null) {
                return \u00d400000;
            }
            return PermissionSet.getAllForbiddenPermissionSet();
        }
        if (string.equals("_downloads")) {
            if (httpSession != null) {
                return \u00d2O0000;
            }
            return PermissionSet.getAllForbiddenPermissionSet();
        }
        if (string.startsWith("_configs") || string.startsWith("_viewers")) {
            return \u00d4O0000;
        }
        SourceConnectorReader sourceConnectorReader = this.\u00f4O0000.getSourceConnectorFromAssetURLPath(string, httpSession);
        return this.getPermissions(sourceConnectorReader, httpSession, bl);
    }

    public PermissionSet getPermissions(SourceConnectorReader sourceConnectorReader, HttpSession httpSession, boolean bl) {
        Object object;
        Object object2;
        PermissionSet permissionSet = new PermissionSet();
        this.mergePermissionsIfNotSet(permissionSet, this.voidsuper);
        if (httpSession != null && this.validateSession((String)(object2 = (String)httpSession.getAttribute("id"))) == SessionStatus.\u00d300000) {
            object = this.getUser((String)object2);
            Users.User user = this.getUserByName((String)object);
            this.mergePermissionsIfNotSet(permissionSet, this.\u00f400000.get(user.permissionSet));
            PermissionSet object3 = new PermissionSet();
            for (Group group : this.getGroupsForUser((String)object)) {
                this.mergePermissionsIfTrue(object3, this.\u00f400000.get(group.getPermissionSet()));
            }
            this.mergePermissionsIfNotSet(permissionSet, object3);
            if (sourceConnectorReader != null) {
                Map<String, PermissionSet> map = this.interface.get(object);
                if (map != null) {
                    this.mergePermissionsIfNotSet(permissionSet, (PermissionSet)map.get(sourceConnectorReader.getPrefix()));
                }
            } else {
                if (permissionSet.read.renderedImages == null) {
                    permissionSet.read.renderedImages = true;
                }
                if (permissionSet.read.basicMetadata == null) {
                    permissionSet.read.basicMetadata = true;
                }
            }
        }
        object2 = new PermissionSet();
        this.mergePermissionsIfNotSet((PermissionSet)object2, this.\u00f400000.get("public"));
        if (sourceConnectorReader != null) {
            object = null;
            for (Map.Entry entry : sourceConnectorReader.getAccessPermissions().entrySet()) {
                if (!((Group)entry.getKey()).equals(this.Objectsuper.get("public"))) continue;
                object = (PermissionSet)entry.getValue();
                break;
            }
            this.mergePermissionsIfNotSet((PermissionSet)object2, (PermissionSet)object);
        } else {
            if (permissionSet.read.renderedImages == null) {
                permissionSet.read.renderedImages = true;
            }
            if (permissionSet.read.basicMetadata == null) {
                permissionSet.read.basicMetadata = true;
            }
        }
        this.mergePermissionsIfTrue(permissionSet, (PermissionSet)object2);
        if (permissionSet.isEmpty()) {
            if (bl) {
                return PermissionSet.getAllForbiddenPermissionSet();
            }
            return null;
        }
        if (bl) {
            this.mergePermissionsIfNotSet(permissionSet, PermissionSet.getAllForbiddenPermissionSet());
        }
        return permissionSet;
    }

    private Set<Group> getGroupsForUser(String string) {
        HashSet<Group> hashSet = new HashSet<Group>();
        for (Group group : this.Objectsuper.values()) {
            if (!group.containsUser(string)) continue;
            hashSet.add(group);
        }
        return hashSet;
    }

    public Set<String> getGroupNamesForUser(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string != null) {
            for (Group group : this.Objectsuper.values()) {
                if (!group.containsUser(string)) continue;
                hashSet.add(group.getName());
            }
        }
        return hashSet;
    }

    private PropertySet mergePropertiesEqually(PropertySet propertySet, PropertySet propertySet2) {
        if (propertySet == null && propertySet2 == null) {
            return null;
        }
        if (propertySet == null) {
            return propertySet2;
        }
        if (propertySet2 == null) {
            return propertySet;
        }
        PropertySet propertySet3 = new PropertySet();
        propertySet3.general = this.mergePropertyItemListEqually(propertySet.general, propertySet2.general);
        propertySet3.custommetadatafields = this.mergePropertyItemListEqually(propertySet.custommetadatafields, propertySet2.custommetadatafields);
        propertySet3.publishingsets = this.mergePropertyItemListEqually(propertySet.publishingsets, propertySet2.publishingsets);
        propertySet3.hideApps = this.mergePropertyItemListEqually(propertySet.hideApps, propertySet2.hideApps);
        propertySet3.hidePublishingTabs = this.mergePropertyItemListEqually(propertySet.hidePublishingTabs, propertySet2.hidePublishingTabs);
        propertySet3.custom = this.mergePropertyItemListEqually(propertySet.custom, propertySet2.custom);
        return propertySet3;
    }

    private List<PropertySet.ItemType> mergePropertyItemListEqually(List<PropertySet.ItemType> list, List<PropertySet.ItemType> list2) {
        HashMap<String, PropertySet.ItemType> hashMap = new HashMap<String, PropertySet.ItemType>();
        for (PropertySet.ItemType itemType : list) {
            hashMap.put(itemType.name, itemType);
        }
        for (PropertySet.ItemType itemType : list2) {
            PropertySet.ItemType itemType2 = (PropertySet.ItemType)hashMap.get(itemType.name);
            if (itemType2 == null) {
                hashMap.put(itemType.name, itemType);
                continue;
            }
            if (itemType2.isProtected && itemType.isProtected || !itemType2.isProtected && !itemType.isProtected) {
                if (!itemType.value) continue;
                itemType2.value = true;
                continue;
            }
            if (itemType2.isProtected) continue;
            hashMap.put(itemType.name, itemType);
        }
        return new ArrayList<PropertySet.ItemType>(hashMap.values());
    }

    private void mergePropertiesOverwriteIfNotProtected(PropertySet propertySet, PropertySet propertySet2) {
        if (propertySet2 == null) {
            return;
        }
        this.mergePropertyItemListOverwriteIfNotProtected(propertySet.general, propertySet2.general);
        this.mergePropertyItemListOverwriteIfNotProtected(propertySet.custommetadatafields, propertySet2.custommetadatafields);
        this.mergePropertyItemListOverwriteIfNotProtected(propertySet.hideApps, propertySet2.hideApps);
        this.mergePropertyItemListOverwriteIfNotProtected(propertySet.hidePublishingTabs, propertySet2.hidePublishingTabs);
        this.mergePropertyItemListOverwriteIfNotProtected(propertySet.publishingsets, propertySet2.publishingsets);
        this.mergePropertyItemListOverwriteIfNotProtected(propertySet.custom, propertySet2.custom);
    }

    private void mergePropertyItemListOverwriteIfNotProtected(List<PropertySet.ItemType> list, List<PropertySet.ItemType> list2) {
        for (PropertySet.ItemType itemType : list2) {
            PropertySet.ItemType itemType2 = null;
            for (PropertySet.ItemType itemType3 : list) {
                if (!itemType3.name.equals(itemType.name)) continue;
                itemType2 = itemType3;
                break;
            }
            if (itemType2 == null) {
                list.add(itemType);
                continue;
            }
            if (itemType2.isProtected) continue;
            list.remove(itemType2);
            list.add(itemType);
        }
    }

    private void mergePermissionsIfTrue(PermissionSet permissionSet, PermissionSet permissionSet2) {
        if (permissionSet2 == null) {
            return;
        }
        if (permissionSet2.general.readLicence != null && permissionSet2.general.readLicence.booleanValue()) {
            permissionSet.general.readLicence = true;
        }
        if (permissionSet2.general.writeLicence != null && permissionSet2.general.writeLicence.booleanValue()) {
            permissionSet.general.writeLicence = true;
        }
        if (permissionSet2.general.changePassword != null && permissionSet2.general.changePassword.booleanValue()) {
            permissionSet.general.changePassword = true;
        }
        if (permissionSet2.general.writePreferences != null && permissionSet2.general.writePreferences.booleanValue()) {
            permissionSet.general.writePreferences = true;
        }
        if (permissionSet2.general.switchUser != null && permissionSet2.general.switchUser.booleanValue()) {
            permissionSet.general.switchUser = true;
        }
        if (permissionSet2.read.renderedImages != null && permissionSet2.read.renderedImages.booleanValue()) {
            permissionSet.read.renderedImages = true;
        }
        if (permissionSet2.read.basicMetadata != null && permissionSet2.read.basicMetadata.booleanValue()) {
            permissionSet.read.basicMetadata = true;
        }
        if (permissionSet2.read.extendedMetadata != null && permissionSet2.read.extendedMetadata.booleanValue()) {
            permissionSet.read.extendedMetadata = true;
        }
        if (permissionSet2.read.files != null && permissionSet2.read.files.booleanValue()) {
            permissionSet.read.files = true;
        }
        if (permissionSet2.read.downloadSource != null && permissionSet2.read.downloadSource.booleanValue()) {
            permissionSet.read.downloadSource = true;
        }
        if (permissionSet2.read.copy != null && permissionSet2.read.copy.booleanValue()) {
            permissionSet.read.copy = true;
        }
        if (permissionSet2.read.iccProfiles != null && permissionSet2.read.iccProfiles.booleanValue()) {
            permissionSet.read.iccProfiles = true;
        }
        if (permissionSet2.read.totalAssetsCount != null && permissionSet2.read.totalAssetsCount.booleanValue()) {
            permissionSet.read.totalAssetsCount = true;
        }
        if (permissionSet2.read.storageStatus != null && permissionSet2.read.storageStatus.booleanValue()) {
            permissionSet.read.storageStatus = true;
        }
        if (permissionSet2.list.files != null && permissionSet2.list.files.booleanValue()) {
            permissionSet.list.files = true;
        }
        if (permissionSet2.list.directories != null && permissionSet2.list.directories.booleanValue()) {
            permissionSet.list.directories = true;
        }
        if (permissionSet2.list.connector != null && permissionSet2.list.connector.booleanValue()) {
            permissionSet.list.connector = true;
        }
        if (permissionSet2.list.searchResults != null && permissionSet2.list.searchResults.booleanValue()) {
            permissionSet.list.searchResults = true;
        }
        if (permissionSet2.write.createDirectory != null && permissionSet2.write.createDirectory.booleanValue()) {
            permissionSet.write.createDirectory = true;
        }
        if (permissionSet2.write.upload != null && permissionSet2.write.upload.booleanValue()) {
            permissionSet.write.upload = true;
        }
        if (permissionSet2.write.paste != null && permissionSet2.write.paste.booleanValue()) {
            permissionSet.write.paste = true;
        }
        if (permissionSet2.write.delete != null && permissionSet2.write.delete.booleanValue()) {
            permissionSet.write.delete = true;
        }
        if (permissionSet2.write.moveToTrash != null && permissionSet2.write.moveToTrash.booleanValue()) {
            permissionSet.write.moveToTrash = true;
        }
        if (permissionSet2.write.rename != null && permissionSet2.write.rename.booleanValue()) {
            permissionSet.write.rename = true;
        }
        if (permissionSet2.write.overwrite != null && permissionSet2.write.overwrite.booleanValue()) {
            permissionSet.write.overwrite = true;
        }
        if (permissionSet2.write.moveWithinConnector != null && permissionSet2.write.moveWithinConnector.booleanValue()) {
            permissionSet.write.moveWithinConnector = true;
        }
        if (permissionSet2.write.extendedMetadata != null && permissionSet2.write.extendedMetadata.booleanValue()) {
            permissionSet.write.extendedMetadata = true;
        }
        if (permissionSet2.tasks.batchRendering != null && permissionSet2.tasks.batchRendering.booleanValue()) {
            permissionSet.tasks.batchRendering = true;
        }
        if (permissionSet2.tasks.createArchive != null && permissionSet2.tasks.createArchive.booleanValue()) {
            permissionSet.tasks.createArchive = true;
        }
        if (permissionSet2.tasks.reimportFiles != null && permissionSet2.tasks.reimportFiles.booleanValue()) {
            permissionSet.tasks.reimportFiles = true;
        }
    }

    private void mergePermissionsIfNotSet(PermissionSet permissionSet, PermissionSet permissionSet2) {
        if (permissionSet2 == null) {
            return;
        }
        if (permissionSet.general.readLicence == null) {
            permissionSet.general.readLicence = permissionSet2.general.readLicence;
        }
        if (permissionSet.general.writeLicence == null) {
            permissionSet.general.writeLicence = permissionSet2.general.writeLicence;
        }
        if (permissionSet.general.changePassword == null) {
            permissionSet.general.changePassword = permissionSet2.general.changePassword;
        }
        if (permissionSet.general.writePreferences == null) {
            permissionSet.general.writePreferences = permissionSet2.general.writePreferences;
        }
        if (permissionSet.general.switchUser == null) {
            permissionSet.general.switchUser = permissionSet2.general.switchUser;
        }
        if (permissionSet.read.renderedImages == null) {
            permissionSet.read.renderedImages = permissionSet2.read.renderedImages;
        }
        if (permissionSet.read.basicMetadata == null) {
            permissionSet.read.basicMetadata = permissionSet2.read.basicMetadata;
        }
        if (permissionSet.read.extendedMetadata == null) {
            permissionSet.read.extendedMetadata = permissionSet2.read.extendedMetadata;
        }
        if (permissionSet.read.files == null) {
            permissionSet.read.files = permissionSet2.read.files;
        }
        if (permissionSet.read.downloadSource == null) {
            permissionSet.read.downloadSource = permissionSet2.read.downloadSource;
        }
        if (permissionSet.read.copy == null) {
            permissionSet.read.copy = permissionSet2.read.copy;
        }
        if (permissionSet.read.iccProfiles == null) {
            permissionSet.read.iccProfiles = permissionSet2.read.iccProfiles;
        }
        if (permissionSet.read.totalAssetsCount == null) {
            permissionSet.read.totalAssetsCount = permissionSet2.read.totalAssetsCount;
        }
        if (permissionSet.read.storageStatus == null) {
            permissionSet.read.storageStatus = permissionSet2.read.storageStatus;
        }
        if (permissionSet.list.files == null) {
            permissionSet.list.files = permissionSet2.list.files;
        }
        if (permissionSet.list.directories == null) {
            permissionSet.list.directories = permissionSet2.list.directories;
        }
        if (permissionSet.list.connector == null) {
            permissionSet.list.connector = permissionSet2.list.connector;
        }
        if (permissionSet.list.searchResults == null) {
            permissionSet.list.searchResults = permissionSet2.list.searchResults;
        }
        if (permissionSet.write.createDirectory == null) {
            permissionSet.write.createDirectory = permissionSet2.write.createDirectory;
        }
        if (permissionSet.write.upload == null) {
            permissionSet.write.upload = permissionSet2.write.upload;
        }
        if (permissionSet.write.paste == null) {
            permissionSet.write.paste = permissionSet2.write.paste;
        }
        if (permissionSet.write.delete == null) {
            permissionSet.write.delete = permissionSet2.write.delete;
        }
        if (permissionSet.write.moveToTrash == null) {
            permissionSet.write.moveToTrash = permissionSet2.write.moveToTrash;
        }
        if (permissionSet.write.rename == null) {
            permissionSet.write.rename = permissionSet2.write.rename;
        }
        if (permissionSet.write.overwrite == null) {
            permissionSet.write.overwrite = permissionSet2.write.overwrite;
        }
        if (permissionSet.write.extendedMetadata == null) {
            permissionSet.write.extendedMetadata = permissionSet2.write.extendedMetadata;
        }
        if (permissionSet.write.moveWithinConnector == null) {
            permissionSet.write.moveWithinConnector = permissionSet2.write.moveWithinConnector;
        }
        if (permissionSet.tasks.batchRendering == null) {
            permissionSet.tasks.batchRendering = permissionSet2.tasks.batchRendering;
        }
        if (permissionSet.tasks.createArchive == null) {
            permissionSet.tasks.createArchive = permissionSet2.tasks.createArchive;
        }
        if (permissionSet.tasks.reimportFiles == null) {
            permissionSet.tasks.reimportFiles = permissionSet2.tasks.reimportFiles;
        }
    }

    private void dumpGroupsAndUsers() {
        System.err.println("Users/Groups setup");
        for (Map.Entry<String, Group> entry : this.Objectsuper.entrySet()) {
            System.err.println(" - " + entry.getValue().getName() + ": " + entry.getValue().getPermissionSet());
        }
    }

    protected abstract void readGroups();

    protected abstract void readUsers();

    public abstract boolean duplicateGroup(String var1, String var2);

    void readPermissionSets() {
        this.\u00f400000.clear();
        this.voidsuper = null;
        this.setupDefaultPermissionSets();
        if (!Files.exists(this.\u00d600000, new LinkOption[0])) {
            this.Oo0000.log(2078, this.\u00d600000.toFile().getAbsolutePath());
        } else {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.\u00d600000, "*.xml");){
                for (Path path : directoryStream) {
                    String string = path.getFileName().toString();
                    String string2 = string.substring(0, string.length() - 4);
                    try {
                        Document document = FileOperations.getXMLFileContent(this.Oo0000, path);
                        String string3 = XMLOperations.elementNamesToLowerCase(this.Oo0000, document);
                        PermissionSet permissionSet = XMLOperations.unmarshalJAXB(string3, PermissionSet.class);
                        permissionSet.setName(string2);
                        this.\u00d300000.put(string2, permissionSet);
                        PermissionSet permissionSet2 = permissionSet.clone();
                        permissionSet2.applyDefaults();
                        this.\u00f400000.put(string2, permissionSet2);
                        this.Oo0000.log(2077, string2);
                    }
                    catch (DataBindingException dataBindingException) {
                        this.Oo0000.log(2061, path);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                }
            }
            catch (IOException | DirectoryIteratorException exception) {
                this.Oo0000.logException(exception, 2071, this.\u00d600000.toString());
            }
        }
    }

    private boolean readPropertySets() {
        int n = this.\u00f800000.hashCode();
        this.\u00f800000.clear();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.do, "*.xml");){
            for (Path path : directoryStream) {
                String string = path.getFileName().toString();
                try {
                    String string2 = string.substring(0, string.length() - 4);
                    Document document = FileOperations.getXMLFileContent(this.Oo0000, path);
                    String string3 = XMLOperations.elementNamesToLowerCase(this.Oo0000, document);
                    PropertySet propertySet = XMLOperations.unmarshalJAXB(string3, PropertySet.class);
                    propertySet.setName(string2);
                    if (this.propertySetValid(propertySet)) {
                        this.\u00f800000.put(string2, propertySet);
                        this.Oo0000.log(2075, string2);
                        continue;
                    }
                    this.Oo0000.log(2076, string2);
                }
                catch (DataBindingException dataBindingException) {
                    this.Oo0000.log(2061, path);
                }
            }
        }
        catch (IOException | DirectoryIteratorException exception) {
            this.Oo0000.log(2072, this.do.toString());
        }
        return this.\u00f800000.hashCode() != n;
    }

    private boolean propertySetValid(PropertySet propertySet) {
        return this.itemListValid(propertySet.general) && this.itemListValid(propertySet.custommetadatafields) && this.itemListValid(propertySet.hideApps) && this.itemListValid(propertySet.hidePublishingTabs) && this.itemListValid(propertySet.publishingsets) && this.itemListValid(propertySet.custom);
    }

    private boolean itemListValid(List<PropertySet.ItemType> list) {
        boolean bl = false;
        for (PropertySet.ItemType itemType : list) {
            if (!itemType.inherit) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return true;
    }

    private void readPublishingSets() {
        this.\u00d6O0000.clear();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.\u00f6O0000, "*.{xml}");){
            for (Path path : directoryStream) {
                String string = path.getFileName().toString();
                String string2 = string.substring(0, string.length() - 4);
                try {
                    Document document = FileOperations.getXMLFileContent(this.Oo0000, path);
                    String string3 = XMLOperations.elementNamesToLowerCase(this.Oo0000, document);
                    PublishingSet publishingSet = XMLOperations.unmarshalJAXB(string3, PublishingSet.class);
                    publishingSet.setName(string2);
                    this.\u00d6O0000.put(string2, publishingSet);
                    this.Oo0000.log(2074, string2);
                }
                catch (IOException iOException) {
                    this.Oo0000.log(2061, path);
                }
            }
        }
        catch (IOException | DirectoryIteratorException exception) {
            this.Oo0000.log(2073, this.\u00f6O0000.toString());
        }
    }

    @Obfuscation
    public void updateSourceConnectorAccessRules() {
        this.readPermissionConfig();
        this.readPropertyConfig();
        if (this.\u00f4O0000 instanceof SourceManagerSettings) {
            ((SourceManagerSettings)this.\u00f4O0000).updateSourceConnectorAccessRules();
        }
    }

    private Users.User getUserByName(String string) {
        Users.User user = null;
        for (Users.User user2 : this.\u00f600000) {
            if (!user2.name.equals(string)) continue;
            user = user2;
            break;
        }
        return user;
    }

    public AuthenticationCode validateCredentials(String string, String string2, String string3) {
        if (this.\u00f600000 == null) {
            return AuthenticationCode.\u00d200000;
        }
        Users.User user = this.getUserByName(string);
        if (user == null) {
            return AuthenticationCode.\u00d300000;
        }
        if (this.super) {
            try {
                LoginContext loginContext = new LoginContext("primaryLoginContext", null, new _o(string, string2), this.int);
                loginContext.login();
                loginContext.logout();
                return AuthenticationCode.class;
            }
            catch (LoginException loginException) {
                Throwable throwable = loginException.getCause();
                if (throwable == null) {
                    this.Oo0000.log(3266, loginException.getLocalizedMessage());
                    return AuthenticationCode.\u00d200000;
                }
                if (throwable instanceof SocketTimeoutException) {
                    this.Oo0000.log(3265, throwable.getLocalizedMessage());
                    return AuthenticationCode.\u00d200000;
                }
                if (throwable instanceof Exception) {
                    this.Oo0000.log(3267, string, throwable.getLocalizedMessage());
                    return AuthenticationCode.\u00d600000;
                }
                this.Oo0000.log(3266, loginException.getLocalizedMessage());
                return AuthenticationCode.\u00d200000;
            }
        }
        if (user.hash != null && user.hash.length() > 0) {
            if (string2 != null && string2.equals(DigestUtils.sha256(string3 + user.hash, FileOperations.new))) {
                return AuthenticationCode.class;
            }
            return AuthenticationCode.super;
        }
        if (user.plain != null && user.plain.length() > 0) {
            if (string2 != null && string2.equals(DigestUtils.sha256(string3 + DigestUtils.sha256(user.plain, FileOperations.new), FileOperations.new))) {
                return AuthenticationCode.class;
            }
            return AuthenticationCode.super;
        }
        this.Oo0000.log(3268, string);
        return AuthenticationCode.super;
    }

    public boolean isKerberosAuthenticationEnabled() {
        return this.super;
    }

    public String registerSession(String string) {
        String string2 = DigestUtils.sha256(System.currentTimeMillis() + string, FileOperations.new);
        this.class.put(string2, string);
        return string2;
    }

    public void logout(String string) {
        this.class.remove(string);
    }

    public SessionStatus validateSession(String string) {
        SessionStatus sessionStatus = SessionStatus.\u00d200000;
        if (this.class.containsKey(string)) {
            sessionStatus = SessionStatus.\u00d300000;
        }
        return sessionStatus;
    }

    public String getUser(String string) {
        String string2 = null;
        if (string != null && this.class.containsKey(string)) {
            string2 = this.class.get(string);
        }
        return string2;
    }

    public boolean changeUser(String string, String string2) {
        boolean bl = false;
        if (string != null && string2 != null && this.class.containsKey(string)) {
            this.class.put(string, string2);
            bl = true;
        }
        return bl;
    }

    public Set<String> getUsers() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Users.User user : this.\u00f600000) {
            hashSet.add(user.name);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUserPassword(String string, String string2) {
        boolean bl = false;
        \u00d200000.lock();
        try {
            Users.User user = null;
            for (Users.User user2 : this.\u00f600000) {
                if (!user2.name.equals(string)) continue;
                user = user2;
                break;
            }
            if (user != null) {
                user.plain = null;
                user.hash = DigestUtils.sha256(string2, FileOperations.new);
                bl = this.saveUsers();
            }
        }
        finally {
            \u00d200000.unlock();
        }
        return bl;
    }

    public boolean setUserPasswordHash(String string, String string2) {
        boolean bl = false;
        Users.User user = null;
        for (Users.User user2 : this.\u00f600000) {
            if (!user2.name.equals(string)) continue;
            user = user2;
            break;
        }
        if (user != null) {
            user.plain = null;
            user.hash = string2;
            bl = this.saveUsers();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUser(String string, String string2) {
        boolean bl;
        \u00d200000.lock();
        try {
            boolean bl2 = false;
            for (Users.User user : this.\u00f600000) {
                if (!user.name.equals(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                this.Oo0000.log(3206, string);
                bl = false;
            } else {
                Users.User user = new Users.User();
                user.name = string;
                user.hash = DigestUtils.sha256(string2, FileOperations.new);
                this.\u00f600000.add(user);
                bl = this.saveUsers();
                this.Objectsuper.get("authenticated").getUsers().add(string);
                bl &= this.saveGroups();
            }
        }
        finally {
            \u00d200000.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteUser(String string) {
        boolean bl = false;
        \u00d200000.lock();
        try {
            Users.User user = null;
            for (Users.User user2 : this.\u00f600000) {
                if (!user2.name.equals(string)) continue;
                user = user2;
                break;
            }
            if (user != null) {
                this.\u00f600000.remove(user);
                bl = this.saveUsers();
            }
        }
        finally {
            \u00d200000.unlock();
        }
        return bl;
    }

    public boolean addGroup(String string, Set<String> set, String string2, String string3) {
        boolean bl = false;
        if (!this.Objectsuper.containsKey(string)) {
            Group group = new Group(string);
            if (string2 != null) {
                group.setPermissionSet(string2);
            }
            if (string3 != null) {
                group.setPropertySet(string3);
            }
            group.setUsers(set);
            this.Objectsuper.put(string, group);
            bl = this.saveGroups();
        }
        if (bl) {
            this.Oo0000.log(3216, string);
        } else {
            this.Oo0000.log(3217, string);
        }
        return bl;
    }

    public boolean addPropertySet(String string, PropertySet propertySet) {
        Path path = this.do.resolve(string + ".xml");
        try {
            JAXB.marshal((Object)propertySet, (File)path.toFile());
            this.\u00f800000.put(string, propertySet);
            return true;
        }
        catch (DataBindingException dataBindingException) {
            return false;
        }
    }

    public boolean addPublishingSet(String string, String string2) {
        PublishingSet publishingSet = new PublishingSet();
        publishingSet.setName(string);
        publishingSet.viewerpath = new PublishingSet.ValueType();
        publishingSet.viewerpath.value = string2;
        publishingSet.viewerpath.isProtected = false;
        return this.addPublishingSet(publishingSet);
    }

    public boolean addPublishingSet(PublishingSet publishingSet) {
        Path path = this.\u00f6O0000.resolve(publishingSet.getName() + ".xml");
        try {
            JAXB.marshal((Object)publishingSet, (File)path.toFile());
            this.\u00d6O0000.put(publishingSet.getName(), publishingSet);
            return true;
        }
        catch (DataBindingException dataBindingException) {
            return false;
        }
    }

    public boolean deleteGroup(String string) {
        boolean bl = false;
        if (this.Objectsuper.containsKey(string)) {
            this.Objectsuper.remove(string);
            bl = this.saveGroups();
        }
        return bl;
    }

    public boolean addUserGroupAssignment(String string, String string2) {
        Group group = this.Objectsuper.get(string);
        group.getUsers().add(string2);
        boolean bl = this.updateGroup(string, group);
        if (bl) {
            this.updateUserPublishingSets();
        }
        return bl;
    }

    public boolean updateGroup(String string, Group group) {
        boolean bl = false;
        if (this.Objectsuper.containsKey(string)) {
            this.Objectsuper.put(string, group);
            bl = this.saveGroups();
        }
        return bl;
    }

    public boolean removeUserGroupAssignment(String string, String string2) {
        Group group;
        boolean bl = false;
        if (this.Objectsuper.containsKey(string) && (group = this.Objectsuper.get(string)).getUsers().remove(string2)) {
            bl = this.saveGroups();
        }
        return bl;
    }

    public Map<String, Group> getGroups() {
        return this.Objectsuper;
    }

    public int getGroupCount() {
        int n = 0;
        for (Map.Entry<String, Group> entry : this.Objectsuper.entrySet()) {
            String string = entry.getValue().getName();
            boolean bl = true;
            for (String string2 : Defines.O\u00d50000) {
                if (!string.equalsIgnoreCase(string2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    public Map<String, PermissionSet> getPermissionSets() {
        return this.\u00f400000;
    }

    public Map<String, PropertySet> getPropertySets() {
        return this.\u00f800000;
    }

    public Map<String, PublishingSet> getPublishingSets() {
        return this.\u00d6O0000;
    }

    public boolean addPermissionSet(String string, PermissionSet permissionSet) {
        boolean bl = true;
        if (!this.\u00d300000.containsKey(string)) {
            this.\u00d300000.put(string, permissionSet);
            bl &= this.savePermissionSets();
        }
        try {
            PermissionSet permissionSet2 = permissionSet.clone();
            permissionSet2.applyDefaults();
            if (!this.\u00f400000.containsKey(string)) {
                this.\u00f400000.put(string, permissionSet2);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.\u00f4O0000.getCacheManager().clearAll();
        return bl;
    }

    public boolean updatePermissionSet(String string, PermissionSet permissionSet) {
        boolean bl = true;
        this.\u00d300000.put(string, permissionSet);
        bl &= this.savePermissionSets();
        try {
            PermissionSet permissionSet2 = permissionSet.clone();
            permissionSet2.applyDefaults();
            this.\u00f400000.put(string, permissionSet2);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.\u00f4O0000.getCacheManager().clearAll();
        return bl;
    }

    public boolean deletePermissionSet(String string) {
        boolean bl = false;
        if (this.\u00d300000.containsKey(string)) {
            this.\u00d300000.remove(string);
            bl = this.savePermissionSets();
        }
        if (this.\u00f400000.containsKey(string)) {
            this.\u00f400000.remove(string);
        }
        this.\u00f4O0000.getCacheManager().clearAll();
        return bl;
    }

    public boolean deletePropertySet(String string) {
        boolean bl = false;
        if (this.\u00f800000.containsKey(string)) {
            this.\u00f800000.remove(string);
            Path path = this.do.resolve(string + ".xml");
            try {
                bl = Files.deleteIfExists(path);
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean deletePublishingSet(String string) {
        boolean bl = false;
        if (this.\u00d6O0000.containsKey(string)) {
            this.\u00d6O0000.remove(string);
            Path path = this.\u00f6O0000.resolve(string + ".xml");
            try {
                bl = Files.deleteIfExists(path);
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    public Map<String, Map<String, Object>> getDetailedUserList() {
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        for (Users.User user : this.\u00f600000) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("name", user.name);
            hashMap.put(user.name, hashMap2);
        }
        return hashMap;
    }

    void setupDefaultPermissionSets() {
        PermissionSet permissionSet = new PermissionSet("public_images");
        permissionSet.read.storageStatus = true;
        permissionSet.read.renderedImages = true;
        permissionSet.read.basicMetadata = true;
        permissionSet.read.extendedMetadata = true;
        permissionSet.list.files = true;
        permissionSet.list.searchResults = true;
        this.\u00f400000.put(permissionSet.getName(), permissionSet);
        PermissionSet permissionSet2 = new PermissionSet("public_statics");
        permissionSet2.read.storageStatus = true;
        permissionSet2.read.files = true;
        permissionSet2.read.basicMetadata = true;
        permissionSet2.read.extendedMetadata = true;
        permissionSet2.list.files = true;
        permissionSet2.list.searchResults = true;
        this.\u00f400000.put(permissionSet2.getName(), permissionSet2);
        PermissionSet permissionSet3 = new PermissionSet("read_only");
        permissionSet3.setFullReadPermissionsEnabled(true);
        this.\u00f400000.put(permissionSet3.getName(), permissionSet3);
        PermissionSet permissionSet4 = new PermissionSet("read_write");
        permissionSet4.setFullReadPermissionsEnabled(true);
        permissionSet4.setFullWritePermissionsEnabled(true);
        this.\u00f400000.put(permissionSet4.getName(), permissionSet4);
        PermissionSet permissionSet5 = new PermissionSet("administrator");
        permissionSet5.general.defaultValue = true;
        permissionSet5.read.defaultValue = true;
        permissionSet5.list.defaultValue = true;
        permissionSet5.write.defaultValue = true;
        permissionSet5.tasks.defaultValue = true;
        permissionSet5.applyDefaults();
        this.\u00f400000.put(permissionSet5.getName(), permissionSet5);
    }

    void setupDefaultGroups() {
        Group group = new Group("public");
        this.Objectsuper.put("public", group);
        Group group2 = new Group("administrators");
        this.Objectsuper.put("administrators", group2);
        Group group3 = new Group("authenticated");
        HashSet<String> hashSet = new HashSet<String>();
        for (Users.User user : this.\u00f600000) {
            hashSet.add(user.name);
        }
        group3.setUsers(hashSet);
        this.Objectsuper.put("authenticated", group3);
    }

    protected abstract boolean saveUsers();

    protected abstract boolean saveGroups();

    protected abstract boolean savePermissionSets();

    @Obfuscation
    public void updateSourceConnectors(Map<String, SourceConnectorReader> map) {
        Object object;
        this.interface.clear();
        this.\u00d8O0000.clear();
        for (Users.User object2 : this.\u00f600000) {
            HashMap hashMap = new HashMap();
            object = new HashMap();
            for (SourceConnectorReader sourceConnectorReader : map.values()) {
                Map.Entry<Group, PermissionSet> entry2;
                Map<Group, PermissionSet> map2 = sourceConnectorReader.getAccessPermissions();
                for (Map.Entry<Group, PermissionSet> entry2 : map2.entrySet()) {
                    if (!entry2.getKey().containsUser(object2.name)) continue;
                    hashMap.put(sourceConnectorReader.getPrefix(), entry2.getValue());
                }
                Map<Group, String> map3 = sourceConnectorReader.getAccessProperties();
                entry2 = map3.entrySet().iterator();
                while (entry2.hasNext()) {
                    Map.Entry entry3 = (Map.Entry)entry2.next();
                    if (!((Group)entry3.getKey()).containsUser(object2.name)) continue;
                    object.put(sourceConnectorReader.getPrefix(), this.getPropertySets().get(entry3.getValue()));
                }
            }
            this.interface.put(object2.name, hashMap);
            this.\u00d8O0000.put(object2.name, (Map<String, PropertySet>)object);
        }
        HashMap hashMap = new HashMap();
        for (SourceConnectorReader sourceConnectorReader : map.values()) {
            object = sourceConnectorReader.getAccessPermissions().get(this.Objectsuper.get("public"));
            hashMap.put(sourceConnectorReader.getPrefix(), object);
        }
        this.interface.put("public", hashMap);
        this.updateUserPublishingSets();
    }

    /*
     * WARNING - void declaration
     */
    private void updateUserPublishingSets() {
        this.\u00f8O0000.clear();
        for (Users.User user : this.\u00f600000) {
            Map<String, PropertySet> map;
            boolean bl;
            Object object;
            Object object2;
            Object object3;
            ArrayList<PublishingSet> arrayList = new ArrayList<PublishingSet>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (this.OO0000 != null) {
                for (PropertySet.ItemType object4 : this.OO0000.publishingsets) {
                    object3 = this.\u00d6O0000.get(object4.name);
                    if (object3 == null) {
                        this.Oo0000.log(2064, object4.name);
                        continue;
                    }
                    if (object4.inherit) {
                        PublishingSet publishingSet = ((PublishingSet)object3).clone();
                        if (object4.isProtected) {
                            publishingSet.protectAll(true);
                        }
                        arrayList.add(publishingSet);
                        continue;
                    }
                    hashMap.put(object4.name, object3);
                }
            }
            if (user.propertySet != null) {
                void var6_9;
                object2 = this.\u00f800000.get(user.propertySet);
                Object var6_8 = null;
                for (PropertySet.ItemType itemType : ((PropertySet)object2).publishingsets) {
                    object = this.\u00d6O0000.get(itemType.name);
                    if (object == null) {
                        this.Oo0000.log(2065, itemType.name, user.name);
                        continue;
                    }
                    if (itemType.inherit) {
                        PublishingSet publishingSet = ((PublishingSet)object).clone();
                        if (!itemType.isProtected) continue;
                        publishingSet.protectAll(true);
                        continue;
                    }
                    hashMap.put(itemType.name, this.applyInheritanceChain((PublishingSet)object, (List<PublishingSet>)arrayList));
                }
                if (var6_9 != null) {
                    arrayList.add((PublishingSet)var6_9);
                }
            }
            object2 = this.getGroupsForUser(user.name);
            boolean bl2 = false;
            object3 = null;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Group)iterator.next();
                String string = ((Group)object).getPropertySet();
                if (string == null) continue;
                PropertySet propertySet = this.\u00f800000.get(string);
                if (propertySet == null) {
                    this.Oo0000.log(2066, string, ((Group)object).getName());
                    continue;
                }
                for (PropertySet.ItemType itemType : propertySet.publishingsets) {
                    PublishingSet publishingSet = this.\u00d6O0000.get(itemType.name);
                    if (publishingSet == null) {
                        this.Oo0000.log(2067, itemType.name, string);
                        continue;
                    }
                    if (itemType.inherit) {
                        if (object3 != null) {
                            this.Oo0000.log(2068, user.name);
                            bl = true;
                            continue;
                        }
                        object3 = publishingSet.clone();
                        if (!itemType.isProtected) continue;
                        ((PublishingSet)object3).protectAll(true);
                        continue;
                    }
                    hashMap.put(itemType.name, this.applyInheritanceChain(publishingSet, arrayList));
                }
            }
            if (!bl && object3 != null) {
                arrayList.add((PublishingSet)object3);
            }
            if ((map = this.\u00d8O0000.get(user.name)) != null) {
                for (PropertySet propertySet : map.values()) {
                    for (PropertySet.ItemType itemType : propertySet.publishingsets) {
                        PublishingSet publishingSet = this.\u00d6O0000.get(itemType.name);
                        if (publishingSet == null) {
                            this.Oo0000.log(2069, itemType.name);
                            continue;
                        }
                        if (itemType.inherit) {
                            this.Oo0000.log(2070, itemType.name);
                            continue;
                        }
                        hashMap.put(itemType.name, this.applyInheritanceChain(publishingSet, arrayList));
                    }
                }
            }
            this.\u00f8O0000.put(user.name, hashMap);
        }
    }

    private PublishingSet applyInheritanceChain(PublishingSet publishingSet, List<PublishingSet> list) {
        PublishingSet publishingSet2 = publishingSet.clone();
        for (int i = list.size() - 1; i >= 0; ++i) {
            PublishingSet publishingSet3 = list.get(i);
            if (publishingSet2.viewerpath == null || publishingSet3.viewerpath != null && publishingSet3.viewerpath.isProtected) {
                publishingSet2.viewerpath = publishingSet3.viewerpath;
            }
            if (publishingSet2.proxyURL == null || publishingSet3.proxyURL != null && publishingSet3.proxyURL.isProtected) {
                publishingSet2.proxyURL = publishingSet3.proxyURL;
            }
            if (publishingSet2.proxyServerPattern == null || publishingSet3.proxyServerPattern != null && publishingSet3.proxyServerPattern.isProtected) {
                publishingSet2.proxyServerPattern = publishingSet3.proxyServerPattern;
            }
            if (publishingSet2.proxyStaticPattern == null || publishingSet3.proxyStaticPattern != null && publishingSet3.proxyStaticPattern.isProtected) {
                publishingSet2.proxyStaticPattern = publishingSet3.proxyStaticPattern;
            }
            if (publishingSet2.proxyJSPath == null || publishingSet3.proxyJSPath != null && publishingSet3.proxyJSPath.isProtected) {
                publishingSet2.proxyJSPath = publishingSet3.proxyJSPath;
            }
            if (publishingSet2.proxyViewerPath == null || publishingSet3.proxyViewerPath != null && publishingSet3.proxyViewerPath.isProtected) {
                publishingSet2.proxyViewerPath = publishingSet3.proxyViewerPath;
            }
            if (publishingSet2.proxyUserViewerBase != null && (publishingSet3.proxyUserViewerBase == null || !publishingSet3.proxyUserViewerBase.isProtected)) continue;
            publishingSet2.proxyUserViewerBase = publishingSet3.proxyUserViewerBase;
        }
        return publishingSet2;
    }

    void setFileMonitorTasksSuspended(boolean bl) {
        for (FileEventCursor.RegisteredPath registeredPath : this.\u00d3O0000) {
            registeredPath.setSuspended(bl);
        }
    }

    public boolean saveUsersToFile(Path path) {
        boolean bl = false;
        Users users = new Users();
        users.users = new HashSet<Users.User>();
        users.users.addAll(this.\u00f600000);
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            JAXB.marshal((Object)users, (OutputStream)outputStream);
            bl = true;
        }
        catch (IOException | DataBindingException throwable) {
            this.Oo0000.log(2048, path.toString(), throwable.getLocalizedMessage());
        }
        return bl;
    }

    public boolean saveGroupsToFile(Path path) {
        boolean bl = false;
        Groups groups = new Groups();
        ArrayList<Group> arrayList = new ArrayList<Group>();
        for (Map.Entry<String, Group> entry : this.Objectsuper.entrySet()) {
            if (entry.getKey().equals("public") || entry.equals("authenticated")) continue;
            arrayList.add(entry.getValue());
        }
        groups.setGroups(arrayList);
        try {
            Map.Entry<String, Group> entry;
            OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
            entry = null;
            try {
                JAXB.marshal((Object)groups, (OutputStream)outputStream);
                bl = true;
            }
            catch (Throwable throwable) {
                entry = throwable;
                throw throwable;
            }
            finally {
                if (outputStream != null) {
                    if (entry != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)entry)).addSuppressed(throwable);
                        }
                    } else {
                        outputStream.close();
                    }
                }
            }
        }
        catch (IOException | DataBindingException throwable) {
            this.Oo0000.log(2048, path.toString(), throwable.getLocalizedMessage());
        }
        return bl;
    }

    static {
        UserAuthenticationInterface.\u00d400000.read.basicMetadata = true;
        UserAuthenticationInterface.\u00d400000.read.renderedImages = true;
        UserAuthenticationInterface.\u00d400000.read.files = true;
        UserAuthenticationInterface.\u00d400000.list.files = true;
        UserAuthenticationInterface.\u00d400000.write.delete = true;
        \u00d2O0000 = PermissionSet.getAllForbiddenPermissionsClone();
        UserAuthenticationInterface.\u00d2O0000.read.basicMetadata = true;
        UserAuthenticationInterface.\u00d2O0000.read.renderedImages = true;
        UserAuthenticationInterface.\u00d2O0000.read.downloadSource = true;
        UserAuthenticationInterface.\u00d2O0000.read.files = true;
        UserAuthenticationInterface.\u00d2O0000.list.files = true;
        UserAuthenticationInterface.\u00d2O0000.write.delete = true;
        UserAuthenticationInterface.\u00d2O0000.tasks.createArchive = true;
        UserAuthenticationInterface.\u00d2O0000.tasks.batchRendering = true;
        \u00d4O0000 = PermissionSet.getAllForbiddenPermissionsClone();
        UserAuthenticationInterface.\u00d4O0000.read.basicMetadata = true;
        UserAuthenticationInterface.\u00d4O0000.read.renderedImages = true;
        UserAuthenticationInterface.\u00d4O0000.read.files = true;
        UserAuthenticationInterface.\u00d4O0000.list.files = true;
        UserAuthenticationInterface.\u00d4O0000.list.directories = true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class _o
    implements CallbackHandler {
        private final String new;
        private final char[] o00000;

        _o(String string, String string2) {
            this.new = string;
            this.o00000 = string2 != null ? string2.toCharArray() : null;
        }

        @Override
        public void handle(Callback[] callbackArray) {
            for (Callback callback : callbackArray) {
                if (callback instanceof NameCallback && this.new != null) {
                    ((NameCallback)callback).setName(this.new);
                    continue;
                }
                if (!(callback instanceof PasswordCallback) || this.o00000 == null) continue;
                ((PasswordCallback)callback).setPassword(this.o00000);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum SessionStatus {
        \u00d300000,
        \u00d200000;

    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum AuthenticationCode {
        class,
        \u00d300000,
        super,
        \u00d600000,
        \u00d200000;

    }
}

