/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;

final class PeriodicShiftOpImage
extends OpImage {
    private int[] xTrans;
    private int[] yTrans;
    private TranslateIntOpImage[] images;
    private Rectangle[] bounds;

    public PeriodicShiftOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n, int n2) {
        super(PeriodicShiftOpImage.vectorize(renderedImage), imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone(), map, false);
        this.xTrans = new int[]{-n, -n, this.width - n, this.width - n};
        this.yTrans = new int[]{-n2, this.height - n2, -n2, this.height - n2};
        this.images = new TranslateIntOpImage[4];
        for (int i = 0; i < 4; ++i) {
            this.images[i] = new TranslateIntOpImage(renderedImage, null, this.xTrans[i], this.yTrans[i]);
        }
        Rectangle rectangle = this.getBounds();
        this.bounds = new Rectangle[4];
        for (int i = 0; i < 4; ++i) {
            this.bounds[i] = rectangle.intersection(this.images[i].getBounds());
        }
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        for (int i = 0; i < 4; ++i) {
            Rectangle rectangle3 = rectangle2.intersection(this.bounds[i]);
            if (rectangle3.isEmpty()) continue;
            JDKWorkarounds.setRect(writableRaster, this.images[i].getData(rectangle3));
        }
        return writableRaster;
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("PeriodicShiftOpImage0"));
        }
        Rectangle rectangle2 = null;
        for (int i = 0; i < 4; ++i) {
            Rectangle rectangle3 = rectangle;
            rectangle3.translate(this.xTrans[i], this.yTrans[i]);
            Rectangle rectangle4 = rectangle3.intersection(this.getBounds());
            if (rectangle4.isEmpty()) continue;
            rectangle2 = rectangle2 == null ? rectangle4 : rectangle2.union(rectangle4);
        }
        return rectangle2;
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("PeriodicShiftOpImage0"));
        }
        Rectangle rectangle2 = null;
        for (int i = 0; i < 4; ++i) {
            Rectangle rectangle3 = rectangle.intersection(this.bounds[i]);
            if (rectangle3.isEmpty()) continue;
            rectangle3.translate(-this.xTrans[i], -this.yTrans[i]);
            rectangle2 = rectangle2 == null ? rectangle3 : rectangle2.union(rectangle3);
        }
        return rectangle2;
    }
}

