/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.util;

import com.sun.media.jai.codecimpl.util.DataBufferUtils;
import com.sun.media.jai.codecimpl.util.JaiI18N;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;

public class ComponentSampleModelJAI
extends ComponentSampleModel {
    public ComponentSampleModelJAI(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        super(n, n2, n3, n4, n5, nArray);
    }

    public ComponentSampleModelJAI(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        super(n, n2, n3, n4, n5, nArray, nArray2);
    }

    private long getBufferSize() {
        int n = this.bandOffsets[0];
        for (int i = 1; i < this.bandOffsets.length; ++i) {
            n = Math.max(n, this.bandOffsets[i]);
        }
        long l = 0L;
        if (n >= 0) {
            l += (long)(n + 1);
        }
        if (this.pixelStride > 0) {
            l += (long)(this.pixelStride * (this.width - 1));
        }
        if (this.scanlineStride > 0) {
            l += (long)(this.scanlineStride * (this.height - 1));
        }
        return l;
    }

    private int[] JAIorderBands(int[] nArray, int n) {
        int n2;
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray2[n2] = n2;
        }
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            int n3 = n2;
            for (int i = n2 + 1; i < nArray3.length; ++i) {
                if (nArray[nArray2[n3]] <= nArray[nArray2[i]]) continue;
                n3 = i;
            }
            nArray3[nArray2[n3]] = n2 * n;
            nArray2[n3] = nArray2[n2];
        }
        return nArray3;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int n3;
        int[] nArray;
        int n4;
        Object var3_3 = null;
        int n5 = this.bandOffsets[0];
        int n6 = this.bandOffsets[0];
        for (n4 = 1; n4 < this.bandOffsets.length; ++n4) {
            n5 = Math.min(n5, this.bandOffsets[n4]);
            n6 = Math.max(n6, this.bandOffsets[n4]);
        }
        n4 = this.bandOffsets.length;
        int n7 = Math.abs(this.pixelStride);
        int n8 = Math.abs(this.scanlineStride);
        int n9 = Math.abs(n6 -= n5);
        if (n7 > n8) {
            if (n7 > n9) {
                if (n8 > n9) {
                    nArray = new int[this.bandOffsets.length];
                    for (n3 = 0; n3 < n4; ++n3) {
                        nArray[n3] = this.bandOffsets[n3] - n5;
                    }
                    n8 = n9 + 1;
                    n7 = n8 * n2;
                } else {
                    nArray = this.JAIorderBands(this.bandOffsets, n8 * n2);
                    n7 = n4 * n8 * n2;
                }
            } else {
                n7 = n8 * n2;
                nArray = this.JAIorderBands(this.bandOffsets, n7 * n);
            }
        } else if (n7 > n9) {
            nArray = new int[this.bandOffsets.length];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = this.bandOffsets[n3] - n5;
            }
            n7 = n9 + 1;
            n8 = n7 * n;
        } else if (n8 > n9) {
            nArray = this.JAIorderBands(this.bandOffsets, n7 * n);
            n8 = n4 * n7 * n;
        } else {
            n8 = n7 * n;
            nArray = this.JAIorderBands(this.bandOffsets, n8 * n2);
        }
        n3 = 0;
        if (this.scanlineStride < 0) {
            n3 += n8 * n2;
            n8 *= -1;
        }
        if (this.pixelStride < 0) {
            n3 += n7 * n;
            n7 *= -1;
        }
        int n10 = 0;
        while (n10 < n4) {
            int n11 = n10++;
            nArray[n11] = nArray[n11] + n3;
        }
        return new ComponentSampleModelJAI(this.dataType, n, n2, n7, n8, this.bankIndices, nArray);
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            nArray2[i] = this.bankIndices[n];
            nArray3[i] = this.bandOffsets[n];
        }
        return new ComponentSampleModelJAI(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, nArray2, nArray3);
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n, this.numBanks);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n, this.numBanks);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n, this.numBanks);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n, this.numBanks);
                break;
            }
            case 4: {
                dataBuffer = DataBufferUtils.createDataBufferFloat(n, this.numBanks);
                break;
            }
            case 5: {
                dataBuffer = DataBufferUtils.createDataBufferDouble(n, this.numBanks);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
        return dataBuffer;
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        switch (n3) {
            case 0: {
                byte[] byArray = object == null ? new byte[n4] : (byte[])object;
                for (int i = 0; i < n4; ++i) {
                    byArray[i] = (byte)dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[n4] : (short[])object;
                for (int i = 0; i < n4; ++i) {
                    sArray[i] = (short)dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n4] : (int[])object;
                for (int i = 0; i < n4; ++i) {
                    nArray[i] = dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = nArray;
                break;
            }
            case 2: {
                short[] sArray = object == null ? new short[n4] : (short[])object;
                for (int i = 0; i < n4; ++i) {
                    sArray[i] = (short)dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = sArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n4] : (float[])object;
                for (int i = 0; i < n4; ++i) {
                    fArray[i] = dataBuffer.getElemFloat(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n4] : (double[])object;
                for (int i = 0; i < n4; ++i) {
                    dArray[i] = dataBuffer.getElemDouble(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = dArray;
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
        return object;
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        int n5 = this.getTransferType();
        int n6 = this.getNumDataElements();
        int n7 = 0;
        Object object2 = null;
        switch (n5) {
            case 0: {
                byte[] byArray = object == null ? new byte[n6 * n3 * n4] : (byte[])object;
                for (int i = n2; i < n2 + n4; ++i) {
                    for (int j = n; j < n + n3; ++j) {
                        object2 = this.getDataElements(j, i, object2, dataBuffer);
                        byte[] byArray2 = (byte[])object2;
                        for (int k = 0; k < n6; ++k) {
                            byArray[n7++] = byArray2[k];
                        }
                    }
                }
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[n6 * n3 * n4] : (short[])object;
                for (int i = n2; i < n2 + n4; ++i) {
                    for (int j = n; j < n + n3; ++j) {
                        object2 = this.getDataElements(j, i, object2, dataBuffer);
                        short[] sArray2 = (short[])object2;
                        for (int k = 0; k < n6; ++k) {
                            sArray[n7++] = sArray2[k];
                        }
                    }
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n6 * n3 * n4] : (int[])object;
                for (int i = n2; i < n2 + n4; ++i) {
                    for (int j = n; j < n + n3; ++j) {
                        object2 = this.getDataElements(j, i, object2, dataBuffer);
                        int[] nArray2 = (int[])object2;
                        for (int k = 0; k < n6; ++k) {
                            nArray[n7++] = nArray2[k];
                        }
                    }
                }
                object = nArray;
                break;
            }
            case 2: {
                short[] sArray = object == null ? new short[n6 * n3 * n4] : (short[])object;
                for (int i = n2; i < n2 + n4; ++i) {
                    for (int j = n; j < n + n3; ++j) {
                        object2 = this.getDataElements(j, i, object2, dataBuffer);
                        short[] sArray3 = (short[])object2;
                        for (int k = 0; k < n6; ++k) {
                            sArray[n7++] = sArray3[k];
                        }
                    }
                }
                object = sArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n6 * n3 * n4] : (float[])object;
                for (int i = n2; i < n2 + n4; ++i) {
                    for (int j = n; j < n + n3; ++j) {
                        object2 = this.getDataElements(j, i, object2, dataBuffer);
                        float[] fArray2 = (float[])object2;
                        for (int k = 0; k < n6; ++k) {
                            fArray[n7++] = fArray2[k];
                        }
                    }
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n6 * n3 * n4] : (double[])object;
                for (int i = n2; i < n2 + n4; ++i) {
                    for (int j = n; j < n + n3; ++j) {
                        object2 = this.getDataElements(j, i, object2, dataBuffer);
                        double[] dArray2 = (double[])object2;
                        for (int k = 0; k < n6; ++k) {
                            dArray[n7++] = dArray2[k];
                        }
                    }
                }
                object = dArray;
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
        return object;
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], byArray[i] & 0xFF);
                }
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], sArray[i] & 0xFFFF);
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], nArray[i]);
                }
                break;
            }
            case 2: {
                short[] sArray = (short[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], sArray[i]);
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElemFloat(this.bankIndices[i], n5 + this.bandOffsets[i], fArray[i]);
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElemDouble(this.bankIndices[i], n5 + this.bandOffsets[i], dArray[i]);
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        int n5 = 0;
        Object var8_8 = null;
        int n6 = this.getTransferType();
        int n7 = this.getNumDataElements();
        switch (n6) {
            case 0: {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = new byte[n7];
                for (int i = n2; i < n2 + n4; ++i) {
                    for (int j = n; j < n + n3; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            byArray2[k] = byArray[n5++];
                        }
                        this.setDataElements(j, i, byArray2, dataBuffer);
                    }
                }
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                short[] sArray2 = new short[n7];
                for (int i = n2; i < n2 + n4; ++i) {
                    for (int j = n; j < n + n3; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            sArray2[k] = sArray[n5++];
                        }
                        this.setDataElements(j, i, sArray2, dataBuffer);
                    }
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int[] nArray2 = new int[n7];
                for (int i = n2; i < n2 + n4; ++i) {
                    for (int j = n; j < n + n3; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            nArray2[k] = nArray[n5++];
                        }
                        this.setDataElements(j, i, nArray2, dataBuffer);
                    }
                }
                break;
            }
            case 2: {
                short[] sArray = (short[])object;
                short[] sArray3 = new short[n7];
                for (int i = n2; i < n2 + n4; ++i) {
                    for (int j = n; j < n + n3; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            sArray3[k] = sArray[n5++];
                        }
                        this.setDataElements(j, i, sArray3, dataBuffer);
                    }
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                float[] fArray2 = new float[n7];
                for (int i = n2; i < n2 + n4; ++i) {
                    for (int j = n; j < n + n3; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            fArray2[k] = fArray[n5++];
                        }
                        this.setDataElements(j, i, fArray2, dataBuffer);
                    }
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                double[] dArray2 = new double[n7];
                for (int i = n2; i < n2 + n4; ++i) {
                    for (int j = n; j < n + n3; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            dArray2[k] = dArray[n5++];
                        }
                        this.setDataElements(j, i, dArray2, dataBuffer);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("RasterFactory3"));
            }
        }
    }

    public void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
        dataBuffer.setElemFloat(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3], f);
    }

    public float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
        float f = dataBuffer.getElemFloat(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3]);
        return f;
    }

    public void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
        dataBuffer.setElemDouble(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3], d);
    }

    public double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
        double d = dataBuffer.getElemDouble(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3]);
        return d;
    }

    public double[] getPixels(int n, int n2, int n3, int n4, double[] dArray, DataBuffer dataBuffer) {
        int n5 = 0;
        double[] dArray2 = dArray != null ? dArray : new double[this.numBands * n3 * n4];
        for (int i = n2; i < n4 + n2; ++i) {
            for (int j = n; j < n3 + n; ++j) {
                for (int k = 0; k < this.numBands; ++k) {
                    dArray2[n5++] = this.getSampleDouble(j, i, k, dataBuffer);
                }
            }
        }
        return dArray2;
    }

    public String toString() {
        String string = "ComponentSampleModelJAI:   dataType=" + this.getDataType() + "  numBands=" + this.getNumBands() + "  width=" + this.getWidth() + "  height=" + this.getHeight() + "  bandOffsets=[ ";
        for (int i = 0; i < this.numBands; ++i) {
            string = string + this.getBandOffsets()[i] + " ";
        }
        string = string + "]";
        return string;
    }
}

