/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class WriterAbstract
implements Closeable {
    private final Path \u00d400000;
    SeekableByteChannel \u00d300000;
    ByteOrder super;
    private long \u00d200000 = -1L;

    WriterAbstract(Path path, Set<StandardOpenOption> set) throws IOException {
        this.\u00d400000 = path;
        this.checkAccess(set);
        this.init(set);
    }

    WriterAbstract(Path path, StandardOpenOption ... standardOpenOptionArray) throws IOException {
        this.\u00d400000 = path;
        HashSet<StandardOpenOption> hashSet = new HashSet<StandardOpenOption>(standardOpenOptionArray.length);
        Collections.addAll(hashSet, standardOpenOptionArray);
        this.checkAccess(hashSet);
        this.init(hashSet);
    }

    private void checkAccess(Set<StandardOpenOption> set) throws IOException {
        if (!(set.contains(StandardOpenOption.CREATE) || set.contains(StandardOpenOption.CREATE_NEW) || set.contains(StandardOpenOption.WRITE))) {
            throw new IOException("Only write modes allowed");
        }
    }

    private void init(Set<StandardOpenOption> set) throws IOException {
        this.\u00d300000 = Files.newByteChannel(this.\u00d400000, set, new FileAttribute[0]);
        this.super = ByteOrder.nativeOrder();
    }

    public long length() throws IOException {
        if (this.\u00d200000 == -1L) {
            this.\u00d200000 = this.\u00d300000.size();
        }
        return this.\u00d200000;
    }

    public String toString() {
        return this.\u00d400000.toString();
    }

    public boolean isOpen() {
        return this.\u00d300000.isOpen();
    }

    @Override
    public abstract void close() throws IOException;

    public abstract void write(ByteBuffer var1) throws IOException;

    public abstract void write(byte[] var1) throws IOException;

    public abstract void writeByte(byte var1) throws IOException;

    public abstract void writeShort(short var1) throws IOException;

    public abstract void writeInt(int var1) throws IOException;

    public abstract void writeLong(long var1) throws IOException;

    public abstract void writeFloat(float var1) throws IOException;

    public abstract void writeDouble(double var1) throws IOException;

    public abstract void writeTagByte(short var1, byte var2) throws IOException;

    public abstract void writeTagBytes(short var1, byte[] var2) throws IOException;

    public abstract void writeTagFloat(short var1, float var2) throws IOException;

    public abstract void writeTagFloats(short var1, float[] var2) throws IOException;

    public abstract void write(float[] var1) throws IOException;

    public abstract void writeTagShort(short var1, short var2) throws IOException;

    public abstract void writeTagInt(short var1, int var2) throws IOException;

    public abstract void writeTagLong(short var1, long var2) throws IOException;

    public abstract void writeTagDouble(short var1, double var2) throws IOException;

    public abstract void writeTagUTF8(short var1, String var2) throws IOException;

    public abstract long position() throws IOException;

    public abstract void seek(long var1) throws IOException;

    public void setByteOrder(ByteOrder byteOrder) {
        this.super = byteOrder;
    }

    public ByteOrder getByteOrder() {
        return this.super;
    }
}

