/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.area.perspective;

import com.neptunelabs.fsiserver.framework.helpers.ExecutorPool;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.area.perspective.A;
import com.neptunelabs.fsiserver.imagemanipulator.area.perspective.C;
import com.neptunelabs.fsiserver.imagemanipulator.area.perspective.new;
import com.neptunelabs.fsiserver.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.fsiserver.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class PerspectiveDistortion
extends EffectUtils {
    public PerspectiveDistortion(FSILogger fSILogger) {
        super(fSILogger);
    }

    public FSIImage transform(FSIImage fSIImage, FILTER fILTER, Point2D.Float float_, Point2D.Float float_2, Point2D.Float float_3, Point2D.Float float_4, boolean bl) throws ImageManipulatorException, ProcessingException {
        int n = fSIImage.getWidth();
        int n2 = fSIImage.getHeight();
        Point point = new Point();
        point.x = (int)(float_.x * (float)n);
        point.y = (int)(float_.y * (float)n2);
        Point point2 = new Point();
        point2.x = (int)(float_2.x * (float)n);
        point2.y = (int)(float_2.y * (float)n2);
        Point point3 = new Point();
        point3.x = (int)(float_3.x * (float)n);
        point3.y = (int)(float_3.y * (float)n2);
        Point point4 = new Point();
        point4.x = (int)(float_4.x * (float)n);
        point4.y = (int)(float_4.y * (float)n2);
        return this.transform(fSIImage, fILTER, point, point2, point3, point4, bl);
    }

    private FSIImage transform(FSIImage fSIImage, FILTER fILTER, Point point, Point point2, Point point3, Point point4, boolean bl) throws ImageManipulatorException, ProcessingException {
        int n;
        float[] fArray = PerspectiveDistortion.getMatrix(point, point2, point3, point4);
        fSIImage.addAlpha();
        FSIImageLimited fSIImageLimited = ((FSIImageLimited)fSIImage).createCompatibleAlphaImage();
        int n2 = this.calcThreads(fSIImage);
        ExecutorService executorService = ExecutorPool.createExecutorService("PCO", n2);
        ArrayList<CompletableFuture<Void>> arrayList = new ArrayList<CompletableFuture<Void>>(n2);
        int[][] nArray = PerspectiveDistortion.calcThreadImageRanges(fSIImage.getHeight(), n2);
        switch (fILTER) {
            case o00000: {
                int[] nArray2;
                for (n = 0; n < n2; ++n) {
                    nArray2 = nArray[n];
                    new new_ = new new(nArray2[0], nArray2[1]);
                    new_.\u00d400000(fArray);
                    new_.setImages(fSIImage, fSIImageLimited);
                    arrayList.add(CompletableFuture.supplyAsync(new_, executorService));
                }
                break;
            }
            case \u00d300000: {
                int[] nArray2;
                for (n = 0; n < n2; ++n) {
                    nArray2 = nArray[n];
                    A a = new A(nArray2[0], nArray2[1]);
                    a.Oo0000(fArray);
                    a.setImages(fSIImage, fSIImageLimited);
                    arrayList.add(CompletableFuture.supplyAsync(a, executorService));
                }
                break;
            }
            default: {
                int[] nArray2;
                for (n = 0; n < n2; ++n) {
                    nArray2 = nArray[n];
                    C c = new C(nArray2[0], nArray2[1]);
                    c.\u00f500000(fArray);
                    c.setImages(fSIImage, fSIImageLimited);
                    arrayList.add(CompletableFuture.supplyAsync(c, executorService));
                }
            }
        }
        n = 1;
        try {
            n = ExecutorPool.shutdownAndWait(executorService, arrayList, 60) ? 1 : 0;
            ExecutorPool.getAllVoid(arrayList);
        }
        catch (InterruptedException interruptedException) {
            n = 0;
        }
        catch (ExecutionException executionException) {
            n = 0;
            this.super.logException(executionException, 3800, executionException.getLocalizedMessage());
            throw new ProcessingException(executionException.getCause());
        }
        finally {
            if (n == 0) {
                fSIImageLimited.dispose();
            }
        }
        if (!bl) {
            fSIImage.dispose();
        }
        return fSIImageLimited;
    }

    private static float[] getMatrix(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9 = (float)point2D.getX();
        float f10 = (float)point2D.getY();
        float f11 = (float)point2D2.getX();
        float f12 = (float)point2D2.getY();
        float f13 = (float)point2D3.getX();
        float f14 = (float)point2D3.getY();
        float f15 = (float)point2D4.getX();
        float f16 = (float)point2D4.getY();
        float f17 = f11 - f13;
        float f18 = f12 - f14;
        float f19 = f15 - f13;
        float f20 = f16 - f14;
        float f21 = f9 - f11 + f13 - f15;
        float f22 = f10 - f12 + f14 - f16;
        if (f21 == 0.0f && f22 == 0.0f) {
            f8 = f11 - f9;
            f7 = f13 - f11;
            f6 = f9;
            f5 = f12 - f10;
            f4 = f14 - f12;
            f3 = f10;
            f2 = 0.0f;
            f = 0.0f;
        } else {
            f = (f21 * f20 - f19 * f22) / (f17 * f20 - f18 * f19);
            f2 = (f17 * f22 - f18 * f21) / (f17 * f20 - f18 * f19);
            f8 = f11 - f9 + f * f11;
            f7 = f15 - f9 + f2 * f15;
            f6 = f9;
            f5 = f12 - f10 + f * f12;
            f4 = f16 - f10 + f2 * f16;
            f3 = f10;
        }
        float f23 = f4 - f3 * f2;
        float f24 = f6 * f2 - f7;
        float f25 = f7 * f3 - f6 * f4;
        float f26 = f3 * f - f5;
        float f27 = f8 - f6 * f;
        float f28 = f6 * f5 - f8 * f3;
        float f29 = f5 * f2 - f4 * f;
        float f30 = f7 * f - f8 * f2;
        float f31 = f8 * f4 - f7 * f5;
        return new float[]{f23, f24, f25, f26, f27, f28, f29, f30, f31};
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum FILTER {
        o00000,
        \u00d300000,
        \u00d400000;

    }
}

