/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.encoder.png;

import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiserver.framework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.fsiserver.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.fsiserver.imagemanipulator.dither.Ditherer;
import com.neptunelabs.fsiserver.imagemanipulator.encoder.ImageEncoder;
import com.neptunelabs.fsiserver.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.fsiserver.imagemanipulator.palette.Palette;
import com.neptunelabs.fsiserver.imagemanipulator.quantizer.Quantizer;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageMode;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public final class PNGEncoder
extends ImageEncoderUtils
implements ImageEncoder {
    public static final int \u00f6o0000 = 0;
    private static final int O\u00d20000 = 1;
    private final byte[] dosuper = new byte[]{73, 72, 68, 82};
    private final byte[] \u00d5\u00d30000 = new byte[]{73, 68, 65, 84};
    private final byte[] \u00f5o0000 = new byte[]{73, 69, 78, 68};
    private final byte[] \u00d5o0000 = new byte[]{105, 67, 67, 80};
    private final byte[] \u00d6\u00d30000 = new byte[]{116, 69, 88, 116};
    private final byte[] o\u00d20000 = new byte[]{112, 72, 89, 115};
    private final byte[] \u00d6o0000 = new byte[]{80, 76, 84, 69};
    private final byte[] O\u00d30000 = new byte[]{116, 82, 78, 83};
    private final byte[] \u00f5\u00d20000 = new byte[]{115, 82, 71, 66};
    private final byte[] Objectnew = new byte[]{103, 65, 77, 65};
    private final CRC32 \u00d6\u00d20000 = new CRC32();
    private int o\u00d30000;
    private int floatnew;
    private boolean superObject = false;
    private int voidnew = 1;
    private int publicnew;
    private int \u00d2\u00d30000 = 4;
    private boolean \u00d4\u00d30000 = false;
    private int \u00d5\u00d20000 = 10;
    private int \u00f4\u00d20000 = -1;
    private int \u00f6\u00d20000 = 0xFFFFFF;
    private ImageEncoderUtils.DithererMode \u00d4\u00d20000;
    private ImageEncoderUtils.QuantizerMode \u00f4o0000;
    private ImageEncoderUtils.PaletteMode \u00d2\u00d20000;
    private boolean interfacesuper = true;

    public PNGEncoder(FSILogger fSILogger) {
        super(fSILogger);
    }

    @Override
    public String getName() {
        return "PNGEncoder";
    }

    public void setMaxColors(int n) {
        this.\u00f4\u00d20000 = n;
    }

    public void setMatteColor(int n) {
        this.\u00f6\u00d20000 = n;
    }

    public void setSerpentine(boolean bl) {
        this.interfacesuper = bl;
    }

    public void setDitherer(ImageEncoderUtils.DithererMode dithererMode) {
        this.\u00d4\u00d20000 = dithererMode;
    }

    public void setQuantizer(ImageEncoderUtils.QuantizerMode quantizerMode) {
        this.\u00f4o0000 = quantizerMode;
    }

    public void setQuantizerSampleDepth(int n) {
        this.\u00d5\u00d20000 = n;
    }

    public void setPalette(ImageEncoderUtils.PaletteMode paletteMode) {
        this.\u00d2\u00d20000 = paletteMode;
    }

    @Override
    public void encode() throws IOException {
        if (this.Object != null) {
            byte[] byArray;
            byte[] byArray2 = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
            this.o\u00d30000 = this.Object.getWidth();
            this.floatnew = this.Object.getHeight();
            if (!this.Object.hasAlpha()) {
                this.superObject = false;
            }
            this.publicnew = this.\u00f4\u00d20000 > 0 ? 1 : (this.\u00d4\u00d30000 ? (this.superObject ? 2 : 1) : (this.superObject ? 4 : 3));
            PNGEncoder.writeBytes(this.\u00d200000, byArray2);
            this.writeHeader();
            this.writeSRGBChunk();
            this.writeGAMAChunk();
            if (this.\u00f4\u00d20000 > 0) {
                Object object;
                if (this.Object.hasAlpha() && this.Object.getMode() == FSIImageMode.\u00d200000) {
                    object = new ParallelColorOperation(this.\u00d2O0000);
                    try {
                        this.Object = ((ParallelColorOperation)object).transform(this.Object, new MatteTransparent(this.\u00f6\u00d20000, true), false);
                    }
                    catch (ProcessingException processingException) {
                        throw new IOException(processingException);
                    }
                }
                object = PNGEncoder.getQuantizer(this.\u00f4o0000, (int)this.Object.getIntSize(), this.\u00d5\u00d20000, this.\u00f4\u00d20000, this.Object.hasAlpha());
                ((Quantizer)object).addImageData(this.Object);
                byte[] byArray3 = ((Quantizer)object).getPalette();
                Palette palette = PNGEncoder.getPalette(this.\u00d2\u00d20000);
                palette.setPalette(byArray3, ((Quantizer)object).hasAlpha(), this.\u00f6\u00d20000);
                Ditherer ditherer = PNGEncoder.getDitherer(this.\u00d4\u00d20000, palette, this.interfacesuper);
                byArray = ditherer.dither(this.Object);
                byte[] byArray4 = palette.getPalette();
                this.writePLTEChunk(byArray4);
                if (this.Object.hasAlpha()) {
                    this.writeTRNSChunk(byArray4, palette.getTransparentIndex());
                }
            } else {
                byArray = null;
                if (this.\u00d600000 != null) {
                    this.writeICC();
                }
            }
            if (this.\u00f600000 != null) {
                this.writeText("Copyright", this.\u00f600000);
            }
            if (this.float != null) {
                this.writeText("Software", this.float);
            }
            if (this.o00000 > 0) {
                this.writePHYSChunk(this.o00000);
            }
            if (this.\u00d500000 != null && this.\u00f500000 != null) {
                this.writeDirtyChunk(this.\u00d500000, this.\u00f500000);
            }
            if (byArray == null) {
                this.writeIDATChunk();
            } else {
                this.writeIDATChunk(byArray);
            }
            this.writeEnd();
            this.\u00d200000.close();
        }
    }

    public void setEncodeAlpha(boolean bl) {
        this.superObject = bl;
    }

    public void setEncodeGray(boolean bl) {
        this.\u00d4\u00d30000 = bl;
    }

    public void setFilter(int n) {
        this.voidnew = n;
    }

    public void setCompressionLevel(int n) {
        if (n >= 0 && n <= 9) {
            this.\u00d2\u00d30000 = n;
        }
    }

    @Override
    public void dispose() {
        if (this.\u00d400000 != null) {
            this.\u00d400000.dispose();
        }
    }

    private static void writeBytes(OutputStream outputStream, byte[] byArray) throws IOException {
        outputStream.write(byArray);
    }

    private static void writeInt4(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        outputStream.write(byArray);
    }

    private static void writeByte(OutputStream outputStream, int n) throws IOException {
        outputStream.write((byte)n);
    }

    private void writeHeader() throws IOException {
        PNGEncoder.writeInt4(this.\u00d200000, 13);
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.allocate(17, ByteOrder.BIG_ENDIAN);
        byteArrayWalker.put(this.dosuper);
        byteArrayWalker.putInt(this.o\u00d30000);
        byteArrayWalker.putInt(this.floatnew);
        byteArrayWalker.putByte(8);
        if (this.\u00f4\u00d20000 <= 0) {
            if (this.\u00d4\u00d30000) {
                byteArrayWalker.putByte(this.superObject ? 4 : 0);
            } else {
                byteArrayWalker.putByte(this.superObject ? 6 : 2);
            }
        } else {
            byteArrayWalker.putByte(3);
        }
        byteArrayWalker.putByte(0);
        byteArrayWalker.putByte(0);
        byteArrayWalker.putByte(0);
        byte[] byArray = byteArrayWalker.array();
        this.\u00d6\u00d20000.reset();
        this.\u00d6\u00d20000.update(byArray);
        PNGEncoder.writeBytes(this.\u00d200000, byArray);
        PNGEncoder.writeInt4(this.\u00d200000, (int)this.\u00d6\u00d20000.getValue());
    }

    private static void filterSub(byte[] byArray, int n, int n2) {
        for (int i = n - 1; i >= n2; --i) {
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] - byArray[i - n2]);
        }
    }

    private void writeICC() throws IOException {
        this.\u00d6\u00d20000.reset();
        this.\u00d6\u00d20000.update(this.\u00d5o0000);
        this.\u00d6\u00d20000.update(this.\u00d600000);
        PNGEncoder.writeInt4(this.\u00d200000, this.\u00d600000.length);
        PNGEncoder.writeBytes(this.\u00d200000, this.\u00d5o0000);
        PNGEncoder.writeBytes(this.\u00d200000, this.\u00d600000);
        PNGEncoder.writeInt4(this.\u00d200000, (int)this.\u00d6\u00d20000.getValue());
    }

    private void writeText(String string, String string2) throws IOException {
        byte[] byArray = string.getBytes("ISO-8859-1");
        byte[] byArray2 = string2.getBytes("ISO-8859-1");
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.allocate(byArray.length + 1 + byArray2.length, ByteOrder.BIG_ENDIAN);
        byteArrayWalker.put(byArray);
        byteArrayWalker.putByte(0);
        byteArrayWalker.put(byArray2);
        byte[] byArray3 = byteArrayWalker.array();
        this.\u00d6\u00d20000.reset();
        this.\u00d6\u00d20000.update(this.\u00d6\u00d30000);
        this.\u00d6\u00d20000.update(byArray3);
        PNGEncoder.writeInt4(this.\u00d200000, byArray3.length);
        PNGEncoder.writeBytes(this.\u00d200000, this.\u00d6\u00d30000);
        PNGEncoder.writeBytes(this.\u00d200000, byArray3);
        PNGEncoder.writeInt4(this.\u00d200000, (int)this.\u00d6\u00d20000.getValue());
    }

    private void writeDirtyChunk(byte[] byArray, byte[] byArray2) throws IOException {
        this.\u00d6\u00d20000.reset();
        this.\u00d6\u00d20000.update(byArray);
        this.\u00d6\u00d20000.update(byArray2);
        PNGEncoder.writeInt4(this.\u00d200000, byArray2.length);
        PNGEncoder.writeBytes(this.\u00d200000, byArray);
        PNGEncoder.writeBytes(this.\u00d200000, byArray2);
        PNGEncoder.writeInt4(this.\u00d200000, (int)this.\u00d6\u00d20000.getValue());
    }

    private void writePHYSChunk(int n) throws IOException {
        int n2 = (int)Math.round((double)n / 0.0254);
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.allocate(13, ByteOrder.BIG_ENDIAN);
        byteArrayWalker.put(this.o\u00d20000);
        byteArrayWalker.putInt(n2);
        byteArrayWalker.putInt(n2);
        byteArrayWalker.putByte(1);
        byte[] byArray = byteArrayWalker.array();
        this.\u00d6\u00d20000.reset();
        this.\u00d6\u00d20000.update(byArray);
        PNGEncoder.writeInt4(this.\u00d200000, 9);
        PNGEncoder.writeBytes(this.\u00d200000, byArray);
        PNGEncoder.writeInt4(this.\u00d200000, (int)this.\u00d6\u00d20000.getValue());
    }

    private void writeSRGBChunk() throws IOException {
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.allocate(5, ByteOrder.BIG_ENDIAN);
        byteArrayWalker.put(this.\u00f5\u00d20000);
        byteArrayWalker.putByte(0);
        byte[] byArray = byteArrayWalker.array();
        this.\u00d6\u00d20000.reset();
        this.\u00d6\u00d20000.update(byArray);
        PNGEncoder.writeInt4(this.\u00d200000, 1);
        PNGEncoder.writeBytes(this.\u00d200000, byArray);
        PNGEncoder.writeInt4(this.\u00d200000, (int)this.\u00d6\u00d20000.getValue());
    }

    private void writeGAMAChunk() throws IOException {
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.allocate(8, ByteOrder.BIG_ENDIAN);
        int n = 45455;
        byteArrayWalker.put(this.Objectnew);
        byteArrayWalker.putInt(45455);
        byte[] byArray = byteArrayWalker.array();
        this.\u00d6\u00d20000.reset();
        this.\u00d6\u00d20000.update(byArray);
        PNGEncoder.writeInt4(this.\u00d200000, 4);
        PNGEncoder.writeBytes(this.\u00d200000, byArray);
        PNGEncoder.writeInt4(this.\u00d200000, (int)this.\u00d6\u00d20000.getValue());
    }

    private void writePLTEChunk(byte[] byArray) throws IOException {
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.allocate(4 + byArray.length, ByteOrder.BIG_ENDIAN);
        byteArrayWalker.put(this.\u00d6o0000);
        byteArrayWalker.put(byArray);
        byte[] byArray2 = byteArrayWalker.array();
        this.\u00d6\u00d20000.reset();
        this.\u00d6\u00d20000.update(byArray2);
        PNGEncoder.writeInt4(this.\u00d200000, byArray.length);
        PNGEncoder.writeBytes(this.\u00d200000, byArray2);
        PNGEncoder.writeInt4(this.\u00d200000, (int)this.\u00d6\u00d20000.getValue());
    }

    private void writeTRNSChunk(byte[] byArray, int n) throws IOException {
        int n2 = byArray.length / 3;
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = i == n ? 0 : -1;
        }
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.allocate(4 + byArray2.length, ByteOrder.BIG_ENDIAN);
        byteArrayWalker.put(this.O\u00d30000);
        byteArrayWalker.put(byArray2);
        byte[] byArray3 = byteArrayWalker.array();
        this.\u00d6\u00d20000.reset();
        this.\u00d6\u00d20000.update(byArray3);
        PNGEncoder.writeInt4(this.\u00d200000, byArray2.length);
        PNGEncoder.writeBytes(this.\u00d200000, byArray3);
        PNGEncoder.writeInt4(this.\u00d200000, (int)this.\u00d6\u00d20000.getValue());
    }

    private void writeIDATChunk() throws IOException {
        Deflater deflater = new Deflater(this.\u00d2\u00d30000);
        ByteArrayOutputStreamFast byteArrayOutputStreamFast = new ByteArrayOutputStreamFast((int)this.Object.getByteSize());
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStreamFast, deflater, 8192);
        int n = this.o\u00d30000 * this.publicnew;
        byte[] byArray = new byte[n];
        this.Object.setPosition(0L);
        int[] nArray = new int[this.o\u00d30000 * this.floatnew];
        this.Object.getSamples(nArray, 0, nArray.length);
        for (int i = 0; i < this.floatnew; ++i) {
            int n2;
            int n3;
            int n4 = 0;
            deflaterOutputStream.write(this.voidnew);
            if (this.\u00d4\u00d30000) {
                for (n3 = 0; n3 < this.o\u00d30000; ++n3) {
                    n2 = nArray[i * this.o\u00d30000 + n3];
                    byArray[n4++] = (byte)(n2 & 0xFF);
                    if (!this.superObject) continue;
                    byArray[n4++] = (byte)(n2 >>> 24 & 0xFF);
                }
            } else {
                for (n3 = 0; n3 < this.o\u00d30000; ++n3) {
                    n2 = nArray[i * this.o\u00d30000 + n3];
                    byArray[n4++] = (byte)(n2 >> 16 & 0xFF);
                    byArray[n4++] = (byte)(n2 >> 8 & 0xFF);
                    byArray[n4++] = (byte)(n2 & 0xFF);
                    if (!this.superObject) continue;
                    byArray[n4++] = (byte)(n2 >>> 24 & 0xFF);
                }
            }
            if (this.voidnew == 1) {
                PNGEncoder.filterSub(byArray, n, this.publicnew);
            }
            deflaterOutputStream.write(byArray);
        }
        deflaterOutputStream.close();
        deflater.finish();
        byte[] byArray2 = byteArrayOutputStreamFast.toByteArray();
        int n5 = byArray2.length;
        this.\u00d6\u00d20000.reset();
        this.\u00d6\u00d20000.update(this.\u00d5\u00d30000);
        this.\u00d6\u00d20000.update(byArray2);
        PNGEncoder.writeInt4(this.\u00d200000, n5);
        PNGEncoder.writeBytes(this.\u00d200000, this.\u00d5\u00d30000);
        PNGEncoder.writeBytes(this.\u00d200000, byArray2);
        PNGEncoder.writeInt4(this.\u00d200000, (int)this.\u00d6\u00d20000.getValue());
    }

    private void writeIDATChunk(byte[] byArray) throws IOException {
        Deflater deflater = new Deflater(this.\u00d2\u00d30000);
        ByteArrayOutputStreamFast byteArrayOutputStreamFast = new ByteArrayOutputStreamFast(1024);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStreamFast, deflater, 8192);
        int n = this.o\u00d30000 * this.publicnew;
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < this.floatnew; ++i) {
            int n2 = 0;
            deflaterOutputStream.write(this.voidnew);
            for (int j = 0; j < this.o\u00d30000; ++j) {
                byArray2[n2++] = byArray[i * this.o\u00d30000 + j];
            }
            if (this.voidnew == 1) {
                PNGEncoder.filterSub(byArray2, n, this.publicnew);
            }
            deflaterOutputStream.write(byArray2);
        }
        deflaterOutputStream.close();
        deflater.finish();
        byte[] byArray3 = byteArrayOutputStreamFast.toByteArray();
        int n3 = byArray3.length;
        this.\u00d6\u00d20000.reset();
        this.\u00d6\u00d20000.update(this.\u00d5\u00d30000);
        this.\u00d6\u00d20000.update(byArray3);
        PNGEncoder.writeInt4(this.\u00d200000, n3);
        PNGEncoder.writeBytes(this.\u00d200000, this.\u00d5\u00d30000);
        PNGEncoder.writeBytes(this.\u00d200000, byArray3);
        PNGEncoder.writeInt4(this.\u00d200000, (int)this.\u00d6\u00d20000.getValue());
    }

    private void writeEnd() throws IOException {
        PNGEncoder.writeInt4(this.\u00d200000, 0);
        PNGEncoder.writeBytes(this.\u00d200000, this.\u00f5o0000);
        this.\u00d6\u00d20000.reset();
        this.\u00d6\u00d20000.update(this.\u00f5o0000);
        PNGEncoder.writeInt4(this.\u00d200000, (int)this.\u00d6\u00d20000.getValue());
    }
}

