/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.HTTPDisposition;
import com.neptunelabs.fsiserver.framework.SoftwareVersion;
import com.neptunelabs.fsiserver.framework.cache.CacheKey;
import com.neptunelabs.fsiserver.framework.cache.CacheManager;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.helpers.URLDecoderFast;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.licensing.LicenceManager;
import com.neptunelabs.fsiserver.framework.licensing.RawLicence;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.area.CheckerMatte;
import com.neptunelabs.fsiserver.imagemanipulator.area.FSIServerWatermark;
import com.neptunelabs.fsiserver.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.requestprocessor.MetaDataSource;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.ProcessorEnv;
import com.neptunelabs.fsiserver.requestprocessor.effects.EffectsManager;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressorResponse;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputFormat;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.requesthandlers.StaticFileRequestHandler;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.search.processors.SearchProcessor;
import com.neptunelabs.fsiserver.search.solr.SolrSearcher;
import com.neptunelabs.fsiserver.utils.Defines;
import com.neptunelabs.fsiserver.utils.ETag;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.MockHttpServletRequest;
import com.neptunelabs.fsiserver.utils.MockHttpServletResponse;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.ServletOutputStreamWrapper;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.Version;
import com.neptunelabs.fsiserver.utils.cache.CacheableHttpServletResponse;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MainProcessorNG
implements Runnable {
    private static final int \u00d600000 = 8192;
    private static final String \u00d8O0000 = "HEAD";
    private static final String String = "GET";
    private static final String private = "OPTIONS";
    private static final String \u00f800000 = "POST";
    private final AsyncContext oO0000;
    private final AtomicInteger for = new AtomicInteger(0);
    private final AtomicInteger o00000 = new AtomicInteger(0);
    private final Map<OutputFormat, OutputCompressor> \u00d3O0000;
    private final RequestProcessorSettings \u00d5O0000;
    private final FSILogger newsuper;
    private final String \u00d800000;
    private final Map<Parameters.Type, SearchProcessor> \u00d6O0000;
    private final StaticFileRequestHandler \u00d200000;
    private final SystemMonitor null;
    private final EffectsManager \u00d300000;
    private final SolrSearcher \u00f600000;
    private final CacheManager \u00f500000;
    private final Pattern \u00d2O0000 = Pattern.compile("\\{(.+?)\\}");
    private AsyncListener \u00d500000;

    public MainProcessorNG(AsyncContext asyncContext, ProcessorEnv processorEnv) {
        this.oO0000 = asyncContext;
        this.\u00d5O0000 = (RequestProcessorSettings)processorEnv.getSettings();
        this.newsuper = this.\u00d5O0000.getLogger();
        this.\u00d800000 = processorEnv.getServletInitErrorMessage();
        this.\u00d6O0000 = processorEnv.getSearchProcessors();
        this.\u00d200000 = processorEnv.getStaticFileRequestHandler();
        this.null = processorEnv.getSystemMonitor();
        this.\u00d3O0000 = processorEnv.getOutputCompressors();
        this.\u00d300000 = processorEnv.getEffectsManager();
        this.\u00f600000 = processorEnv.getSolrSearcher();
        this.\u00f500000 = processorEnv.getCacheManager();
    }

    public void setListener(AsyncListener asyncListener) {
        this.\u00d500000 = asyncListener;
    }

    @Override
    public void run() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.oO0000.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.oO0000.getResponse();
        try {
            String string = httpServletRequest.getMethod();
            if (string.equals(String)) {
                this.doGet(httpServletRequest, httpServletResponse);
            } else if (string.equals(\u00d8O0000)) {
                this.doHead(httpServletRequest, httpServletResponse);
            } else if (string.equals(\u00f800000)) {
                this.doPost(httpServletRequest, httpServletResponse);
            } else if (string.equals(private)) {
                this.doOptions(httpServletRequest, httpServletResponse);
            }
        }
        catch (Throwable throwable) {
            AsyncEvent asyncEvent = new AsyncEvent(this.oO0000, (ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, throwable);
            try {
                this.\u00d500000.onError(asyncEvent);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            this.oO0000.complete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Renderer determineRenderer(Parameters parameters, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        Renderer renderer = null;
        String string2 = string = parameters.contains(Parameters.General.\u00f5\u00d40000) ? parameters.get(Parameters.General.\u00f5\u00d40000) : this.\u00d5O0000.getPrefsString("limits", "defaultrenderer");
        if (!this.\u00d5O0000.hasEnabledRenderer(string)) {
            if (parameters.contains(Parameters.General.\u00f5\u00d40000)) {
                this.sendInvalidParameterValueResponse(httpServletResponse, "renderer", parameters.get(Parameters.General.\u00f5\u00d40000));
            } else {
                this.sendInternalServerErrorResponse(httpServletResponse, "Configuration Error: Missing default renderer");
            }
        } else {
            if (string.equals("_private") && parameters.contains(Parameters.FileImage.OO0000)) {
                string = "_licence";
            }
            renderer = this.\u00d5O0000.getEnabledRenderer(string);
        }
        return renderer;
    }

    private boolean checkRendererProtection(RendererAbstract rendererAbstract, String string, HttpSession httpSession) throws NotConfiguredException {
        Set<String> set;
        if (rendererAbstract != null && (set = rendererAbstract.getAllowedGroups()) != null) {
            if (set.contains("public")) {
                return true;
            }
            if (httpSession == null) {
                return false;
            }
            UserAuthenticationInterface userAuthenticationInterface = this.\u00d5O0000.getUserAuthenticationInterface();
            String string2 = (String)httpSession.getAttribute("id");
            Set<String> set2 = userAuthenticationInterface.getGroupNamesForUser(userAuthenticationInterface.getUser(string2));
            for (String string3 : set2) {
                if (!set.contains(string3)) continue;
                return true;
            }
        }
        return false;
    }

    private String getCopyrightNoticeForAsset(String string) {
        String string2 = null;
        SourceConnectorReader sourceConnectorReader = this.\u00d5O0000.getSourceConnectorFromAssetURLPath(string);
        if (sourceConnectorReader != null) {
            string2 = sourceConnectorReader.getImageCopyright();
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = this.\u00d5O0000.getImageCopyright();
        }
        return string2;
    }

    private void handleImageRequest(HttpServletRequest httpServletRequest, CacheableHttpServletResponse cacheableHttpServletResponse, int n) throws ServletException, IOException {
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        String string = parameters.getAssetURLPath();
        long l = System.currentTimeMillis();
        Renderer renderer = this.determineRenderer(parameters, (HttpServletResponse)cacheableHttpServletResponse);
        if (renderer == null) {
            return;
        }
        try {
            if (!this.checkRendererProtection(renderer.getImageRenderer(), string, httpServletRequest.getSession(false))) {
                cacheableHttpServletResponse.setStatus(403);
                cacheableHttpServletResponse.setCachable(false);
                return;
            }
        }
        catch (NotConfiguredException notConfiguredException) {
            cacheableHttpServletResponse.setCachable(false);
            cacheableHttpServletResponse.sendError(503, notConfiguredException.getLocalizedMessage());
            return;
        }
        RendererAbstract rendererAbstract = renderer.getImageRenderer();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Set<String> set = rendererAbstract.getRequiredMetaData();
        List<MetaDataSource> list = renderer.getMetaDataSources();
        for (MetaDataSource metaDataSource : list) {
            Map<String, Object> map = metaDataSource.getMetaData(string, set);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (!this.isMetadataComplete(set, hashMap)) {
            this.sendIncompleteMetaDataResponse((HttpServletResponse)cacheableHttpServletResponse);
            cacheableHttpServletResponse.setCachable(false);
            this.newsuper.log(4001, httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI());
            return;
        }
        try {
            RendererResponse rendererResponse = rendererAbstract.processRequest(httpServletRequest, hashMap);
            cacheableHttpServletResponse.setCachable(rendererResponse.isCacheable());
            cacheableHttpServletResponse.setPixels(rendererResponse.getPixels());
            long l2 = System.currentTimeMillis();
            int n2 = rendererResponse.getStatus();
            cacheableHttpServletResponse.setStatus(n2);
            this.transferRendererResponseHeaders(cacheableHttpServletResponse, rendererResponse, n2);
            long l3 = rendererResponse.getDateHeader("Last-Modified");
            if (l3 > 0L) {
                cacheableHttpServletResponse.setLastModified(l3);
            }
            if (rendererResponse.getPixels() > 0L && (n2 >= 200 && n2 < 300 || n2 == 404) && rendererResponse instanceof RendererImageResponse) {
                int n3;
                int n4;
                OutputCompressorResponse outputCompressorResponse;
                long l4;
                Object object;
                FSIServerSettings.LicenceState licenceState;
                long l5;
                Object object2;
                boolean bl = false;
                OutputFormat outputFormat = this.getOutputFormat(parameters, renderer);
                if (outputFormat == OutputFormat.\u00d400000 || outputFormat == OutputFormat.\u00d200000 || outputFormat == OutputFormat.o00000) {
                    bl = true;
                }
                RendererImageResponse rendererImageResponse = (RendererImageResponse)rendererResponse;
                OutputCompressor outputCompressor = this.\u00d3O0000.get((Object)outputFormat);
                String string2 = this.getCopyrightNoticeForAsset(string);
                if (rendererImageResponse.isMultiImageResponse() && outputCompressor.hasMultiImageSupport()) {
                    object2 = rendererImageResponse.getImageList();
                    l5 = System.currentTimeMillis();
                    if (renderer.getOutputEffects().size() > 0) {
                        object2 = this.applyRendererEffects((FSIImage[])object2, rendererImageResponse.getSelectionsRaws(), renderer.getOutputEffects(), parameters);
                        cacheableHttpServletResponse.getETag().addModifier(renderer.getOutputEffectsChecksum());
                    }
                    if (parameters.contains(Parameters.GeneralImage.StringObject)) {
                        object2 = this.applyQueryEffects((FSIImage[])object2, rendererImageResponse.getSelectionsRaws(), parameters, parameters.get(Parameters.GeneralImage.StringObject));
                    }
                    if ((licenceState = this.\u00d5O0000.isLicensed()) != FSIServerSettings.LicenceState.\u00f600000 && !rendererResponse.isLicenceImage()) {
                        for (Object object3 : object2) {
                            FSIServerWatermark.transform((FSIImage)object3, Defines.\u00d3\u00d40000);
                        }
                        this.setLicenceCommentHeader(cacheableHttpServletResponse, licenceState, n2);
                        cacheableHttpServletResponse.getETag().addModifier("unlic");
                    } else {
                        cacheableHttpServletResponse.getETag().addModifier("lic");
                    }
                    if (!bl) {
                        object = new CheckerMatte(this.newsuper);
                        for (int i = 0; i < ((Object)object2).length; ++i) {
                            if (!((FSIImage)object2[i]).hasAlpha()) continue;
                            object2[i] = ((CheckerMatte)object).transform((FSIImage)object2[i], 8, 0xC8C8C8, 0xFFFFFF, false);
                        }
                    }
                    l4 = System.currentTimeMillis();
                    outputCompressorResponse = outputCompressor.compressImageData(n, (FSIImage[])object2, renderer, parameters, string2);
                    for (Object object3 : object2) {
                        ((FSIImage)object3).dispose();
                    }
                    n4 = ((FSIImage)object2[0]).getWidth();
                    n3 = ((FSIImage)object2[0]).getHeight();
                } else {
                    object2 = rendererImageResponse.getImage();
                    l5 = System.currentTimeMillis();
                    if (renderer.getOutputEffects().size() > 0) {
                        object2 = this.applyRendererEffects((FSIImage)object2, rendererImageResponse.getSelectionsRaw(), renderer.getOutputEffects(), parameters);
                    }
                    if (parameters.contains(Parameters.GeneralImage.StringObject)) {
                        object2 = this.applyQueryEffects((FSIImage)object2, rendererImageResponse.getSelectionsRaw(), parameters, parameters.get(Parameters.GeneralImage.StringObject));
                    }
                    if ((licenceState = this.\u00d5O0000.isLicensed()) != FSIServerSettings.LicenceState.\u00f600000 && !rendererResponse.isLicenceImage()) {
                        FSIServerWatermark.transform((FSIImage)object2, Defines.\u00d3\u00d40000);
                        this.setLicenceCommentHeader(cacheableHttpServletResponse, licenceState, n2);
                        cacheableHttpServletResponse.getETag().addModifier("unlic");
                    } else {
                        cacheableHttpServletResponse.getETag().addModifier("lic");
                    }
                    if (((FSIImage)object2).hasAlpha() && !bl) {
                        object = new CheckerMatte(this.newsuper);
                        object2 = ((CheckerMatte)object).transform((FSIImage)object2, 8, 0xC8C8C8, 0xFFFFFF, false);
                    }
                    l4 = System.currentTimeMillis();
                    outputCompressorResponse = outputCompressor.compressImageData(n, (FSIImage)object2, renderer, parameters, string2);
                    ((FSIImage)object2).dispose();
                    n4 = ((FSIImage)object2).getWidth();
                    n3 = ((FSIImage)object2).getHeight();
                }
                long l6 = System.currentTimeMillis();
                this.newsuper.log(3000, n, l2 - l, l4 - l5, l6 - l4);
                if (outputCompressorResponse.getImageData() != null) {
                    cacheableHttpServletResponse.setContentType(outputCompressorResponse.getMimeType());
                    cacheableHttpServletResponse.setContentLength(outputCompressorResponse.getImageData().length);
                    cacheableHttpServletResponse.getETag().addModifier(outputCompressorResponse.getETagModifier());
                }
                this.setPredefinedResponseHeaders(httpServletRequest, cacheableHttpServletResponse, rendererResponse, n4, n3, "image.default", n2);
                if (httpServletRequest.getAttribute("headrequest") == null || !((Boolean)httpServletRequest.getAttribute("headrequest")).booleanValue()) {
                    object = null;
                    if (parameters.contains(Parameters.GeneralImage.O\u00d20000)) {
                        object = parameters.get(Parameters.GeneralImage.O\u00d20000);
                    } else if (parameters.contains(Parameters.GeneralImage.o\u00d40000)) {
                        object = parameters.get(Parameters.GeneralImage.o\u00d40000);
                    }
                    if (object != null && (Boolean.parseBoolean((String)object) || ((String)object).equals("1"))) {
                        Object object3;
                        HTTPDisposition hTTPDisposition = new HTTPDisposition();
                        object3 = parameters.get(Parameters.GeneralImage.o\u00d30000);
                        Object object4 = object3 != null ? object3 : (string != null ? string.substring(string.lastIndexOf("/") + 1) : "download.bin");
                        HashMap<String, String> hashMap2 = hTTPDisposition.getHeader(httpServletRequest.getHeader("User-Agent"), (String)object4, outputCompressorResponse.getImageData().length, outputCompressorResponse.getMimeType());
                        for (Map.Entry entry : hashMap2.entrySet()) {
                            cacheableHttpServletResponse.addHeader((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
                cacheableHttpServletResponse.setETag();
                this.checkForNotModified(parameters, httpServletRequest, cacheableHttpServletResponse);
                if (cacheableHttpServletResponse.isNotModifiedSent()) {
                    this.writeChunkedNG(cacheableHttpServletResponse, outputCompressorResponse.getImageData(), true);
                } else {
                    long l7 = System.currentTimeMillis() - cacheableHttpServletResponse.getRequestStartTime();
                    this.null.setTTFB(l7);
                    if (this.newsuper.hasNeLaDebug()) {
                        cacheableHttpServletResponse.addHeader("X-TTFB", Long.toString(l7) + "ms");
                    }
                    this.writeChunkedNG(cacheableHttpServletResponse, outputCompressorResponse.getImageData(), false);
                }
            } else if (n2 != 304) {
                cacheableHttpServletResponse.setCachable(false);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.newsuper.logException(illegalArgumentException, 4000, illegalArgumentException.getLocalizedMessage(), httpServletRequest.getMethod() + " " + httpServletRequest.getQueryString());
            cacheableHttpServletResponse.sendError(400, illegalArgumentException.getLocalizedMessage());
        }
        catch (ImageManipulatorException imageManipulatorException) {
            this.newsuper.logException(imageManipulatorException, 4000, imageManipulatorException.getLocalizedMessage(), httpServletRequest.getMethod() + " " + httpServletRequest.getQueryString());
            cacheableHttpServletResponse.sendError(500, imageManipulatorException.getLocalizedMessage());
        }
        catch (ProcessingException processingException) {
            this.newsuper.logException(processingException, 4000, processingException.getLocalizedMessage(), httpServletRequest.getMethod() + " " + httpServletRequest.getQueryString());
            cacheableHttpServletResponse.sendError(503, processingException.getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {
            cacheableHttpServletResponse.sendError(503, interruptedException.getLocalizedMessage());
        }
    }

    private OutputFormat getOutputFormat(Parameters parameters, Renderer renderer) {
        OutputFormat outputFormat = null;
        String string = parameters.get(Parameters.GeneralImage.O\u00d40000);
        if (string != null) {
            outputFormat = OutputFormat.valueOf(string.toUpperCase());
        }
        if (outputFormat == null) {
            outputFormat = renderer.getOutputFormat();
        }
        return outputFormat;
    }

    private void handleDirectoryRequest(HttpServletRequest httpServletRequest, CacheableHttpServletResponse cacheableHttpServletResponse, int n) throws ServletException, IOException {
        Object object;
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        String string = parameters.getAssetURLPath();
        long l = System.currentTimeMillis();
        Renderer renderer = this.determineRenderer(parameters, (HttpServletResponse)cacheableHttpServletResponse);
        if (renderer == null) {
            return;
        }
        RendererAbstract rendererAbstract = renderer.getDirectoryImageRenderer();
        if (rendererAbstract == null) {
            cacheableHttpServletResponse.setCachable(false);
            cacheableHttpServletResponse.sendError(404);
            return;
        }
        try {
            object = httpServletRequest.getSession(false);
            if (!this.checkRendererProtection(rendererAbstract, string, (HttpSession)object)) {
                cacheableHttpServletResponse.setStatus(403);
                cacheableHttpServletResponse.setCachable(false);
                return;
            }
        }
        catch (NotConfiguredException notConfiguredException) {
            cacheableHttpServletResponse.setCachable(false);
            cacheableHttpServletResponse.sendError(503, notConfiguredException.getLocalizedMessage());
            return;
        }
        object = new HashMap();
        Set<String> set = rendererAbstract.getRequiredMetaData();
        List<MetaDataSource> list = renderer.getMetaDataSources();
        for (MetaDataSource metaDataSource : list) {
            Map<String, Object> map = metaDataSource.getMetaData(string, set);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                object.put(entry.getKey(), entry.getValue());
            }
        }
        if (!this.isMetadataComplete(set, (Map<String, Object>)object)) {
            this.sendIncompleteMetaDataResponse((HttpServletResponse)cacheableHttpServletResponse);
            cacheableHttpServletResponse.setCachable(false);
            this.newsuper.log(4001, httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI());
            return;
        }
        try {
            RendererResponse rendererResponse = rendererAbstract.processRequest(httpServletRequest, (Map<String, Object>)object);
            cacheableHttpServletResponse.setCachable(rendererResponse.isCacheable());
            cacheableHttpServletResponse.setPixels(rendererResponse.getPixels());
            long l2 = System.currentTimeMillis();
            int n2 = rendererResponse.getStatus();
            cacheableHttpServletResponse.setStatus(n2);
            this.transferRendererResponseHeaders(cacheableHttpServletResponse, rendererResponse, n2);
            long l3 = rendererResponse.getDateHeader("Last-Modified");
            cacheableHttpServletResponse.setLastModified(l3);
            if (n2 >= 200 && n2 < 300) {
                if (rendererResponse instanceof RendererImageResponse) {
                    OutputCompressorResponse outputCompressorResponse;
                    long l4;
                    long l5;
                    FSIImage[] fSIImageArray;
                    RendererImageResponse rendererImageResponse = (RendererImageResponse)rendererResponse;
                    this.setPredefinedResponseHeaders(httpServletRequest, cacheableHttpServletResponse, rendererResponse, rendererImageResponse.getImage().getWidth(), rendererImageResponse.getImage().getHeight(), "image.default", n2);
                    OutputFormat outputFormat = this.getOutputFormat(parameters, renderer);
                    OutputCompressor outputCompressor = this.\u00d3O0000.get((Object)outputFormat);
                    String string2 = this.getCopyrightNoticeForAsset(string);
                    if (rendererImageResponse.isMultiImageResponse() && outputCompressor.hasMultiImageSupport()) {
                        FSIServerSettings.LicenceState licenceState;
                        fSIImageArray = rendererImageResponse.getImageList();
                        l5 = System.currentTimeMillis();
                        if (renderer.getOutputEffects().size() > 0) {
                            fSIImageArray = this.applyRendererEffects(fSIImageArray, rendererImageResponse.getSelectionsRaws(), renderer.getOutputEffects(), parameters);
                            cacheableHttpServletResponse.getETag().addModifier(renderer.getOutputEffectsChecksum());
                        }
                        if (parameters.contains(Parameters.GeneralImage.StringObject)) {
                            fSIImageArray = this.applyQueryEffects(fSIImageArray, rendererImageResponse.getSelectionsRaws(), parameters, parameters.get(Parameters.GeneralImage.StringObject));
                        }
                        if ((licenceState = this.\u00d5O0000.isLicensed()) != FSIServerSettings.LicenceState.\u00f600000 && !rendererResponse.isLicenceImage()) {
                            for (FSIImage fSIImage : fSIImageArray) {
                                FSIServerWatermark.transform(fSIImage, Defines.\u00d3\u00d40000);
                            }
                            this.setLicenceCommentHeader(cacheableHttpServletResponse, licenceState, n2);
                            cacheableHttpServletResponse.getETag().addModifier("unlic");
                        } else {
                            cacheableHttpServletResponse.getETag().addModifier("lic");
                        }
                        l4 = System.currentTimeMillis();
                        outputCompressorResponse = outputCompressor.compressImageData(n, fSIImageArray, renderer, parameters, string2);
                        for (FSIImage fSIImage : fSIImageArray) {
                            fSIImage.dispose();
                        }
                    } else {
                        FSIServerSettings.LicenceState licenceState;
                        fSIImageArray = rendererImageResponse.getImage();
                        l5 = System.currentTimeMillis();
                        if (renderer.getOutputEffects().size() > 0) {
                            fSIImageArray = this.applyRendererEffects((FSIImage)fSIImageArray, rendererImageResponse.getSelectionsRaw(), renderer.getOutputEffects(), parameters);
                        }
                        if (parameters.contains(Parameters.GeneralImage.StringObject)) {
                            fSIImageArray = this.applyQueryEffects((FSIImage)fSIImageArray, rendererImageResponse.getSelectionsRaw(), parameters, parameters.get(Parameters.GeneralImage.StringObject));
                        }
                        if ((licenceState = this.\u00d5O0000.isLicensed()) != FSIServerSettings.LicenceState.\u00f600000 && !rendererResponse.isLicenceImage()) {
                            this.setLicenceCommentHeader(cacheableHttpServletResponse, licenceState, n2);
                            cacheableHttpServletResponse.getETag().addModifier("unlic");
                        } else {
                            cacheableHttpServletResponse.getETag().addModifier("lic");
                        }
                        l4 = System.currentTimeMillis();
                        outputCompressorResponse = outputCompressor.compressImageData(n, (FSIImage)fSIImageArray, renderer, parameters, string2);
                        fSIImageArray.dispose();
                    }
                    long l6 = System.currentTimeMillis();
                    this.newsuper.log(3000, n, l2 - l, l4 - l5, l6 - l4);
                    if (outputCompressorResponse.getImageData() != null) {
                        cacheableHttpServletResponse.setContentType(outputCompressorResponse.getMimeType());
                        cacheableHttpServletResponse.setContentLength(outputCompressorResponse.getImageData().length);
                        cacheableHttpServletResponse.getETag().addModifier(outputCompressorResponse.getETagModifier());
                        cacheableHttpServletResponse.setETag();
                        this.checkForNotModified(parameters, httpServletRequest, cacheableHttpServletResponse);
                        if (cacheableHttpServletResponse.isNotModifiedSent()) {
                            this.writeChunkedNG(cacheableHttpServletResponse, outputCompressorResponse.getImageData(), true);
                        } else {
                            this.null.setTTFB(System.currentTimeMillis() - cacheableHttpServletResponse.getRequestStartTime());
                            this.writeChunkedNG(cacheableHttpServletResponse, outputCompressorResponse.getImageData(), false);
                        }
                    }
                }
            } else if (n2 != 304) {
                cacheableHttpServletResponse.setCachable(false);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.newsuper.logException(illegalArgumentException, 4000, illegalArgumentException.getLocalizedMessage(), httpServletRequest.getMethod() + " " + httpServletRequest.getQueryString());
            cacheableHttpServletResponse.sendError(400, illegalArgumentException.getLocalizedMessage());
        }
        catch (ImageManipulatorException imageManipulatorException) {
            this.newsuper.logException(imageManipulatorException, 4000, imageManipulatorException.getLocalizedMessage(), httpServletRequest.getMethod() + " " + httpServletRequest.getQueryString());
            cacheableHttpServletResponse.sendError(500, imageManipulatorException.getLocalizedMessage());
        }
        catch (ProcessingException processingException) {
            this.newsuper.logException(processingException, 4000, processingException.getLocalizedMessage(), httpServletRequest.getMethod() + " " + httpServletRequest.getQueryString());
            cacheableHttpServletResponse.sendError(503, processingException.getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {
            cacheableHttpServletResponse.sendError(503, interruptedException.getLocalizedMessage());
        }
    }

    private void checkForNotModified(Parameters parameters, HttpServletRequest httpServletRequest, CacheableHttpServletResponse cacheableHttpServletResponse) throws IOException {
        long l;
        boolean bl = false;
        boolean bl2 = false;
        try {
            l = httpServletRequest.getDateHeader("If-Modified-Since") / 1000L * 1000L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            l = 0L;
        }
        if (l > 0L) {
            bl2 = true;
            if (l == cacheableHttpServletResponse.getLastModified()) {
                bl = true;
            }
        }
        boolean bl3 = false;
        boolean bl4 = false;
        String string = httpServletRequest.getHeader("If-None-Match");
        if (string != null) {
            bl3 = true;
            if (string.equals(cacheableHttpServletResponse.getETag().getStrongTag(parameters.getAssetURLHash(), parameters.hashCode64()))) {
                bl4 = true;
            }
        }
        if (!(!bl2 && !bl3 || bl2 && !bl || bl3 && !bl4)) {
            cacheableHttpServletResponse.sendError(304);
        }
    }

    private void setLicenceCommentHeader(CacheableHttpServletResponse cacheableHttpServletResponse, FSIServerSettings.LicenceState licenceState, int n) {
        switch (licenceState) {
            case \u00d600000: {
                cacheableHttpServletResponse.addHeader("X-Comment", "Licence expired");
                break;
            }
            case super: {
                cacheableHttpServletResponse.addHeader("X-Comment", "Max Images exceeded");
                break;
            }
            case \u00f800000: {
                cacheableHttpServletResponse.addHeader("X-Comment", "Max Source Connectors exceeded");
                break;
            }
            case int: {
                cacheableHttpServletResponse.addHeader("X-Comment", "Max User Groups exceeded");
                break;
            }
            case \u00f400000: {
                cacheableHttpServletResponse.addHeader("X-Comment", "No Licence installed");
                break;
            }
            case class: {
                cacheableHttpServletResponse.addHeader("X-Comment", "Invalid Licence installed");
                break;
            }
            case \u00d400000: {
                cacheableHttpServletResponse.addHeader("X-Comment", "Invalid Hardware ID");
            }
        }
        if (n < 300) {
            cacheableHttpServletResponse.setHeader("Cache-Control", "private, must-revalidate");
        }
    }

    private boolean isMetadataComplete(Set<String> set, Map<String, Object> map) {
        boolean bl = true;
        for (String string : set) {
            if (map.containsKey(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private FSIImage applyRendererEffects(FSIImage fSIImage, byte[] byArray, List<String> list, Parameters parameters) throws ProcessingException {
        try {
            for (String string : list) {
                if (string == null) continue;
                fSIImage = this.\u00d300000.applyEffects(fSIImage, byArray, string, parameters);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.newsuper.log(3153, null, illegalArgumentException.getLocalizedMessage(), "");
        }
        return fSIImage;
    }

    private FSIImage[] applyRendererEffects(FSIImage[] fSIImageArray, byte[][] byArray, List<String> list, Parameters parameters) throws ProcessingException {
        for (int i = 0; i < fSIImageArray.length; ++i) {
            if (fSIImageArray[i] == null) continue;
            fSIImageArray[i] = this.applyRendererEffects(fSIImageArray[i], byArray[i], list, parameters);
        }
        return fSIImageArray;
    }

    private FSIImage applyQueryEffects(FSIImage fSIImage, byte[] byArray, Parameters parameters, String string) throws ProcessingException {
        try {
            fSIImage = this.\u00d300000.applyEffects(fSIImage, byArray, string, parameters);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.newsuper.log(3153, null, illegalArgumentException.getLocalizedMessage(), "");
        }
        return fSIImage;
    }

    private FSIImage[] applyQueryEffects(FSIImage[] fSIImageArray, byte[][] byArray, Parameters parameters, String string) throws ProcessingException {
        for (int i = 0; i < fSIImageArray.length; ++i) {
            fSIImageArray[i] = byArray != null ? this.applyQueryEffects(fSIImageArray[i], byArray[i], parameters, string) : this.applyQueryEffects(fSIImageArray[i], null, parameters, string);
        }
        return fSIImageArray;
    }

    private void handleTextRequest(HttpServletRequest httpServletRequest, CacheableHttpServletResponse cacheableHttpServletResponse, int n) throws ServletException, IOException {
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        Parameters.Type type = parameters.getType();
        cacheableHttpServletResponse.setCharacterEncoding("UTF-8");
        if (type == Parameters.Type.o00000) {
            Renderer renderer = this.determineRenderer(parameters, (HttpServletResponse)cacheableHttpServletResponse);
            if (renderer != null) {
                try {
                    if (!this.checkRendererProtection(renderer.getInfoRenderer(), parameters.getAssetURLPath(), httpServletRequest.getSession(false))) {
                        cacheableHttpServletResponse.setStatus(403);
                        cacheableHttpServletResponse.setCachable(false);
                        return;
                    }
                }
                catch (NotConfiguredException notConfiguredException) {
                    cacheableHttpServletResponse.setCachable(false);
                    cacheableHttpServletResponse.sendError(503, notConfiguredException.getLocalizedMessage());
                }
                this.processInfoAndListRequest(httpServletRequest, parameters, cacheableHttpServletResponse, renderer, n);
            }
        } else if (type == Parameters.Type.\u00d500000) {
            Renderer renderer = this.determineRenderer(parameters, (HttpServletResponse)cacheableHttpServletResponse);
            if (renderer != null) {
                try {
                    if (!this.checkRendererProtection(renderer.getListRenderer(), parameters.getAssetURLPath(), httpServletRequest.getSession(false))) {
                        cacheableHttpServletResponse.setStatus(403);
                        cacheableHttpServletResponse.setCachable(false);
                        return;
                    }
                }
                catch (NotConfiguredException notConfiguredException) {
                    cacheableHttpServletResponse.setCachable(false);
                    cacheableHttpServletResponse.sendError(503, notConfiguredException.getLocalizedMessage());
                }
                this.processInfoAndListRequest(httpServletRequest, parameters, cacheableHttpServletResponse, renderer, n);
            }
        } else if (type == Parameters.Type.\u00f500000 || type == Parameters.Type.new) {
            this.processSearchRequest(httpServletRequest, parameters, cacheableHttpServletResponse);
        } else if (type == Parameters.Type.\u00f400000) {
            this.processAppInfoRequest(httpServletRequest, cacheableHttpServletResponse);
        } else if (type == Parameters.Type.return) {
            this.processLicenceInfoRequest(httpServletRequest, cacheableHttpServletResponse);
        }
    }

    private void setPredefinedResponseHeaders(HttpServletRequest httpServletRequest, CacheableHttpServletResponse cacheableHttpServletResponse, RendererResponse rendererResponse, int n, int n2, String string, int n3) {
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        if (parameters == null) {
            return;
        }
        String string2 = parameters.getAssetURLPath();
        SourceConnectorReader sourceConnectorReader = null;
        if (string2 != null) {
            sourceConnectorReader = this.\u00d5O0000.getSourceConnectorFromAssetURLPath(string2);
        }
        if (sourceConnectorReader == null) {
            if (parameters.contains(Parameters.General.\u00f8\u00d40000)) {
                Map<String, String> map = this.\u00d5O0000.getHeaderSet(parameters.get(Parameters.General.\u00f8\u00d40000));
                this.transferHeaders(map, (HttpServletResponse)cacheableHttpServletResponse, rendererResponse, n, n2, n3);
            } else {
                Map<String, String> map = this.\u00d5O0000.getHeaderSet(string);
                this.transferHeaders(map, (HttpServletResponse)cacheableHttpServletResponse, rendererResponse, n, n2, n3);
            }
            this.sessionOverwriteHeader(httpServletRequest, (HttpServletResponse)cacheableHttpServletResponse);
            return;
        }
        Map<String, String> map = this.\u00d5O0000.getHeaderSet(sourceConnectorReader.getForceHeadersName());
        if (map != null) {
            this.transferHeaders(map, (HttpServletResponse)cacheableHttpServletResponse, rendererResponse, n, n2, n3);
        } else if (parameters.contains(Parameters.General.\u00f8\u00d40000)) {
            Map<String, String> map2 = this.\u00d5O0000.getHeaderSet(parameters.get(Parameters.General.\u00f8\u00d40000));
            this.transferHeaders(map2, (HttpServletResponse)cacheableHttpServletResponse, rendererResponse, n, n2, n3);
        } else {
            String string3 = sourceConnectorReader.getHeadersName();
            if (string3 == null && string != null) {
                string3 = string;
            }
            Map<String, String> map3 = this.\u00d5O0000.getHeaderSet(string3);
            this.transferHeaders(map3, (HttpServletResponse)cacheableHttpServletResponse, rendererResponse, n, n2, n3);
        }
        this.sessionOverwriteHeader(httpServletRequest, (HttpServletResponse)cacheableHttpServletResponse);
    }

    private void sessionOverwriteHeader(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Map<String, String> map;
        if (httpServletRequest.getSession(false) != null && (map = this.\u00d5O0000.getHeaderSet("webinterface")) != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpServletResponse.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private void transferHeaders(Map<String, String> map, HttpServletResponse httpServletResponse, RendererResponse rendererResponse, int n, int n2, int n3) {
        if (map != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                if (string.equalsIgnoreCase("Cache-Control") && n3 >= 300) continue;
                String string2 = entry.getValue();
                if (rendererResponse != null && rendererResponse.getMetaData() != null && rendererResponse.getMetaData() instanceof ImageMetaData) {
                    ImageMetaData imageMetaData = (ImageMetaData)rendererResponse.getMetaData();
                    Matcher matcher = this.\u00d2O0000.matcher(string2);
                    while (matcher.find()) {
                        arrayList.add(matcher.group(1));
                    }
                    for (String string3 : arrayList) {
                        String string4;
                        if (string3.equalsIgnoreCase("SRC.WIDTH")) {
                            string4 = Integer.toString(imageMetaData.getWidth());
                        } else if (string3.equalsIgnoreCase("SRC.HEIGHT")) {
                            string4 = Integer.toString(imageMetaData.getHeight());
                        } else if (string3.equalsIgnoreCase("SRC.LEVEL")) {
                            Level[] levelArray = imageMetaData.getZoomLevels();
                            if (levelArray != null) {
                                StringBuilder stringBuilder = new StringBuilder();
                                for (Level level : levelArray) {
                                    stringBuilder.append(level.\u00d400000);
                                    stringBuilder.append('x');
                                    stringBuilder.append(level.o00000);
                                    stringBuilder.append('@');
                                    stringBuilder.append(level.Object);
                                    stringBuilder.append('x');
                                    stringBuilder.append(level.\u00d200000);
                                    stringBuilder.append(' ');
                                }
                                string4 = stringBuilder.toString();
                            } else {
                                string4 = "";
                            }
                        } else {
                            string4 = string3.equalsIgnoreCase("WIDTH") && n > 0 ? Integer.toString(n) : (string3.equalsIgnoreCase("HEIGHT") && n2 > 0 ? Integer.toString(n2) : "");
                        }
                        string2 = string2.replaceAll("\\{" + string3 + "\\}", string4);
                    }
                }
                if (string2 == null || string2.equals("")) continue;
                httpServletResponse.addHeader(string, string2);
            }
        }
    }

    private void processLicenceInfoRequest(HttpServletRequest httpServletRequest, CacheableHttpServletResponse cacheableHttpServletResponse) {
        try {
            UserAuthenticationInterface userAuthenticationInterface = this.\u00d5O0000.getUserAuthenticationInterface();
            HttpSession httpSession = httpServletRequest.getSession(false);
            PermissionSet permissionSet = userAuthenticationInterface.getPermissions((SourceConnectorReader)null, httpSession, true);
            if (permissionSet == null || !permissionSet.general.readLicence.booleanValue()) {
                cacheableHttpServletResponse.setStatus(403);
                return;
            }
            ObjectNode objectNode = this.\u00d5O0000.getLicenceInfoAsJSON(this.\u00d5O0000.getLicence(), this.\u00d5O0000.getLicenceContainerHash());
            ObjectMapper objectMapper = new ObjectMapper();
            String string = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)objectNode);
            byte[] byArray = string.getBytes(FileOperations.new);
            cacheableHttpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            cacheableHttpServletResponse.setStatus(200);
            cacheableHttpServletResponse.setContentType("application/json");
            cacheableHttpServletResponse.setContentLength(byArray.length);
            this.writeChunkedNG(cacheableHttpServletResponse, byArray, false);
        }
        catch (IOException iOException) {
            cacheableHttpServletResponse.setStatus(500);
        }
    }

    private void processAppInfoRequest(HttpServletRequest httpServletRequest, CacheableHttpServletResponse cacheableHttpServletResponse) throws IOException {
        RawLicence rawLicence;
        FSIServerSettings.LicenceState licenceState = this.\u00d5O0000.isLicensed();
        LicenceManager licenceManager = this.\u00d5O0000.getLicenceManager();
        Integer n = -1;
        Integer n2 = -1;
        if (licenceState != FSIServerSettings.LicenceState.\u00f600000 || licenceManager == null) {
            rawLicence = null;
        } else {
            try {
                n = Integer.valueOf(httpServletRequest.getParameter("appid"));
                n2 = Integer.valueOf(httpServletRequest.getParameter("version"));
                rawLicence = n2 == -1 || n < 100 || n > 199 ? null : licenceManager.getRawLicence(n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                rawLicence = null;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        stringBuilder.append("<fsi_parameter>");
        String string = httpServletRequest.getParameter("lcid");
        if (string != null) {
            string = string.substring(0, Math.min(64, string.length()));
        }
        String string2 = this.\u00d5O0000.getLicence().getFSIViewerLCID();
        if (rawLicence != null && string != null && string2 != null && n == 101 && n2 >= 6) {
            stringBuilder.append("<licence lcid=\"");
            stringBuilder.append(this.hashCodeFSIViewer(string + string2));
            stringBuilder.append("\">");
        } else {
            int n3 = rawLicence == null ? 1001 : (string == null ? 1002 : (string2 == null ? 1003 : (n != 101 ? 1004 : (n2 < 6 ? 1005 : 1100))));
            stringBuilder.append("<licence keymsg=\"" + n3 + "\">");
        }
        stringBuilder.append(rawLicence.\u00d500000);
        cacheableHttpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        stringBuilder.append("</licence>");
        stringBuilder.append("</fsi_parameter>");
        String string3 = stringBuilder.toString();
        cacheableHttpServletResponse.setStatus(200);
        cacheableHttpServletResponse.setContentType("application/xml");
        cacheableHttpServletResponse.setContentLength(string3.length());
        this.null.setTTFB(System.currentTimeMillis() - cacheableHttpServletResponse.getRequestStartTime());
        this.writeChunkedNG(cacheableHttpServletResponse, string3.getBytes(FileOperations.new), false);
    }

    private long hashCodeFSIViewer(String string) {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l = 31L * l + (long)string.charAt(i) & Integer.MAX_VALUE;
        }
        return l;
    }

    private void processInfoAndListRequest(HttpServletRequest httpServletRequest, Parameters parameters, CacheableHttpServletResponse cacheableHttpServletResponse, Renderer renderer, int n) throws IOException {
        String string = parameters.getAssetURLPath();
        ETag eTag = cacheableHttpServletResponse.getETag();
        RendererAbstract rendererAbstract = parameters.getType() == Parameters.Type.o00000 ? renderer.getInfoRenderer() : renderer.getListRenderer();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Set<String> set = rendererAbstract.getRequiredMetaData();
        List<MetaDataSource> list = renderer.getMetaDataSources();
        for (MetaDataSource object : list) {
            Map<String, Object> n2 = object.getMetaData(string, set);
            for (Map.Entry<String, Object> entry : n2.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        eTag.addModifier(parameters.getType().name() + hashMap.hashCode());
        boolean bl = httpServletRequest.getAttribute("headrequest") != null && (Boolean)httpServletRequest.getAttribute("headrequest") != false;
        try {
            FSIServerSettings.LicenceState licenceState;
            RendererResponse processingException = rendererAbstract.processRequest(httpServletRequest, hashMap);
            int n2 = processingException.getStatus();
            cacheableHttpServletResponse.setStatus(n2);
            cacheableHttpServletResponse.setCachable(n2 == 200 && processingException.isCacheable());
            this.transferRendererResponseHeaders(cacheableHttpServletResponse, processingException, n2);
            long l = processingException.getDateHeader("Last-Modified");
            if (l > 0L) {
                cacheableHttpServletResponse.setLastModified(l);
            }
            if ((licenceState = this.\u00d5O0000.isLicensed()) != FSIServerSettings.LicenceState.\u00f600000) {
                this.setLicenceCommentHeader(cacheableHttpServletResponse, licenceState, n2);
                eTag.addModifier("lic");
            } else {
                eTag.addModifier("unlic");
            }
            this.checkForNotModified(parameters, httpServletRequest, cacheableHttpServletResponse);
            this.setPredefinedResponseHeaders(httpServletRequest, cacheableHttpServletResponse, null, 0, 0, parameters.getType().name() + ".default", n2);
            if (cacheableHttpServletResponse.isNotModifiedSent()) {
                String string3 = ((RendererTextResponse)processingException).getBody();
                if (string3 != null) {
                    byte[] byArray = string3.getBytes(FileOperations.new);
                    cacheableHttpServletResponse.setContentType(processingException.getContentType());
                    cacheableHttpServletResponse.setContentLength(byArray.length);
                    cacheableHttpServletResponse.setETag();
                    this.null.setTTFB(System.currentTimeMillis() - cacheableHttpServletResponse.getRequestStartTime());
                    this.writeChunkedNG(cacheableHttpServletResponse, byArray, true);
                }
            } else {
                String string2 = ((RendererTextResponse)processingException).getBody();
                if (!bl && string2 != null) {
                    byte[] byArray = string2.getBytes(FileOperations.new);
                    cacheableHttpServletResponse.setContentType(processingException.getContentType());
                    if (byArray != null) {
                        cacheableHttpServletResponse.setContentLength(byArray.length);
                        cacheableHttpServletResponse.setETag();
                        this.null.setTTFB(System.currentTimeMillis() - cacheableHttpServletResponse.getRequestStartTime());
                        this.writeChunkedNG(cacheableHttpServletResponse, byArray, false);
                    }
                }
            }
        }
        catch (ProcessingException interruptedException) {
            this.newsuper.logException(interruptedException, 4000, interruptedException.getLocalizedMessage(), httpServletRequest.getMethod() + " " + httpServletRequest.getQueryString());
            cacheableHttpServletResponse.sendError(503, interruptedException.getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {
            cacheableHttpServletResponse.sendError(503, interruptedException.getLocalizedMessage());
        }
    }

    private void processSearchRequest(HttpServletRequest httpServletRequest, Parameters parameters, CacheableHttpServletResponse cacheableHttpServletResponse) throws IOException {
        SearchProcessor searchProcessor = this.\u00d6O0000.get((Object)parameters.getType());
        RendererTextResponse rendererTextResponse = searchProcessor.search(this.\u00f600000, parameters, httpServletRequest.getSession(false));
        int n = rendererTextResponse.getStatus();
        cacheableHttpServletResponse.setCachable(rendererTextResponse.isCacheable());
        cacheableHttpServletResponse.getETag().addModifier(rendererTextResponse.getETagModifier());
        this.transferRendererResponseHeaders(cacheableHttpServletResponse, rendererTextResponse, n);
        cacheableHttpServletResponse.setStatus(n);
        FSIServerSettings.LicenceState licenceState = this.\u00d5O0000.isLicensed();
        if (licenceState != FSIServerSettings.LicenceState.\u00f600000) {
            this.setLicenceCommentHeader(cacheableHttpServletResponse, licenceState, n);
            cacheableHttpServletResponse.getETag().addModifier("unlic");
        } else {
            cacheableHttpServletResponse.getETag().addModifier("lic");
        }
        this.setPredefinedResponseHeaders(httpServletRequest, cacheableHttpServletResponse, null, 0, 0, "list.default", n);
        this.checkForNotModified(parameters, httpServletRequest, cacheableHttpServletResponse);
        if (cacheableHttpServletResponse.getStatus() >= 200 && cacheableHttpServletResponse.getStatus() < 300) {
            if (httpServletRequest.getAttribute("headrequest") == null || !((Boolean)httpServletRequest.getAttribute("headrequest")).booleanValue()) {
                String string = rendererTextResponse.getBody();
                byte[] byArray = string.getBytes(FileOperations.new);
                cacheableHttpServletResponse.setContentType(rendererTextResponse.getContentType());
                cacheableHttpServletResponse.setETag();
                if (byArray != null) {
                    cacheableHttpServletResponse.setContentLength(byArray.length);
                    this.null.setTTFB(System.currentTimeMillis() - cacheableHttpServletResponse.getRequestStartTime());
                    this.writeChunkedNG(cacheableHttpServletResponse, byArray, false);
                }
            }
        } else {
            cacheableHttpServletResponse.setContentType("application/json");
            if (rendererTextResponse.getBody() != null) {
                byte[] byArray = rendererTextResponse.getBody().getBytes(FileOperations.new);
                cacheableHttpServletResponse.setContentLength(byArray.length);
                this.writeChunkedNG(cacheableHttpServletResponse, byArray, false);
            }
        }
    }

    private void transferRendererResponseHeaders(CacheableHttpServletResponse cacheableHttpServletResponse, RendererResponse rendererResponse, int n) {
        Map<String, Object> map = rendererResponse.getHeaders();
        for (Map.Entry<String, Object> object22 : map.entrySet()) {
            String string = object22.getKey();
            Object object = object22.getValue();
            if (string.equalsIgnoreCase("Last-Modified") && object instanceof Long) {
                cacheableHttpServletResponse.addDateHeader(string, (Long)object);
                continue;
            }
            if (string.equalsIgnoreCase("Cache-Control") && (!string.equalsIgnoreCase("Cache-Control") || n >= 300)) continue;
            cacheableHttpServletResponse.addHeader(string, object.toString());
        }
        Map<String, Long> map2 = rendererResponse.getDateHeaders();
        for (Map.Entry entry : map2.entrySet()) {
            cacheableHttpServletResponse.addDateHeader((String)entry.getKey(), (Long)entry.getValue());
        }
        String string = rendererResponse.getETagModifier();
        if (string != null) {
            ETag eTag = cacheableHttpServletResponse.getETag();
            eTag.addModifier(string);
        }
    }

    private void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletRequest.setAttribute("headrequest", (Object)true);
        if (this.null != null) {
            this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_METHOD_HEAD);
        }
        this.doGet(httpServletRequest, httpServletResponse);
    }

    private void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletRequest.setAttribute("cacheable", (Object)true);
        if (this.null != null) {
            this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_METHOD_POST);
        }
        this.doRequest(httpServletRequest, httpServletResponse);
    }

    private void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.null != null) {
            this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_METHOD_GET);
        }
        try {
            this.doRequest(httpServletRequest, httpServletResponse);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.sendInvalidParameterValueResponse(httpServletResponse, "url", "");
        }
    }

    public String handleBatchRequest(Parameters parameters, OutputStream outputStream) throws ServletException, IOException {
        MockHttpServletRequest mockHttpServletRequest = new MockHttpServletRequest(String);
        mockHttpServletRequest.setServletPath("server");
        for (Map.Entry<Parameters.Parameter, String> object2 : parameters.entrySet()) {
            mockHttpServletRequest.addParameter(object2.getKey().toString(), object2.getValue());
        }
        mockHttpServletRequest.setAttribute("parameters", parameters);
        mockHttpServletRequest.setAttribute("cacheable", false);
        Object object3 = null;
        try (ServletOutputStreamWrapper servletOutputStreamWrapper = new ServletOutputStreamWrapper(outputStream);){
            object3 = new MockHttpServletResponse(servletOutputStreamWrapper);
            this.doRequest(mockHttpServletRequest, (HttpServletResponse)object3);
        }
        return ((MockHttpServletResponse)object3).getContentType();
    }

    private void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Charset charset;
        String string;
        String string2;
        String string3 = httpServletRequest.getServletPath();
        String string4 = null;
        if (string3.startsWith("/static")) {
            string4 = httpServletRequest.getPathInfo();
            string2 = "static.default";
        } else {
            string4 = httpServletRequest.getParameter("source");
            string2 = httpServletRequest.getParameter("type") + ".default";
        }
        String string5 = httpServletRequest.getCharacterEncoding();
        if (string5 == null) {
            string5 = "UTF-8";
        }
        if ((string = URLDecoderFast.decode(string4, charset = Charset.forName(string5))) == null) {
            return;
        }
        SourceConnectorReader sourceConnectorReader = this.\u00d5O0000.getSourceConnectorFromAssetURLPath(string);
        if (sourceConnectorReader == null) {
            return;
        }
        Map<String, String> map = this.\u00d5O0000.getHeaderSet(sourceConnectorReader.getForceHeadersName());
        if (map != null) {
            this.transferHeaders(map, httpServletResponse, null, 0, 0, 300);
        } else {
            String string6 = sourceConnectorReader.getHeadersName();
            if (string6 == null) {
                string6 = string2;
            }
            Map<String, String> map2 = this.\u00d5O0000.getHeaderSet(string6);
            this.transferHeaders(map2, httpServletResponse, null, 0, 0, 300);
        }
        this.sessionOverwriteHeader(httpServletRequest, httpServletResponse);
        httpServletResponse.setStatus(200);
    }

    private void doRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.\u00d800000 == null) {
            this.handleAcceptedRequest(httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.setStatus(503);
            try (PrintWriter printWriter = httpServletResponse.getWriter();){
                new Version();
                printWriter.write(SoftwareVersion.getSoftware(true) + " not started");
                printWriter.write("\n");
                printWriter.write(this.\u00d800000);
                printWriter.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAcceptedRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        String string2;
        CacheableHttpServletResponse cacheableHttpServletResponse = null;
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        String string3 = null;
        if (parameters != null) {
            string3 = parameters.getAssetURLPath();
        }
        try {
            int n;
            long l;
            long l2;
            this.for.incrementAndGet();
            this.null.setConcurrentProcessing(this.o00000.incrementAndGet());
            long l3 = System.currentTimeMillis();
            string2 = httpServletRequest.getServletPath();
            if (parameters != null) {
                l2 = parameters.getAssetURLHash();
                l = parameters.hashCode64();
            } else {
                l2 = 0L;
                l = 0L;
            }
            cacheableHttpServletResponse = new CacheableHttpServletResponse(httpServletResponse, l2, l);
            cacheableHttpServletResponse.setRequestStartTime(l3);
            if (string2.startsWith("/static")) {
                this.\u00d200000.handleRequest(httpServletRequest, cacheableHttpServletResponse);
                this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_STATIC);
                if (httpServletRequest.getAttribute("headrequest") == null) {
                    this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL, cacheableHttpServletResponse.getContentLength());
                    this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_STATIC, cacheableHttpServletResponse.getContentLength());
                }
            } else if (parameters != null) {
                if (parameters.getType() == Parameters.Type.if) {
                    long l4;
                    this.handleImageRequest(httpServletRequest, cacheableHttpServletResponse, this.for.get());
                    this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_IMAGE);
                    if (httpServletRequest.getAttribute("headrequest") == null) {
                        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_IMAGE, cacheableHttpServletResponse.getContentLength());
                        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL, cacheableHttpServletResponse.getContentLength());
                    }
                    if ((l4 = cacheableHttpServletResponse.getPixels()) != 0L) {
                        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_PIXEL_ALL, l4);
                    }
                } else if (parameters.getType() == Parameters.Type.\u00d300000) {
                    this.handleDirectoryRequest(httpServletRequest, cacheableHttpServletResponse, this.for.get());
                } else if (parameters.getType() == Parameters.Type.o00000) {
                    this.handleTextRequest(httpServletRequest, cacheableHttpServletResponse, this.for.get());
                    this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_INFO);
                    if (httpServletRequest.getAttribute("headrequest") == null) {
                        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_INFO, cacheableHttpServletResponse.getContentLength());
                        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL, cacheableHttpServletResponse.getContentLength());
                    }
                } else if (parameters.getType() == Parameters.Type.\u00d500000) {
                    this.handleTextRequest(httpServletRequest, cacheableHttpServletResponse, this.for.get());
                    this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_LIST);
                    if (httpServletRequest.getAttribute("headrequest") == null) {
                        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_LIST, cacheableHttpServletResponse.getContentLength());
                        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL, cacheableHttpServletResponse.getContentLength());
                    }
                } else if (parameters.getType() == Parameters.Type.\u00f500000 || parameters.getType() == Parameters.Type.new) {
                    cacheableHttpServletResponse.setCachable(false);
                    this.handleTextRequest(httpServletRequest, cacheableHttpServletResponse, this.for.get());
                    this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HITS_SEARCH);
                    if (httpServletRequest.getAttribute("headrequest") == null) {
                        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_SEARCH, cacheableHttpServletResponse.getContentLength());
                        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL, cacheableHttpServletResponse.getContentLength());
                    }
                } else if (parameters.getType() == Parameters.Type.\u00f400000 || parameters.getType() == Parameters.Type.return) {
                    cacheableHttpServletResponse.setCachable(false);
                    this.handleTextRequest(httpServletRequest, cacheableHttpServletResponse, this.for.get());
                    if (httpServletRequest.getAttribute("headrequest") == null) {
                        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL, cacheableHttpServletResponse.getContentLength());
                    }
                } else {
                    this.sendInvalidParameterValueResponse((HttpServletResponse)cacheableHttpServletResponse, "type", parameters.getType().name());
                    cacheableHttpServletResponse.setCachable(false);
                }
            }
            if ((n = cacheableHttpServletResponse.getStatus()) == 200) {
                this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_200);
            } else if (n == 302) {
                this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_302);
            } else if (n == 304) {
                this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_304);
            } else if (n == 403) {
                this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_403);
            } else if (n == 404) {
                this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_404);
            } else if (n == 500) {
                this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_500);
            } else if (n == 503) {
                this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_503);
            }
            this.null.setConcurrentProcessing(this.o00000.decrementAndGet());
            if (this.o00000.get() == 0) {
                this.for.set(0);
            }
            if (cacheableHttpServletResponse == null) return;
        }
        catch (Throwable throwable) {
            String string4;
            String string5;
            this.null.setConcurrentProcessing(this.o00000.decrementAndGet());
            if (this.o00000.get() == 0) {
                this.for.set(0);
            }
            if (cacheableHttpServletResponse == null) throw throwable;
            cacheableHttpServletResponse.close();
            if (httpServletRequest.getAttribute("cacheable") != null) {
                boolean bl = (Boolean)httpServletRequest.getAttribute("cacheable");
                cacheableHttpServletResponse.setCachable(cacheableHttpServletResponse.isCachable() && bl);
            }
            if (!cacheableHttpServletResponse.isCachable() || cacheableHttpServletResponse.getStatus() != 200) throw throwable;
            String string6 = httpServletRequest.getMethod();
            if (string3 == null || string6 == null || !string6.equals(String)) throw throwable;
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                string5 = httpSession.getId();
                string4 = this.\u00d5O0000.getUserAuthenticationInterface().getUser(string5);
            } else {
                string5 = null;
                string4 = null;
            }
            if (this.\u00f500000 == null) throw throwable;
            CacheKey cacheKey = CacheKey.calculateRequestCacheKey(string3, parameters, string5, string4, string6);
            this.\u00f500000.put(cacheKey, cacheableHttpServletResponse, true);
            throw throwable;
        }
        cacheableHttpServletResponse.close();
        if (httpServletRequest.getAttribute("cacheable") != null) {
            boolean bl = (Boolean)httpServletRequest.getAttribute("cacheable");
            cacheableHttpServletResponse.setCachable(cacheableHttpServletResponse.isCachable() && bl);
        }
        if (!cacheableHttpServletResponse.isCachable() || cacheableHttpServletResponse.getStatus() != 200) return;
        String string7 = httpServletRequest.getMethod();
        if (string3 == null || string7 == null || !string7.equals(String)) return;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            string = httpSession.getId();
            string2 = this.\u00d5O0000.getUserAuthenticationInterface().getUser(string);
        } else {
            string = null;
            string2 = null;
        }
        if (this.\u00f500000 == null) return;
        CacheKey cacheKey = CacheKey.calculateRequestCacheKey(string3, parameters, string, string2, string7);
        this.\u00f500000.put(cacheKey, cacheableHttpServletResponse, true);
    }

    private void sendIncompleteMetaDataResponse(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.sendError(400, "Not enough data to process request");
        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_400);
    }

    private void sendInvalidParameterValueResponse(HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        httpServletResponse.sendError(400, "Invalid Parameter value " + string2 + " for parameter " + string);
        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_400);
    }

    private void sendInternalServerErrorResponse(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.sendError(400, "Internal Server Error " + string);
        this.null.increaseAccumulator(SystemMonitor.Accumulators.RP_HTTP_400);
    }

    private int writeChunkedNG(CacheableHttpServletResponse cacheableHttpServletResponse, byte[] byArray, boolean bl) {
        int n = 0;
        int n2 = (int)Math.ceil((float)byArray.length / 8192.0f);
        for (int i = 0; i < n2; ++i) {
            int n3 = i + 1 == n2 ? byArray.length - i * 8192 : 8192;
            try {
                cacheableHttpServletResponse.write(byArray, i * 8192, n3, bl);
            }
            catch (Exception exception) {
                cacheableHttpServletResponse.setCachable(false);
                break;
            }
            n += n3;
        }
        return n;
    }
}

