/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.comparator.FSIStringComparator;
import com.neptunelabs.fsiserver.framework.freemarker.TemplateType;
import com.neptunelabs.fsiserver.framework.io.StringWriterFast;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.URL;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.comparators.SortMethod;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import freemarker.core.Environment;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class OverviewListRenderer
extends RendererAbstract {
    private PoolEntrySortingField \u00d5o0000;
    private SortDirection Objectnew;
    private SortMethod \u00d2o0000;
    private String O\u00d20000 = null;
    private String \u00d2\u00d20000 = null;
    private boolean \u00f5o0000 = false;
    private PoolEntrySortingField \u00d4o0000 = null;
    private SortDirection o\u00d20000 = null;
    private SortMethod \u00d4\u00d20000 = null;
    private String interfacesuper = null;
    private String \u00f4o0000 = null;
    private boolean \u00d6o0000 = false;
    private boolean dosuper = false;
    private int intsuper = 50;
    private final ImageBuilder \u00f6o0000;

    public OverviewListRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
        this.\u00f6o0000 = requestProcessorSettings.getImageBuilder();
        this.\u00d5o0000 = RendererEnvironment.\u00d400000;
        this.Objectnew = RendererEnvironment.\u00f500000;
        this.\u00d2o0000 = RendererEnvironment.o00000;
        this.O\u00d20000 = this.float.getDefaultSortLanguage();
        this.\u00d2\u00d20000 = this.float.getDefaultSortCountry();
        this.\u00f5o0000 = false;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        if (parameters.getAssetURLPath() == null) {
            return OverviewListRenderer.generateMissingParameterResponse("source");
        }
        if (parameters.getType() != Parameters.Type.\u00d500000) {
            throw new IllegalArgumentException("Invalid type requested");
        }
        RendererResponse rendererResponse = this.processListRequest(this.\u00f6o0000, parameters, map, httpSession);
        return rendererResponse;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("defaultSortField");
        treeSet.add("forceSortField");
        treeSet.add("defaultSortOrder");
        treeSet.add("forceSortOrder");
        treeSet.add("defaultSortMethod");
        treeSet.add("forceSortMethod");
        treeSet.add("defaultSortLanguage");
        treeSet.add("forceSortLanguage");
        treeSet.add("defaultSortCountry");
        treeSet.add("forceSortCountry");
        treeSet.add("defaultSortCaseSensitive");
        treeSet.add("forceSortCaseSensitive");
        return treeSet;
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("defaultsortfield") && this.\u00d5o0000 != null) {
            string2 = this.\u00d5o0000.name();
        } else if (string.equalsIgnoreCase("forcesortfield") && this.\u00d4o0000 != null) {
            string2 = this.\u00d4o0000.name();
        } else if (string.equalsIgnoreCase("defaultsortorder") && this.Objectnew != null) {
            string2 = this.Objectnew.name();
        } else if (string.equalsIgnoreCase("forcesortorder") && this.o\u00d20000 != null) {
            string2 = this.o\u00d20000.name();
        } else if (string.equalsIgnoreCase("defaultsortmethod") && this.\u00d2o0000 != null) {
            string2 = this.\u00d2o0000.name();
        } else if (string.equalsIgnoreCase("forcesortmethod") && this.\u00d4\u00d20000 != null) {
            string2 = this.\u00d4\u00d20000.name();
        } else if (string.equalsIgnoreCase("defaultsortlanguage")) {
            string2 = this.O\u00d20000;
        } else if (string.equalsIgnoreCase("forcesortlanguage")) {
            string2 = this.interfacesuper;
        } else if (string.equalsIgnoreCase("defaultsortcountry")) {
            string2 = this.\u00d2\u00d20000;
        } else if (string.equalsIgnoreCase("forcesortcountry")) {
            string2 = this.\u00f4o0000;
        } else if (string.equalsIgnoreCase("defaultsortcasesensitive")) {
            string2 = Boolean.toString(this.\u00f5o0000);
        } else if (string.equalsIgnoreCase("forcesortcasesensitive")) {
            string2 = Boolean.toString(this.dosuper);
        } else if (string.equalsIgnoreCase("maxEntries")) {
            string2 = Integer.toString(this.intsuper);
        }
        return string2;
    }

    @Override
    public void setOption(String string, String string2) {
        try {
            if (string.equalsIgnoreCase("defaultsortfield")) {
                this.\u00d5o0000 = PoolEntrySortingField.valueOf(string2.toUpperCase());
            } else if (string.equalsIgnoreCase("forcesortfield")) {
                this.\u00d4o0000 = PoolEntrySortingField.valueOf(string2.toUpperCase());
            } else if (string.equalsIgnoreCase("defaultsortorder")) {
                this.Objectnew = SortDirection.valueOf(string2.toUpperCase());
            } else if (string.equalsIgnoreCase("forcesortorder")) {
                this.o\u00d20000 = SortDirection.valueOf(string2.toUpperCase());
            } else if (string.equalsIgnoreCase("defaultsortmethod")) {
                this.\u00d2o0000 = SortMethod.valueOf(string2.toUpperCase());
            } else if (string.equalsIgnoreCase("forcesortmethod")) {
                this.\u00d4\u00d20000 = SortMethod.valueOf(string2.toUpperCase());
            } else if (string.equalsIgnoreCase("defaultsortlanguage")) {
                this.O\u00d20000 = string2.toLowerCase();
            } else if (string.equalsIgnoreCase("forcesortlanguage")) {
                this.interfacesuper = string2.toLowerCase();
            } else if (string.equalsIgnoreCase("defaultsortcountry")) {
                this.\u00d2\u00d20000 = string2.toUpperCase();
            } else if (string.equalsIgnoreCase("forcesortcountry")) {
                this.\u00f4o0000 = string2.toUpperCase();
            } else if (string.equalsIgnoreCase("defaultsortcasesensitive")) {
                this.\u00f5o0000 = Boolean.valueOf(string2.toLowerCase());
            } else if (string.equalsIgnoreCase("forcesortcasesensitive")) {
                this.dosuper = Boolean.valueOf(string2.toLowerCase());
                this.\u00d6o0000 = true;
            } else if (string.equalsIgnoreCase("maxEntries")) {
                this.intsuper = Integer.valueOf(string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.\u00d200000.log(2035, this.void + ".xml", string2, string);
        }
    }

    private String[] extractSourcesFromParameter(String string) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = URL.cleanUpSourceParameter(stringArray[i]);
        }
        if (stringArray.length > this.intsuper) {
            String[] stringArray2 = new String[this.intsuper];
            for (int i = 0; i < this.intsuper; ++i) {
                stringArray2[i] = stringArray[i];
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    private RendererResponse processListRequest(ImageBuilder imageBuilder, Parameters parameters, Map<String, Object> map, HttpSession httpSession) {
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        String string = parameters.getAssetURLPath();
        if (string == null) {
            throw new IllegalArgumentException("source required");
        }
        try {
            Template template = this.determineListTemplate(parameters);
            TemplateAttributes templateAttributes = new TemplateAttributes(this.\u00d200000, template);
            templateAttributes.setRendererResponseContentType(rendererTextResponse);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("query", parameters);
            String[] stringArray = this.extractSourcesFromParameter(string);
            if (!this.checkPermissions(httpSession, stringArray)) {
                rendererTextResponse.setStatus(403);
                return rendererTextResponse;
            }
            SortDirection sortDirection = this.determineSortOrder(parameters);
            FSIStringComparator fSIStringComparator = this.determineSortComparator(parameters);
            PoolEntrySortingField poolEntrySortingField = this.determineSortField(parameters);
            long l = 0L;
            ArrayList arrayList = new ArrayList();
            for (String string2 : stringArray) {
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                try {
                    SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(string2);
                    PoolList poolList = imageBuilder.getPoolList(sourceConnectorReader, string2, httpSession);
                    int n = 0;
                    if (poolList != null) {
                        l = Math.max(l, poolList.\u00d4\u00d60000);
                        n = poolList.getFileCount();
                        if (n > 0) {
                            List<PoolFileEntry> list = poolList.getFilesAsList();
                            if (!list.isEmpty()) {
                                this.sortingPoolList(list, poolEntrySortingField, fSIStringComparator, sortDirection);
                            }
                            String string3 = string2 + "/" + list.get((int)0).o00000;
                            hashMap2.put("src", string3);
                            MetaData metaData = imageBuilder.getImageMetaData(sourceConnectorReader, string3, 0, true, httpSession);
                            if (metaData instanceof ImageMetaData) {
                                ImageMetaData imageMetaData = (ImageMetaData)metaData;
                                hashMap2.put("width", imageMetaData.getWidth());
                                hashMap2.put("height", imageMetaData.getHeight());
                            }
                        }
                    }
                    hashMap2.put("imageCount", n);
                    hashMap2.put("exists", true);
                }
                catch (NoSuchFileException noSuchFileException) {
                    hashMap2.put("exists", false);
                }
                arrayList.add(hashMap2);
            }
            hashMap.put("ilist", arrayList);
            this.renderTemplate(template, hashMap, rendererTextResponse);
            rendererTextResponse.setDateHeader("Last-Modified", l);
            rendererTextResponse.setStatus(200);
        }
        catch (TemplateException | IOException throwable) {
            this.\u00d200000.logException((Exception)throwable, 3158, throwable.getLocalizedMessage());
            rendererTextResponse.setBody(this.getTemplateErrorBody(throwable.getLocalizedMessage()));
            rendererTextResponse.setStatus(500);
            rendererTextResponse.setStatusMessage(throwable.getLocalizedMessage());
        }
        catch (NotConfiguredException notConfiguredException) {
            rendererTextResponse.setStatus(503);
            this.\u00d200000.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
        }
        return rendererTextResponse;
    }

    private boolean checkPermissions(HttpSession httpSession, String[] stringArray) throws NotConfiguredException {
        for (String string : stringArray) {
            PermissionSet permissionSet = this.Object.getUserAuthenticationInterface().getPermissions(string, httpSession, true);
            if (permissionSet != null && (permissionSet.list.files.booleanValue() || permissionSet.list.directories.booleanValue())) continue;
            return false;
        }
        return true;
    }

    private PoolEntrySortingField determineSortField(Parameters parameters) throws IOException {
        PoolEntrySortingField poolEntrySortingField = RendererEnvironment.\u00d400000;
        if (this.\u00d4o0000 != null) {
            poolEntrySortingField = this.\u00d4o0000;
        } else if (parameters.contains(Parameters.Sorting.\u00d3\u00d50000) && parameters.get(Parameters.Sorting.\u00d3\u00d50000).trim().length() > 0) {
            try {
                poolEntrySortingField = PoolEntrySortingField.valueOf(parameters.get(Parameters.Sorting.\u00d3\u00d50000).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Illegal sort field");
            }
        } else {
            poolEntrySortingField = this.\u00d5o0000;
        }
        return poolEntrySortingField;
    }

    private void renderTemplate(Template template, Map map, RendererTextResponse rendererTextResponse) throws IOException, TemplateException {
        try (StringWriterFast stringWriterFast = new StringWriterFast();){
            Environment environment = template.createProcessingEnvironment((Object)map, (Writer)stringWriterFast);
            environment.process();
            rendererTextResponse.setBody(stringWriterFast.toString());
        }
    }

    private Template determineListTemplate(Parameters parameters) throws IOException {
        String string = "json_overview";
        if (parameters.contains(Parameters.General.\u00d8\u00d40000)) {
            string = parameters.get(Parameters.General.\u00d8\u00d40000);
        }
        Template template = this.Object.getTemplateCache().getTemplate(TemplateType.super, string + ".ftl");
        return template;
    }

    private FSIStringComparator determineSortComparator(Parameters parameters) throws IOException {
        SortMethod sortMethod;
        SortDirection sortDirection;
        if (this.o\u00d20000 != null) {
            sortDirection = this.o\u00d20000;
        } else if (parameters.contains(Parameters.Sorting.O\u00d50000)) {
            try {
                sortDirection = SortDirection.valueOf(parameters.get(Parameters.Sorting.O\u00d50000).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Illegal sortorder value");
            }
        } else {
            sortDirection = this.Objectnew;
        }
        if (this.\u00d4\u00d20000 != null) {
            sortMethod = this.\u00d4\u00d20000;
        } else if (parameters.contains(Parameters.Sorting.newString)) {
            try {
                sortMethod = SortMethod.valueOf(parameters.get(Parameters.Sorting.newString).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Illegal sortorder value");
            }
        } else {
            sortMethod = this.\u00d2o0000;
        }
        String string = this.interfacesuper != null ? this.interfacesuper : (parameters.contains(Parameters.Sorting.\u00d4\u00d50000) ? parameters.get(Parameters.Sorting.\u00d4\u00d50000) : this.O\u00d20000);
        String string2 = this.\u00f4o0000 != null ? this.\u00f4o0000 : (parameters.contains(Parameters.Sorting.\u00d5\u00d50000) ? parameters.get(Parameters.Sorting.\u00d5\u00d50000) : this.\u00d2\u00d20000);
        boolean bl = this.\u00d6o0000 ? this.dosuper : (parameters.contains(Parameters.Sorting.returnString) ? Boolean.valueOf(parameters.get(Parameters.Sorting.returnString)) : this.\u00f5o0000);
        return this.float.getFSIStringComparator(sortDirection, sortMethod, string, string2, bl);
    }

    private SortDirection determineSortOrder(Parameters parameters) throws IOException {
        SortDirection sortDirection;
        if (this.o\u00d20000 != null) {
            sortDirection = this.o\u00d20000;
        } else if (parameters.contains(Parameters.Sorting.O\u00d50000)) {
            try {
                sortDirection = SortDirection.valueOf(parameters.get(Parameters.Sorting.O\u00d50000).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Illegal sortorder value");
            }
        } else {
            sortDirection = this.Objectnew;
        }
        return sortDirection;
    }

    private String getTemplateErrorBody(String string) {
        return string;
    }
}

