/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.requesthandlers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.helpers.URLDecoderFast;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.security.CityHash;
import com.neptunelabs.fsiserver.requestprocessor.requesthandlers.RequestHandler;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.ETag;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.cache.CacheableHttpServletResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class StaticFileRequestHandler
extends RequestHandler {
    public StaticFileRequestHandler(RequestProcessorSettings requestProcessorSettings) {
        super(requestProcessorSettings);
    }

    private void setPredefinedResponseHeaders(String string, CacheableHttpServletResponse cacheableHttpServletResponse, String string2) {
        if (string == null) {
            return;
        }
        SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(string);
        if (sourceConnectorReader == null) {
            return;
        }
        Map<String, String> map = this.Object.getHeaderSet(sourceConnectorReader.getForceHeadersName());
        if (map != null) {
            this.transferHeaders(map, cacheableHttpServletResponse);
        } else {
            String string3 = sourceConnectorReader.getHeadersName();
            if (string3 == null && string2 != null) {
                string3 = string2;
            }
            Map<String, String> map2 = this.Object.getHeaderSet(string3);
            this.transferHeaders(map2, cacheableHttpServletResponse);
        }
    }

    private void transferHeaders(Map<String, String> map, CacheableHttpServletResponse cacheableHttpServletResponse) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                cacheableHttpServletResponse.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public void handleRequest(HttpServletRequest httpServletRequest, CacheableHttpServletResponse cacheableHttpServletResponse) {
        block44: {
            cacheableHttpServletResponse.setCachable(false);
            String string = httpServletRequest.getPathInfo();
            try {
                Charset charset;
                String string2 = httpServletRequest.getCharacterEncoding();
                if (string2 == null) {
                    string2 = "UTF-8";
                    charset = StandardCharsets.UTF_8;
                } else if (string2.equalsIgnoreCase("iso-8859-1")) {
                    charset = StandardCharsets.ISO_8859_1;
                } else if (string2.equalsIgnoreCase("utf-16")) {
                    charset = StandardCharsets.UTF_16;
                } else {
                    try {
                        charset = Charset.forName(string2);
                    }
                    catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                        charset = FileOperations.o00000;
                    }
                }
                String string3 = URLDecoderFast.decode(string, charset);
                byte[] byArray = string3.getBytes(StandardCharsets.UTF_8);
                cacheableHttpServletResponse.setAssetURLHash(CityHash.cityHash64(byArray, 0, byArray.length));
                PermissionSet permissionSet = this.Object.getUserAuthenticationInterface().getPermissions(string3, httpServletRequest.getSession(false), true);
                if (permissionSet.read.files.booleanValue()) {
                    String[] stringArray = StorageHelperV1002.splitAssetURLPath(string3);
                    String string4 = URLDecoderFast.decode(stringArray[0], charset);
                    String string5 = URLDecoderFast.decode(stringArray[1], charset);
                    SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnector(string4);
                    this.setPredefinedResponseHeaders(string3, cacheableHttpServletResponse, "static.default");
                    if (sourceConnectorReader != null && sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.super) {
                        Path path = sourceConnectorReader.getInboxDirectory().resolve(string5);
                        if (Files.exists(path, new LinkOption[0])) {
                            if (Files.isReadable(path)) {
                                BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                                int n = 0;
                                long[] lArray = null;
                                try {
                                    lArray = this.getRequestRange(httpServletRequest);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    n = 416;
                                }
                                cacheableHttpServletResponse.setHeader("Accept-Ranges", "bytes");
                                String string6 = this.Object.getServletContext().getMimeType(path.getFileName().toString().toLowerCase());
                                if (string6 != null) {
                                    cacheableHttpServletResponse.setHeader("Content-Type", string6);
                                }
                                long l = basicFileAttributes.lastModifiedTime().toMillis();
                                cacheableHttpServletResponse.setLastModified(l);
                                long l2 = basicFileAttributes.size();
                                cacheableHttpServletResponse.setQueryHash(l2 ^ l);
                                ETag eTag = cacheableHttpServletResponse.getETag();
                                eTag.addModifier("static");
                                cacheableHttpServletResponse.setETag();
                                long l3 = 0L;
                                long l4 = l2 - 1L;
                                if (lArray != null) {
                                    if (lArray[0] > 0L && (l3 = lArray[0]) == -1L) {
                                        l3 = 0L;
                                    }
                                    if (lArray[1] != -1L && (l4 = lArray[1]) == -1L) {
                                        l4 = l2 - 1L;
                                    }
                                    n = 206;
                                    if (l4 >= l2) {
                                        l4 = l2 - 1L;
                                    }
                                    if (l3 > l4) {
                                        n = 416;
                                    } else if (l2 < Integer.MAX_VALUE) {
                                        cacheableHttpServletResponse.setHeader("Content-Range", "bytes " + l3 + "-" + l4 + "/" + l2);
                                    } else {
                                        cacheableHttpServletResponse.setHeader("Content-Range", "bytes " + l3 + "-" + l4);
                                    }
                                } else if (n == 0) {
                                    n = 200;
                                }
                                cacheableHttpServletResponse.setStatus(n);
                                if (n == 416) break block44;
                                try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);){
                                    seekableByteChannel.position(l3);
                                    long l5 = l4 - l3 + 1L;
                                    if (l5 < Integer.MAX_VALUE) {
                                        cacheableHttpServletResponse.setContentLength((int)l5);
                                    }
                                    byte[] byArray2 = new byte[8192];
                                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
                                    int n2 = 0;
                                    while (l5 > 0L && n2 != -1) {
                                        n2 = seekableByteChannel.read(byteBuffer);
                                        if (l5 > (long)n2) {
                                            cacheableHttpServletResponse.write(byArray2, false);
                                        } else {
                                            cacheableHttpServletResponse.write(byArray2, 0, (int)l5, false);
                                        }
                                        l5 -= (long)n2;
                                        byteBuffer.clear();
                                    }
                                    break block44;
                                }
                            }
                            cacheableHttpServletResponse.setStatus(403);
                            break block44;
                        }
                        cacheableHttpServletResponse.setStatus(404);
                        break block44;
                    }
                    cacheableHttpServletResponse.setStatus(404);
                    break block44;
                }
                cacheableHttpServletResponse.setStatus(403);
            }
            catch (NotConfiguredException notConfiguredException) {
                cacheableHttpServletResponse.setStatus(503);
            }
            catch (IOException iOException) {
                cacheableHttpServletResponse.setStatus(500);
                this.Object.getLogger().logException(iOException, 3256, httpServletRequest.getRequestURI(), iOException.getLocalizedMessage());
            }
        }
    }

    private long[] getRequestRange(HttpServletRequest httpServletRequest) {
        long[] lArray = null;
        String string = httpServletRequest.getHeader("range");
        if (string != null) {
            lArray = new long[]{-1L, -1L};
            String[] stringArray = string.split("=", 2);
            if (stringArray[0].equalsIgnoreCase("bytes") && stringArray.length == 2) {
                String string2 = stringArray[1];
                String[] stringArray2 = string2.split("-", 2);
                if (stringArray2.length == 1) {
                    lArray[0] = stringArray2[0].startsWith("-") ? Long.parseLong(stringArray2[0].substring(1)) : Long.parseLong(stringArray2[0]);
                } else if (stringArray2.length == 2) {
                    if (stringArray2[0].length() > 0) {
                        lArray[0] = Long.parseLong(stringArray2[0]);
                    }
                    if (stringArray2[1].length() > 0) {
                        lArray[1] = Long.parseLong(stringArray2[1]);
                    }
                }
            }
        }
        return lArray;
    }
}

