/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiserver.service.C;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiserver.utils.service.Password;
import com.neptunelabs.fsiserver.utils.service.SaltResponse;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/password/")
public final class PasswordService
extends C
implements Serializable {
    private static final long serialVersionUID = -7709019603957201866L;

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getPasswordChangeSalt() {
        String string;
        if (!this.int()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        UserAuthenticationInterface userAuthenticationInterface = this.\u00d8O0000();
        if (!userAuthenticationInterface.isPasswordChangePossible()) {
            ActionResponse actionResponse = new ActionResponse();
            actionResponse.setStatuscode(403);
            actionResponse.setCause("Not supported by Configuration");
            actionResponse.setDetails("Passwords are managed externally.");
            Response.ResponseBuilder responseBuilder = Response.ok((Object)actionResponse);
            responseBuilder.cacheControl(\u00d200000);
            return responseBuilder.build();
        }
        if (this.\u00f8O0000().getAttribute("passwordChangeSalt") != null) {
            string = (String)this.\u00f8O0000().getAttribute("passwordChangeSalt");
        } else {
            string = this.\u00f800000();
            this.\u00f8O0000().setAttribute("passwordChangeSalt", (Object)string);
        }
        Response.ResponseBuilder responseBuilder = Response.ok((Object)new SaltResponse(null, string, null));
        responseBuilder.cacheControl(\u00d200000);
        return responseBuilder.build();
    }

    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response updatePassword(Password password) {
        String string;
        if (!this.int()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ActionResponse actionResponse = new ActionResponse();
        UserAuthenticationInterface userAuthenticationInterface = this.\u00d8O0000();
        if (userAuthenticationInterface.isPasswordChangePossible()) {
            if (this.\u00f8O0000().getAttribute("passwordChangeSalt") != null) {
                string = (String)this.\u00f8O0000().getAttribute("passwordChangeSalt");
                String string2 = password.getOldPasswordHash();
                String string3 = this.\u00d300000();
                UserAuthenticationInterface.AuthenticationCode authenticationCode = userAuthenticationInterface.validateCredentials(string3, string2, string);
                this.\u00f8O0000().removeAttribute("passwordChangeSalt");
                if (authenticationCode == UserAuthenticationInterface.AuthenticationCode.class) {
                    String string4 = password.getNewPasswordHash();
                    boolean bl = userAuthenticationInterface.setUserPasswordHash(string3, string4);
                    if (bl) {
                        actionResponse.setStatuscode(200);
                        this.\u00d3O0000().log(140, string3);
                    } else {
                        actionResponse.setStatuscode(500);
                        actionResponse.setCause("Unknown Error changing password.");
                        this.\u00d3O0000().log(141, string3);
                    }
                } else if (authenticationCode == UserAuthenticationInterface.AuthenticationCode.super) {
                    actionResponse.setStatuscode(403);
                    actionResponse.setCause("Wrong password");
                    this.\u00d3O0000().log(141, string3);
                } else if (authenticationCode == UserAuthenticationInterface.AuthenticationCode.\u00d300000) {
                    actionResponse.setStatuscode(409);
                    actionResponse.setCause("Unknown User");
                    this.\u00d3O0000().log(141, string3);
                } else if (authenticationCode == UserAuthenticationInterface.AuthenticationCode.\u00d200000) {
                    actionResponse.setStatuscode(500);
                    actionResponse.setCause("Authentication Module is currently not available.");
                    this.\u00d3O0000().log(141, string3);
                }
            } else {
                actionResponse.setStatuscode(412);
                actionResponse.setCause("No Salt");
                actionResponse.setDetails("Please request a salt before attempting a password change.");
            }
        } else {
            actionResponse.setStatuscode(403);
            actionResponse.setCause("Not supported by Configuration");
            actionResponse.setDetails("Passwords are managed externally.");
        }
        string = Response.ok((Object)actionResponse);
        string.cacheControl(\u00d200000);
        return string.build();
    }
}

