/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.SoftwareVersion;
import com.neptunelabs.fsiserver.framework.io.MemoryManager;
import com.neptunelabs.fsiserver.framework.jmx.MBeanUtils;
import com.neptunelabs.fsiserver.framework.licensing.Licence;
import com.neptunelabs.fsiserver.framework.settings.ServletXMLSettings;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.utils.Defines;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.ServletUtils;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.super;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public abstract class FSIServerSettings
extends ServletXMLSettings {
    public static final String \u00d5\u00d20000 = "/static";
    protected final Map<String, SourceConnectorReader> o\u00d20000 = new HashMap<String, SourceConnectorReader>();
    protected final Set<ObjectName> \u00f5o0000 = new HashSet<ObjectName>();
    private final Path \u00d2\u00d20000;
    private ByteOrder Stringnew;
    private Comparator<String> \u00d6o0000 = null;
    private RendererEnvironment \u00f6o0000;
    private boolean \u00d8o0000 = false;
    private Timer \u00f8o0000;
    private super \u00d3\u00d20000 = null;
    private Path \u00d5o0000 = null;
    private String thisnew = null;
    private int whilesuper;

    protected FSIServerSettings(ServletContext servletContext, boolean bl, boolean bl2) {
        super(servletContext, bl);
        this.\u00d2\u00d20000 = servletContext != null ? (Path)servletContext.getAttribute("com.neptunelabs.fsiserver.config.home") : null;
        if (bl2) {
            this.\u00f8o0000 = new Timer("FSI Settings Task", true);
            this.\u00d3\u00d20000 = new super(this, 60000L);
            this.\u00f8o0000.scheduleAtFixedRate((TimerTask)this.\u00d3\u00d20000, 0L, 60000L);
        }
    }

    public Path getStorageLocation() {
        if (this.\u00d5o0000 == null) {
            String string = this.getPrefsString("application", "storage");
            Path path = Paths.get(string, new String[0]);
            if (!path.isAbsolute()) {
                path = this.getWebInfPath().resolve(string);
            }
            this.\u00d5o0000 = path.toAbsolutePath();
        }
        return this.\u00d5o0000;
    }

    public int getConversionThreads() {
        return this.whilesuper;
    }

    public void setConversionThreads(int n) {
        this.whilesuper = n;
    }

    protected String getStorageLocationPath() {
        if (this.\u00d5o0000 != null && this.thisnew == null) {
            this.thisnew = this.\u00d5o0000.toAbsolutePath().toString();
        }
        return this.thisnew;
    }

    public Comparator<String> getDefaultStringComparator() {
        if (this.\u00d6o0000 == null) {
            Locale locale = null;
            String string = this.getPrefsString("limits", "sortcollator");
            if (string.equalsIgnoreCase("auto")) {
                locale = Locale.getDefault();
            } else if (!string.equalsIgnoreCase("none")) {
                locale = new Locale(string);
            }
            this.\u00f6o0000 = RendererEnvironment.getInstance(locale);
            this.\u00d6o0000 = this.\u00f6o0000.selectStringComparator(RendererEnvironment.o00000, this.\u00f6o0000.getDefaultSortLanguage(), this.\u00f6o0000.getDefaultSortCountry(), false, RendererEnvironment.\u00f500000 == SortDirection.\u00d300000);
        }
        return this.\u00d6o0000;
    }

    public Path getMetaDataLocation() {
        return this.getStorageLocation().resolve("metadata");
    }

    public Path getConfigHome() {
        return this.\u00d2\u00d20000;
    }

    public void evaluateStorageID() throws IOException {
        this.getStorageHelper().evaluateStorageID();
    }

    public String getStorageID() {
        return this.getStorageHelper().getStorageID();
    }

    public String getStorageKey() {
        return this.getStorageHelper().getStorageKey();
    }

    public SourceConnectorReader getSourceConnectorFromAssetURLPath(String string) {
        return this.o\u00d20000.get(this.getSourceConnectorNameFromAssetURLPath(string));
    }

    protected Path getTempDirectory() {
        return ServletUtils.getRealPath(this.\u00d300000, "PRIVATE").resolve("internal").resolve("temp");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.\u00f8o0000 != null) {
            this.\u00f8o0000.cancel();
        }
    }

    public int getSourceConnectorCount() {
        int n = 0;
        for (Map.Entry<String, SourceConnectorReader> entry : this.o\u00d20000.entrySet()) {
            if (!entry.getValue().isEnabled() || entry.getValue().isVirtualViewerConnector()) continue;
            String string = entry.getKey();
            boolean bl = true;
            for (String string2 : Defines.\u00d5O0000) {
                if (!string.equals(string2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    public SourceConnectorReader getSourceConnectorFromAssetURLPath(String string, String string2) throws NotConfiguredException {
        String string3 = this.getSourceConnectorNameFromAssetURLPath(string);
        if (string3.equals("_configs")) {
            if (string2 != null) {
                return this.generateConfigsConnector(string2);
            }
            return null;
        }
        if (string3.equals("_viewers")) {
            if (string2 != null) {
                return this.generateViewerConnector(string2);
            }
            return null;
        }
        return this.o\u00d20000.get(string3);
    }

    public SourceConnectorReader getSourceConnectorFromAssetURLPath(String string, HttpSession httpSession) throws NotConfiguredException {
        String string2 = null;
        if (httpSession != null) {
            try {
                string2 = this.getUserAuthenticationInterface().getUser((String)httpSession.getAttribute("id"));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return this.getSourceConnectorFromAssetURLPath(string, string2);
    }

    private String getSourceConnectorNameFromAssetURLPath(String string) {
        if (string == null) {
            return null;
        }
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        int n = string.indexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public RendererEnvironment getRenderEnvironment() {
        return this.\u00f6o0000;
    }

    private SourceConnectorReader generateConfigsConnector(String string) throws NotConfiguredException {
        SourceConnectorReader sourceConnectorReader = null;
        if (string != null) {
            PermissionSet permissionSet = new PermissionSet();
            permissionSet.setFullReadPermissionsEnabled(true);
            permissionSet.setFullWritePermissionsEnabled(true);
            sourceConnectorReader = new SourceConnectorReader(this.getLogger(), "_configs", string, this.getUserAuthenticationInterface(), permissionSet, this.getEffectsManager());
        }
        return sourceConnectorReader;
    }

    private SourceConnectorReader generateViewerConnector(String string) throws NotConfiguredException {
        SourceConnectorReader sourceConnectorReader = null;
        if (string != null) {
            PermissionSet permissionSet = new PermissionSet();
            permissionSet.setFullReadPermissionsEnabled(true);
            permissionSet.setFullWritePermissionsEnabled(true);
            sourceConnectorReader = new SourceConnectorReader(this.getLogger(), "_viewers", string, this.getUserAuthenticationInterface(), permissionSet, this.getEffectsManager());
        }
        return sourceConnectorReader;
    }

    public ByteOrder getByteOrder() {
        if (this.Stringnew == null) {
            String string = this.getPrefsString("application", "byteorder");
            this.Stringnew = string.equalsIgnoreCase("big_endian") || string.equalsIgnoreCase("bigendian") || string.equalsIgnoreCase("be") ? ByteOrder.BIG_ENDIAN : (string.equalsIgnoreCase("little_endian") || string.equalsIgnoreCase("littleendian") || string.equalsIgnoreCase("le") ? ByteOrder.LITTLE_ENDIAN : ByteOrder.nativeOrder());
        }
        return this.Stringnew;
    }

    public long evaluateMaxBlockCache(String string) {
        long l;
        long l2 = 0xA0000000L;
        long l3 = 0x10000000L;
        MemoryManager memoryManager = MemoryManager.getInstance();
        long l4 = memoryManager.getMaxOldGen() - 0xA0000000L;
        long l5 = Math.min(l4, l = string == null || string.equalsIgnoreCase("auto") ? l4 : this.getHumanRAMBytes(string));
        if (l5 < 0x10000000L) {
            l5 = 0x10000000L;
        }
        return l5;
    }

    @Override
    public void updateLicenceFromLicenceManager() {
        super.updateLicenceFromLicenceManager();
        if (this.getSystemMonitor() != null) {
            this.getSystemMonitor().setLicence(this.getLicence());
        }
        if (this.\u00d3\u00d20000 != null) {
            this.\u00d3\u00d20000.super();
            this.\u00d3\u00d20000.run();
        }
        this.configureJMXSupport();
    }

    public LicenceState isLicensed() {
        return this.isLicensed(this.getLicence());
    }

    public LicenceState isLicensed(Licence licence) {
        return this.isLicensed(licence, false);
    }

    public LicenceState isLicensed(Licence licence, boolean bl) {
        LicenceState licenceState = LicenceState.\u00f600000;
        if (licence == null || !licence.hasLicence()) {
            licenceState = LicenceState.\u00f400000;
        } else {
            long l;
            int n = SoftwareVersion.getMajorVersion() * 100 + SoftwareVersion.getMinorVersion();
            int n2 = licence.getMaxVersion();
            int n3 = licence.getMinVersion();
            if (n3 < 100) {
                n3 = 300;
            }
            if (n2 < 100) {
                n2 = 1608;
            }
            if (n < n3) {
                licenceState = LicenceState.\u00d300000;
            }
            if (n > n2) {
                licenceState = LicenceState.\u00d200000;
            }
            if (bl) {
                l = licence.getExpireTime();
                if (l > 0L && System.currentTimeMillis() > l) {
                    licenceState = LicenceState.\u00d600000;
                }
            } else {
                if (this.\u00d8o0000) {
                    licenceState = LicenceState.\u00d600000;
                }
                if (licenceState == LicenceState.\u00f600000 && !this.\u00d800000) {
                    licenceState = LicenceState.\u00d400000;
                }
            }
            if (licenceState == LicenceState.\u00f600000 && this.getSystemMonitor() != null) {
                l = this.getSystemMonitor().getAssetCount();
                if (licence.getMaxImages() > 0L && l > 0L && l > licence.getMaxImages()) {
                    licenceState = LicenceState.super;
                }
            }
            if (licenceState == LicenceState.\u00f600000 && licence.getMaxConnectors() > 0 && this.getSourceConnectorCount() > licence.getMaxConnectors()) {
                licenceState = LicenceState.\u00f800000;
            }
            if (licenceState == LicenceState.\u00f600000 && this.getUserAuthenticationInterface() != null && licence.getMaxUserGroups() > 0 && this.getUserAuthenticationInterface().getGroupCount() > licence.getMaxUserGroups()) {
                licenceState = LicenceState.int;
            }
        }
        return licenceState;
    }

    void setLicenceExpired(boolean bl) {
        this.\u00d8o0000 = bl;
    }

    protected abstract void initMBeans();

    public void configureJMXSupport() {
        if (this.\u00d3O0000) {
            boolean bl = true;
            if (this.getPrefsBoolean("application", "jmx")) {
                if (this.getLicence().isJMXEnabled()) {
                    this.initMBeans();
                    bl = false;
                } else if (this.isLicensed() == LicenceState.\u00f600000) {
                    this.getLogger().log(2058, new Object[0]);
                }
            }
            if (bl) {
                this.unregisterMBeans();
            }
        }
    }

    private int evaluateThreadsPerCPU(String string, int n, int n2) {
        int n3;
        if (this.\u00f8O0000.isStagingLicence()) {
            n3 = 1;
        } else {
            if (string.equalsIgnoreCase("auto")) {
                n3 = (int)Math.ceil((float)n * 0.8f);
            } else {
                try {
                    n3 = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = (int)Math.ceil((float)n / (float)n2);
                    this.getLogger().log(2503, "maxThreadsPerJob", string);
                }
            }
            n3 = n3 < 1 ? 1 : n3;
            n3 = n3 < n ? n3 : n;
        }
        return n3;
    }

    public int evaluateMaxCPU(String string) {
        int n;
        int n2 = Runtime.getRuntime().availableProcessors();
        if (string.equalsIgnoreCase("auto")) {
            n = n2;
        } else {
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = Runtime.getRuntime().availableProcessors();
                this.getLogger().log(2503, "maxCPU", string);
            }
        }
        n = n < 1 ? 1 : n;
        int n3 = n = n < n2 ? n : n2;
        if (this.\u00f8O0000.isStagingLicence()) {
            n = 1;
        }
        return n;
    }

    public int evaluateMaxIO(String string) {
        int n;
        int n2 = 2;
        if (string.equalsIgnoreCase("auto")) {
            n = 2;
        } else {
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = Runtime.getRuntime().availableProcessors();
                this.getLogger().log(2503, "maxIO", string);
            }
        }
        n = n < 1 ? 1 : n;
        int n3 = n = n < 2 ? n : 2;
        if (this.\u00f8O0000.isStagingLicence()) {
            n = 1;
        }
        return n;
    }

    private void unregisterMBeans() {
        for (ObjectName objectName : this.\u00f5o0000) {
            MBeanUtils.unregister(this.getLogger(), objectName);
        }
        this.\u00f5o0000.clear();
    }

    public void setupStorageID() throws IOException {
        this.getStorageHelper().setupStorageID();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum LicenceState {
        \u00f600000,
        \u00f400000,
        \u00d600000,
        super,
        \u00f800000,
        int,
        class,
        \u00d400000,
        \u00d300000,
        \u00d200000;

    }
}

