/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class ImageListFileWriter {
    private final FSIServerSettings \u00d200000;
    private final ImageListFileReader o00000;

    public ImageListFileWriter(FSIServerSettings fSIServerSettings, ImageListFileReader imageListFileReader) {
        this.\u00d200000 = fSIServerSettings;
        this.o00000 = imageListFileReader;
    }

    public void updateEntry(Path path, String string, Path path2, String string2, PoolEntry poolEntry, long l) {
        ArrayList<PoolEntry> arrayList = new ArrayList<PoolEntry>(1);
        if (poolEntry != null) {
            arrayList.add(poolEntry);
        }
        this.updateEntries(path, string, path2, string2, arrayList, l);
    }

    public PoolList updateEntries(Path path, String string, Path path2, String string2, List<PoolEntry> list, long l) {
        if (list == null) {
            return null;
        }
        string = ImageListFileWriter.cleanEntryname(string);
        PoolList poolList = this.getPoolList(path, string);
        if (l != -1L) {
            poolList.\u00d4\u00d60000 = l;
        }
        this.replacePoolListEntries(poolList, list);
        poolList.setSyncRequired(true);
        this.writeListAndLog(path, string, poolList);
        if (path2 != null && string2 != null) {
            String string3 = (string2 = ImageListFileWriter.cleanEntryname(string2)).length() > 1 ? string.substring(string2.length() + 1) : string;
            this.updateParentContentCount(path2, string2, string3, poolList.getDirectoryCount(), poolList.getFileCount(), poolList.\u00d4\u00d60000);
        }
        this.\u00d200000.getLogger().log(3507, list.size(), string, path);
        return poolList;
    }

    private void updateParentContentCount(Path path, String string, String string2, int n, int n2, long l) {
        PoolList poolList = this.getPoolList(path, string);
        PoolDirectoryEntry poolDirectoryEntry = poolList.getDirectory(string2);
        boolean bl = false;
        if (poolDirectoryEntry != null) {
            if (poolDirectoryEntry.\u00d200000 != l) {
                poolDirectoryEntry.\u00d200000 = l;
                bl = true;
            }
            if (poolDirectoryEntry.\u00f500000 != (long)n2) {
                poolDirectoryEntry.\u00f500000 = n2;
                bl = true;
            }
            if (poolDirectoryEntry.null != (long)n) {
                poolDirectoryEntry.null = n;
                bl = true;
            }
        } else {
            PoolDirectoryEntry poolDirectoryEntry2 = new PoolDirectoryEntry(string2, l, n2, n);
            poolList.addDirectory(poolDirectoryEntry2);
            poolList.\u00d4\u00d60000 = l;
            bl = true;
        }
        if (bl) {
            this.writeListAndLog(path, string, poolList);
        }
    }

    public void updateLastModified(Path path, String string, long l) {
        PoolList poolList;
        this.\u00d200000.getLogger().log(3509, string, path);
        try {
            poolList = this.o00000.getListFileContents(path, string);
        }
        catch (IOException iOException) {
            poolList = new PoolList(path, string);
        }
        if (poolList == null) {
            poolList = new PoolList(path, string);
        }
        poolList.\u00d4\u00d60000 = l;
        poolList.setSyncRequired(true);
        this.writeListAndLog(path, string, poolList);
    }

    private void replacePoolListEntries(PoolList poolList, List<PoolEntry> list) {
        for (PoolEntry poolEntry : list) {
            if (poolEntry.\u00d300000 == ListEntryType.String) {
                this.replaceImageEntry(poolList, (PoolFileEntry)poolEntry);
                continue;
            }
            if (poolEntry.\u00d300000 != ListEntryType.\u00d200000) continue;
            poolList.addDirectory((PoolDirectoryEntry)poolEntry);
        }
    }

    private PoolList getPoolList(Path path, String string) {
        PoolList poolList = null;
        try {
            poolList = this.o00000.getListFileContents(path, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (poolList == null) {
            poolList = new PoolList(path, string);
        }
        return poolList;
    }

    private int replaceImageEntry(PoolList poolList, PoolFileEntry poolFileEntry) {
        int n = 1;
        if (poolList.containsImageFilename(poolFileEntry.o00000)) {
            if (poolFileEntry.\u00d600000 == 0) {
                PoolFileEntry poolFileEntry2 = poolList.getImage(poolFileEntry.o00000);
                poolFileEntry.\u00d600000 = poolFileEntry2.\u00d600000;
                poolFileEntry.String = poolFileEntry2.String;
            }
            poolList.removeImageFilename(poolFileEntry.o00000);
            n = 0;
        }
        poolList.addImage(poolFileEntry);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(Path path, String string, Path path2, String string2, String string3, long l) {
        string3 = ImageListFileWriter.cleanEntryname(string3);
        string = ImageListFileWriter.cleanEntryname(string);
        String string4 = path.toAbsolutePath().toString();
        synchronized (string4) {
            try {
                PoolList poolList = this.o00000.getListFileContents(path, string);
                if (l > 0L) {
                    poolList.\u00d4\u00d60000 = l;
                }
                boolean bl = false;
                if (poolList.containsImageFilename(string3)) {
                    this.\u00d200000.getLogger().log(3514, string3, path);
                    poolList.removeImageFilename(string3);
                    bl = true;
                } else if (poolList.getDirectoryNameSet().contains(string3)) {
                    this.\u00d200000.getLogger().log(3515, string3, path);
                    poolList.removeDirectory(string3);
                    bl = true;
                }
                if (bl) {
                    this.writeListAndLog(path, string, poolList);
                    if (path2 != null && string2 != null) {
                        String string5 = (string2 = ImageListFileWriter.cleanEntryname(string2)).length() > 1 ? string.substring(string2.length() + 1) : string;
                        this.updateParentContentCount(path2, string2, string5, poolList.getDirectoryCount(), poolList.getFileCount(), poolList.\u00d4\u00d60000);
                    }
                }
            }
            catch (IOException iOException) {
                this.\u00d200000.getLogger().logException(iOException, 3249, string, path);
            }
        }
    }

    private void writeListAndLog(Path path, String string, PoolList poolList) {
        this.o00000.getListBuffer().writeList(path, poolList);
        if (this.\u00d200000 instanceof SourceManagerSettings) {
            this.\u00d200000.getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.super, string);
        }
    }

    public void forceClearingAllBuffers() {
        this.o00000.getListBuffer().invalidateAllBuffers();
    }

    public void forceClearingBuffer(String string) {
        this.o00000.getListBuffer().invalidateBuffer(string);
    }

    public synchronized void replaceAll(Path path, PoolList poolList) {
        this.o00000.getListBuffer().writeList(path, poolList);
    }

    private static String cleanEntryname(String string) {
        if (!string.equals("/")) {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.lastIndexOf(47));
            }
        }
        return string;
    }

    public static enum ListEntryType {
        String,
        \u00d200000,
        \u00d300000;

    }
}

