/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiserver.framework.concurrent.LockerReadWrite;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.ReaderChannel;
import com.neptunelabs.fsiserver.framework.security.BytesToAscii36;
import com.neptunelabs.fsiserver.framework.security.HexConverter;
import com.neptunelabs.fsiserver.framework.security.Sha160;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageLockHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.CRC32;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class StorageHelperV1002 {
    private static final Charset \u00d800000 = StandardCharsets.UTF_16LE;
    private final Hasher OO0000;
    private static final int \u00d500000 = 1002;
    private static final String \u00f800000 = 'V' + Integer.toString(1002);
    private static final String \u00d300000 = ".metrics";
    private static final String \u00d400000 = ".trash";
    private static final String new = ".downloads";
    private static final String if = ".root";
    private static final String \u00f500000 = "_viewer";
    private final Path o00000;
    private String return = null;
    private String \u00f400000 = null;

    public StorageHelperV1002(Hasher hasher, Path path) {
        this.OO0000 = hasher;
        this.o00000 = path;
    }

    public static String getVersionPrefix() {
        return \u00f800000;
    }

    public Path getMetricsDir() {
        return this.o00000.resolve(\u00d300000);
    }

    public Path getProfileStorageBase(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        return this.o00000.resolve(\u00f800000).resolve(string);
    }

    public Path getTrashFolder(SourceConnectorReader sourceConnectorReader) {
        if (sourceConnectorReader.isVirtualViewerConnector()) {
            return this.o00000.resolve(\u00f800000).resolve(\u00f500000).resolve(sourceConnectorReader.getVirtualConnectorUsername());
        }
        return this.getProfileStorageBase(sourceConnectorReader.getPrefix()).resolve(\u00d400000);
    }

    public Path getDownloadsFolder() {
        return this.o00000.resolve(new);
    }

    public Path getEisFile(String string) {
        String string2 = StorageHelperV1002.cleanAssetURLPath(string);
        if (string2.length() == 0) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = StorageHelperV1002.splitAssetURLPath(string2);
        String string3 = this.calculateStorageHash("/" + stringArray[1]);
        return this.o00000.resolve(\u00f800000).resolve(stringArray[0]).resolve("i" + string3.charAt(0)).resolve(string3.substring(1, 3)).resolve("e" + string3.substring(3) + ".eis");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getRealEisFile(String string, StorageLockHandler storageLockHandler) throws NotConfiguredException, IOException {
        Path path = this.getEisFile(string);
        LockerReadWrite.Value<String> value = storageLockHandler.readLock(path);
        try (ReaderChannel readerChannel = new ReaderChannel(path, StandardOpenOption.READ);){
            byte[] byArray = new byte[8];
            readerChannel.read(byArray);
            if (Arrays.equals(byArray, EISEnvironment.\u00d600000)) {
                int n = EISChainReader.findChainEntryNumber(readerChannel, string);
                readerChannel.close();
                if (n == -1) {
                    throw new NoSuchFileException("No such entry for " + string + " in chain");
                }
                path = StorageManager.getChainedDestination(path, n);
            }
        }
        finally {
            storageLockHandler.unlockRead(value);
        }
        return path;
    }

    public Path getDirectoryFile(String string) {
        if ((string = StorageHelperV1002.cleanAssetURLPath(string)).length() == 0) {
            return this.o00000.resolve(if).resolve("root.dir");
        }
        String[] stringArray = StorageHelperV1002.splitAssetURLPath(string);
        String string2 = this.calculateStorageHash("/" + stringArray[1]);
        return this.o00000.resolve(\u00f800000).resolve(stringArray[0]).resolve("d" + string2.charAt(0)).resolve(string2.substring(1, 3)).resolve("d" + string2.substring(3) + ".dir");
    }

    public String calculateTrashFileHash(String string) {
        String string2 = this.calculateStorageHash(string);
        return string2.charAt(0) + "/" + string2.substring(1, 2) + "/t" + string2.substring(3);
    }

    public static String[] splitAssetURLPath(String string) {
        string = StorageHelperV1002.cleanAssetURLPath(string);
        String[] stringArray = new String[2];
        int n = string.indexOf(47);
        if (n >= 0) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        } else {
            stringArray[0] = string;
            stringArray[1] = "";
        }
        return stringArray;
    }

    public boolean isStorageDirectory(String string) {
        if (!(string = FileOperations.convertBackslash(string)).endsWith("/")) {
            string = string + '/';
        }
        return Files.exists(this.getDirectoryFile(string), new LinkOption[0]);
    }

    private static String cleanAssetURLPath(String string) {
        String string2 = FileOperations.convertBackslash(string);
        string2 = FileOperations.trim(string2, '/');
        return string2;
    }

    private String calculateStorageHash(String string) {
        byte[] byArray;
        switch (this.OO0000) {
            case \u00d300000: {
                CRC32 cRC32 = new CRC32();
                cRC32.update(string.getBytes(\u00d800000));
                int n = (int)cRC32.getValue();
                byArray = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    byArray[i] = (byte)(n >> i * 8 & 0xFF);
                }
                break;
            }
            case \u00d500000: {
                int n = string.hashCode();
                byArray = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    byArray[i] = (byte)(n >> i * 8 & 0xFF);
                }
                break;
            }
            case \u00d400000: {
                Sha160 sha160 = new Sha160();
                byArray = sha160.digest(string.getBytes(\u00d800000));
                break;
            }
            case o00000: {
                int n = string.hashCode();
                byArray = new byte[]{(byte)(n >>> 24 & 5), (byte)(n >>> 16 & 5), (byte)(n >>> 8 & 5), (byte)(n & 5)};
                break;
            }
            default: {
                byArray = null;
            }
        }
        return BytesToAscii36.encode(byArray);
    }

    public String getStorageID() {
        return this.return;
    }

    public String getStorageKey() {
        return this.\u00f400000;
    }

    public void evaluateStorageID() throws IOException {
        Object object;
        Object object2;
        String string;
        String string2;
        block20: {
            int n = 0;
            string2 = null;
            string = null;
            object2 = Files.newBufferedReader(this.o00000.resolve(".FSIServerStorage"), FileOperations.new);
            object = null;
            try {
                String string3;
                while ((string3 = ((BufferedReader)object2).readLine()) != null) {
                    switch (n) {
                        case 0: {
                            string2 = string3.trim();
                            break;
                        }
                        case 1: {
                            string = string3.trim();
                            break;
                        }
                        default: {
                            break block20;
                        }
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((BufferedReader)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedReader)object2).close();
                    }
                }
            }
        }
        if (string2 != null && string != null) {
            object2 = HexConverter.hexStringToByteArray(string2);
            object = HexConverter.hexStringToByteArray(string);
            if (object2 != null && object != null) {
                int n = ((Object)object).length / 2;
                CRC32 cRC32 = new CRC32();
                cRC32.update((byte[])object, 0, n);
                int n2 = (int)cRC32.getValue();
                cRC32.reset();
                cRC32.update((byte[])object, n, n);
                int n3 = (int)cRC32.getValue();
                String string4 = String.format("%04X", n2) + String.format("%04X", n3);
                if (string2.equals(string4)) {
                    this.return = string2;
                    this.\u00f400000 = string;
                }
            }
        }
    }

    public boolean setupStorageID() throws IOException {
        Path path = this.o00000.resolve(".FSIServerStorage");
        Path path2 = this.o00000.resolve(".FSIServerStorage.Prepare");
        boolean bl = false;
        int n = 5;
        while (n-- > 0 && Files.notExists(path, new LinkOption[0])) {
            if (Files.exists(path2, new LinkOption[0])) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            bl = true;
            break;
        }
        if (Files.exists(path, new LinkOption[0])) {
            try {
                this.evaluateStorageID();
                if (this.return == null) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        if (bl) {
            Path path3 = path2.getParent();
            if (Files.notExists(path3, new LinkOption[0])) {
                Files.createDirectories(path3, new FileAttribute[0]);
                Files.createFile(path2, new FileAttribute[0]);
            }
            Random random = new Random();
            byte[] byArray = new byte[64];
            int n2 = byArray.length / 2;
            random.nextBytes(byArray);
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray, 0, n2);
            int n3 = (int)cRC32.getValue();
            cRC32.reset();
            cRC32.update(byArray, n2, n2);
            int n4 = (int)cRC32.getValue();
            this.return = String.format("%04X", n3) + String.format("%04X", n4);
            this.\u00f400000 = HexConverter.byteArrayToHexString(byArray);
            String string = this.return + FileOperations.getNewLine() + this.\u00f400000;
            FileOperations.writeFile(path2, string.getBytes(FileOperations.new));
            FileOperations.move(path2, path);
        }
        return true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Hasher {
        \u00d500000,
        \u00d300000,
        \u00d400000,
        o00000;

    }
}

